// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14861 $
//  $Date: 2007-05-09 21:57:20 -0700 (Wed, 09 May 2007) $
//  $Author: jiangl $



// Rosetta Headers
#include "free_energy_estimate.h"
#include "after_opts.h"
#include "fullatom.h"
#include "nblist.h"
#include "param_pack.h"
#include "param_rotamer_trie.h"
#include "pose_design.h"
#include "pose_fwd.h"
#include "pose_io.h"
#include "silent_input.h"
#include "score.h"
#include "score_name.h"
#include "score_ns.h"

// ObjexxFCL Headers

// Numeric Headers

// C++ Headers
#include <iostream>
#include <sstream>
#include <fstream>

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
// Attempt to estimate Z = partition function
// after redesign.
//
// Relies on the relation:
//
//  log Z = - integral ( <E> dBeta)
//
// where Beta = 1/Temperature, and the integral runs from
// Beta = 0 (infinite temperature) to final temperature.
//
// rhiju may 2007.
//
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////
void
setup_packing_options(){
  set_rot_limit( 45, 24 ); //like in relax_structure.
  set_perc_limit( 0.9999, 0.9999 );
  get_packing_options(); // does it hurt to set this up again?

  pose_set_use_nblist( true );
  param_rotamer_trie::use_rotamer_trie = true;

  param_pack::scale_inner_iterations_value = realafteroption( "scale_inner_iterations", 1);
  param_pack::scale_outer_iterations_value = realafteroption( "scale_outer_iterations", 1);
}

////////////////////////////////////////////////////////////////////
void
free_energy_design( pose_ns::Pose & pose ){
  using namespace pose_ns;

  int const nres = pose.total_residue();

  FArray2D_bool design_matrix( param::MAX_AA(), nres, false );

  //Hey are all the packer options and weights set correctly?
  setup_packing_options();

  //First do a repack with fixed sequence. Don't minimize.
  // Design matrix for fixed sequence.
  for (int i = 1; i <=nres; i++ ){
    design_matrix(  pose.res(i), i ) = true;
  }

  pose.redesign( design_matrix, false /*include_current*/ );

  //Hold on to free energy.
  float const delG_repack = scores::delG;
  float const E_repack    = scores::energy_pack;

  //Then do a design, "repack" with alternative sequences.
  //Do our scratchwork on a new pose.
  Pose design_pose;
  design_pose = pose;

  for (int i = 1; i <=nres; i++ ){
    for (int j = 1; j <= 20; j++ ){
      design_matrix(  j, i ) = true;
    }
  }

  design_pose.redesign( design_matrix, false /*include_current*/ );

  //Hold on to free energy.
  float const delG_redesign = scores::delG;
  float const E_redesign    = scores::energy_pack;

  //Report difference in free energy between fixed sequence and
  // all-sequence runs.
  pose.score( score12 );

  pose.set_0D_score( DELG_PACK, delG_repack);
  pose.set_0D_score( ENERGY_PACK, E_repack);
  pose.set_extra_score( "DDG_DESI", delG_repack - delG_redesign );
  pose.set_extra_score( "DDE_DESI", E_repack    - E_redesign );

}


////////////////////////////////////////////////////////////////////
void
free_energy_test()
{
  using namespace pose_ns;
  using namespace silent_io;

  std::vector< std::string > files;

  std::string const scorefilename = stringafteroption("o","rescore.out");

  if (scorefilename == "rescore.out"){
    system( "rm rescore.out rescore.out.list" );
  }

  Silent_out out( scorefilename );

  if (truefalseoption("s")) {
    files.push_back( stringafteroption("s") );
  }

  if (truefalseoption("l")) {
    std::ifstream data( stringafteroption("l").c_str() );
    std::string line;
    while ( getline( data,line ) ) {
      files.push_back(line);
    }
    data.close();
  }

  Pose native_pose;
  bool const native_exists = truefalseoption("n");
  if ( native_exists ) {
    pose_from_pdb( native_pose, stringafteroption("n"), true /*fullatom*/, false );
  }

  for ( std::vector< std::string >::const_iterator file=files.begin();
	file != files.end(); ++file ) {

    std::string const start_file( *file);

    std::string tag = start_file;
    unsigned int n = tag.rfind(".pdb");
    tag.replace(n,4,"");

    if ( !out.start_decoy( tag ) ) continue;

    // read pose
    Pose pose;

    std::cout << "Reading in ... " << start_file << std::endl;
    pose_from_pdb( pose, start_file,
		   true, false, true );
    pose.copy_to_misc(); // need to set total_residue correctly, etc.

    free_energy_design( pose );

    if (native_exists){
      pose.set_native_pose( native_pose );
      calc_rms( pose );
    }

    out.write( tag, pose );

  }

}
