// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15095 $
//  $Date: 2007-05-23 09:25:07 -0400 (Wed, 23 May 2007) $
//  $Author: sarel $


// Rosetta Headers
#include "fullatom_energies.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// Using
using namespace param;


namespace fullatom_energies {


//bk  fullatomE       :total full atom energy,no backbone-backbone hbondenergies
//car  hbenergy_bb     :total backbone-backbone hbondenergy


namespace totals {
	float fullatomE;
	float hbenergy_srbb;
	float hbenergy_lrbb;
}


namespace energies {
	FArray1D_float atrenergy( MAX_RES() );
	FArray1D_float repenergy( MAX_RES() );
	FArray1D_float solenergy( MAX_RES() );
	FArray1D_float gb_elecenergy( MAX_RES() );
	FArray1D_float probenergy( MAX_RES() );
	FArray1D_float dunenergy( MAX_RES() );
	FArray1D_float unfenergy( MAX_RES() );
	FArray1D_float protonation_energy( MAX_RES() );
	FArray1D_float hbenergy( MAX_RES() );
	FArray1D_float hbenergy_sc_sc( MAX_RES() ); // these are needed for symmetry
	FArray1D_float hbenergy_sc_bb( MAX_RES() ); // "
	FArray1D_float hbenergy_sr_bb( MAX_RES() ); // "
	FArray1D_float hbenergy_lr_bb( MAX_RES() ); // "
	FArray2D_float atr_pair( MAX_RES(), MAX_RES() );
	FArray2D_float rep_pair( MAX_RES(), MAX_RES() );
	FArray2D_float sol_pair( MAX_RES(), MAX_RES() );
	FArray2D_float gb_elec_pair( MAX_RES(), MAX_RES() );
	FArray2D_float cst_pair( MAX_RES(), MAX_RES() );
	FArray2D_float pair_pair( MAX_RES(), MAX_RES() );
	FArray2D_float plane_plane( MAX_RES(), MAX_RES() );
	FArray1D_float resenergy( MAX_RES() );
	FArray1D_float pair_energy( MAX_RES() );
	FArray1D_float plane_energy( MAX_RES() );
	FArray2D_float hbond_pair( MAX_RES(), MAX_RES() );
	FArray1D_float h2oenergy( MAX_RES(), 0. );
	FArray2D_float h2o_pair( MAX_RES(), MAX_RES(), 0. );
	FArray1D_float h2ohbenergy( MAX_RES(), 0. );
	FArray2D_float h2o_hb_pair( MAX_RES(), MAX_RES(), 0. );
	FArray1D_float wsolenergy( MAX_RES() );
	FArray1D_float intraresenergy( MAX_RES() );
  FArray1D_float elecenergy( MAX_RES() );
  FArray2D_float elec_pair( MAX_RES(), MAX_RES() );
	FArray1D_float cstenergy( MAX_RES() );
	FArray1D_float bondangleenergy( MAX_RES() );
}

//KMa aa-ligand(surface) excluding aa-aa energies  2006/1
namespace lenergies {
    FArray1D_float latrenergy( MAX_RES() );
	FArray1D_float lrepenergy( MAX_RES() );
	FArray1D_float lsolenergy( MAX_RES() );
	FArray1D_float lgb_elecenergy( MAX_RES() );
	FArray1D_float lh2oenergy( MAX_RES() );
	FArray1D_float lhbenergy( MAX_RES() );
	FArray1D_float lpair_energy( MAX_RES() );
	FArray1D_float lresenergy( MAX_RES() );
}


namespace best_energies {
	FArray1D_float best_atrenergy( MAX_RES(), 0.0f );
	FArray1D_float best_repenergy( MAX_RES(), 0.0f );
	FArray1D_float best_solenergy( MAX_RES(), 0.0f );
	FArray1D_float best_wsolenergy( MAX_RES(), 0.0f );
	FArray1D_float best_gb_elecenergy( MAX_RES(), 0.0f );
	FArray1D_float best_probenergy( MAX_RES(), 0.0f );
	FArray1D_float best_dunenergy( MAX_RES(), 0.0f );
	FArray1D_float best_unfenergy( MAX_RES(), 0.0f );
	FArray1D_float best_protonation_energy( MAX_RES(), 0.0f );
	FArray2D_float best_atr_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray2D_float best_rep_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray2D_float best_sol_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray2D_float best_cst_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray2D_float best_gb_elec_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray2D_float best_plane_plane( MAX_RES(), MAX_RES(), 0.0f );
	FArray1D_float best_resenergy( MAX_RES(), 0.0f );
	FArray1D_float best_h2oenergy( MAX_RES(), 0.0f );
	FArray2D_float best_h2o_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray1D_float best_h2ohbenergy( MAX_RES(), 0.0f );
	FArray2D_float best_h2o_hb_pair( MAX_RES(), MAX_RES(), 0.0f );
	FArray1D_float best_intraresenergy( MAX_RES(), 0.0f );
	FArray1D_float best_cstenergy( MAX_RES(), 0.0f );
	FArray1D_float best_bondangleenergy( MAX_RES(), 0.0f );
  FArray1D_float best_elecenergy( MAX_RES(), 0.0f );
  FArray2D_float best_elec_pair( MAX_RES(), MAX_RES(), 0.0f );
}


//bk energies binned by atom type


namespace atm_energies {
	FArray1D_float solE_atm( MAX_ATOMTYPES() );
	FArray1D_float atrE_atm( MAX_ATOMTYPES() );
	FArray1D_float repE_atm( MAX_ATOMTYPES() );
	FArray1D_int n_atm( MAX_ATOMTYPES() );
}


}
