// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17053 $
//  $Date: 2007-09-08 21:26:28 -0400 (Sat, 08 Sep 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_fullatom_energy
#define INCLUDED_fullatom_energy


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// fullatom_energy Function Declarations

namespace fullatom_energy_debug {
	extern bool debug;
	extern bool in_fullatom_energy;
}

namespace do_not_use {
	extern float junk_float;
	extern FArray1D_float junk_oneDf;
}

inline
bool
inside_fullatom_energy()
{
	return fullatom_energy_debug::in_fullatom_energy;
}

float
get_fullatom_totalE();


void
sum_fullatom_energies(
	int const nres,
	float & attractiveE,
	float & repulsiveE,
	float & solvationE,
	float & referenceE,
	float & protonationE,
	float & dunbrackE,
	float & Paa_ppE,
	float & pairprobE,
	float & planeprobE,
	float & h2oE,
	float & h2ohbE,
	float & h2o_solE,
	float & srbb_hbondE,
	float & lrbb_hbondE,
	float & sc_bb_hbondE,
	float & intra_resE,
	float & gb_elecE,
	float & elecE,
	float & cstE,
	float & bondangleE
);


void
fullatom_energy_full(
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord,
	int total_residue
);


void
check_fullatom_scores( bool const use_subset_energy );


void
compare_fullatom_energy();


void
zero_atom_Earrays();

bool
aro_charged_pair(
int aa1,
int attype1,
int atnum1,
int aa2,
int attype2,
int atnum2
);

void
fill_Earrays(
	int res1,
	int res2,
	float solE,
	float atrE,
	float repE,
  float elecE
);


void
fill_repE_array(
	int res1,
	int res2,
	float repE
);


void
fill_solE_array(
	int res1,
	int res2,
	float solE
);


void
fill_atom_Earrays(
	int type1,
	int type2,
	float sE1,
	float sE2,
	float atrE,
	float repE
);


void
fullatom_energy(
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord,
	int nres_inout,
	bool subset
);



void
copy_fullatom_energies_to_best( int nres );


void
get_rotamer_probability(
	int aa,
	int aa_variant,
	float phi,
	float psi,
	int seqpos,
	int nres,
	FArray1Da_float chi,
	FArray1Da_int rot,
	float & rot_prob,
	float & drperc_dphi = do_not_use::junk_float,
	float & drperc_dpsi = do_not_use::junk_float,
	FArray1D_float & drperc_dchi = do_not_use::junk_oneDf
);


void
eval_dunbrack_derivs(
	int & aa,
	int & aav,
	float & phi,
	float & psi,
	int & seqpos,
	int & nres,
	FArray1Da_float chi,
	FArray1Da_int rot,
	float & dE_dphi,
	float & dE_dpsi,
	FArray1Da_float dE_dchi
);

void
fill_cstE_array(
	int res1,
	int res2,
	float & energy
);


void
nblist_atompair_energy(
	FArray1D_int const & aan,
	FArray1D_int const & aa_variant,
	FArray3D_float const & xyz
);


void
evaluate_atom_energy( FArray2D_float & atom_energy );

#endif
