// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11814 $
//  $Date: 2006-12-16 16:26:13 -0500 (Sat, 16 Dec 2006) $
//  $Author: bkidd $


// Rosetta Headers
#include "fullatom_extra_props.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// Using
using namespace param;


//cj    extra data for a_sasa & ex_ljvdw


//*****************************************************************
//**   Van der Waal radii and Well Depth from CHAARM 19
//**   Neria et al. J. Chem. Phys., 105, pg 1902 (1996)
//**   except aromatic carbons have been made smaller since using hydrogens
//cj    from brian's code to make Etables


namespace fullatom_ex_props {


	void
	aradii_initializer( FArray1D_float & aradii )
	{
		//j    setting radii that correspond to lj energies used by brian
		//j    below are original values:
		//j    data radii / 2.1, 2.1, 2.365, 2.235, 2.165,
		//j   *             1.85, 1.6,   1.6,   1.6, 1.6,
		//j   *             1.6, 1.6,   1.6,   1.6, 1.6,
		//j   *             1.89,1.6, 2.365,   2.1, 1.6, 0.6,1.2,1.2,0.6/
		//j
		//j    convention is to multiply them by 0.95, so did
		if ( aradii.u() == 0 ) return;
		int i = 0;
		aradii( ++i ) = 1.89;   // CNH2
		aradii( ++i ) = 1.89;   // COO
		aradii( ++i ) = 2.1285; // CH1
		aradii( ++i ) = 2.0115; // CH2
		aradii( ++i ) = 1.9485; // CH3
		aradii( ++i ) = 1.665;  // aroC
		aradii( ++i ) = 1.44;   // Ntrp
		aradii( ++i ) = 1.44;   // Nhis
		aradii( ++i ) = 1.44;   // NH2O
		aradii( ++i ) = 1.44;   // Nlys
		aradii( ++i ) = 1.44;   // Narg
		aradii( ++i ) = 1.44;   // Npro
		aradii( ++i ) = 1.44;   // OH
		aradii( ++i ) = 1.44;   // ONH2
		aradii( ++i ) = 1.44;   // OOC
		aradii( ++i ) = 1.701;  // S
		aradii( ++i ) = 1.44;   // Nbb
		aradii( ++i ) = 2.1285; // CAbb
		aradii( ++i ) = 1.89;   // CObb
		aradii( ++i ) = 1.44;   // OCbb
		aradii( ++i ) = 2.0425;   // Phos in Phosphate ;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		aradii( ++i ) = 0.54;   // Hpol
		aradii( ++i ) = 1.08;   // Hapo
		aradii( ++i ) = 1.08;   // Haro
		aradii( ++i ) = 0.54;   // HNbb
		if ( aradii.u() == 25 ) return;
		// jk scale up water radii to be sure to avoid clashes
		//		aradii( ++i ) = 1.40;   // HOH
		aradii( ++i ) = 1.50;   // HOH
		if ( aradii.u() == 26 ) return;
		aradii( ++i ) = 1.7100; // F  taken from MM3 forcefield
		aradii( ++i ) = 2.0700; // Cl taken from MM3 forcefield
		aradii( ++i ) = 2.2200; // Br taken from MM3 forcefield
		aradii( ++i ) = 2.3600; // I  taken from MM3 forcefield
		aradii( ++i ) = 1.0900; // Zn2p ion radius CHARMM27
		aradii( ++i ) = 0.7800; // Fe2p ion radius CHARMM27
		aradii( ++i ) = 0.6500; // Fe3p ion radius CHARMM27
		aradii( ++i ) = 1.1850; // Mg2p ion radius CHARMM27
		aradii( ++i ) = 1.2986; // Ca2p ion radius CHARMM27,kosta makrodimitris(*0.95)
		aradii( ++i ) = 1.3638; // Na1p ion radius CHARMM27
		aradii( ++i ) = 1.7638; // K1p  ion radius CHARMM27
		aradii( ++i ) = 1.5626; // Au, (see etable.cc)
		aradii( ++i ) = 1.5200; // O in ice (see etable.cc)
		aradii( ++i ) = 0.7600; // H in ice (see etable.cc)
		aradii( ++i ) = 2.0401; // Si in alpha Quartz (see etable.cc)
		aradii( ++i ) = 1.6625; // O in alpha Quartz (see etable.cc)
		aradii( ++i ) = 1.6150; // OP  in Phosphate ;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		aradii( ++i ) = 1.6815; // OH  in Phosphate ;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		aradii( ++i ) = 0.2133; // HO  in Phosphate ;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		aradii( ++i ) = 2.0425; //  P/ HA;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		aradii( ++i ) = 1.6150; // OP/ HA;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		aradii( ++i ) = 1.6815; // OH/ HA;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		aradii( ++i ) = 0.2133; // HO/ HA;  radius *0.95 CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		aradii( ++i ) = 2.1612; // CS1
		aradii( ++i ) = 2.1612; // CS2
		aradii( ++i ) = 2.1612; // CS5
		aradii( ++i ) = 2.1612; // CS6
		aradii( ++i ) = 1.6815; // O5
		aradii( ++i ) = 0.0;    // V01
		aradii( ++i ) = 0.0;    // V02
		aradii( ++i ) = 0.0;    // V03
		aradii( ++i ) = 0.0;    // V04
		aradii( ++i ) = 0.0;    // V05
		aradii( ++i ) = 0.0;    // V06
		aradii( ++i ) = 0.0;    // V07
		aradii( ++i ) = 0.0;    // V08
		aradii( ++i ) = 0.0;    // V09
		aradii( ++i ) = 0.0;    // V10
		aradii( ++i ) = 0.0;    // V11
		aradii( ++i ) = 0.0;    // V12
		aradii( ++i ) = 0.0;    // V13
		aradii( ++i ) = 0.0;    // V14
		aradii( ++i ) = 0.0;    // V15
		aradii( ++i ) = 0.0;    // V16
		aradii( ++i ) = 0.0;    // V17
//******************************************************************************
//vats Vatsan Raman
//vats vdw radii for Nucleic acids CHARMM 27
//vats Ref etable.h
//******************************************************************************
//		aradii( ++i ) = 1.900;  // CN1  carbonyl carbon
//		aradii( ++i ) = 1.900;  // CN2  aromatic carbon to amide
//		aradii( ++i ) = 1.900;  // CN3  aromatic carbon
//		aradii( ++i ) = 1.900;  // CN4  purine C8 and ADE C2
//		aradii( ++i ) = 1.900;  // CN5  purine C4 and C5
//		aradii( ++i ) = 1.900;  // CN7  carbon (C1',C2',C3',C4')
//		aradii( ++i ) = 2.000;  // CN8  carbon (C5')
//		aradii( ++i ) = 2.000;  // CN9  carbon (C5M)
//		aradii( ++i ) = 1.850;  // NN1  amide nitrogen
//		aradii( ++i ) = 1.850;  // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//		aradii( ++i ) = 1.850;  // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//		aradii( ++i ) = 1.850;  // NN4  purine N7
//		aradii( ++i ) = 1.700;  // ON1  carbonyl oxygen
//		aradii( ++i ) = 1.770;  // ON2  phosphate ester oxygen
//		aradii( ++i ) = 1.700;  // ON3  =O in phosphate
//		aradii( ++i ) = 1.770;  // ON4  phosphate hydroxyl oxygen
//		aradii( ++i ) = 1.770;  // ON5  ribose hydroxyl oxygen
//		aradii( ++i ) = 1.770;  // ON6  deoxyribose, ribose ring oxygen
//		aradii( ++i ) = 1.340;  // H    polar hydrogen
//		aradii( ++i ) = 1.200;  // H    non-polar hydrogen
	}


	void
	adepth_initializer( FArray1D_float & adepth )
	{
		if ( adepth.u() == 0 ) return;
		int i = 0;
		adepth( ++i ) = 0.120000; // CNH2
		adepth( ++i ) = 0.120000; // COO
		adepth( ++i ) = 0.048600; // CH1
		adepth( ++i ) = 0.114200; // CH2
		adepth( ++i ) = 0.181100; // CH3
		adepth( ++i ) = 0.120000; // aroC
		adepth( ++i ) = 0.238400; // Ntrp
		adepth( ++i ) = 0.238400; // Nhis
		adepth( ++i ) = 0.238400; // NH2O
		adepth( ++i ) = 0.238400; // Nlys
		adepth( ++i ) = 0.238400; // Narg
		adepth( ++i ) = 0.238400; // Npro
		adepth( ++i ) = 0.159100; // OH
		adepth( ++i ) = 0.159100; // ONH2
		adepth( ++i ) = 0.210000; // OOC
		adepth( ++i ) = 0.043000; // S
		adepth( ++i ) = 0.238400; // Nbb
		adepth( ++i ) = 0.048600; // CAbb
		adepth( ++i ) = 0.140000; // CObb
		adepth( ++i ) = 0.159100; // OCbb
		adepth( ++i ) = 0.585000; // Phos in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		adepth( ++i ) = 0.010000; // Hpol
		adepth( ++i ) = 0.010000; // Hapo
		adepth( ++i ) = 0.010000; // Haro
		adepth( ++i ) = 0.010000; // HNbb
		if ( adepth.u() == 25 ) return;
		adepth( ++i ) = 0.050000; // HOH
		if ( adepth.u() == 26 ) return;
		adepth( ++i ) = 0.075000; // F  taken from MM3 forcefield
		adepth( ++i ) = 0.240000; // Cl taken from MM3 forcefield
		adepth( ++i ) = 0.320000; // Br taken from MM3 forcefield
		adepth( ++i ) = 0.424000; // I  taken from MM3 forcefield
		adepth( ++i ) = 0.250000; // Zn2p taken from CHARMM27
		adepth( ++i ) = 0.000000; // Fe2p taken from CHARMM27
		adepth( ++i ) = 0.000000; // Fe3p taken from CHARMM27
		adepth( ++i ) = 0.015000; // Mg2p taken from CHARMM27
		adepth( ++i ) = 0.120000; // Ca2p taken from CHARMM27
		adepth( ++i ) = 0.046900; // Na1p taken from CHARMM27
		adepth( ++i ) = 0.087000; // K1p  taken from CHARMM27
		adepth( ++i ) = 0.039000; // Au (see etable.cc)
		adepth( ++i ) = 0.159100; // O in ice (see etable.cc)
		adepth( ++i ) = 0.049800; // H in ice (see etable.cc)
		adepth( ++i ) = 0.402000; // Si in Quartz (see etable.cc)
		adepth( ++i ) = 0.060000; // O in Quartz (see etable.cc)
		adepth( ++i ) = 0.120000; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		adepth( ++i ) = 0.152100; // OH  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		adepth( ++i ) = 0.046000; // HO  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		adepth( ++i ) = 0.585000; //  P/ HA;   CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		adepth( ++i ) = 0.120000; //  OP/ HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		adepth( ++i ) = 0.152100; //  OH/ HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		adepth( ++i ) = 0.046000; //  HO/ HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris 11/2005
		adepth( ++i ) = 0.020000; // CS1
		adepth( ++i ) = 0.020000; // CS2
		adepth( ++i ) = 0.020000; // CS5
		adepth( ++i ) = 0.020000; // CS6
		adepth( ++i ) = 0.152100; // O5
		adepth( ++i ) = 0.000000; // V01
		adepth( ++i ) = 0.000000; // V02
		adepth( ++i ) = 0.000000; // V03
		adepth( ++i ) = 0.000000; // V04
		adepth( ++i ) = 0.000000; // V05
		adepth( ++i ) = 0.000000; // V06
		adepth( ++i ) = 0.000000; // V07
		adepth( ++i ) = 0.000000; // V08
		adepth( ++i ) = 0.000000; // V09
		adepth( ++i ) = 0.000000; // V10
		adepth( ++i ) = 0.000000; // V11
		adepth( ++i ) = 0.000000; // V12
		adepth( ++i ) = 0.000000; // V13
		adepth( ++i ) = 0.000000; // V14
		adepth( ++i ) = 0.000000; // V15
		adepth( ++i ) = 0.000000; // V16
		adepth( ++i ) = 0.000000; // V17
//******************************************************************************
//vats  well-depth for Nucleic Acids CHARMM 27
//******************************************************************************
//		adepth( ++i ) = 0.100000; // CN1  carbonyl carbon
//		adepth( ++i ) = 0.100000; // CN2  aromatic carbon to amide
//		adepth( ++i ) = 0.090000; // CN3  aromatic carbon
//		adepth( ++i ) = 0.075000; // CN4  purine C8 and ADE C2
//		adepth( ++i ) = 0.075000; // CN5  purine C4 and C5
//		adepth( ++i ) = 0.020000; // CN7  carbon (C1',C2',C3',C4')
//		adepth( ++i ) = 0.056000; // CN8  carbon (C5')
//		adepth( ++i ) = 0.078000; // CN9  carbon (C5M)
//		adepth( ++i ) = 0.200000; // NN1  amide nitrogen
//		adepth( ++i ) = 0.200000; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//		adepth( ++i ) = 0.200000; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//		adepth( ++i ) = 0.200000; // NN4  purine N7
//		adepth( ++i ) = 0.120000; // ON1  carbonyl oxygen
//		adepth( ++i ) = 0.152100; // ON2  phosphate ester oxygen
//		adepth( ++i ) = 0.120000; // ON3  =O in phosphate
//		adepth( ++i ) = 0.152100; // ON4  phosphate hydroxyl oxygen
//		adepth( ++i ) = 0.152100; // ON5  ribose hydroxyl oxygen
//		adepth( ++i ) = 0.152100; // ON6  deoxyribose, ribose ring oxygen
//		adepth( ++i ) = 0.046000; // H    polar hydrogen
//		adepth( ++i ) = 0.022000; // H    non-polar hydrogen
	}


	void
	asp_initializer( FArray1D_float & asp )
	{
		//j   (from Koehl and Delarue,Proteins,20:264(1994))
		//j   Carbon 36.0, Sulfur 44.0, Arginine N -46.0, Lysine N -46.0, other N 8.1
		//j   GLU & ASP O -5.0, Other O 8.1, H is zero for not used
		if ( asp.u() == 0 ) return;
		int i = 0;
		asp( ++i ) =  36.0; // CNH2
		asp( ++i ) =  36.0; // COO
		asp( ++i ) =  36.0; // CH1
		asp( ++i ) =  36.0; // CH2
		asp( ++i ) =  36.0; // CH3
		asp( ++i ) =  36.0; // aroC
		asp( ++i ) =   8.1; // Ntrp
		asp( ++i ) =   8.1; // Nhis
		asp( ++i ) =   8.1; // NH2O
		asp( ++i ) = -46.0; // Nlys
		asp( ++i ) = -46.0; // Narg
		asp( ++i ) =   8.1; // Npro
		asp( ++i ) =   8.1; // OH
		asp( ++i ) =   8.1; // ONH2
		asp( ++i ) =  -5.0; // OOC
		asp( ++i ) =  44.0; // S
		asp( ++i ) =   8.1; // Nbb
		asp( ++i ) =  36.0; // CAbb
		asp( ++i ) =  36.0; // CObb
		asp( ++i ) =   8.1; // OCbb
		asp( ++i ) =  36.0; // Phos; copy COO - jjh
		asp( ++i ) =   0.0; // Hpol
		asp( ++i ) =   0.0; // Hapo
		asp( ++i ) =   0.0; // Haro
		asp( ++i ) =   0.0; // HNbb
		if ( asp.u() == 25 ) return;
		asp( ++i ) =   0.0; // HOH
		if ( asp.u() == 26 ) return;
		asp( ++i ) =   8.1; // F    wild guess = N/O
		asp( ++i ) =   8.1; // Cl   wild guess = N/O
		asp( ++i ) =   8.1; // Br   wild guess = N/O
		asp( ++i ) =   8.1; // I    wild guess = N/O
		asp( ++i ) = -46.0; // Zn2p wild guess = N+
		asp( ++i ) = -46.0; // Fe2p wild guess = N+
		asp( ++i ) = -46.0; // Fe3p wild guess = N+
		asp( ++i ) = -46.0; // Mg2p wild guess = N+
		asp( ++i ) = -46.0; // Ca2p wild guess = N+
		asp( ++i ) = -46.0; // Na1p wild guess = N+
		asp( ++i ) = -46.0; // K1p  wild guess = N+
		asp( ++i ) =  44.0; // Au ????????????
		asp( ++i ) =   8.1; // O in ice ??????????
		asp( ++i ) =   0.0; // H in ice ??????????
		asp( ++i ) =  44.0; // Si in quartz ???????????
		asp( ++i ) =   8.1; // O in Quartz ??????????
		asp( ++i ) =   8.1; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =   8.1; // OH  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =   0.0; // HO  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =  36.0; //  P/HA ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =   8.1; // OP/HA ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =   8.1; // OH/HA ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =   0.0; // HO/HA ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		asp( ++i ) =  36.0; // CS1
		asp( ++i ) =  36.0; // CS2
		asp( ++i ) =  36.0; // CS5
		asp( ++i ) =  36.0; // CS6
		asp( ++i ) =   8.1; // O5
		asp( ++i ) =   0.0; // V01
		asp( ++i ) =   0.0; // V02
		asp( ++i ) =   0.0; // V03
		asp( ++i ) =   0.0; // V04
		asp( ++i ) =   0.0; // V05
		asp( ++i ) =   0.0; // V06
		asp( ++i ) =   0.0; // V07
		asp( ++i ) =   0.0; // V08
		asp( ++i ) =   0.0; // V09
		asp( ++i ) =   0.0; // V10
		asp( ++i ) =   0.0; // V11
		asp( ++i ) =   0.0; // V12
		asp( ++i ) =   0.0; // V13
		asp( ++i ) =   0.0; // V14
		asp( ++i ) =   0.0; // V15
		asp( ++i ) =   0.0; // V16
		asp( ++i ) =   0.0; // V17
//******************************************************************************
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
//		asp( ++i ) =   0.0; //
	}


	FArray1D_float const aradii( MAX_ATOMTYPES(), aradii_initializer );
	 // radii corresponding to 24 types and how Energy table built
	FArray1D_float const adepth( MAX_ATOMTYPES(), adepth_initializer );
	 // well depth for atom radii for 24 types of radii
	FArray1D_float const asp( MAX_ATOMTYPES(), asp_initializer );
	 // atomic solvation parameters for atoms (Eisenberg & Macclachlan)


} // namespace fullatom_ex_props
