// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16119 $
//  $Date: 2007-07-19 13:20:22 -0400 (Thu, 19 Jul 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_fullatom_sasa
#define INCLUDED_fullatom_sasa


// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


extern short const bit_count[]; // lookup table for sasa computation, used also in void.cc

// fullatom_sasa Function Declarations


void
input_sasa_dats();


void
get_overlap(
	FArray1DB_float const & a,
	float & ra,
	FArray1DB_float const & b,
	float & rb,
	float & dist,
	int & olp
);


void
get_orientation(
	FArray1DB_float const & a,
	FArray1DB_float const & b,
	int & aphi,
	int & theta,
	float dist
);

void
get_2way_orientation(
  FArray1DB_float const & a,
  FArray1DB_float const & b,
  int & aphi_a2b,
  int & theta_a2b,
  int & aphi_b2a,
  int & theta_b2a,
  float dist
);

void
calc_aprox_sasa();


float
calc_sasa();

void
calc_per_atom_sasa(
	FArray2Da_float atom_sasa,
	FArray1Da_float rsd_sasa,
	float const probe_radius, // input
	bool const heavyatoms_only, // jk if true, ignore hydrogens and waters in computing SASA
	bool const self_chain_only, // jk if true, ignore SASA occluded by
			// chains other than the one harboring the current atom
			// (ie. compute SASA in the "unbound" state)
	bool const rna_ring = false // rhiju -- just c1*,c2*,c3*,c4*,c5* atoms.
);


float
get_ex_gsolt();

float
get_ex_sasa_gsolt();

void
calc_min_rsq( FArray2D_float & rsq_min );

void
calc_gsolt( pose_ns::Pose & pose );

#endif
