// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17813 $
//  $Date: 2007-10-16 16:49:26 -0400 (Tue, 16 Oct 2007) $
//  $Author: johnk $

#ifndef INCLUDED_fullatom_setup
#define INCLUDED_fullatom_setup


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace fullatom_setup_ns {
	extern float mod_hhrep_height;
	extern float mod_hhrep_width;
	extern float mod_hhrep_center;
	extern float mod_hhrep_exponent;
	extern float smooth_etable_ljweight;
	extern float smooth_etable_solvweight;
}


// fullatom_setup Function Declarations


void
set_fa_lj_rep_slope( std::string const & setting );


void
initialize_fullatom();


void
setup_dun();


void
setup_exrot_db();


void
setup_packer();


void
setup_intra_cp_table();


bool
one_bond_away(
	int atom1,
	int atom2,
	int aa,
	int aav
);


bool
two_bond_away(
	int atom1,
	int atom2,
	int aa,
	int aav
);


bool
three_bond_away(
	int atom1,
	int atom2,
	int aa,
	int aav
);


float
intra_res_count_pair(
	int const aa,
	int const aav,
	int const atom1,
	int const atom2
);


void
apply_packer_weights( bool const standard_weights, bool const suppress_output = false );


#endif
