// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16636 $
//  $Date: 2007-08-21 18:47:16 -0400 (Tue, 21 Aug 2007) $
//  $Author: ashworth $


// Rosetta Headers
#include "ga_seq_opt.h"
#include "aa_name_conversion.h" // num_from_name
#include "param.h"
#include "param_aa.h"

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.io.hh>

// utility Headers
#include <utility/vector1.hh>

#include <iostream>

// Using
using namespace param;

namespace ga_seq_opt {

////////////////////////////////////////////////////////////////////////////////
std::string seqstr( std::vector<int> const & vec )
{
	std::string str;
	for ( std::vector<int>::const_iterator seq( vec.begin() ); seq != vec.end();
	      ++seq ) {
		str += param_aa::aa_name3( *seq ) + " ";
	}
	return str;
}

////////////////////////////////////////////////////////////////////////////////
std::string Estr( std::vector<float> const & vec )
{
	std::string str;
	for ( std::vector<float>::const_iterator E( vec.begin() ); E != vec.end();
	      ++E ) {
		str += F( 7, 2, *E ) + " ";
	}
	return str;
}

////////////////////////////////////////////////////////////////////////////////
PopMember::PopMember( std::string line )
{
	_rank = 0;
	_cached = false;
	std::string word;
	// inefficient to use string intermediate, but takes care of endline detection
	std::istringstream linestream( line );
	linestream >> word; // "Current" or "Cached" // (skip)
	linestream >> word; // "Member" (skip)
	while ( linestream >> word ) {
//		std::cerr << word << " ";
		if ( word == "Fitness" ) break;
		// sequence
		int aa_num;
		num_from_name( word, aa_num );
		_sequence.push_back( aa_num );
	}
	// now word == 'fitness'
	linestream >> _fitness; // next is the fitness value

	// now for the state energies
	linestream >> word; // "Energies"
	float energy;
	while ( linestream >> energy ) {
//		std::cerr << F( 7, 2, energy ) << " ";
		_state_energies.push_back( energy );
	}
//	std::cerr << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
std::ostream & operator<< ( std::ostream & os, PopMember const & pm )
{
	os << "Member " << seqstr( pm._sequence )
	   << " Fitness " << F( 5, 2, pm.fitness() )
	   << " Energies " << Estr( pm.state_energies() )
	   << std::endl;
	return os;
}

////////////////////////////////////////////////////////////////////////////////
const int base_mod = 10;
const int base_prime[base_mod] = { 1, 29, 43, 71, 149, 211, 457, 521, 1039, 1069 };

////////////////////////////////////////////////////////////////////////////////
inline int
hash_prime( int const hash_index ) {
	return base_prime[ hash_index % base_mod ];
}

////////////////////////////////////////////////////////////////////////////////
size_t
ga_seq_hash::operator() ( const std::vector<int> &this_seq ) const
{
	size_t hash_key = 0;

	for(unsigned int i = 0 ; i < this_seq.size() ; ++i) {
		int use_power = (i % 3) + 1;
		switch (use_power) {
				case 1:
						hash_key += hash_prime(i)*this_seq[i];
				case 2:
						hash_key += hash_prime(i)*this_seq[i]*this_seq[i];
				case 3:
						hash_key += hash_prime(i)*this_seq[i]*this_seq[i]*this_seq[i];
		}
	}
	return hash_key;
}

////////////////////////////////////////////////////////////////////////////////
bool
ga_seq_hash::operator() (
	std::vector<int> const & seq1,
	std::vector<int> const & seq2
) const
{
	return ( seq1 == seq2 );
}

////////////////////////////////////////////////////////////////////////////////
namespace multi_state {

//	hash_map< std::vector< int >, PopMember, ga_seq_hash > _ms_hash_map;
	MultistateHashMap _ms_hash_map;

}


}
