// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17358 $
//  $Date: 2007-09-24 23:08:09 -0400 (Mon, 24 Sep 2007) $
//  $Author: harrison $

#ifndef INCLUDED_gb_elec
#define INCLUDED_gb_elec


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// forward declarations
class DesignMap;
class RotamerSet;


// gb_elec Function Declarations

void // PBH
reset_gb_status();
void
show_gb_status();

void
gb_set_use_simple_electrostratics( bool const setting );

void
gb_set_use_no_intra_res( bool const setting );

bool
get_update_born_radii();


void
set_update_born_radii( bool const setting );


bool
count_pair_gb(
	const int atm1,
	const int pos1,
	const int aa1,
	const int aav1,
	const int atm2,
	const int pos2,
	const int aa2,
	const int aav2
);


float
gb_shell_intxn_deriv(
	float const qai,
	float const rai,
	float const qbi,
	float const rbi,
	float const dist
);


void
gb_clear_born_radii(
	FArray1Da_float gb_rad_array,
	int const aa,
	int const aav
);


void
gb_res_res_burial(
	FArray1Da_float brad1,
	FArray2Da_float coord1,
	int const natoms1,
	int const dim_atoms1,
	FArray1Da_int fa_type1,
	FArray2Da_float coord2,
	int const natoms2,
	int const dim_atoms2,
	FArray1Da_int fa_type2,
	bool same_res,
	int const override
);


void
gb_get_all_born_radii();

void
gb_get_all_born_radii_dummy( int dummy_pos );

void
gb_build_placeholders(
	int const nres,
	FArray3Da_float xyz,
	FArray1Da_int aan,
	FArray1Da_int aa_variant,
	const DesignMap & design_map
);


void
gb_get_template_born_radii(
	int const nres,
	FArray3Da_float xyz,
	FArray2Da_float born_radius,
	FArray1Da_int aan,
	FArray1Da_int aav,
	const DesignMap & design_map
);


void
gb_get_rotamers_born_radii(
	int const nres,
	FArray3Da_float xyz,
	FArray1Da_int aan,
	FArray1Da_int aav,
	RotamerSet & rotamer_set,
	const DesignMap & design_map
);


float
gb_get_res_res_elecE(
	int const seqpos1,
	int const aa1,
	int const aav1,
	FArray2Da_float coord1,
	FArray1Da_float brad1,
	int const seqpos2,
	int const aa2,
	int const aav2,
	FArray2Da_float coord2,
	FArray1Da_float brad2
);


float
gb_get_res_res_simple_elecE(
	int const seqpos1,
	int const aa1,
	int const aav1,
	FArray2Da_float coord1,
	int const seqpos2,
	int const aa2,
	int const aav2,
	FArray2Da_float coord2
);


float
gb_get_ligand_elecE(
	int const natoms1,
	int const dim_atoms1,
	FArray2Da_float coord1,
	FArray1Da_float brad1,
	FArray1Da_float charge1,
	FArray1Da_int fa_type1,
	int const natoms2,
	int const dim_atoms2,
	FArray2Da_float coord2,
	FArray1Da_float brad2,
	FArray1Da_float charge2,
	FArray1Da_int fa_type2,
	bool const same_res
);

float
gb_shell_intxn(
	float const qa1,
	float const rai,
	float const qbi,
	float const rbi,
	float const dist
);

void
gb_set_use_simple_electrostatics(
  bool const setting
);

void
gb_set_use_no_intra_res(
  bool const setting
);

float
gb_simple_elec_eval_dE_dR_over_r(
	int const seqpos1,
	int const atom1,
	int const aa1,
	int const aav1,
	FArray1Da_float coord1,
	int const seqpos2,
	int const atom2,
	int const aa2,
	int const aav2,
	FArray1Da_float coord2,
	bool const update_f1f2,
	FArray1Da_float f1,
	FArray1Da_float f2
);


void
setup_simple_electrostatics();


#endif
