// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17358 $
//  $Date: 2007-09-24 23:08:09 -0400 (Mon, 24 Sep 2007) $
//  $Author: harrison $

#ifndef INCLUDED_gb_elec_ns
#define INCLUDED_gb_elec_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


//jjh   extra data for generalized Born electrostatics
namespace gb_elec {


	// Dielectric constants for protein (Ep) and for solvent (Ew)
	extern float const Ep;
	extern float const Ew;

	// Parameters for determination of Generalized Born radii
	extern float const ParamS;
	extern float const ParamD;
	extern float const ParamB;
	extern float const ParamG;

	// More parameters for GB burial
	extern float const Param_TA;
	extern float const Param_TB;
	extern float const Param_TC;
	extern float const Param_TD;
	extern float const Param_TDD;
	extern float const Param_TE;
	extern float const Param_TF;
	extern float const Param_TG;
	extern float const Param_TH;
	extern float const Param_THH;



	// Also for diagnostics, I sometimes accumlate the direct
	// coulombic and polarization electrostatics separately.
	extern float total_coul;
	extern float total_gb;

	extern float gb_dummy_rad;
	extern float gb_dummy_dist;

	extern bool update_radii;

	// hack: simple electrostatics
	extern bool use_no_intra_res;
	extern bool use_simple_elec;
	extern FArray3D_float simple_charge;
	extern FArray3D_float simple_elecE_table;
	extern FArray3D_int charge_bin;

	extern FArray1D_float const gb_radius; // radii for GB electrostatics
	extern FArray1D_float const gb_scale; // scaling factor for GB electrostatics

	extern FArray2D_float born_rad;
	extern FArray3D_float place_holder_xyz;
}


#endif
