// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14781 $
//  $Date: 2007-05-08 13:35:56 -0400 (Tue, 08 May 2007) $
//  $Author: jiangl $
//
// this file is OK to include
// it's ifdef'd out unless -DGL_GRAPHICS

#ifndef INCLUDED_graphics
#define INCLUDED_graphics

#ifndef GL_GRAPHICS

#define GRAPHICS_LOG(expr)

#else

#define GRAPHICS_LOG(expr) ( gl_graphics_log( expr ) )

#include "pose.h"
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>
#include <vector>


namespace graphics {
	enum Bond_type { HBOND, GB_BOND, WATER_HBOND };
	class Bond;
	class T_point;
	extern FArray3D_int intxn_atm;
}


void*
graphics_thread_wrapper(void* ) ;


int
main_glut(int argc, char** argv) ;


// called by jobdistributor?
void
open_windows(
	bool const use_pose_graphics = false
);

void
set_worker_done( bool );

// checked by gb_elec.cc
float
gl_graphics_bond_energy_threshold();


// for setting the title
void
gl_graphics_set_title( std::string const & t );


// for logging messages to the graphics window
// wrapped in the GRAPHICS_LOG macro
void
gl_graphics_log( std::string const & msg );


/////////////////////////
// monte carlo interface:

void
gl_graphics_mc_reset( float const low_score, float const low_rms );


void
gl_graphics_mc_new_scorefxn(
   float const best_score,
	 float const low_score,
	 float const best_rms
 );


void
gl_graphics_mc_recover_low( float const low_score, float const low_rms );


void
gl_graphics_mc_trial(
	float const score,
	float const best_score,
	float const low_score,
	float const rms_err,
	std::string const & move_type,
	int const accept_type
);


void
gl_graphics_save_best_scores();

void
get_rsd_color(
							int const i,
							int const, // aa,
							int const nres,
							float & red,
							float & green,
							float & blue
							);


bool
wait_on_graphics();


// called inside fullatom_energy
void
gl_graphics_reset_bonds();

void
gl_graphics_reset_bonds(
	FArray2DB_bool const & pair_moved,
	bool const update_born_radii
);


// called by scorefxn
void
gl_graphics_save_scores( float const total_score, bool const fullatom );



// called by hbonds or water code
void
gl_graphics_store_bond(
	int const seqpos1,
	int const atm1,
	int const seqpos2,
	int const atm2,
	float const bondE,
	graphics::Bond_type const type
);


// called by pose refold
void
gl_graphics_new_pose(
	int const nres,
	bool const fullatom,
	int const anchor_pos
);

void
gl_graphics_new_pose();

void
gl_graphics_clear_trajectory();

void
gl_graphics_append_trajectory( float const score, float const rms );

#endif
#endif
