// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10372 $
//  $Date: 2006-09-19 21:44:45 -0400 (Tue, 19 Sep 2006) $
//  $Author: chu $

#ifndef INCLUDED_grid_docking
#define INCLUDED_grid_docking

//Rosetta headers
#include "pose.h"

#include <iostream>

void
grid_dock_output_all_pdbs(
	pose_ns::Pose & pose,
	int const rb_cutpoint
);

void
progressive_grid_dock_move_from_misc();

void
progressive_grid_dock_move(
	pose_ns::Pose & pose
);

void
grid_search_basic_move(
	pose_ns::Pose & pose,
	int grid_move_index,
	float perturb
);

void
build_grid_move_map();

void
read_GridSearchParam(
);

class GridSearchParam
{
public:
  GridSearchParam ():   //default initialization
    center_(0.0,0.0,0.0),
    axis_(1.0,0.0,0.0),
		fixed_axis_(true),
    step_size_(0.0),
    min_displacement_(1.0),
    max_displacement_(-1.0)
  {}

  void set_move_type( std::string mt ) { move_type_ = mt; }
  std::string get_move_type() const { return move_type_; }

  void set_center( numeric::xyzVector_double cnt ) { center_ = cnt; }
  numeric::xyzVector_double get_center () const { return center_; }

  void set_axis( numeric::xyzVector_double ax ) { axis_ = ax; }
  numeric::xyzVector_double get_axis () const { return axis_; }

  void set_fixed_axis( bool at );
	bool is_fixed_axis() const { return fixed_axis_; }

  void set_step_size( float ss ) { step_size_ = ss; }
  float get_step_size () const { return step_size_; }

  void set_min( float min ) { min_displacement_ = min; }
  float get_min () const { return min_displacement_; }

  void set_max( float max ) { max_displacement_ = max; }
  float get_max () const { return max_displacement_; }

	void translate_rot_center( numeric::xyzVector_double ext_axis, float translate_by);

	void rotate_axis_by_axis( numeric::xyzVector_double ext_axis, float theata);

	void rotate_center_by_axis( numeric::xyzVector_double ext_axis, numeric::xyzVector_double ext_center, float theata);

	void dump_info();

private:
  std::string move_type_;
  numeric::xyzVector_double center_;
  numeric::xyzVector_double axis_;
	bool fixed_axis_;
  float step_size_;
  float min_displacement_, max_displacement_;
};

#endif
