// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15882 $
//  $Date: 2007-07-08 02:10:40 -0400 (Sun, 08 Jul 2007) $
//  $Author: johnk $


// Rosetta Headers
#include "hbonds_ns.h"
#include "HBondSet.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>

// Using
using namespace param;


//bk information about hydrogen bonds, can be used in full atom or
//bk centroid mode

//bk nhbonds    :number of bonds in list
//bk hbdonh_atm :donor proton
//bk hbact_atm  :acceptor atm
//bk hbdon_res  :donor residue
//bk hbact_res  :acceptor residue


namespace hbonds {
	float NODERIV; // used to indicate that no derivative computation is needed
  FArray2D_float NODERIV2D(3,2, 0.0); // don't use value
  FArray3Da_float NODERIV3Da; //  default parameter (value unused) for get_aa_1way_hbond_energy

	HBondSet hbond_set, best_hbond_set;

	std::string hb_stats_tag; // JSS for hb_stats
	bool output_hb_stats( false );

void
	HBeval_lookup_initializer(FArray2D<HBEvalType> & hbe){
		hbe(hbacc_NO  , hbdon_NO) = hbe_NONE; hbe(hbacc_NO  , hbdon_BBN) = hbe_NONE ; hbe(hbacc_NO  , hbdon_SC) = hbe_NONE  ;
		hbe(hbacc_BB  , hbdon_NO) = hbe_NONE; hbe(hbacc_BB  , hbdon_BBN) = hbe_BB   ; hbe(hbacc_BB  , hbdon_SC) = hbe_BSC   ;
		hbe(hbacc_SP2 , hbdon_NO) = hbe_NONE; hbe(hbacc_SP2 , hbdon_BBN) = hbe_SP2B ; hbe(hbacc_SP2 , hbdon_SC) = hbe_SP2SC ;
		hbe(hbacc_SP3 , hbdon_NO) = hbe_NONE; hbe(hbacc_SP3 , hbdon_BBN) = hbe_SP3B ; hbe(hbacc_SP3 , hbdon_SC) = hbe_SP3SC ;
		hbe(hbacc_RING, hbdon_NO) = hbe_NONE; hbe(hbacc_RING, hbdon_BBN) = hbe_RINGB; hbe(hbacc_RING, hbdon_SC) = hbe_RINGSC;
	}

FArray2D<HBEvalType> const HBeval_lookup(hbacc_MAX, hbdon_MAX, HBeval_lookup_initializer);

//FArray1D_float HBE_Weight(hbe_MAX, 0.0); // Weights by HBEvalType, initially all zero.


//tk environment dependency
namespace hb_flags {
	bool use_W_hb_env_dep_tk = { true };
	bool use_W_hb_env_dep_lin = { false };
	bool smooth_env_dep_hb = { true };
  bool fine_hb_categories = { false };
}

namespace hbond_gather {
	bool storage = { false };
}

static FArray1D_float HBdum2_( MAX_HB_PER_ATM ); // energies
static FArray1D_int HBdum3_( MAX_HB_PER_ATM );
static FArray1D_int HBdum4_( MAX_HB_PER_ATM );
static FArray1D_int HBdum5_( MAX_HB_PER_ATM );
static FArray1D_int HBdum6_( MAX_HB_PER_ATM );
static FArray1D_int HBdum7_( MAX_HB_PER_ATM );
static FArray1D_bool HBdum8_( 2 );
static FArray1D_bool HBdum9_( 2 );

}

using namespace hbonds;

//car dummy parameters for evaluating hbond energy
//JSS to eliminate these
//Objexx: static for speed (overflow issue?)
int HBdum1; // nhbonds
FArray1Da_float const HBdum2(HBdum2_); // energies
FArray1Da_int const HBdum3(HBdum3_);
FArray1Da_int const HBdum4(HBdum4_);
FArray1Da_int const HBdum5(HBdum5_);
FArray1Da_int const HBdum6(HBdum6_);
FArray1Da_int const HBdum7(HBdum7_);
FArray1Da_bool const HBdum8(HBdum8_);
FArray1Da_bool const HBdum9(HBdum9_);


