// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17038 $
//  $Date: 2007-09-08 04:26:54 -0400 (Sat, 08 Sep 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_hbonds_ns
#define INCLUDED_hbonds_ns
#include <ObjexxFCL/FArray1Da.hh>

//Rosetta headers
#include "HBondSet.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray3Da.hh>


//bk information about hydrogen bonds, can be used in full atom or
//bk centroid mode

//bk nhbonds    :number of bonds in list
//bk hbdonh_atm :donor proton
//bk hbact_atm  :acceptor atm
//bk hbdon_res  :donor residue
//bk hbact_res  :acceptor residue


namespace hbonds {
  extern float NODERIV; // sentinels indicating deriv need not be computed for hbond_compute_energy
  extern FArray2D_float NODERIV2D;
  extern FArray3Da_float NODERIV3Da;
  // derivative types for aa_1way_hbonds through hb_energy_deriv.
  // NONE is default, ABE_GO is the usual, and DOCK is for docking,
  // which is later refined to indicate acceptor or donor first.
  enum HBDerivType {hbderiv_NONE, hbderiv_ABE_GO, hbderiv_DOCK, hbderiv_DOCK_ACC_DON, hbderiv_DOCK_DON_ACC, hbderiv_ABE_GO_NO_xD, hbderiv_ABE_GO_NO_xH};

	extern HBondSet hbond_set;
  extern HBondSet best_hbond_set;

	extern std::string hb_stats_tag; // JSS for hb_stats
	extern bool output_hb_stats;

  static int const MAX_HB = { 5000 };
  static int const MAX_HB_ATM = { 2048 };
  static int const MAX_HB_PER_ATM = { 8 };

//car hb_types
//car these are the types that rosetta/packer tracks separately
int const SHORT_RANGE_CUTOFF = { 4 };
//car    SRBB_HBTYPE     short range backbone-backbone
//car    LRBB_HBTYPE     long range backbone-backbone
//car    SCBB_HBTYPE     side chain-backbone
//car    SC_HBTYPE       side chain
  enum HBTypes {SRBB_HBTYPE=1, LRBB_HBTYPE, SCBB_HBTYPE, SC_HBTYPE};

//car cutoffs defining what is a hbond
static float const MAX_R = { 3.0 };
static float const MIN_R = { 1.4 }; // AH distance
static float const MIN_xH = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // psi cutoff
static float const MIN_xD = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // theta cutoff
static float const MAX_xH = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // psi cutoff
static float const MAX_xD = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // theta cutoff
static float const R_INTERP_EDGE = { 2.1 };
static float const ANGLE_INTERP_EDGE = { .05 };

static float const MIN_R2 = { MIN_R * MIN_R };
static float const MAX_R2 = { MAX_R * MAX_R };

static float const MAX_HB_ENERGY = { 0.0 }; // at and above this cutoff, not considered a hbond

//car for sidechain hbonds, separate polynomials exist for short and long
//car distances  // JSS This makes their computation rather baroque...
//JSS Need these to be static floats so I can initialize classes with them
static float const SWITCH_DIS = { 2.1 }; // distance cutoff for sidechain hbonds tables
static float const INTERP_RANGE = { 0.2 };
 // interpolate if AH dist falls between switch +/- range
static float const INTERP_MIN = { SWITCH_DIS - INTERP_RANGE };
static float const INTERP_MAX = { SWITCH_DIS + INTERP_RANGE };


//JSS Chemtypes determine which hbond scoring function applies to AHdist, theta, psi, chi, burial
// Chemtypes assigned to atomtypes in aaproperties_pack.cc;
// The lookup table from accchemtype,donorchemtype to evaltype in hbonds_ns.cc
enum HBEvalType {hbe_NONE, hbe_BB, // no bond, generic BB/BB (only refined are used)
								 hbe_BBTURN, hbe_BBHELIX, // BB/BB short range
								 hbe_BBOTHER, // keep BB/BB consecutive for hbond_compute_energy
								 hbe_SP2B, hbe_SP3B, hbe_RINGB,// BB donor, SC acceptor
								 hbe_BSC, // BB acceptor, SC donor
								 hbe_SP2SC, hbe_SP3SC, hbe_RINGSC, //SC/SC
								 hbe_MAX=hbe_RINGSC}; // hbe_MAX should always be # of last

inline bool hbe_is_BB_type(HBEvalType hbe) { return (hbe <= hbe_BBOTHER) && (hbe >= hbe_BB); }
inline bool hbe_is_SC_type(HBEvalType hbe) { return (hbe > hbe_BBOTHER); }


enum HBDonChemType	{hbdon_NO = 1, hbdon_BBN, hbdon_SC, hbdon_MAX=hbdon_SC}; // existing donor classes
//enum HBDonChemType	{hbdon_NO = 1, hbdon_BBN, hbdon_SCN, hbdon_SCOH, hbdon_HOH, hbdon_MAX=hbdon_HOH}; // recommended donor classes
enum HBAccChemType	{hbacc_NO = 1, hbacc_BB, hbacc_SP2, hbacc_SP3, hbacc_RING, hbacc_MAX=hbacc_RING}; // existing acceptor classes

extern FArray2D<HBEvalType> const HBeval_lookup;


//car hybridization types -- JSS please use ChemTypes above for hbonding
enum HYBRIDIZType {H_HYBRID = 1, SP2_HYBRID, SP3_HYBRID, RING_HYBRID};

//tk environment dependency
namespace hb_flags {
	extern bool use_W_hb_env_dep_tk;
	extern bool use_W_hb_env_dep_lin;
	static bool const check_hbenergy = false; // for debugging
	extern bool smooth_env_dep_hb;
	extern bool fine_hb_categories;
}
using namespace hb_flags;


namespace hbond_gather {
	extern bool storage;
}

//JSS Useful #defines to set up hbonds_geom scoring polynomials of the form
// name(/*in*/ double x, /*out*/ double &value, double &deriv);
// You shouldn't have to look at these; The idea is to auto-generate
// the calls to create_poly#() using matlab scripts to fit polynomials.
// POLY_CLIPVAL is the polynomial value outside of clip interval [xmin xmax]
// See hbonds_geom.cc for more comments.
#define POLY_CLIPVAL 0.0
#define create_poly8(name, xmin, xmax, c7, c6, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c7; value = value*x+c6; deriv = deriv*x+value; value = value*x+c5; deriv = deriv*x+value; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly7(name, xmin, xmax, c6, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c6; value = value*x+c5; deriv = deriv*x+value; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly6(name, xmin, xmax, c5, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c5; value = value*x+c4; deriv = deriv*x+value; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly5(name, xmin, xmax, c4, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c4; value = value*x+c3; deriv = deriv*x+value; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly4(name, xmin, xmax, c3, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c3; value = value*x+c2; deriv = deriv*x+value; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly3(name, xmin, xmax, c2, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c2; value = value*x+c1; deriv = deriv*x+value; value = value*x+c0; }
#define create_poly2(name, xmin, xmax, c1, c0) inline void name(double x, double &value, double &deriv) { if ( (x<=xmin) || (x>=xmax) ) {value = POLY_CLIPVAL; deriv = 0.0; return; } value = deriv = c1; value = value*x+c0; }

}

//car dummy parameters for evaluating hbond energy
//JSS to eliminate
//Objexx: static for speed (overflow issue?)
extern int HBdum1; // nhbonds
extern FArray1Da_float const HBdum2; // energies
extern FArray1Da_int const HBdum3;
extern FArray1Da_int const HBdum4;
extern FArray1Da_int const HBdum5;
extern FArray1Da_int const HBdum6;
extern FArray1Da_int const HBdum7;
extern FArray1Da_bool const HBdum8;
extern FArray1Da_bool const HBdum9;

#endif
