// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11287 $
//  $Date: 2006-11-13 20:18:54 -0500 (Mon, 13 Nov 2006) $
//  $Author: johnk $

#ifndef INCLUDED_initialize
#define INCLUDED_initialize

#include <sstream>
#include <vector>
#include <string>

// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// initialize Function Declarations


void
initialize_query();


void
reset_secstruct();


void
initialize_start(
	std::string const & mode,
	int const startnum,
	int const outputnum,
	std::string & status, // return status
  std::stringstream *pdbdata=NULL    // mtyka: if == NULL, behaves normally
	                                   //        if != NULL, it will read PDB
																		 //                    from the memory block
);


void
initialize_decoy();


void
store_native( bool const input_fa, bool const output_fa );


bool
get_native_exists();


void
save_START();


void
delete_START();


void
setup_start_list(
	int & nstartnm, // number of starting pdb names
	FArray1D_string & startnm, // starting pdb files
	FArray1D_string & outnm, // output pdb files
	FArray1D_char & startch // starting chain id
);


void
read_start_list(
	std::string const & listname,
	int & nstartnm, // number of starting pdb names
	FArray1D_string & startnm, // starting pdb files
	FArray1D_string & outnm, // output pdb files
	FArray1D_char & startch // starting chain id
);


void
make_start_list(
	int & nstartnm, // number of starting pdb names
	FArray1D_string & startnm, // starting pdb files
	FArray1D_string & outnm, // output pdb files
	FArray1D_char & startch // starting chain id
);


void
calc_filename_max_length(
	int const nstartnm,
	FArray1D_string const & outnm
);


void
retrieve_filename_max_length( int & fml );


void
retrieve_native_centroid_pose();


void
initialize_set_native_pose( pose_ns::Pose & pose );


pose_ns::Pose &
initialize_get_native_pose();


void
initialize_set_start_pose( pose_ns::Pose & pose );


pose_ns::Pose &
initialize_get_start_pose();


void
initialize_set_decoy_pose( pose_ns::Pose & pose );


pose_ns::Pose &
initialize_get_decoy_pose();


bool
get_use_barcode_to_score();

bool get_apply_filters_flag();

void
read_checkpoint_decoy(
	std::string filename,
	bool fullatom
);

bool nucleic_acids_check( std::string const mode );

#ifdef BOINC_GRAPHICS
void
get_wu_desc();
#endif

#endif
