// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 14:54:04 -0500 (Wed, 23 Jan 2008) $
//  $Author: possu $


// Rosetta Headers
#include "int_fullatom_energies.h"
#include "analyze_interface_ddg_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// Using
using namespace analyze_interface_ddg_ns;


namespace int_fullatom_energies {


void
initialize_MAX_MUT_STRUCTS()
{
	static bool initialized( false );
	const int max_mut_structs = 20000;
	if ( ! initialized )
	{
		MAX_MUT_STRUCTS() = max_mut_structs;
		initialized = true;
	}
}

//tk energetic contributions to the fullaton energy for interface mode


//tk contributions to the TOTAL energy
//tk for protein complexes: complex_*(3)
//tk where 1: partner 1
//tk       2: partner 2
//tk       3: complex

namespace complex_energies {
	FArray1D_float complex_atrenergy( 3, 0.0f );
	FArray1D_float complex_repenergy( 3, 0.0f );
	FArray1D_float complex_solenergy( 3, 0.0f );
	FArray1D_float complex_probenergy( 3, 0.0f );
	FArray1D_float complex_dunenergy( 3, 0.0f );
	FArray1D_float complex_intraresenergy( 3, 0.0f );
	FArray1D_float complex_unfenergy( 3, 0.0f );
	FArray1D_float complex_protonation_energy( 3, 0.0f );
	FArray1D_float complex_hbenergy( 3, 0.0f );
	FArray1D_float complex_resenergy( 3, 0.0f );
	FArray1D_float complex_pair_energy( 3, 0.0f );
	FArray1D_float complex_plane_energy( 3, 0.0f );
	FArray1D_float complex_h2oenergy( 3, 0.0f );
	FArray1D_float complex_h2ohbenergy( 3, 0.0f );
	FArray1D_float complex_h2osolenergy( 3, 0.0f );
	FArray1D_float complex_sasa_gsolt( 3, 0.0f );
	FArray1D_float complex_sasa_polar( 3, 0.0f );
	FArray1D_float complex_sasa_apolar( 3, 0.0f );
	FArray1D_float complex_sasa_pack( 3, 0.0f );
	FArray1D_float complex_bbhb_uns( 3, 0.0f );
	FArray1D_float complex_schb_uns( 3, 0.0f );
	FArray1D_float complex_gu_tot( 3, 0.0f );
	FArray1D_float complex_Wgu_tot( 3, 0.0f );
	//ja ddg per residue
	FArray2D_float complex_resenergy_res( 3, param::MAX_RES(), 0.0f );
  FArray1D_float complex_elecenergy( 3, 0.0f );
}


//tk contributions to the TOTAL energy
//tk for wild-type complex wt_*(3)

namespace wt_energies {
	FArray1D_float wt_atrenergy( 3, 0.0f );
	FArray1D_float wt_repenergy( 3, 0.0f );
	FArray1D_float wt_solenergy( 3, 0.0f );
	FArray1D_float wt_probenergy( 3, 0.0f );
	FArray1D_float wt_dunenergy( 3, 0.0f );
	FArray1D_float wt_intraresenergy( 3, 0.0f );
	FArray1D_float wt_unfenergy( 3, 0.0f );
 	FArray1D_float wt_protonation_energy( 3, 0.0f );
	FArray1D_float wt_hbenergy( 3, 0.0f );
	FArray1D_float wt_resenergy( 3, 0.0f );
	FArray1D_float wt_pair_energy( 3, 0.0f );
	FArray1D_float wt_h2oenergy( 3, 0.0f );
	FArray1D_float wt_h2ohbenergy( 3, 0.0f );
	FArray1D_float wt_h2osolenergy( 3, 0.0f );
	FArray1D_float wt_sasa_gsolt( 3, 0.0f );
	FArray1D_float wt_sasa_polar( 3, 0.0f );
	FArray1D_float wt_sasa_apolar( 3, 0.0f );
	FArray1D_float wt_sasa_pack( 3, 0.0f );
	FArray1D_float wt_bbhb_uns( 3, 0.0f );
	FArray1D_float wt_schb_uns( 3, 0.0f );
	FArray1D_float wt_gu_tot( 3, 0.0f );
	FArray1D_float wt_Wgu_tot( 3, 0.0f );
}



//tk contribution to the BINDING free energy
//tk for all mutations in the mutation list: dgbind_*(MAX_MUT_STRUCTS(), 0.0f)
//tk where dgbind_*(1): denotes the WT binding energy

namespace dgbind_energies {
	FArray1D_float dgbind_atrenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_repenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_solenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_probenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_dunenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_intraresenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_unfenergy( MAX_MUT_STRUCTS(), 0.0f );
 	FArray1D_float dgbind_protonation_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_hbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_resenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_pair_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_h2oenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_h2ohbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float dgbind_h2osolenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_sasa_gsolt( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_sasa_polar( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_sasa_apolar( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_sasa_pack( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_bbhb_uns( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_schb_uns( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_gu_tot( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float D_Wgu_tot( MAX_MUT_STRUCTS(), 0.0f );
}


//tk complex_fullatomE :total full atom energy,no backbone-backbone hbondenergies

namespace int_totals {
	FArray1D_float complex_fullatomE( 3, 0.0f );
	FArray1D_float complex_hbenergy_srbb( 3, 0.0f );
	FArray1D_float complex_hbenergy_lrbb( 3, 0.0f );
}


//ds contributions to the intrinsic free energy for each chain in the complex.
//ds These variables are currently only used if the alter_spec_format flag is used.

namespace intrinsic_chain_energies {
	FArray1D_float chainA_atrenergy( MAX_MUT_STRUCTS(), 0.0f ); // Chain "A"
	FArray1D_float chainA_repenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_solenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_probenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_dunenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_intraresenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_unfenergy( MAX_MUT_STRUCTS(), 0.0f );
 	FArray1D_float chainA_protonation_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_hbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_resenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_pair_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_h2oenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_h2ohbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainA_h2osolenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_atrenergy( MAX_MUT_STRUCTS(), 0.0f ); // Chain "B"
	FArray1D_float chainB_repenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_solenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_probenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_dunenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_intraresenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_unfenergy( MAX_MUT_STRUCTS(), 0.0f );
 	FArray1D_float chainB_protonation_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_hbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_resenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_pair_energy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_h2oenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_h2ohbenergy( MAX_MUT_STRUCTS(), 0.0f );
	FArray1D_float chainB_h2osolenergy( MAX_MUT_STRUCTS(), 0.0f );
}


}
