// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11160 $
//  $Date: 2006-11-04 19:12:21 -0500 (Sat, 04 Nov 2006) $
//  $Author: johnk $


// Rosetta Headers
#include "interface.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// Using
using namespace param;


// variables pertaining to the definition of the interface


namespace interface {


int const max_docking_sites = { 2 };

// array indicating residues at the interface under 6A definitions

namespace interface_data {
	FArray1D_bool int_res( MAX_RES() ); // mark residues at the interface
	FArray1D< utility::vector1_int >  int_res_list( max_docking_sites );
	FArray1D< utility::vector1_int >  int_pair_list( max_docking_sites );
}


// array indicating residues at the interface under 8A definitions

namespace interface_data8 {
	FArray1D_bool int_res8( MAX_RES() ); // mark residues at the interface
	FArray1D< utility::vector1_int >  int_res_list8( max_docking_sites );
	FArray1D< utility::vector1_int >  int_pair_list8( max_docking_sites );
}


// stuff for remembering site constraints and scoring them
int const max_site_constraints = { 20 };


namespace site_data {
	bool site_constraints_exist;
	FArray1D< utility::vector1_int > site_constraint_residues( max_site_constraints );
	FArray1D_float site_constraint_bonus( max_site_constraints );
	float site_constraint_filter_score = { 9999. };
	int N_site_constraints;
}


// or for remembering the native site

namespace native_sites {
	FArray1D< utility::vector1_int > native_site_residues( max_docking_sites );
}


// distance constraints

namespace dist_data {
	bool dist_constraint_exists;
	FArray1D_int dist_constraint_residues( 2 );
	float dist_constraint_distance_sq;
}


//chu for calculating fraction of native contacts
//ora and number of contacts

namespace docking_contact_map {
	FArray2D_bool docking_native_contact_map( MAX_RES(), MAX_RES() );
	int n_native_contact;
	float frac_native_contact;
	float frac_nonnat_contact;
	int n_contacts;
}


}
