// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10468 $
//  $Date: 2006-09-30 00:55:51 -0400 (Sat, 30 Sep 2006) $
//  $Author: rhiju $

#ifndef INCLUDED_jumping_loops
#define INCLUDED_jumping_loops

#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

#include <vector>

// Forward declarations
namespace pose_ns { class Loops; }

// Types
typedef  float (*Scoring_Function)();


// jumping_loops Function Declarations


void
set_jmp_chainbreak_weight( float const weight /* input */ );


void
jmp_show_chainbreaks( pose_ns::Pose const & pose );


void
jmp_get_chainbreaks_by_loops(
	pose_ns::Pose const & pose,
	pose_ns::Loops const & loops,
	std::vector< float > & chain_breaks
);


void
set_jmp_chainbreak_overlap( int const setting /* input */ );


float
jmp_chainbreak_score();


void
scored_ccd_loop_closure(
	int const loop_begin,
	int const loop_end,
	int const cutpoint,
	int const ii_cycles,
	Scoring_Function score_fxn, // input
	float & forward_deviation, // output
	float & backward_deviation, // output
	bool const score_check,
	bool const rama_check
);


void
calculate_ccd_angle(
	FArray2Da_double F,
	FArray2Da_double M,
	int const n_atoms,
	int const pos,
	int const torsion,
	int const direction,
	double & angle,
	double & dev
);


void
Dassert_equal(
	double const a,
	double const b,
	int const tag
);


void
get_overlap_pos_old_refold(
	int const pos,
	int const direction,
	FArray2Da_double M // output
);


void
get_overlap_pos(
	int const cutpoint,
	int const dir,
	FArray2Da_double M // output
);


void
get_overlap_pos_pose(
	pose_ns::Pose const & pose,
	FArray3DB_float const & Eposition,
	int const cutpoint,
	int const dir,
	FArray2Da_double M // output
);


void
get_overlap_stub_loops(
	int const dir,
	int const seqpos,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


void
get_torsion_axis(
	int const pos,
	int const torsion,
	FArray1Da_double A,
	FArray1Da_double axis_vector
);


void
test_jumping_loop_closure();


int
fast_ccd_loop_closure(
	pose_ns::Pose & pose,
	int const loop_begin,
	int const loop_end,
	int const cutpoint,
	int const ii_cycles,
	float const tolerance,
	bool const rama_check,
	float const max_rama_score_increase,
	float const max_total_delta_helix,
	float const max_total_delta_strand,
	float const max_total_delta_loop,
	float & forward_deviation, // output
	float & backward_deviation, // output
	float & torsion_delta,
	float & rama_delta
);


void
refold_loop_torsion(
  float const alpha,
	int const pos,
	int const torsion,
	int const dir,
	int const cutpoint,
	FArray3DB_float & Epos,
	FArray2Da_double M
);


float
calc_chainbreak(
	FArray3Da_float Epos,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega
);

void
ccd_moves(
	const int total_moves,
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int cutpoint
);

bool
get_wobble_CCD();

void
close_loop_at_cutpoint(
	int const cutpoint,
	pose_ns::Pose & ccd_pose,
	int splint_begin,
	int splint_end,
	bool & closed_loop,
	float & deviation_score,
	float & rama_delta
);


void
add_fast_wobble_CCD(
	int & frag_begin,
	int size,
	int nwobble,
	int wobble_gap,
	float & rama_score,
	float & msd_score,
	bool & gfrag,
	int & fold_begin,
	int & fold_end
	);

#endif
