// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_jumping_pairings_ns
#define INCLUDED_jumping_pairings_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <cstdlib>
#include <vector>


namespace pairing_ns {
	class Pairing {
	public:
		int pos1;
		int pos2;
		int orientation;
		int pleating;
	};
	typedef std::vector<Pairing> Pairing_list;
}

namespace jumping_pairings {
	// constants
	extern int const max_sheets;
	extern int const max_sheet_size;

	extern int const parallel_orientation;
	extern int const antiparallel_orientation;
}

namespace same_strand_ns {
	// useful bool array derived from fragment "E" fractions
	// whether or not two residues are considered to be in the
	// same strand or not.
	extern FArray2D_bool same_strand;
}


#endif
