// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_bonded_atom
#define INCLUDED_kin_bonded_atom


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_moving_atom.h"
#include "kin_atom_bad_return_vals.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Bonded_atom : public Moving_atom {
	public:


		///////////////////////////////////////////////////////////////////////////
		// go back and forth between torsions and coords
		virtual
		void
		update_coords(
			Stub & stub,
			Coords & coords // could be a simple wrapper for FArray
		) const;


		virtual
		void
		update_torsions(
			Stub & stub,
			Coords const & coords,
			bool const recursive = true
		);


		///////////////////////////////////////////////////////////////////////////
		// access torsions
		virtual
		void
		set_torsion(
			Kin_torsion_type const type,
			float const value
		);


		virtual
		float
		get_torsion(
			Kin_torsion_type const type
		) const;


		virtual
		pose_ns::Jump const &
		jump() const { abort_bad_call(); return BAD_JUMP; }


		virtual
		pose_ns::Jump &
		jump() { abort_bad_call(); return BAD_JUMP; }


		virtual
		void
		show_allow_move() const {
			if ( !phi_fixed ) std::cout << atom_id << " PHI moving" << std::endl;
			if ( !theta_fixed ) std::cout << atom_id << " THETA moving" << std::endl;
			if ( !d_fixed ) std::cout << atom_id << " D moving" << std::endl;
			for ( std::vector< Atom* >::const_iterator it= atoms.begin(),
							it_end = atoms.end(); it != it_end; ++it ) {
				(*it)->show_allow_move();
			}
		}

		// copy:
		virtual
		Atom*
		copy( Atom* parent_in ) const;


		///////////////////////////////////////////////////////////////////////////
		// for minimizing
		virtual
		void
		setup_min_map(
			Torsion_id & last_torsion,
			Minimizer_map & min_map
		) const;


		virtual
		void
		get_torsion_axis_and_end_pos(
			Coords const & coords,
			numeric::xyzVector_float & axis,
			numeric::xyzVector_float & end_pos,
			Kin_torsion_type const type
		) const;


		///////////////////////////////////////////////////////////////////////////
		// miscellaneous inspection
		virtual
		bool
		is_jump() const { return false; }


		virtual
		bool
		torsions_fixed() const { return phi_fixed && theta_fixed && d_fixed; }


		virtual
		bool
		keep_torsion_fixed(
			Kin_torsion_type const type
		) const;


		virtual
		bool
		get_allow_move(
			Kin_torsion_type const type
			) const;


		///////////////////////////////////////////////////////////////////////////
		// copy torsions, torsion_moved, allow_move
		virtual
		void
		copy_torsions( Atom const & src );

		///////////////////////////////////////////////////////////////////////////
		// setting miscellaneous stuff

		virtual
		void
		set_allow_move(
			Kin_torsion_type const type,
			bool const setting
		);


		//protected:

		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// protected methods
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		// useful helper function for manipulating stubs
		virtual
		void
		update_stub(
			Stub & stub
		) const;


		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// data
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		double phi, theta, d;
		bool phi_fixed, theta_fixed, d_fixed;

	};
}
#endif
