// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_min
#define INCLUDED_kin_min


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {



	/////////////////////////////////////////////////////////////////////////////
	class Atom_node {
	public:
		Atom_node( Atom_id const & id_in ):id( id_in ) {}

		inline
		int
		rsd() const { return id.rsd(); }

		inline
		int
		atomno() const { return id.atomno(); }

		inline
		std::vector< Atom_node* >::iterator
		nbr_list_begin() { return nbrs.begin(); }

		inline
		std::vector< Atom_node* >::iterator
		nbr_list_end() { return nbrs.end(); }

		inline
		void
		add_nbr( Atom_node* nbr ) { nbrs.push_back( nbr ); }

	private:
		Atom_id id;
		std::vector< Atom_node* > nbrs;
	};


	/////////////////////////////////////////////////////////////////////////////
	class Torsion_node {
	public:
		inline
		numeric::xyzVector_float &
		F1() { return F1_; };

		inline
		numeric::xyzVector_float &
		F2() { return F2_; }

		inline
		numeric::xyzVector_float const &
		F1() const { return F1_; };

		inline
		numeric::xyzVector_float const &
		F2() const { return F2_; }

		inline
		int
		rsd() const { return id.atom_id().rsd(); }

		inline
		int
		atomno() const { return id.atom_id().atomno(); }

		inline
		Atom_id const &
		atom_id() const { return id.atom_id(); }

		inline
		Kin_torsion_type
		type() const { return id.type(); }

		inline
		Torsion_id const &
		torsion_id() const { return id; }

		inline
		int depth() const;

		inline
		std::vector< Atom_node* >::const_iterator
		atoms_begin() const { return atoms.begin(); }

		inline
		std::vector< Atom_node* >::const_iterator
		atoms_end() const { return atoms.end(); }

		inline
		void
		add_atom( Atom_node* const atom ) { atoms.push_back( atom );}


		void
		get_rosetta_type(
			int & tor_no,
			int & tor_rsd
		) const;

		void
		set_rosetta_torsion_type(
			int const torsion,
			int const rsd
		);

		void
		link_vectors();

		// constructor
		Torsion_node(
			Torsion_id const & id_in,
			Torsion_node* const parent_in
		):
			F1_(0.0),
			F2_(0.0),
			depth_(-1),
			id( id_in ),
			parent( parent_in )
		{}

	private:
		numeric::xyzVector_float F1_;
		numeric::xyzVector_float F2_;
		mutable int depth_;
		Torsion_id id;
		std::vector< Atom_node* > atoms;
		Torsion_node* parent;
		int rosetta_torsion_type;
		int rosetta_torsion_rsd;


		friend
		inline
		bool
		operator< ( Torsion_node const & t1, Torsion_node const & t2 ) {
			return ( t1.depth() > t2.depth() ); // check that this gives correct sort
		}
	};


	inline
	int
	Torsion_node::depth() const
	{
		if ( parent == 0 ) {
			depth_ = 0;
		} else if ( depth_ < 0 ) {
			depth_ = parent->depth() + 1;
		}
		assert( depth_ >= 0 );
		return depth_;
	}



	/////////////////////////////////////////////////////////////////////////////
	class Minimizer_map {
	public:
		typedef std::list< Torsion_node* >::iterator Torsion_iterator;
		typedef std::list< Torsion_node* >::const_iterator Torsion_const_iterator;

		void
		setup(
			pose_ns::Pose & pose,
			bool const use_nblist_in
		);

		void
		add_torsion(
			Torsion_id const & new_torsion,
			Torsion_id const & parent
		);

		void
		add_atom(
			Atom_id const & atom_id,
			Torsion_id const & torsion
		);

		void
		add_to_nblist(
			int const atomno1,
			int const rsd1,
			int const atomno2,
			int const rsd2
		);


		Torsion_iterator torsions_begin();
		Torsion_iterator torsions_end();
		Torsion_const_iterator torsions_begin() const;
		Torsion_const_iterator torsions_end() const;

		void
		get_nbr_bounds(
			Atom_node* atom1,
			std::vector< Atom_node* >::const_iterator & atom2_begin,
			std::vector< Atom_node* >::const_iterator & atom2_end
		) const;

		// this will only work if torsions are sorted!
		void
		link_torsion_vectors();

		//
		void
		zero_torsion_vectors();

		void
		reset();

		void
		pack_phipsi(
			pose_ns::Pose const & pose,
			FArray1DB_float & phipsi
		) const;

		void
		unpack_phipsi(
			pose_ns::Pose & pose,
			FArray1DB_float const & phipsi
		) const;

		inline
		int
		nangles() const { return torsions.size(); }

		inline
		std::vector< Atom_node * >::const_iterator
		atoms_begin() const { return atoms.begin(); }

		inline
		std::vector< Atom_node * >::const_iterator
		atoms_end() const { return atoms.end(); }

		inline
		bool
		use_nblist() const { return use_nblist_; }

		// this is used in pack/unpack_phipsi and deriv calculation
		float
		torsion_scale_factor(
			Torsion_node const & tor
		) const;

	private:
		std::list< Torsion_node* > torsions;
		std::vector< Atom_node* > atoms;
		std::map< Torsion_id, Torsion_node* > torsion_id_map;
		FArray2D< Atom_node* > atom_node_pointer; // could also be std::map
		bool use_nblist_;

		void
		assign_rosetta_torsions( pose_ns::Pose const & pose ); // part of setup

		void
		update_nblist( pose_ns::Pose & pose );

	};
}


#endif
