// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#include "kin_test.h"
#include "aa_name_conversion.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "cst_countpair.h"
#include "cst_descriptor.h"
#include "cst_set.h"
#include "dna_ns.h"
#include "dunbrack_pack.h"
#include "Dunbrack4D.h"
#include "Dunbrack5D.h"
#include "enzyme.h"
#include "enzyme_ns.h"
#include "files_paths.h"
#include "jumping_ns.h"
#include "kin_atom.h"
#include "kin_util.h"
#include "ligand.h"
#include "input_pdb.h"
#include "jumping_util.h"
#include "make_pdb.h"
#include "minimize.h"
#include "nblist.h"
#include "misc.h"
#include "namespace_fullatom_flag.h"
#include "pack.h"
#include "param_aa.h"
#include "param.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_dna.h"
#include "pose_ligand.h"
#include "prof.h"
#include "random_numbers.h"
#include "read_aaproperties.h"
#include "recover.h"
#include "refold.h"
#include "runlevel.h"
#include "rotamer_functions.h"
#include "score.h"
#include "util_interpolate.h"
#include "packing_measures.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.o.hh>

// Numeric Headers
#include <numeric/conversions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/orstream.hh>
#include <utility/io/ozstream.hh>
#include <utility/io/izstream.hh>

#include <cstdlib>
#include <iostream>
#include <fstream>
#include <list>

///////////////////////////////////////////////////////////////////////////////
void
kin_test()
{
	using namespace pose_ns;
	using namespace kin;

	// test building from sidechain outward
	Pose pdb_pose;
	pose_from_pdb( pdb_pose, "/work/pbradley/cfr/one_chain_0001.pdb",
								 true, false );

	int const nres( pdb_pose.total_residue() );
	int const cutpoint( nres/2 );
	int const jump_pos1( 31 );
	int const jump_pos2( 63 );
	int const tyr_hh( 14 );
	int const glu_cd( 7 );
	int const glu_oe2( 9 );

	if ( false ) { // first test
		Pose pose;
		pose = pdb_pose;

		// from pose.cc
		Fold_tree f;
		f.clear();
		f.add_edge( jump_pos1, jump_pos2, 1 );
		f.add_edge(1,jump_pos1, pose_param::PEPTIDE );
		f.add_edge(jump_pos1,cutpoint, pose_param::PEPTIDE );
		f.add_edge(cutpoint+1,jump_pos2, pose_param::PEPTIDE);
		f.add_edge(jump_pos2,nres, pose_param::PEPTIDE);
		f.reorder(1);


		// the new hack:
		f.set_jump_atoms( 1, tyr_hh, glu_oe2, false );

		pose.set_fold_tree(f);

		pose.setup_atom_tree(); // uses the extra atom info in fold_tree

		pose.dump_pdb("test1.pdb");

		Atom_id glu_cd_atom( glu_cd, jump_pos2 );
		Torsion_id tor( glu_cd_atom, PHI );
		Torsion_id tor2( glu_cd_atom, THETA );
		pose.set_allow_move( tor, true );
		pose.set_allow_move( tor2, true );

		float const start_phi( pose.get_atom_tree_torsion( tor ) );
		for ( int i=0; i<10; ++i ) {
			pose.set_atom_tree_torsion( tor, start_phi + 0.1*i );
			pose.dump_pdb("test_"+string_of(i)+".pdb");
		}
	}


	{
		// completely different: mini-pose with just 31 and 63
		// try to optimize hbond geometry...
		//
		Pose pose;
		Fold_tree f;
		f.add_edge(1,2,1);
		f.set_jump_atoms( 1, tyr_hh, glu_oe2, true );
		pose.set_fold_tree(f);
		pose.set_fullatom_flag( true, false );
		pose.copy_segment(1,pdb_pose,1, jump_pos1 );
		pose.copy_segment(1,pdb_pose,2, jump_pos2 );
		pose.dump_pdb( "test1.pdb" );

		pose.setup_atom_tree();
		pose.dump_pdb( "test2.pdb" );

		pose.set_allow_jump_move( true );

		Score_weight_map w;
		//		w.set_weight( HB_SC, 1.0 );
		w.set_weight( HB_SC, 100.0 );
		minimize_set_tolerance( 1e-12 );
		pose.main_minimize( w, "dfpmin" );

		pose.dump_pdb( "test3.pdb" );

	}


	std::exit(0 );
}

///////////////////////////////////////////////////////////////////////////////
//
// cst_mode
// Lin Jiang
//
// input constraint from two format:
//             single line format: "-cst_from_file <single_line.cst>"
//             complicate format:  "-cstfile <complex.cst>"
//             enzyme cst format:  "-read_enzyme_cst"
//
// if minimization involving in ligand, the flag "enable_ligand_aa" should be turned on
// ligand will be treated as a new amino acid type( lig1, lig2), there is nothing
// special for ligand during the energy calculation, expect the initial setup for
// new amino acid type
//

//lin cst_mode_test interface
void
cst_mode_test()
{
  using namespace enzyme;
  using namespace pose_ns;
	using namespace cst_allow_move_ns;
  using namespace cst_set_ns;
  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
  using namespace packer_cst_ns;
	using namespace files_paths;

  //function param
  Pose pose, pose_saved ;
	Packer_cst_set packer_cst; //lin constraint for packer
	Cst_set pose_cst; //lin constraint for pose minimization
	Allow_move_set allow_move; //lin set of allow_move
  cst_set_descriptor csts;   //lin cst class for handling the input and output

	//lin set the cst_mode flag and get the cst_mode option
	set_cst_mode_flag( true );

	//lin  read a list of scaffold files
	std::vector< std::string > files;
	creat_scaffolds_list( files, "l", "s" );

	//lin read the patches
	bool const read_patches ( truefalseoption( "read_patches" ) );

	//lin loop the files
	for(int ii=0,ie=files.size(); ii<ie; ii++ ) {
		//lin input output name
		std::string inputpdbname, outname, outname_saved, listname;
		{
			inputpdbname =  start_path + files[ii] + ".pdb";
			if( use_pdbout ) {
				outname = pdb_out_path + pdboutname;
			} else {
				outname = pdb_out_path + files[ii];
			}
		}

		//lin read the pdb scaffold
		bool const fullatom( true );
		bool const ideal_pose( false );
		std::cout<<"cst_mode: read the scaffold " << inputpdbname << std::endl;
		{
			bool const old_flag ( get_read_ligaa_flag() );
			//skipping read the ligand from scaffold if read_patches
			if( read_patches ) set_read_ligaa_flag( false );
			pose_from_pdb( pose, inputpdbname, fullatom, ideal_pose, true );
			if( read_patches ) {
				set_read_ligaa_flag( old_flag );
				setup_part_from_domains();//reset the docking part
			}
		}

		//lin read a list of the patches
		std::vector< std::string > patches;
		if( read_patches ) {
			listname = start_path + files[ii] + ".list";
			creat_scaffolds_list( patches, "pl", "ps", listname );
		} else {
			patches.push_back("none");
		}

		//lin loop the patches
		for(int jj=0, je=patches.size(); jj<je; jj++ ) {

			//lin backup
			if( jj > 0 )  {
				pose = pose_saved;
				outname = outname_saved;
			} else if( jj == 0 ) {
				pose_saved = pose;
				outname_saved = outname;
			}

			//lin read patch ( ligand + res )
			//lin read the ligand if get_enable_ligaa_flag()
			if( read_patches ) outname = start_path + patches[jj] ;

			//lin check if overwrite_pdbs
			if( check_overwrite_decoys( outname ) ) {
				continue; // skipping....
			} else {
				write_checkpoint( outname, "BEGIN" );
			}

			if( read_patches ) {
				Pose patch_pose;
				inputpdbname =  start_path + patches[jj] + ".pdb";

				std::cout<<" cst_mode: read the patch input pdb " << inputpdbname << std::endl;
				//make sure the setup_part_from_domains is not called
				bool save_cst_flag ( get_cst_mode_flag() );
				bool const save_ligaa_flag ( get_enable_ligaa_flag() );
				set_cst_mode_flag(false);
				set_enable_ligaa_flag(false);
				pose_from_pdb( patch_pose, inputpdbname, fullatom, ideal_pose, true );
				set_cst_mode_flag(save_cst_flag);
				set_enable_ligaa_flag(save_ligaa_flag);

				for( int i=1; i<= patch_pose.total_residue(); ++i ) {
					pose.copy_sidechain( patch_pose.pdb_info().pdb_res_num(i), patch_pose.res(i),
															 patch_pose.res_variant(i), patch_pose.full_coord()(1,1,i) );
				}
			}

			//lin reading and set up all classes
			cst_mode_io( inputpdbname, pose, pose_cst, packer_cst, csts, allow_move );


			//lin main function
			cst_mode_test( outname, pose, pose_cst, packer_cst, csts, allow_move );

			// checkpoint
			write_checkpoint( outname, "END" );

		}//end loop the patches
	}//end loop the file

  if (truefalseoption("make_packing_pdb")) {
    std::string outname = pdb_out_path + files[0] + "_packing.pdb";
    utility::io::ozstream out(outname);
    packing_ns::ProteinSasa* df_protein_sasa_ = new packing_ns::ProteinSasa();
    df_protein_sasa_->compute_atom_bsasa_score();
    df_protein_sasa_->compute_cavity_ball_burial();
    df_protein_sasa_->makePackingPDB(out, true);
    df_protein_sasa_->setup_fasc_cols();
    delete df_protein_sasa_;
  }
  // silly message for autobench
  std::cout << "DONE :: pose_test1" << std::endl;
	exit(0);

}


///////////////////////////////////////////////////////////////////////////////
//
// minimization demo

void
mj_min_test()
{
	// using
	using namespace pose_ns;
	using namespace param;
	using namespace kin;
	using namespace cst_set_ns;
	using numeric::conversions::radians;
	using numeric::conversions::degrees;


	// params
	// note that bond angles and torsions are stored in the atom_tree
	// as radians, hence the degrees(1.0) term in the tether weights
	// below -- this converts the tether score to degrees, which
	// is easier to think about
	//
	int const lig_root_atomno( 1 ); // 1st hetero heavyatom in pdb file
	float const bond_length_tether( 10000.0 );
	float const bond_angle_tether( degrees(1.0) * degrees(1.0) * 10.0 );
	float const bond_torsion_tether( degrees(1.0) * degrees(1.0) );
	//float const bond_length_tether( 0.01 );
	//float const bond_angle_tether( 0.01 );
	//float const bond_torsion_tether( 0.01 );



	// read in the starting structure
	// will trigger read_pdb_hetero
	Pose pose;
	bool const fullatom( true ), ideal_pose( false ), read_all_chains( true );

	pose_from_pdb( pose, stringafteroption("s"), fullatom, ideal_pose,
								 read_all_chains  );


	// setup ligand aa type
	FArray2D_float lig_coord( 3, MAX_ATOM()() );
	{
		using namespace param_aa;
		ligand_aa_vector[1] = na_ura;
		if ( !ligand_aa_vector[1] || param::MAX_AA()() < ligand_aa_vector[1] ) {
			std::cout << "MAX_AA is insufficient! " << ligand_aa_vector[1] << ' ' << MAX_AA()() <<
				std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		is_RNA( ligand_aa_vector[1] ) = false;
		is_NA( ligand_aa_vector[1] ) = false;
// 		is_protein( ligand_aa_vector[1] ) = false; // not necessary
// 		is_nonnatural( ligand_aa_vector[1] ) = false; // not necessary
		has_ligand_no( ligand_aa_vector[1] ) = 1;
		setup_ligand_aa( ligand_aa_vector[1], 1, get_ligand_one(), lig_coord ); // aav=1
	}


	// no longer using ligand mode to manage the ligand
	// that's the hack -- it's been setup as an amino acid now
	set_ligand_flag( false );


	// find closest C-alpha to ligand anchor atom
	int anchor_rsd(0);
	{
		using numeric::xyzVector_float;
		xyzVector_float const lig_root_xyz( &( lig_coord( 1, lig_root_atomno )));
		float min_d( 1000.0f );
		for ( int i=1; i<= pose.total_residue(); ++i ) {
			float const d = distance( xyzVector_float( &(pose.full_coord()(1,2,i))),
																lig_root_xyz );
			if ( d<min_d ) {
				min_d = d;
				anchor_rsd = i;
			}
		}
	}


	// add ligand to the pose
	int const anchor_atomno(2); // CA
	bool const attach_by_jump( true ); // alternative is to attach by a bond
	pose.attach_ligand( param_aa::ligand_aa_vector[1], 1 /* aav */, anchor_atomno, anchor_rsd,
											lig_root_atomno, lig_coord, attach_by_jump );

	pose.dump_pdb( "test1.pdb" );

	int const lig_rsd( pose.total_residue() );

	// now try minimizing
	// first set up what is allowed to vary

	pose.set_allow_move( ALL, false );

	bool const minimize_ligand_bonds   ( truefalseoption("bonds") );
	bool const minimize_ligand_angles  ( truefalseoption("angles") );
	bool const minimize_ligand_torsions( truefalseoption("torsions") );

	// protein backbone
	pose.set_allow_bb_move( truefalseoption("bb") );

	// protein chi angles
	pose.set_allow_chi_move( truefalseoption("chi") );

	// only one jump: ligand rigid-body degrees of freedom
	pose.set_allow_jump_move( truefalseoption("jump") );

	// ligand internal dof
	// setup a constraint set to tether these to current values
	Cst_set cst_set;
	pose.set_constraints( cst_set );
	{
		int const natoms( aaproperties_pack::natoms( param_aa::ligand_aa_vector[1], 1 ) );
		for ( int i=1; i<= natoms; ++i ) {
			if ( i == lig_root_atomno ) continue;

			Atom_id atom( i, lig_rsd );

			if ( minimize_ligand_bonds ) { // bond length
				Torsion_id this_bond_length( atom, D );
				float const current_val( pose.get_atom_tree_torsion(this_bond_length));
				//float const eps( current_val*0.1 );
				cst_set.add_kin_torsion_constraint( this_bond_length, current_val,
																						bond_length_tether );
				pose.set_allow_move( this_bond_length, true );
			}

			if ( minimize_ligand_angles ) { // bond angle
				Torsion_id this_bond_angle( atom, THETA );
				float const current_val( pose.get_atom_tree_torsion( this_bond_angle));
				//float const eps( current_val*0.1 );
				cst_set.add_kin_torsion_constraint( this_bond_angle, current_val,
																						bond_angle_tether );
				pose.set_allow_move( this_bond_angle, true );
			}

			if ( minimize_ligand_torsions ) { // torsion angle or torsion-offset
				Torsion_id this_bond_torsion( atom, PHI );
				float const current_val(pose.get_atom_tree_torsion(this_bond_torsion));
				//float const eps( current_val*0.1 );
				cst_set.add_kin_torsion_constraint( this_bond_torsion, current_val,
																						bond_torsion_tether );
				pose.set_allow_move( this_bond_torsion, true );
			}
		}
	}

	///
	Score_weight_map weight_map( score12 );
	weight_map.set_weight( KIN_1D_CST, 1.0 ); // the torsion/bond/angle tether
	set_use_nblist( true );
	minimize_set_tolerance( 1e-6 );


	pose.main_minimize( weight_map, "dfpmin" );
	pose.dump_pdb("mj_min.pdb" );
	exit(0);
}

///////////////////////////////////////////////////////////////////////////////
void
darpa_rot_swap(
							 std::vector< int > const & seqpos_list,
							 pose_ns::Pose & pose
)
{
	int const seqpos
		( seqpos_list[ static_cast< int >( ran3() * seqpos_list.size() ) ] );
	darpa_rot_swap( seqpos, pose );
}



///////////////////////////////////////////////////////////////////////////////
void
darpa_rot_swap(
	int const seqpos,
	pose_ns::Pose & pose
)
{
	using namespace aaproperties_pack;
	//using namespace design;
	using namespace dunbrack_pack;
	using namespace param;
	using namespace param_aa;
	//using namespace param_pack;

// fixed parameters
	float const binrange = { 10.0 };
	int const nbins = { 36 };

	int const nres( pose.total_residue() );
	int const aa( pose.res(seqpos) ), aav( pose.res_variant( seqpos ));

	//int const seqpos( static_cast< int >( ran3()*(nres-2)) + 2 );
	//std::cout << "WHOAH\n";
	//assert( seqpos != 1 );

	// choose p
	float const p( ran3() );

	//// debug assist:
	int iphi(0), ipsi(0), phibin, psibin, phibin_next, psibin_next;
	float phi_err, psi_err;

	get_phibin( pose.phi( seqpos ), pose.psi( seqpos ), iphi, ipsi, seqpos,nres);
	get_phi_interpolate_bin( pose.phi( seqpos ), pose.psi( seqpos ), phibin,
		psibin, phibin_next, psibin_next, phi_err, psi_err, seqpos, nres );

	float perc_total(0.0);

	for ( int linenum=1; linenum<100000; ++linenum ) {

		// rotamer crap
		FArray1D_int base_rotno( param::MAX_CHI, 0 );
		for ( int i = 1, nchi_aa = nchi(aa,aav); i <= nchi_aa; ++i ) {
			base_rotno(i) = dun_group_rotno_to_rotno(iphi,ipsi,aa,linenum,i);
		}

		int packed_rotno = get_aa_rotno_to_packedrotno(aa,aav,base_rotno);

		// calculate perc for this rotamer
		bool treat_as_angles = false;
		float perc, tmp1, tmp2;
		interpolate_bilinear(phibin,phibin_next,phi_err,psibin,psibin_next,
			psi_err,dun_prob(1,1,packed_rotno),nbins,nbins,binrange,treat_as_angles,
			perc,tmp1,tmp2);

		perc_total += perc;
		if ( perc_total < p ) continue;

		// now get the chi angles for this rotamer and fill in the pose:
		int const nchi_aa = nchi(aa,aav);

		for ( int i = 1; i <= nchi_aa; ++i ) {
			float chi;
			if ( is_chi_proton_rotamer(aa,aav,i) ) {
				FArray1D_float tmp_hchi( param::MAXANGLES_PER_CHI );
				bool const is_extra( false );
				int count(0);
				// choose one at random
				if ( aa == aa_ser || aa == aa_thr ) { // ser and thr
					get_ser_thr_hchi(is_extra,count,tmp_hchi);
				} else if ( aa == aa_tyr ) {      //// tyr
					get_tyr_hchi(is_extra,count,tmp_hchi);
				} else {
					assert( false );
				}
				chi = tmp_hchi( static_cast< int >( ran3() * count )+1 );
			} else {
				treat_as_angles = true;

				//Objexx:SGM Replaced call below since dun_chi is no longer sliceable
				interpolate_bilinear_by_value(
					dun_chi( phibin, psibin, packed_rotno, i ),
					dun_chi( phibin_next, psibin, packed_rotno, i ),
					dun_chi( phibin, psibin_next, packed_rotno, i ),
					dun_chi( phibin_next, psibin_next, packed_rotno, i ),
					phi_err, psi_err, binrange, treat_as_angles, chi,
					tmp1, tmp2
					);
			}
			// set the chi angle inside the pose
			pose.set_chi( i, seqpos, chi );
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////
void
darpa_rot_perturb(
	int const npert,
	std::vector< int > const & seqpos_list,
	pose_ns::Pose & pose
)
{
	using namespace aaproperties_pack;
	//using namespace design;
	using namespace dunbrack_pack;
	using namespace param;
	using namespace param_aa;

	int const nres( pose.total_residue() );
	float const binrange = { 10.0 };
	//int const nbins = { 36 };

	for ( int r=1; r<= npert; ++r ) {

		int const seqpos
			( seqpos_list[ static_cast< int >( ran3()*seqpos_list.size() ) ] );
		int const aa( pose.res(seqpos) ), aav( pose.res_variant( seqpos ));
		int const nchi_aa = nchi(aa,1);
		int const chino( static_cast< int >( ran3() * nchi_aa ) + 1 );

		if ( is_chi_proton_rotamer(aa,aav,chino) ) {
			--r;
			continue;
		}

		//// bin the phipsi's
		int iphi(0), ipsi(0), phibin, psibin, phibin_next, psibin_next;
		float phi_err, psi_err;

		get_phibin( pose.phi(seqpos), pose.psi(seqpos),iphi,ipsi,seqpos,nres);
		get_phi_interpolate_bin( pose.phi( seqpos ), pose.psi( seqpos ), phibin,
			psibin, phibin_next, psibin_next, phi_err, psi_err, seqpos, nres );

		// get rot numbers for this sidechain
		FArray1D_float chi( param::MAX_CHI );
		for ( int i = 1; i <= nchi_aa; ++i ) {
			chi(i) = pose.chi(i,seqpos);
		}
		FArray1D_int rot( param::MAX_CHI, 0 );
		rotamer_from_chi( chi, aa, rot );
		int packed_rotno = get_aa_rotno_to_packedrotno(aa,aav,rot);

		// figure out stddev
		float sd;
		bool treat_as_angles = false;
		float tmp1,tmp2;
		interpolate_bilinear_by_value(
					dun_sd( phibin, psibin, packed_rotno, chino ),
					dun_sd( phibin_next, psibin, packed_rotno, chino ),
					dun_sd( phibin, psibin_next, packed_rotno, chino ),
					dun_sd( phibin_next, psibin_next, packed_rotno, chino ),
					phi_err, psi_err, binrange, treat_as_angles, sd,
					tmp1, tmp2
					);

		// figure out the base chi for this rotamer
		treat_as_angles = true;

		//Objexx:SGM Replaced call below since dun_chi is no longer sliceable
		float base_chi;
		interpolate_bilinear_by_value(
					dun_chi( phibin, psibin, packed_rotno, chino ),
					dun_chi( phibin_next, psibin, packed_rotno, chino ),
					dun_chi( phibin, psibin_next, packed_rotno, chino ),
					dun_chi( phibin_next, psibin_next, packed_rotno, chino ),
					phi_err, psi_err, binrange, treat_as_angles, base_chi,
					tmp1, tmp2
					);

		float const new_chi( base_chi + gaussian() * sd );
		//float const old_chi( pose.chi( chino, seqpos ) );
		pose.set_chi( chino, seqpos, new_chi );

// 		std::cout << "chi_pert: " << seqpos << ' ' << chino << ' ' <<
// 			old_chi << ' ' << new_chi << ' ' << sd << std::endl;
	}

}



///////////////////////////////////////////////////////////////////////////////
float
darpa_chainbreak_score(
	pose_ns::Pose const & pose
)
{
	using numeric::xyzVector_float;
	int const N_index( 1 ), C_index( 3 );

	int const nres( pose.total_residue() );
	FArray3D_float const & fcoord( pose.full_coord() );

	int ncut;
	FArray1D_int const & cuts
		( pose.fold_tree().get_fold_tree_cutpoint( ncut ) );


	FArray1D_int nterm( ncut-1), cterm( ncut-1);
	int count(0);
	for ( int i=1; i<= ncut; ++i ) {
		int const cutpoint( cuts( i ) );
		if ( cutpoint == nres-1 ) continue;
		nterm( ++count ) = cutpoint+1;
		cterm(   count ) = cutpoint;
	}
	assert( count == ncut-1);

	// now start matching up
	float score(0.0);

	FArray1D_bool nmatch( count, false ), cmatch( count, false );
	for ( int i=1; i<= count; ++i ) {
		float min_d(1000.0);
		int jj(0),kk(0);
		for ( int j=1; j<= count; ++j ) {
			if ( nmatch(j) ) continue;
			xyzVector_float n_xyz( &fcoord(1,N_index,nterm(j) ) );
			for ( int k=1; k<= count; ++k ) {
				if ( cmatch(k) ) continue;
				xyzVector_float c_xyz( &fcoord(1,C_index,cterm(k) ) );

				float const d( distance( c_xyz, n_xyz ) );
				if ( d<min_d ) {
					min_d = d;
					kk = k;
					jj = j;
				}
			}
		}
		nmatch( jj ) = true;
		cmatch( kk ) = true;
		//std::cout << "match: " << i << ' ' << jj << ' ' << kk << ' ' <<
		//	F(9,3,min_d ) << std::endl;
		if ( min_d > 7.5 ) score += square(min_d-7.5);
	}
	return score;
}



///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////








class Cat_rsd {
public:
	int aa;
	int anchor;
	std::vector< int > atomno;
	std::vector< numeric::xyzVector_float > xyz;
};




///////////////////////////////////////////////////////////////////////////////
void
setup_cats(
	std::string const & filename,
	FArray2D_float const & lig_coord,
	std::vector< Cat_rsd > & cats
)
{
	using numeric::xyzVector_float;
	int const natoms_lig( aaproperties_pack::natoms( param_aa::ligand_aa_vector[1], 1 ) );
	char const desired_chain( 'P' ); // CHAIN = P

	std::ifstream data( filename.c_str() );
	std::string line;
	while ( getline( data,line ) ) {
		char const chain( line[21] );
		std::cout << chain << ' ' << line << std::endl;
		if ( line.substr(0,6) != "ATOM  " || line.size() < 66 ||
				 chain != desired_chain ) continue;

		std::string atom_name( line.substr(12,4) ),
			res_name( line.substr(17,3) );

		int aa; num_from_name( res_name, aa );
		int const aav(1);

		std::istringstream numbers
			( line.substr(22,4)+' '+ // resnum
				line.substr(30,8)+' '+line.substr(38,8)+' '+line.substr(46,8));//xyz
		int seqpos;
		numeric::xyzVector_float xyz;
		numbers >> seqpos >> xyz(1) >> xyz(2) >> xyz(3);
		if ( numbers.fail() ) {
			std::cout << "bad line:" << line << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			continue;
		}


		// put info into map
		if ( seqpos > int(cats.size()) ) {
			assert( seqpos == int(cats.size())+1 );
			cats.push_back( Cat_rsd() );

			// identify closest ligand atom
			int anchor_atom(0);
			float min_d(1000.0);
			for ( int j=1; j<= natoms_lig; ++j ) {
				xyzVector_float const v( &(lig_coord(1,j)));
				float const d( distance( v, xyz ) );
				if ( d<min_d ) {
					min_d = d;
					anchor_atom = j;
				}
			}

			cats[seqpos-1].aa = aa;
			cats[seqpos-1].anchor = anchor_atom;
		}
		assert( seqpos == int(cats.size()) );

		Cat_rsd & cat_rsd( cats[seqpos-1] );
		assert( aa == cat_rsd.aa );
		int atomno;
		atom_num_from_atom_name( atom_name, aa, aav, atomno );
		cat_rsd.atomno.push_back( atomno );
		cat_rsd.xyz.push_back( xyz );

	}



}


///////////////////////////////////////////////////////////////////////////////
void
setup_darpa_pose(
								 std::vector< Cat_rsd > const & cats,
								 std::vector< int > seg_sizes,
								 FArray2D_float const & lig_coord,
								 std::vector< int > & cat_seqpos,
								 pose_ns::Pose & pose
)
{
	using numeric::xyzVector_float;
	using namespace pose_ns;

	int const natoms_lig( aaproperties_pack::natoms( param_aa::ligand_aa_vector[1], 1 ) );

	/////////////////////////////////////////////////////////////////////////////
	// generate coords
	//int const seg_size(7);
	assert( cats.size() == seg_sizes.size() );
	int const ncat( cats.size() );
	std::vector< int > seg_begin, seg_end;
	int nres_protein(0);
	for ( int i=0; i<ncat; ++i ) {
		seg_begin.push_back( nres_protein+1 );
		nres_protein+=seg_sizes[i];
		seg_end.push_back( nres_protein );
	}
	int const nres( nres_protein + 1 );
	//Pose pose;
	pose.simple_fold_tree( nres ); // for filling res,resv info
	pose.set_fullatom_flag( true, false );
	FArray3D_float full_coord( 3, param::MAX_ATOM()(), nres );
	//std::vector< int > cat_seqpos;
	{ // now generate a full_coord array

		Pose protein_pose;
		protein_pose.simple_fold_tree( nres_protein );
		for ( int i=0; i< ncat; ++i ) {
			int const seg_size( seg_sizes[i] );
			int const cat_pos
				( static_cast< int >( ran3() * seg_size ) + seg_begin[i] );
			assert( int(cat_seqpos.size()) == i );
			cat_seqpos.push_back( cat_pos );
			for ( int pos=seg_begin[i]; pos<= seg_end[i]; ++pos ) {
				int const aa( pos == cat_pos ? cats[i].aa : param_aa::aa_ala );
				protein_pose.set_res        ( pos, aa );
				protein_pose.set_res_variant( pos, 1 ); // aav=1
				pose.set_res        ( pos, aa );
				pose.set_res_variant( pos, 1 ); // aav=1
				protein_pose.set_phi  ( pos, -64.0 );
				protein_pose.set_psi  ( pos, -43.0 );
				protein_pose.set_omega( pos, 180.0 );
			}
		}
		protein_pose.set_fullatom_flag( true ); // will pack some sidechains

		for ( int k=0; k<3*param::MAX_ATOM()()*nres_protein; ++k ) {
			full_coord[k] = protein_pose.full_coord()[k]; // make copy
		}

// 		{ // testing
// 			Pose new_protein_pose,old_protein_pose;
// 			new_protein_pose = protein_pose;
// 			old_protein_pose = protein_pose;

// 			protein_pose.setup_atom_tree();

// 			Fold_tree f;
// 			f.simple_tree( nres_protein );
// 			f.reorder( nres_protein );
// 			new_protein_pose.set_fold_tree(f);
// 			new_protein_pose.setup_atom_tree();

// 			for ( int i=1; i<= nres_protein; ++i ) {
// 				std::cout << "ppo: " << i <<
// 					F(9,3,old_protein_pose.phi  (i)) <<
// 					F(9,3,old_protein_pose.psi  (i)) <<
// 					F(9,3,old_protein_pose.omega(i)) <<
// 					F(9,3,old_protein_pose.chi(1,i)) << "\nppo: " << i <<
// 					F(9,3,protein_pose.phi  (i)) <<
// 					F(9,3,protein_pose.psi  (i)) <<
// 					F(9,3,protein_pose.omega(i)) <<
// 					F(9,3,protein_pose.chi(1,i)) << "\nppo: " << i <<
// 					F(9,3,new_protein_pose.phi  (i)) <<
// 					F(9,3,new_protein_pose.psi  (i)) <<
// 					F(9,3,new_protein_pose.omega(i)) <<
// 					F(9,3,new_protein_pose.chi(1,i)) << std::endl;
// 			}
// 		}


		// now reorient segments onto the template atoms
		for ( int i=0; i<ncat; ++i ) {
			Cat_rsd const & cat( cats[i] );
			int const this_cat_pos( cat_seqpos[i] ); //i*seg_size + cat_pos );
			FArray2D_float target(3,3), current(3,3);
			for ( int j=1; j<=3; ++j ) {
				int const atomno( cat.atomno[j-1] );
				for ( int k=1; k<= 3; ++k ) {
					target (k,j) = cat.xyz[j-1](k);
					current(k,j) = full_coord( k, atomno, this_cat_pos );
				}
			}

			// now re-orient the segment
			FArray2D_float Mgl( 4, 4 );
			get_GL_matrix( current(1,3),
										 current(1,1), // mapped to target(1,1)
										 current(1,2), // 1->2 vector is preserved
										 target (1,3),
										 target (1,1),
										 target (1,2),
										 Mgl );

			//int const seg_begin( i*seg_size + 1);
			//int const seg_end  ( (i+1)*seg_size );
			for ( int pos=seg_begin[i]; pos<= seg_end[i]; ++pos ) {
				int const aa ( pose.res(pos));
				int const aav( pose.res_variant(pos));
				for ( int j=1; j<= aaproperties_pack::natoms(aa,aav); ++j ) {
					GL_rot_in_place( Mgl, full_coord(1,j,pos) );
				}
			}
		}


		// now copy the ligand coords
		for ( int j=1; j<= natoms_lig; ++j ) {
			for ( int k=1; k<= 3; ++k ) {
				full_coord(k,j,nres) = lig_coord(k,j);
			}
		}

	}
	pose.set_res        ( nres, param_aa::ligand_aa_vector[1] );
	pose.set_res_variant( nres, 1 ); // aav=1


	/////////////////////////////////////////////////////////////////////////////
	Fold_tree f;

	{ // setup a fold_tree
		// anchor at the first catalytic residue
		// jump from him to ligand and from ligand to other cat residues
		FArray2D_int jumps(2,ncat);
		FArray1D_int cuts(ncat);
		for ( int i=1; i<= ncat; ++i ) {
			cuts(i) = seg_end[i-1];
			jumps(1,i) = cat_seqpos[i-1];
			jumps(2,i) = nres;
		}
		f.tree_from_jumps_and_cuts( nres, ncat, jumps, cuts );
		f.reorder( nres );
// 		f.reorder( cat_pos );

		// add info about the anchor atoms
		for ( int i=1; i<= ncat; ++i ) {
			Cat_rsd const & cat( cats[i-1] );
			int const protein_atomno( cat.atomno[0] );
			int const  ligand_atomno( cat.anchor );
			f.set_jump_atoms( i, ligand_atomno, protein_atomno );
// 			int const   upstream_atomno( i == 1 ? protein_atomno : ligand_atomno );
// 			int const downstream_atomno( i == 1 ? ligand_atomno : protein_atomno );
// 			f.set_jump_atoms( i, upstream_atomno, downstream_atomno );
		}


	}


	/////////////////////////////////////////////////////////////////////////////
	// make the pose
	pose.set_fold_tree( f );
	FArray3D_float Epos;
	pose.set_coords( false, Epos, full_coord );
}



///////////////////////////////////////////////////////////////////////////////
void
darpa_test()
{
	using namespace pose_ns;

	assert( truefalseoption("ligand") &&
					truefalseoption("enable_dna") );

	jumping::darpa = true; // SILLY HACK

	///////////////////////////////////////////////
	// hack -- read in ligand, setup ligand aa info
	// reads chain L from the pdb file
	// should contain the ligand info

	FArray2D_float lig_coord( 3, param::MAX_ATOM()() );
	{
		read_ligand( stringafteroption("s") );

		using namespace param_aa;
		ligand_aa_vector[1] = na_ura;
		is_RNA( ligand_aa_vector[1] ) = false;
		is_NA( ligand_aa_vector[1] ) = false;
		has_ligand_no( ligand_aa_vector[1] ) = 1;

		setup_ligand_aa( ligand_aa_vector[1], 1, get_ligand_one(), lig_coord );

		set_ligand_flag( false );
	}
	//int const natoms_lig( aaproperties_pack::natoms( param_aa::ligand_aa_vector[1], 1 ) );


	//////////////////////////////////////////////////////////////
	// read in the template catalytic sidechain atoms from the pdb
	std::vector< Cat_rsd > cats;
	setup_cats( stringafteroption("s"), lig_coord, cats);


	/////////////////////////////////////////////////////////////////////////////
	// simulations:

	assert( cats.size() == 6 );
	std::vector< int > seg_sizes;
	seg_sizes.push_back( 3 );
	seg_sizes.push_back( 6 );
	seg_sizes.push_back( 18 );
	seg_sizes.push_back( 18 );
	seg_sizes.push_back( 18 );
	seg_sizes.push_back( 18 );
// 	seg_sizes.push_back( 3 );
// 	seg_sizes.push_back( 3 );
// 	seg_sizes.push_back( 9 );
// 	seg_sizes.push_back( 9 );
// 	seg_sizes.push_back( 13 );
// 	seg_sizes.push_back( 13 );

	// scorefxn
	Score_weight_map w( score12 );
	w.set_weight( CHAINBREAK, 1.0 );
	w.set_weight( FA_DUN, 5.0 );

	//float const max_score( 100.0 );

	set_use_nblist( false );
	minimize_set_tolerance( 1e-3 );

	prof::reset();
	for ( int d=1; d<= 1000; ++d ) {

		std::random_shuffle( seg_sizes.begin(), seg_sizes.end() );

		Pose pose;
		std::vector< int > cat_seqpos;
		setup_darpa_pose( cats, seg_sizes, lig_coord, cat_seqpos, pose );
		pose.set_allow_chi_move( true );
		int const nres( pose.total_residue() );

		// randomize the rotamers
		for ( int i=1; i<= nres-1; ++i ) {
			darpa_rot_swap( i, pose );
		}

		// setup monte carlo object
		float const temperature(2.0);
		Monte_carlo mc( pose, w, temperature );

		for ( int n=1; n<= 10; ++n ) {
			mc.reset_counters();
			for ( int m=1; m<=100; ++m ) {
				darpa_rot_swap( cat_seqpos, pose );
				mc.boltzmann( pose, "rot_swap" );
			}
			pose = mc.low_pose();
			std::cout << n << ' ' << pose.get_0D_score( SCORE ) << std::endl;
			mc.show_counters();
		}

		if ( !score_filter( pose.get_0D_score( SCORE ), "nil", 0.1 ) ) {
			--d;
			continue;
		}

		// do some refinement
		for ( int n=1; n<= 3; ++n ) {
			mc.reset_counters();
			std::string min_type;
			if ( n==3 ) {
				min_type = "dfpmin";
			} else {
				min_type = "linmin";
			}
			for ( int m=1; m<=10; ++m ) {
				darpa_rot_swap( cat_seqpos, pose );
				pose.main_minimize( w, min_type );
				mc.boltzmann( pose, "rot_swap_"+min_type );

				darpa_rot_perturb( 3, cat_seqpos, pose );
				pose.main_minimize( w, min_type );
				mc.boltzmann( pose, "rot_perturb_"+min_type );

			}
			pose = mc.low_pose();
			std::cout << n << ' ' << pose.get_0D_score( SCORE ) << std::endl;
			mc.show_counters();
		}

		pose.dump_pdb( "decoy."+string_of(d)+".pdb");
	}

	prof::show();

	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
}





///////////////////////////////////////////////////////////////////////////////





///////////////////////////////////////////////////////////////////////////////
// read in ligand
//

void
kin_test_gp_meeting()
{
	using namespace pose_ns;
	using namespace param;
	using namespace kin;
	using namespace cst_set_ns;
	//using namespace aaproperties_pack;
	//using namespace param_aa;
	using numeric::conversions::radians;
	using numeric::conversions::degrees;

	bool const fullatom( true ), ideal_pose( false ), read_all_chains( true );

	Pose pose;
	pose_from_pdb( pose, "/users/pbradley/kin/gp_meeting.pdb", fullatom,
								 ideal_pose, read_all_chains  );
	pose.dump_pdb("test1.pdb");

	{
		using namespace param_aa;
		ligand_aa_vector[1] = na_ura;
		is_RNA( ligand_aa_vector[1] ) = false;
		is_NA( ligand_aa_vector[1] ) = false;
		has_ligand_no( ligand_aa_vector[1] ) = 1;
	}

	FArray2D_float lig_coord( 3, MAX_ATOM()() );
	setup_ligand_aa( param_aa::ligand_aa_vector[1], 1, get_ligand_one(), lig_coord );

	set_ligand_flag( false );

	int const anchor_atomno( 8 ); // ND1
	int const anchor_rsd( 36 );
	assert( param_aa::aa_glu == pose.res( anchor_rsd ) );

	int const ZN_atomno( 1 );
	int const lig_root_atomno( ZN_atomno );
	pose.attach_ligand( param_aa::ligand_aa_vector[1], 1, anchor_atomno, anchor_rsd,
											lig_root_atomno, lig_coord, false );

	int const lig1_rsd( pose.total_residue() );
	pose.attach_ligand( param_aa::ligand_aa_vector[1], 1, anchor_atomno, anchor_rsd,
											lig_root_atomno, lig_coord, false );
	int const lig2_rsd( pose.total_residue() );

	pose.dump_pdb("test2.pdb");

	// special atoms
	Atom_id protein_anchor( anchor_atomno, anchor_rsd );
	Atom_id lig1_root( lig_root_atomno, lig1_rsd );
	Atom_id lig2_root( lig_root_atomno, lig2_rsd );
	Atom_id lig1_Owater( 2, lig1_rsd );
	Atom_id lig2_Owater( 2, lig2_rsd );
	Atom_id lig1_Olig( 8, lig1_rsd );
	Atom_id lig2_Olig( 8, lig2_rsd );
	Atom_id dna_root( dna_variables::p, 60 );

	// try re-wiring:
	pose.reattach_atom( lig1_root, protein_anchor );
	pose.reattach_atom( lig2_root, protein_anchor );
	pose.reattach_atom( dna_root, lig1_root );


	// move!
	pose.set_allow_move( PHI, true );
	pose.set_allow_move( THETA, true );
	pose.set_allow_move( D, true );
	pose.set_atom_tree_torsion( lig1_root, D, 4.0 );
	pose.set_atom_tree_torsion( lig2_root, D, 4.0 );
	pose.set_atom_tree_torsion( lig2_Olig, THETA, 0.522 ); // random
	pose.set_atom_tree_torsion( lig2_Owater, THETA, 0.361 ); // random
	pose.set_atom_tree_torsion( dna_root, D, 4.0 );

	pose.dump_pdb("test3.pdb");

	///
	Score_weight_map weight_map;
	weight_map.set_weight( ATOMPAIR_CST, 1.0 );
	set_use_nblist( true );
	minimize_set_tolerance( 1e-6 );

	///
	Cst_set cst_set;
	pose.set_constraints( cst_set );

	// what can move?
	pose.set_allow_move( ALL, false );
	pose.set_allow_move( lig1_root, ALL, true );
	pose.set_allow_move( lig2_root, ALL, true );
	pose.set_allow_move( lig1_Olig, ALL, true );
	pose.set_allow_move( lig2_Olig, ALL, true );
	pose.set_allow_move( lig1_Owater, ALL, true );
	pose.set_allow_move( lig2_Owater, ALL, true );
	pose.set_allow_move( dna_root, ALL, true );

	// really the same atom
	cst_set.add_atompair_constraint( lig1_root, lig2_root, 0.0, 10.0 );


	// first: protein -- zn -- Oligand_aa_vector[1]
	cst_set.add_atompair_constraint( lig1_root, protein_anchor, 4.0, 1.0 );
	cst_set.add_atompair_constraint( lig1_root, lig1_Olig, 4.0, 1.0 );
	cst_set.add_atom_angle_constraint( protein_anchor, lig1_root, lig1_Olig,
																radians( 90.0f ), 1.0 );

	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min1.pdb");


	// now add Owater1
	cst_set.add_atompair_constraint( lig1_root, lig1_Owater, 4.0, 1.0 );
	cst_set.add_atom_angle_constraint( protein_anchor, lig1_root, lig1_Owater,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Olig, lig1_root, lig1_Owater,
																radians( 90.0f ), 1.0 );

	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min2.pdb");


	// now add Olig2
	cst_set.add_atompair_constraint( lig1_root, lig2_Olig, 4.0, 1.0 );
	cst_set.add_atom_angle_constraint( protein_anchor, lig1_root, lig2_Olig,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Owater, lig1_root, lig2_Olig,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Olig, lig1_root, lig2_Olig,
																radians( 180.0f ), 1.0 );

	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min3.pdb");


	// now add Owater2
	cst_set.add_atompair_constraint( lig1_root, lig2_Owater, 4.0, 1.0 );
	cst_set.add_atom_angle_constraint( protein_anchor, lig1_root, lig2_Owater,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig2_Olig, lig1_root, lig2_Owater,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Owater, lig1_root, lig2_Owater,
																radians( 180.0f ), 1.0 );

	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min4.pdb");


	// now add DNA
	cst_set.add_atompair_constraint( lig1_root, lig2_Owater, 4.0, 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Owater, lig1_root, dna_root,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig2_Owater, lig1_root, dna_root,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig1_Olig, lig1_root, dna_root,
																radians( 90.0f ), 1.0 );
	cst_set.add_atom_angle_constraint( lig2_Olig, lig1_root, dna_root,
																radians( 90.0f ), 1.0 );


	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min5.pdb");

	// try minimzing clashes
	weight_map.set_weight( FA_REP, 0.001 );
	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min6.pdb");

	weight_map.set_weight( FA_REP, 0.005 );
	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min7.pdb");

	weight_map.set_weight( FA_REP, 0.025 );
	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min8.pdb");

	weight_map.set_weight( FA_REP, 0.125 );
	pose.main_minimize( weight_map, "dfpmin");
	pose.dump_pdb("test_min9.pdb");



	exit(0);
}

///////////////////////////////////////////////////////////////////////////////
// read in ligand
//
void
kin_test_ligand()
{
	using namespace pose_ns;
	using namespace param;
	using namespace kin;

	bool const fullatom( true ), ideal_pose( false );

	Pose pose;
	pose_from_pdb( pose, "/users/pbradley/kin/1p6oA_native.pdb", fullatom,
								 ideal_pose );
	pose.dump_pdb("test1.pdb");

	{
		using namespace param_aa;
		ligand_aa_vector[1] = na_ura;
		is_RNA( ligand_aa_vector[1] ) = false;
		is_NA( ligand_aa_vector[1] ) = false;
		has_ligand_no( ligand_aa_vector[1] ) = 1;
	}

	FArray2D_float lig_coord( 3, MAX_ATOM()() );
	setup_ligand_aa( param_aa::ligand_aa_vector[1], 1, get_ligand_one(), lig_coord );

	set_ligand_flag( false );

	int const anchor_atomno( 7); // ND1
	int const anchor_rsd( 60 );
	//int const O_atomno( 7 );
	int const ZN_atomno( 1 );
	int const lig_root_atomno( ZN_atomno );
	pose.attach_ligand( param_aa::ligand_aa_vector[1], 1, anchor_atomno, anchor_rsd,
											lig_root_atomno, lig_coord, false );

	int const lig_rsd( pose.total_residue() );

	pose.dump_pdb("test2.pdb");


	// minimize:

	// chi2 of histidine
	// torsion around the N-Zn bond
	// torsion around the Zn-O bond

	pose.set_allow_move( PHI, false );
	pose.set_allow_move( THETA, false );
	pose.set_allow_move( D, false );

	{ // test torsion constraints
		using namespace cst_set_ns;
		using namespace aaproperties_pack;
		using namespace param_aa;
		using numeric::conversions::radians;
		using numeric::conversions::degrees;

		Cst_set cst_set;


		Atom_id
			atom1( anchor_atomno, anchor_rsd ),
			atom2( 6, 89 ),
			atom3( ZN_atomno, lig_rsd ),
			atom4( 6, 92 );
// 			atom4( O_atomno, lig_rsd );

// 		Atom_id atom1( 7, lig_rsd ), atom2( 1, lig_rsd ),
// 			atom3 ( anchor_atomno, anchor_rsd );
		int const aav(1);
		std::cout << "add angle constraint: 4 atoms are " <<
			aa_name3( pose.res( atom1.rsd() ) ) << ' ' <<
			atom_name( atom1.atomno(), pose.res( atom1.rsd() ), aav ) << ' ' <<
			aa_name3( pose.res( atom2.rsd() ) ) << ' ' <<
			atom_name( atom2.atomno(), pose.res( atom2.rsd() ), aav ) << ' ' <<
			aa_name3( pose.res( atom3.rsd() ) ) << ' ' <<
			atom_name( atom2.atomno(), pose.res( atom3.rsd() ), aav ) << ' ' <<
			aa_name3( pose.res( atom4.rsd() ) ) << ' ' <<
			atom_name( atom3.atomno(), pose.res( atom4.rsd() ), aav ) << std::endl;

		float const weight( degrees(1.0)*degrees(1.0) );
		//float const weight( 0.5 );
		cst_set.add_atom_torsion_constraint( atom1, atom2, atom3, atom4, radians( 175.0f ),
																		weight );

		Score_weight_map weight_map;
		weight_map.set_weight( ATOMPAIR_CST, 1.0 );

		pose.set_constraints( cst_set );
		std::cout << "score= " << pose.score( weight_map ) << std::endl;
		pose.dump_pdb("test2.pdb");

		// now let one atom move around
		int const lig_atomno( ZN_atomno );
		pose.set_allow_move( lig_atomno, lig_rsd, PHI, true );
		pose.set_allow_move( lig_atomno, lig_rsd, THETA, true );
		pose.set_allow_move( lig_atomno, lig_rsd, D, true );

		minimize_set_tolerance( 0.001 );
		set_use_nblist( true );
		pose.main_minimize( weight_map, "dfpmin" );
		pose.dump_pdb("test3.pdb");


	}


	exit(0);

	{ // test angle constraints
		using namespace cst_set_ns;
		using namespace aaproperties_pack;
		using namespace param_aa;
		using numeric::conversions::radians;
		using numeric::conversions::degrees;

		Cst_set cst_set;


		Atom_id atom1( 6, 89 ), atom2( 1, lig_rsd ),
			atom3 ( 6, 92 );
// 		Atom_id atom1( 7, lig_rsd ), atom2( 1, lig_rsd ),
// 			atom3 ( anchor_atomno, anchor_rsd );
		int const aav(1);
		std::cout << "add angle constraint: 3 atoms are " <<
			aa_name3( pose.res( atom1.rsd() ) ) << ' ' <<
			atom_name( atom1.atomno(), pose.res( atom1.rsd() ), aav ) << ' ' <<
			aa_name3( pose.res( atom2.rsd() ) ) << ' ' <<
			atom_name( atom2.atomno(), pose.res( atom2.rsd() ), aav ) << ' ' <<
			aa_name3( pose.res( atom3.rsd() ) ) << ' ' <<
			atom_name( atom3.atomno(), pose.res( atom3.rsd() ), aav ) << std::endl;

		float const weight( degrees(1.0)*degrees(1.0) );
		//float const weight( 0.5 );
		cst_set.add_atom_angle_constraint( atom1, atom2, atom3, radians( 90.0f ),
																	weight );

		Score_weight_map weight_map;
		weight_map.set_weight( ATOMPAIR_CST, 1.0 );

		pose.set_constraints( cst_set );
		std::cout << "score= " << pose.score( weight_map ) << std::endl;
		pose.dump_pdb("test2.pdb");

		// now let the O move around
		int const lig_atomno( ZN_atomno );
		pose.set_allow_move( lig_atomno, lig_rsd, PHI, true );
		pose.set_allow_move( lig_atomno, lig_rsd, THETA, true );
		pose.set_allow_move( lig_atomno, lig_rsd, D, true );

		minimize_set_tolerance( 0.001 );
		set_use_nblist( true );
		pose.main_minimize( weight_map, "dfpmin" );
		pose.dump_pdb("test3.pdb");


	}


	exit(0);


	if ( false ) { // first, just everything downstream of O
		Score_weight_map weight_map;
		weight_map.set_weight( FA_ATR, 1.0 );
		weight_map.set_weight( FA_REP, 1.0 );

		{ // create small clash
			int const chino(2);
			pose.set_allow_move( PHI, true );
			float const start_chi( pose.chi( chino, anchor_rsd ) );
			for ( int i=-20; i<= 20; ++i ) {
				pose.set_chi( chino, anchor_rsd, start_chi+i );
				std::cout << i << ' ' << pose.score( weight_map ) << std::endl;
				pose.dump_pdb("test_chi"+string_of(i)+".pdb");
			}
			pose.set_allow_move( PHI, false );
		}

		int const O_atomno( 7 );
		pose.set_allow_move( O_atomno, lig_rsd, PHI, true );
		pose.set_allow_move( O_atomno, lig_rsd, THETA, true );
		pose.set_allow_move( O_atomno, lig_rsd, D, true );
		int const ZN_atomno( 1 );
		pose.set_allow_move( ZN_atomno, lig_rsd, PHI, true );
		pose.set_allow_move( ZN_atomno, lig_rsd, THETA, true );
		pose.set_allow_move( ZN_atomno, lig_rsd, D, true );

		minimize_set_tolerance( 0.001 );
		set_use_nblist( true );
		pose.main_minimize( weight_map, "dfpmin" );
		pose.dump_pdb("test3.pdb");
	}



	if ( false ) {
		int const chino(2);
		pose.set_allow_move( PHI, true );
		float const start_chi( pose.chi( chino, anchor_rsd ) );
		for ( int i=-10; i<= 10; ++i ) {
			pose.set_chi( chino, anchor_rsd, start_chi+i );
			pose.dump_pdb("test_chi"+string_of(i)+".pdb");
		}
	}
	if ( false ) {
		int const atomno(6); // CH1
		pose.set_allow_move( PHI, true );
		float const start_chi
			( pose.get_atom_tree_torsion( atomno, lig_rsd, PHI ) );
		for ( int i=-10; i<= 10; ++i ) {
			pose.set_atom_tree_torsion( atomno, lig_rsd, PHI,
																	start_chi+numeric::conversions::radians(float(i)));
			pose.dump_pdb("test_lig"+string_of(i)+".pdb");
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// test DNA
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void
kin_test_old()
// kin_test_DNA()
{
	using namespace param;
	using param_aa::is_NA;
	using namespace pose_ns;
	using namespace kin;
	using numeric::xyzMatrix_double;
	using numeric::xyzVector_double;
	using numeric::conversions::degrees;
	using aaproperties_pack::natoms;

	assert( truefalseoption("enable_dna"));

	Pose pose;

	// setup a fold_tree that supports the dna
	int const nres_protein( 59 );
	int const nres_strand1( 20 );
	int const nres_strand2( 20 );
	int const nres( nres_protein + nres_strand1 + nres_strand2 );
	int const num_jump( 2 );

	{ // scope
		FArray1D_int cuts(2);
		cuts(1) = nres_protein;
		cuts(2) = nres_protein + nres_strand1;

		FArray2D_int jumps(2,2);
		jumps(1,1) = 45;
		jumps(2,1) = 71;
		jumps(1,2) = 71; // intra-dna
		jumps(2,2) = 89;

		Fold_tree f;
		f.tree_from_jumps_and_cuts( nres, num_jump, jumps, cuts );
		pose.set_fold_tree( f );
	}

	// this will trigger atom_tree setup
	{
		bool const fullatom( true ), ideal_pose( false ), read_all_chains( true );
		pose_from_pdb( pose, "/users/pbradley/kin/1b72_noB.pdb", fullatom,
									 ideal_pose, read_all_chains );
	}

	pose.dump_pdb( "test1.pdb" );


	// test basepair params
	{
		for ( int pos1=61; pos1<= 79; ++pos1 ) {
			int const pos2( 81 + ( 79 - pos1 ) );
			FArray1D_float params(6,0.0);
			base_pair_params( pose.res(pos1), pose.res(pos2),
												pose.full_coord()(1,1,pos1),
												pose.full_coord()(1,1,pos2),
												params);
		}
	}

	// scoring
	{
		using namespace param_aa;
		Score_weight_map weight_map( score12 );
		std::cout << "score12= " << pose.score( weight_map ) << std::endl;

		FArray2D_float const & rep_pair( pose.get_2D_score( REP_PAIR ) );
		for ( int i=1; i<= nres; ++i ) {
			for ( int j=1; j<= nres; ++j ) {
				if ( rep_pair(i,j) > 10.0 ) {
					std::cout << "clash: " << rep_pair(i,j) << ' ' <<
						i << ' ' << aa_name3(pose.res(i)) << ' ' <<
						j << ' ' << aa_name3(pose.res(j)) << std::endl;
				}
			}
		}
	}


	{
		// try minimzing dna jump angles
		pose.set_allow_move( ALL, false );
		pose.set_allow_jump_move( 1, true );

		Score_weight_map weight_map( score12 );
		set_use_nblist( true );
		minimize_set_tolerance( 0.0000001 );
		pose.main_minimize( weight_map, "dfpmin" );

	}

	pose.dump_pdb( "test2.pdb" );
	exit(0);

	{
		// try minimzing dna chi angles
		pose.set_allow_move( ALL, false );
		for ( int i=nres_protein+1; i<= nres; ++i ) {
			pose.set_allow_chi_move( i, true );
		}

		Score_weight_map weight_map( score12 );
		set_use_nblist( true );
		minimize_set_tolerance( 0.0000001 );
		pose.main_minimize( weight_map, "dfpmin" );

	}

	pose.dump_pdb( "test3.pdb" );

	{
		// try minimzing dna bb angles
		pose.set_allow_move( ALL, false );
		for ( int i=nres_protein+1; i<= nres; ++i ) {
			pose.set_allow_bb_move( i, true );
			pose.set_allow_chi_move( i, true );
		}

		Score_weight_map weight_map( score12 );
		set_use_nblist( true );
		minimize_set_tolerance( 0.0000001 );
		pose.main_minimize( weight_map, "dfpmin" );

	}

	pose.dump_pdb( "test4.pdb" );

	exit(0);


	// test minimization
	Score_weight_map weight_map;
	weight_map.set_weight( FA_ATR, 1.0 );
	weight_map.set_weight( FA_REP, 1.0 );

	pose.score( weight_map );

	pose.set_allow_move( PHI, true );
	pose.set_allow_move( THETA, false );
	pose.set_allow_move( D, false );
	pose.set_allow_move( RB_TRANSLATION, false );
	pose.set_allow_move( RB_ROTATION, false );
	//pose.set_sibling_phi_move( false );

	minimize_set_tolerance( 0.0000001 );
	set_use_nblist( true );
	pose.main_minimize( weight_map, "dfpmin" );

	exit( 0 );
}


///////////////////////////////////////////////////////////////////////////////
void
kin_test2()
{
	using namespace param;
	using param_aa::is_NA;
	using namespace pose_ns;
	using namespace kin;
	using numeric::xyzMatrix_double;
	using numeric::xyzVector_double;
	using numeric::conversions::degrees;
	using aaproperties_pack::natoms;

	int i;
	kin::Atom* ptr;
	std::vector< int > iv;
	std::vector< kin::Atom* > ptrv;
	std::list< kin::Atom* > ptrl;

	Torsion_id torsion_id;
	Atom_id atom_id;

	std::cout << "sizeof i " << sizeof(i) <<
		" sizeof ptr " << sizeof( ptr ) <<
		" sizeof iv " << sizeof( iv ) <<
		" sizeof ptrv " << sizeof( ptrv ) <<
		" sizeof ptrl " << sizeof( ptrl ) <<
		" sizeof atom_id " << sizeof( atom_id ) <<
		" sizeof torsion_id " << sizeof( torsion_id ) <<
		std::endl;
	exit(0);

	assert( truefalseoption("enable_dna"));

	// set some i/o params used by input_pdb
	files_paths::protein_chain = '-'; //
	files_paths::read_all_chains = true; //
	files_paths::multi_chain = false; //
	files_paths::skip_missing = false; //
	files_paths::allow_missing = false; //
	bool const fullatom( true );
	bool fail;
	utility::io::izstream data( "1b72_noB.pdb" ); // /users/pbradley/kin/
	input_pdb( data, false, fullatom, fail ); // seq_defined=F
	data.close();

	dump_fullatom_pdb("test1b72_noB.pdb");

	// setup a fold_tree
	int const nres_protein( 59 );
	int const nres_strand1( 20 );
	int const nres_strand2( 20 );
	int const nres( misc::total_residue );
	int const num_jump( 2 );
	assert( nres == nres_protein + nres_strand1 + nres_strand2 );

	FArray1D_int cuts(2);
	cuts(1) = nres_protein;
	cuts(2) = nres_protein + nres_strand1;

	FArray2D_int jumps(2,2);
	jumps(1,1) = 1;
	jumps(2,1) = 71;
	jumps(1,2) = 71; // intra-dna
	jumps(2,2) = 89;

	Fold_tree f;
	f.tree_from_jumps_and_cuts( nres, num_jump, jumps, cuts );

	// important setup

	// generate an atom tree from the fold_tree and res,resv info

	FArray2D< kin::Atom * > atom_pointer( MAX_ATOM()(), nres );
	kin::Atom * root( build_tree( f, misc::res, misc::res_variant,
																atom_pointer ) );

	for ( int i=1; i<= misc::total_residue; ++i ) {
		int const aa( misc::res(i) );
		int const aav( misc::res_variant(i) );
		for ( int j=1; j<= param::MAX_ATOM()(); ++j ) {
			assert( ( j <= natoms(aa,aav) && atom_pointer(j,i) != 0 ) ||
							( j >  natoms(aa,aav) && atom_pointer(j,i) == 0 ) );
		}
		std::cout << "check: " << i << std::endl;
	}

	Stub stub( numeric::xyzMatrix_double::I(), numeric::xyzVector_double(0.0));
	root->update_torsions( stub, Coords_FArray( misc::full_coord ) );

	{
		Coords_FArray tmp_coords( misc::full_coord );
		root->update_coords( stub, tmp_coords );
	}

	dump_fullatom_pdb("test1b72_noB_after.pdb");

	exit( 0 );

// 	for ( int i=nres_protein+1; i<= nres; ++i ) {
// 		std::cout << "tor: " << i;
// 		for ( int j=1; j<= 7; ++j ) {
// 			std::cout << F( 10, 3, dna.get_torsion( j, i ) );
// 		}
// 		std::cout << std::endl;

// 	}

//	dump_fullatom_pdb( "test1" );

// 	// try refolding the dna:
// 	std::cout << "fold_tree: " << f << std::endl;
// 	for ( Fold_tree::const_iterator it=f.begin(), it_end = f.end();
// 				it != it_end; ++it ) {
// 		if ( is_NA( misc::res( it->stop ) ) ) {
// 			if ( it->is_jump() ) {
// 				Stub stub( dna.get_stub( it->stop, misc::full_coord ) );
// 				dna.build_jump( stub, *it, misc::full_coord );
// 			} else {
// 				dna.build_segment( *it, misc::full_coord );
// 			}
// 		}
// 	}

// 	dump_fullatom_pdb( "test2" );

// 	if ( false ) {
// 		// try refolding the dna: translate to default stub
// 		std::cout << "fold_tree: " << f << std::endl;
// 		for ( Fold_tree::const_iterator it=f.begin(), it_end = f.end();
// 					it != it_end; ++it ) {
// 			if ( is_NA( misc::res( it->stop ) ) ) {
// 				if ( it->is_jump() ) {
// 					// jump that anchors the DNA
// 					kin::Stub const default_stub
// 						( xyzMatrix_double::I(), xyzVector_double( 0.0, 0.0, 0.0 ) );
// 					dna.build_jump( default_stub, *it, misc::full_coord );
// 				} else {
// 					dna.build_segment( *it, misc::full_coord );
// 				}
// 			} // is_NA
// 		}
// 		dump_fullatom_pdb( "test3" );
// 	}

// 	{
// 		for ( int i=1; i<= nres; ++i ) {
// 			if ( is_NA( misc::res(i) ) ) {
// 				dna.set_torsion( 7, i, dna.get_torsion( 7,i) + 90.0 );
// 			}
// 		}
// 		for ( Fold_tree::const_iterator it=f.begin(), it_end = f.end();
// 					it != it_end; ++it ) {
// 			if ( is_NA( misc::res( it->stop ) ) ) {
// 				if ( it->is_jump() ) {
// 					Stub stub( dna.get_stub( it->stop, misc::full_coord ) );
// 					dna.build_jump( stub, *it, misc::full_coord );
// 				} else {
// 					dna.build_segment( *it, misc::full_coord );
// 				}
// 			}
// 		}
// 		dump_fullatom_pdb( "test3" );
// 	}

// 	exit(0);

}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// 	/////////////////////////////////////////////////////////////////////////////
// 	// generate coords
// 	int const seg_size(7);
// 	int const cat_pos( ( seg_size+1 )/2 );
// 	int const ncat( cats.size() );
// 	int const nres_protein( ncat * seg_size );
// 	int const nres( nres_protein + 1 );
// 	Pose pose;
// 	pose.simple_fold_tree( nres ); // for filling res,resv info
// 	pose.set_fullatom_flag( true, false );
// 	FArray3D_float full_coord( 3, param::MAX_ATOM()(), nres );
// 	{ // now generate a full_coord array

// 		Pose protein_pose;
// 		protein_pose.simple_fold_tree( nres_protein );
// 		for ( int i=0; i< ncat; ++i ) {
// 			for ( int k=1; k<= seg_size; ++k ) {
// 				int const pos( i*seg_size + k );
// 				int const aa( k == cat_pos ? cats[i].aa : param_aa::aa_ala );
// 				protein_pose.set_res        ( pos, aa );
// 				protein_pose.set_res_variant( pos, 1 ); // aav=1
// 				pose.set_res        ( pos, aa );
// 				pose.set_res_variant( pos, 1 ); // aav=1
// 				protein_pose.set_phi  ( pos, -64.0 );
// 				protein_pose.set_psi  ( pos, -43.0 );
// 				protein_pose.set_omega( pos, 180.0 );
// 			}
// 		}
// 		protein_pose.set_fullatom_flag( true ); // will pack some sidechains

// 		for ( int k=0; k<3*param::MAX_ATOM()()*nres_protein; ++k ) {
// 			full_coord[k] = protein_pose.full_coord()[k]; // make copy
// 		}

// 		{ // testing
// 			Pose new_protein_pose,old_protein_pose;
// 			new_protein_pose = protein_pose;
// 			old_protein_pose = protein_pose;

// 			protein_pose.setup_atom_tree();

// 			Fold_tree f;
// 			f.simple_tree( nres_protein );
// 			f.reorder( nres_protein );
// 			new_protein_pose.set_fold_tree(f);
// 			new_protein_pose.setup_atom_tree();

// 			for ( int i=1; i<= nres_protein; ++i ) {
// 				std::cout << "ppo: " << i <<
// 					F(9,3,old_protein_pose.phi  (i)) <<
// 					F(9,3,old_protein_pose.psi  (i)) <<
// 					F(9,3,old_protein_pose.omega(i)) <<
// 					F(9,3,old_protein_pose.chi(1,i)) << "\nppo: " << i <<
// 					F(9,3,protein_pose.phi  (i)) <<
// 					F(9,3,protein_pose.psi  (i)) <<
// 					F(9,3,protein_pose.omega(i)) <<
// 					F(9,3,protein_pose.chi(1,i)) << "\nppo: " << i <<
// 					F(9,3,new_protein_pose.phi  (i)) <<
// 					F(9,3,new_protein_pose.psi  (i)) <<
// 					F(9,3,new_protein_pose.omega(i)) <<
// 					F(9,3,new_protein_pose.chi(1,i)) << std::endl;
// 			}
// 		}


// 		// now reorient segments onto the template atoms
// 		for ( int i=0; i<ncat; ++i ) {
// 			Cat_rsd const & cat( cats[i] );
// 			int const this_cat_pos( i*seg_size + cat_pos );
// 			FArray2D_float target(3,3), current(3,3);
// 			for ( int j=1; j<=3; ++j ) {
// 				int const atomno( cat.atomno[j-1] );
// 				for ( int k=1; k<= 3; ++k ) {
// 					target (k,j) = cat.xyz[j-1](k);
// 					current(k,j) = full_coord( k, atomno, this_cat_pos );
// 				}
// 			}

// 			// now re-orient the segment
// 			FArray2D_float Mgl( 4, 4 );
// 			get_GL_matrix( current(1,3),
// 										 current(1,1), // mapped to target(1,1)
// 										 current(1,2), // 1->2 vector is preserved
// 										 target (1,3),
// 										 target (1,1),
// 										 target (1,2),
// 										 Mgl );

// 			int const seg_begin( i*seg_size + 1);
// 			int const seg_end  ( (i+1)*seg_size );
// 			for ( int pos=seg_begin; pos<= seg_end; ++pos ) {
// 				int const aa ( pose.res(pos));
// 				int const aav( pose.res_variant(pos));
// 				for ( int j=1; j<= aaproperties_pack::natoms(aa,aav); ++j ) {
// 					GL_rot_in_place( Mgl, full_coord(1,j,pos) );
// 				}
// 			}
// 		}


// 		// now copy the ligand coords
// 		for ( int j=1; j<= natoms_lig; ++j ) {
// 			for ( int k=1; k<= 3; ++k ) {
// 				full_coord(k,j,nres) = lig_coord(k,j);
// 			}
// 		}

// 	}
// 	pose.set_res        ( nres, param_aa::ligand_aa_vector[1] );
// 	pose.set_res_variant( nres, 1 ); // aav=1


// 	/////////////////////////////////////////////////////////////////////////////
// 	Fold_tree f;

// 	{ // setup a fold_tree
// 		// anchor at the first catalytic residue
// 		// jump from him to ligand and from ligand to other cat residues
// 		FArray2D_int jumps(2,ncat);
// 		FArray1D_int cuts(ncat);
// 		for ( int i=1; i<= ncat; ++i ) {
// 			cuts(i) = i*seg_size;
// 			jumps(1,i) = (i-1)*seg_size + cat_pos;
// 			jumps(2,i) = nres;
// 		}
// 		f.tree_from_jumps_and_cuts( nres, ncat, jumps, cuts );
// 		f.reorder( nres );
// // 		f.reorder( cat_pos );

// 		// add info about the anchor atoms
// 		for ( int i=1; i<= ncat; ++i ) {
// 			Cat_rsd const & cat( cats[i-1] );
// 			int const protein_atomno( cat.atomno[0] );
// 			int const  ligand_atomno( cat.anchor );
// 			f.set_jump_atoms( i, ligand_atomno, protein_atomno );
// // 			int const   upstream_atomno( i == 1 ? protein_atomno : ligand_atomno );
// // 			int const downstream_atomno( i == 1 ? ligand_atomno : protein_atomno );
// // 			f.set_jump_atoms( i, upstream_atomno, downstream_atomno );
// 		}


// 	}


// 	/////////////////////////////////////////////////////////////////////////////
// 	// make the pose
// 	pose.set_fold_tree( f );
// 	FArray3D_float Epos;
// 	pose.set_coords( false, Epos, full_coord );
