// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_knots
#define INCLUDED_knots


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// knots Function Declarations

bool
knot_filter();


bool
knotfind(
	FArray2Da_float chain, // coordinates of CA-trace, chain(4,i)=1 indicates
	int const nres, // number of residues in chain
	int const simplify_start,
	int const simplify_end,
	int const end_trim
);

void
old_get_plane(
	int & res1, // may be modified
	FArray2Da_float chain, // CA trace
	int const nres, // chain length
	FArray1Da_float plane // first 4 slots: A, B, C, D
);


void
find_trouble(
	FArray1Da_float plane,
	FArray2Da_float chain,
	int const nres, // chain length
	FArray2Da_float trouble_above, // pairs of points describing
	FArray2Da_float trouble_below, // line segments that may intersect the plane
	float tolerance, // closest allowed approach
	int & counter, // logical size of trouble_above,trouble_below
	int max_trouble // physical size of trouble_above,trouble_below
);


void
is_part_of_plane(
	int & point1,
	int & point2,
	FArray1Da_float plane,
	bool & in_plane
);


bool
any_cross_plane(
	FArray1Da_float plane,
	FArray2Da_float chain,
	int const nres, // logical size of chain
	int & ntrouble,
	FArray2Da_float t_above,
	FArray2Da_float t_below,
	float tolerance, // closest allowed approach
	bool const check_all // if true, trouble vectors and modify t_start,t_end,ntrouble
);


bool
inside_triangle(
	FArray1Da_float plane, // 1-4 = equation of inifinite plane  Ax + By + Cz + D
	FArray2Da_float ca_chain,
	int const nres,
	FArray1Da_float i_point, // point lying on infinite plane
	float tolerance // closest allowed approach
);


bool
segment_intersects_triangle(
	FArray1Da_float x,
	FArray1Da_float y,
	FArray1Da_float a,
	FArray1Da_float b,
	FArray1Da_float c,
	float tolerance // closest allowed approach of segments
);


void
crossing_loops();


void
createSphere(
	int & j,
	int const nres,
	FArray2Da_float coords
);


void
inCurrentSphere(
	int & current,
	FArray2Da_float points, // 6 by N matrix of all points
	int const nres,
	FArray1Da_float collisions // where all collisions are kept
);

void
sort_distances(
	int n,               // is the total number of distances
	FArray2Da_int ra
);

void
rank(
	int const n,
	FArray1Da_float key, // inputted array, gets replaced on output
	FArray1Da_int output
);

#endif
