// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $


// Rosetta Headers
#include "lig_looprlx.h"
#include "after_opts.h"
#include "aaproperties_pack.h"
#include "fullatom.h"
#include "jumping_util.h"
#include "minimize.h"
#include "misc.h" // pose_flag()
#include "monte_carlo.h"
#include "nblist.h"
#include "output_decoy.h"
#include "pose.h"
#include "pose_io.h"
//#include "pose_design.h"
#include "pose_relax.h"
#include "pose_rotamer_trials.h"
//#include "pose_routines.h"
#include "prof.h"
#include "relax_structure.h"
#include "read_aaproperties.h"
#include "score.h"
#include "smallmove.h"
#include "torsion_bbmove_trials.h"
#include "util_vector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.o.hh>

// Utility Headers
#include <utility/io/ozstream.hh>

// bkidd -- added for pose min and looprlx
#include "enzyme.h"
#include "fragments_pose.h"
#include "jumping_refold.h"
#include "kin_test.h"
#include "ligand.h"
#include "loops_ns.h"
#include "loops.h"
#include "loop_class.h"
#include "loop_relax.h"
#include "pose_ligand.h"
#include "pose_loops.h"
#include "relax.h"
#include "score_data.h"
#include "silent_input.h"

// useful for testing
//#include "files_paths.h"
//#include "fragments.h"
//#include "initialize.h"
//#include "jumping_pairings.h"
//#include "maps.h"
//#include "pose_rms.h"

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <fstream>

///////////////////////////////////////////////////////////////////////////////
// simple wrapper for testing
//

void
lig_looprlx_wrapper()
{
	int const MAX_SIZE = { 5 };
	int total_structs = 1;
	int num_structs = 1;

	std::string out_base = stringafteroption( "F" ) + "_" + stringafteroption ( "out_tag" ) + "_";
	std::string out_ext = ".pdb", out_count, out_filename, input_pdb;
	std::ifstream inp;

	if ( truefalseoption( "nstruct" ) ) {
		total_structs = intafteroption( "nstruct" );
	}

	out_count = lead_zero_string_of( total_structs, MAX_SIZE );

	if ( total_structs > 99999 ) {
		std::cout << std::endl << "nstruct > 99,999, please use smaller value" << std::endl << std::endl;
		exit( 0 );
	}

	out_filename = out_base + out_count + out_ext;

	std::cout << std::endl << "GOING UNTIL WE REACH " + out_filename << std::endl << std::endl;

	if ( truefalseoption ( "s" ) ) {
		input_pdb = stringafteroption( "s" );
	}
//	else if ( truefalseoption ( "l" ) ) {

	while ( num_structs <= total_structs ) {
		inp.open( out_filename.c_str(), std::ifstream::in );
		inp.close();
		if ( inp.fail() ) {
			inp.clear();
			lig_looprlx( out_base, input_pdb );
		}
		num_structs++;
	}
}

// lig_min()
// designed to test out a new pose function that does minimization with a lig
//
void
lig_min()
{
	using namespace pose_ns;
	using namespace param;
	using namespace param_aa;
	using namespace kin;
	using namespace cst_set_ns;
	using namespace enable_ligaa_ns;

	Pose protein_pose;
	Pose prot_lig_pose;

	bool const fullatom ( true ), ideal_pose ( false ), read_allchains ( true ), coord_init ( true );

	// set fullatom score
	Score_weight_map score_weight( score12 );

	// nstruct counter variables
	std::string out_base = stringafteroption( "F" ) + "_" + stringafteroption ( "out_tag" ) + "_";
	std::string out_ext = ".pdb";
	std::string out_filename;
	out_filename = out_base + "0001" +  out_ext;

	std::cout << std::endl << "READING COORDS..." << std::endl << std::endl;

	// read_allchains ( true ) should trigger read_pdb_hetero
	pose_from_pdb( protein_pose, stringafteroption("s"), fullatom, ideal_pose, read_allchains );

	pose_from_misc( protein_pose, fullatom, ideal_pose, coord_init );
	prot_lig_pose = protein_pose;

	// attach ligand as a pose object
	int lig_root_atomno( 1 );   // 1st hetero heavyatom in pdb file
	int anchor_rsd( 1 );        // attach to first res, Ca
	int anchor_atomno( 2 );     // CA

	std::cout << std::endl << "CALLING FARRAY..." << std::endl << std::endl;

	FArray2D_float lig_coord( 3, param::MAX_ATOM() );
	{
		has_ligand_no( ligand_aa_vector[1] ) = 1;
		setup_ligand_aa( ligand_aa_vector[1], 1, get_ligand_one(), lig_coord ); // aav=1
	}

	std::cout << std::endl << "ATTACHING POSE LIGAND..." << std::endl << std::endl;

	// no longer using ligand mode to manage the ligand
	// that's the hack -- it's been setup as an amino acid now
	bool attach_by_jump( true );    // alternative is to attach by a bond
	set_ligand_flag( false );

	prot_lig_pose.attach_ligand( ligand_aa_vector[1], 1 /* aav */, anchor_atomno, anchor_rsd, lig_root_atomno, lig_coord, attach_by_jump );
	prot_lig_pose.dump_scored_pdb( "attached_ligand.pdb", score_weight );

	//////  END ATTACHMENT

	std::cout << std::endl << "STARTING MIN..." << std::endl << std::endl;

	// allow backbone and chi angles to move during minimize
	prot_lig_pose.set_allow_bb_move( true );
	prot_lig_pose.set_allow_chi_move( true );

	// only one jump: ligand rigid-body degrees of freedom
	prot_lig_pose.set_allow_jump_move( truefalseoption("jump") );

	set_use_nblist( true );
	minimize_set_tolerance( 1e-6 );
	prot_lig_pose.main_minimize( score_weight, "dfpmin" );
	prot_lig_pose.dump_scored_pdb( out_filename, score_weight );

	std::exit(0);
}

// lig_looprlx()
// designed to test out a new pose function that does looprlx + farlx in
// the around a ligand
//
void
lig_looprlx(
	std::string const & filename_out,
	std::string const & input_pdb
)
{
	using namespace pose_ns;
	using namespace param;
	using namespace param_aa;
	using namespace kin;
	using namespace cst_set_ns;
	using namespace enable_ligaa_ns;
	using namespace silent_io;

	Pose protein_pose;
	Pose dummy_pose;
	Pose preloop_pose;
	Pose prot_lig_pose;
	Pose fail_clash_check_pose;

	int lj_ramp_cycles = 8;
	int cycles = 8;
	int nres;
	int clash_counter = 0;				// count number of lig - prot clashes, for debugging info
	int MAX_CLASH_NUM = 100;			// avoid infinite loop if ligand always clashing, maybe call dock_pert to move lig?
	int const MAX_SIZE = { 5 };
	int const MAX_STRUCTS = { 99999 };		// avoid infinit loop
	static int i_alt = { 1 };

	bool const fullatom ( true ), ideal_pose ( false ), read_allchains ( true ), coord_init ( true );
	bool looprlx = true;
	bool lig_prot_clash;
	bool out_flag = true;
	bool lig_looprlx_score_filter;

	float clash_score = 0.0;			// vdw score between loop backbone and ligand
	float MIN_CLASH_SCORE = 0.0;			// min vdw to indicate Y/N for backbone clash with ligand
	float clash_accept = 0.0;
	float lig_looprlx_filter_score = 9999.;		// big number by default, modified with lig_looprlx_score_filter flag

	// output file strings
	std::string out_ext = ".pdb";
	std::string out_count;
	std::string out_filename;
	std::ifstream inp;

	Score_weight_map score_weight( score12 );
	std::cout << std::endl << "READING COORDS..." << std::endl << std::endl;

	// read_allchains ( true ) should trigger read_pdb_hetero
	pose_from_pdb( protein_pose, input_pdb, fullatom, ideal_pose, read_allchains );
	preloop_pose = protein_pose;
	fail_clash_check_pose = protein_pose;
	Loops loops;
	Loops loops_built;

	nres = protein_pose.total_residue();
	read_fragments_simple( stringafteroption( "F" ), nres );  // need fragments for loop_relax

	// read command options
	lig_looprlx_score_filter = truefalseoption( "lig_looprlx_score_filter" );
	if ( lig_looprlx_score_filter ) { lig_looprlx_filter_score = realafteroption( "lig_looprlx_score_filter" ); }

	// check lig-prot bb score prior to any operation. baseline for debugging and setting filters
	ligand_bb_fa_vdw( clash_score, ( *ligand::ligand_one ) );
	std::cout << "initial clash_score:  " << clash_score << "  filter_score:  "<< lig_looprlx_filter_score << std::endl;

	// rebuild loops with backbone clash check using ligand_bb_fa_vdw -> sum(atrE+repE) of backbone
	if ( looprlx ) {
		lig_prot_clash = true;    // initially set flag true for first loop rebuild
		while ( lig_prot_clash ) {
			clash_counter++;
			if ( clash_counter > MAX_CLASH_NUM ) {
				std::cout << "WARNING:: too many iterations of clashing ligands and loops" << std::endl;
				std::exit(0);
			}
			bool loop_relax_success = true;
			if ( looprlx ) loop_relax_success = loop_relax();
			if ( !loop_relax_success ) {
				std::cout << "WARNING:: looprlx failed. returning..." << std::endl;
				std::exit(0);
			}

			ligand_bb_fa_vdw( clash_score, ( *ligand::ligand_one ) );
			std::cout << "clash_score:  " << clash_score << "  filter_score:  "<< lig_looprlx_filter_score << std::endl;
			if ( clash_score > MIN_CLASH_SCORE || clash_score > lig_looprlx_filter_score ) {
				lig_prot_clash = true;
				pose_from_misc( fail_clash_check_pose, fullatom, ideal_pose, coord_init );
				loops = loops_built;						// from the Loops namespace
				fail_clash_check_pose.recover_sidechain( preloop_pose );	// add sidechains to rebuilt loop
				repack_loops( loops, fail_clash_check_pose );			// recover packing from loop_relax()
				// fail_clash_check_pose.dump_scored_pdb( "bb_clash.pdb", score_weight );
			}
			else  lig_prot_clash = false;
		}

		clash_accept = 1.0 / clash_counter;
		std::cout << std::endl << "clash_accept:  " << clash_accept << std::endl << std::endl;

		pose_from_misc( protein_pose, fullatom, ideal_pose, coord_init );
		loops = loops_built;                              // from the Loops namespace
		protein_pose.recover_sidechain( preloop_pose );   // add sidechains to rebuilt loop
		repack_loops( loops, protein_pose );              // recover packing from loop_relax()

		//protein_pose.dump_scored_pdb( "test_looprlx_clash.pdb", score_weight );
	}

	pose_from_misc( protein_pose, fullatom, ideal_pose, coord_init );
	prot_lig_pose = protein_pose;

  	// attach ligand as a pose object
	if ( get_enable_ligaa_flag() ) {
		//////  START ATTACHMENT  //////
		int lig_root_atomno( 1 );   // 1st hetero heavyatom in pdb file
		int anchor_rsd( 1 );        // attach to first res, Ca
		int anchor_atomno( 2 );     // CA

		FArray2D_float lig_coord( 3, param::MAX_ATOM() );
		{
		  has_ligand_no( ligand_aa_vector[1] ) = 1;
		  setup_ligand_aa( ligand_aa_vector[1], 1, get_ligand_one(), lig_coord ); // aav=1
		}

		std::cout << std::endl << "ATTACHING POSE LIGAND..." << std::endl << std::endl;

		// no longer using ligand mode to manage the ligand
		// that's the hack -- it's been setup as an amino acid now
		bool attach_by_jump( true );	// alternative is to attach by a bond
		set_ligand_flag( false );

		prot_lig_pose.attach_ligand( ligand_aa_vector[1], 1 /* aav */, anchor_atomno, anchor_rsd, lig_root_atomno, lig_coord, attach_by_jump );
		prot_lig_pose.setup_atom_tree();
		// prot_lig_pose.dump_scored_pdb( "attached_ligand.pdb", score_weight );
		//////  END ATTACHMENT
	}

	if ( truefalseoption( "full_relax" ) ) {
		std::cout << std::endl << "STARTING FARLX..." << std::endl << std::endl;

		bool vary_bond_angles = truefalseoption( "vary_bond_angles" );  // false speeds up code by limiting search space
		float score_filter_accept = 1.0;            // use score filter in fast_relax_pose

		// allow both bb and chi angles to move during minimization
		prot_lig_pose.set_allow_bb_move( true );
		prot_lig_pose.set_allow_chi_move( true );

		// only one jump: ligand rigid-body degrees of freedom
		prot_lig_pose.set_allow_jump_move( truefalseoption("jump") );

		// quick cycle through minimize
		if ( truefalseoption( "fast" ) )	{
			lj_ramp_cycles = 1;
			cycles = 1;
		}

		fast_relax_pose( prot_lig_pose, score_weight, lj_ramp_cycles, cycles, "tmp", score_filter_accept, vary_bond_angles);
	}

	// finished with looprlx and farlx, now simple checkpointing and file output
	while ( out_flag ) {
		out_count = lead_zero_string_of( i_alt, MAX_SIZE );
		out_filename = filename_out + out_count + out_ext;

		inp.open( out_filename.c_str(), std::ifstream::in );
		inp.close();
		if ( inp.fail() ) {
			if ( truefalseoption( "silent_mode" ) ) {
				// open silent-output object
				std::cout << "before silent out" << std::endl;
				Silent_out out( files_paths_pdb_out_prefix() + filename_out + ".out" );
				score_set_evaluate_all_terms( true );
				prot_lig_pose.score( score12 );     // output score
				out.write( "S_" + out_count, prot_lig_pose );
				std::cout << "after silent out" << std::endl;
			} else {
				utility::io::ozstream out;
				prot_lig_pose.open_scored_pdb_outfile( out_filename, out );
				prot_lig_pose.dump_scored_pdb( out, score_weight );
				out.close();
			}
			out_flag = false;
		}
		i_alt++;
		if ( i_alt > MAX_STRUCTS ) { out_flag = false; }	// safety measure
	}
}
