// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.15 $
//  $Date: 2005/09/19 17:56:18 $
//  $Author: pbradley $


// Rosetta Headers
#include "loop_class.h"
#include "random_numbers.h"

// C++ Headers
#include <cassert>
#include <iostream>
#include <cassert>
#include <algorithm>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>
#include <utility/io/ocstream.hh>
#include <utility/file/file_sys_util.hh>


namespace pose_ns {

	std::ostream & operator<<( std::ostream & os, const Loop & loop ) {
		os << loop.start_ << " " << loop.stop_ << " " << loop.cut_ << " "
			 << loop.offset_ << " " << loop.extended_ << std::endl;
		return os;
	}

	std::ostream & operator<<( std::ostream & os, const Loops & loops ) {
		os << "num/begin/end/cut/offset/extended\n";
		int i = 0;
		for( Loops::const_iterator it= loops.begin(), it_end=loops.end();
				 it != it_end; ++it ) {
			++i;
			os << i << " " << *it;
		}
		return os;
	}


  void
  Loops::read_loops_from_file(
		std::string const filename
	)
	{

		utility::io::izstream data( filename.c_str() );
		if ( !data ) {
			std::cout << "Couldn't open check point loop file " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		std::string line;
		while ( getline( data, line ) ) {
			std::istringstream line_stream( line );
			int begin, end, cut, offset, extended;
			line_stream >> begin >> end >> cut >> offset >> extended;
			if ( !line_stream.fail() )
				add_loop(begin,end,cut,offset,extended);
		}
		data.close();
		data.clear();

	}

  void
  Loops::write_loops_to_file(
		std::string const filename
	)
	{

		utility::io::ozstream data;
		data.open( filename );
		if ( !data ) {
			std::cout << "Couldn't write check point loop file " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		for( Loops::const_iterator it= this->begin(), it_end=this->end();
			it != it_end; ++it ) {
			data << it->start() << " " << it->stop() << " " << it->cut() << " "
				<< it->offset() << " " << it->is_extended() << std::endl;
		}

		data.close();
		data.clear();
	}

//////////////////////////////////////////////////////////////////////
  void
  Loops::add_loop(
    int const start,
    int const stop,
    int const cut,
		int const offset,
    bool const extended
  )
  {
    if ( cut >=start-1 && cut <= stop && start < stop ) {
      for( const_iterator it = loop_list.begin(), it_end = loop_list.end();
					 it != it_end; ++it ) {
				// check for conflicts
				if( stop < it->start() || start > it->stop() ) {
					// do nothing
				} else {
					std::cout << "Loops::add_loop error -- overlapping loop regions\n"
										<< "existing loop begin/end: " << it->start() << "/"
										<< it->stop() << "\n"
										<< "new loop_begin/end: " << start << "/" << stop
										<< std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}
      }
      // fine, just add it and do not sort
     //  bool inserted = false;
//       for ( iterator it = loop_list.begin(), it_end = loop_list.end();
// 						it != it_end; ++it ) {
// 				if( it->start() > start ) {
// 					loop_list.insert( it, Loop( start, stop, cut, offset, extended ) );
// 					inserted = true;
// 					break;
// 				}
//       }
//       if( ! inserted )
			loop_list.push_back( Loop( start, stop, cut, offset, extended ) );

    } else {
      std::cout << "Loops::add_loop error -- bad loop definition\n"
								<< "begin/cut/end: " << start << "/" << stop << "/"
								<< cut << std::endl;
			assert( false );
      utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    }
  }
	/////////////////////////////////////////////////////////////////////////////
	void
	Loops::add_loop( const Loops::const_iterator & it ) {
		add_loop( it->start(), it->stop(), it->cut(),
			it->offset(), it->is_extended() );
	}
	/////////////////////////////////////////////////////////////////////////////
	void
	Loops::add_loop( const Loops::iterator & it ) {
		add_loop( it->start(), it->stop(), it->cut(),
			it->offset(), it->is_extended() );
	}
	/////////////////////////////////////////////////////////////////////////////
	void
	Loops::add_overlap_loop( Loops loops ) {
		for( Loops::const_iterator it = loops.begin(), it_end = loops.end();
			 it != it_end; ++it ) {
			add_overlap_loop( *it );
		}
	}
	/////////////////////////////////////////////////////////////////////////////
	void
	Loops::add_overlap_loop( const Loop loop ) {

//    if ( loop.cut() >=loop.start()-1 && loop.cut() <= loop.stop() && loop.start() < loop.stop() ) {
			int temp_start = loop.start();
			int temp_stop  = loop.stop();
			int temp_cut   = loop.cut();
			std::vector<int> loops_to_delete_start;
			std::vector<int> loops_to_delete_stop;
      for( const_iterator it = loop_list.begin(), it_end = loop_list.end();
					 it != it_end; ++it ) {
				// check for conflicts
				if( temp_stop >= it->start() && temp_stop <= it->stop() ){
					temp_stop = it->stop();
					if( std::find( loops_to_delete_start.begin(), loops_to_delete_start.end(),
						it->start() ) == loops_to_delete_start.end() )
					{
						loops_to_delete_start.push_back( it->start() );
						loops_to_delete_stop.push_back( it->stop() );
					}
				}
				if( temp_start <= it->stop() && temp_start >= it->start()) {
					temp_start = it->start();
					if( std::find( loops_to_delete_start.begin(), loops_to_delete_start.end(),
						it->start() ) == loops_to_delete_start.end() )
					{
						loops_to_delete_start.push_back( it->start() );
						loops_to_delete_stop.push_back( it->stop() );
					}
				}
				if( temp_start <= it->start() && temp_stop >= it->stop() ){// include an existing loop
					if( std::find( loops_to_delete_start.begin(), loops_to_delete_start.end(),
						it->start() ) == loops_to_delete_start.end() )
					{
						loops_to_delete_start.push_back( it->start() );
						loops_to_delete_stop.push_back( it->stop() );
					}
				}
      }
			for( int d = 0; d < static_cast<int>( loops_to_delete_start.size() ); ++d )
				delete_loop(loops_to_delete_start[d], loops_to_delete_stop[d] );
			loop_list.push_back( Loop( temp_start, temp_stop, temp_cut, loop.offset(), loop.is_extended() ) );

//    } else {
//      std::cout << "Loops::add_loop error -- bad loop definition\n"
//								<< "begin/cut/end: " << loop.start() << "/" << loop.stop() << "/"
//								<< loop.cut() << std::endl;
//			assert( false );
 //     utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
//    }
  }

  /////////////////////////////////////////////////////////////////////////////
  void
  Loops::delete_loop(
    int const start,
    int const stop
  )
  {
    assert( start < stop );

    for( iterator it=loop_list.begin(), it_end=loop_list.end();
				 it != it_end; ++it ) {
      if ( start == it->start() && stop == it->stop() ) {
				loop_list.erase( it );
				break;
      }
    }
  }
	/////////////////////////////////////////////////////////////////////////////
	Loops::const_iterator
	Loops::one_random_loop() const {
		int const size = int(loop_list.size());
		assert( size > 0 );
		int index =0;
		int const end = int( ran3()*size );
		const_iterator it = loop_list.begin();
		while( index != end ) { ++index; ++it; }
		return it;
	}
	/////////////////////////////////////////////////////////////////////////////
	int
	Loops::loop_size(
		int const num
	) const {
		assert( num > 0 && num <= int(loop_list.size()) );
		return loop_list[num-1].size();
	}

	int
	Loops::loop_size() const {
		int size = 0;
		for( const_iterator it=loop_list.begin(), it_end=loop_list.end();
				 it != it_end; ++it ) {
			size += it->size();
		}
		return size;
	}
	/////////////////////////////////////////////////////////////////////////////
	void
	Loops::sequential_order()
	{
		if ( num_loop() <= 1 ) return;

		std::vector< Loop > new_loop_list;

		iterator it_begin = loop_list.begin();
		new_loop_list.push_back( *it_begin );

		for ( const_iterator it = ++it_begin, it_end = loop_list.end();
					it != it_end; ++it ) {
			bool inserted = false;
			for( iterator it2 = new_loop_list.begin(), it2_end = new_loop_list.end();
					 it2 != it2_end; ++it2 ) {
				if ( it->start() < it2->start() ) {
					new_loop_list.insert( it2, *it );
					inserted = true;
					break;
				}
			}
			if ( ! inserted ) new_loop_list.push_back( *it );
		}
		assert( loop_list.size() == new_loop_list.size() );
		loop_list = new_loop_list;
	}
	void
	Loops::clear(){

		loop_list.clear();

	}
}
