// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12759 $
//  $Date: 2007-02-13 18:00:31 -0500 (Tue, 13 Feb 2007) $
//  $Author: yab $

#ifndef INCLUDED_loop_relax
#define INCLUDED_loop_relax


// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
//#include <iosfwd>
//#include <map>
//#include <utility>
#include <vector>
//#include<map>

// Forward declarations
namespace pose_ns { class Loops; }

/*
namespace loopcst
{
  extern std::map<int,float> coord_cst;
  extern bool coord_cst_exist;
  extern float loop_skip_rate;
  extern float loop_combine_rate;
  extern bool loop_model_exist;
  extern float total_chain_break_score;
  extern std::vector< float > chain_breaks;
  extern pose_ns::Loops loops_built;
}
*/

bool
read_loop_file(
	std::vector<int> & loop_begin,
	std::vector<int> & loop_end
);


void
verify_loop_file(
	pose_ns::Pose const & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end
);


bool
build_obligate_loops(
	pose_ns::Pose & pose,
	pose_ns::Loops & output_loops,
	bool const & full_atom
);


void
barcode_extend_stems(
	int & barcst_extend_begin,
	int & barcst_extend_end,
	int & loop_begin,
	int & loop_end,
	int const & old_loop_begin,
	int const & old_loop_end,
	std::vector<int> const & free_res,
	int const & nres,
	int const & selected_loop,
	int const & total_combine,
	int const & backward_combine,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end
);


void
set_looprlx_allow_move_map(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end
);


bool
get_random_loop_exist(
);


float
get_rmsd_tolerance(
);


float
get_chain_break_tolerance(
);


bool
get_idealization(
);


void
insert_one_random_frags(
	const int frag_size,
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int frag_offset
);


bool build_random_loops(
	pose_ns::Pose & pose ,
	std::vector<int> const & ori_loops_begin,
	std::vector<int> const & ori_loops_end,
	pose_ns::Loops & output_loops,
	bool const & full_atom,
	bool const & obligate
);


bool select_one_loop(
	int nres,
	int & selected_loop,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	std::vector<int> & folded_loops,
	std::vector<int> & inter_res,
	int & loop_begin,
	int & loop_end,
	bool & loops_combined,
	int & combine_number,
	int & loop_counter
);


int
choose_cutpoint
(
	pose_ns::Pose const & pose,
	int loop_begin,
	int loop_end
);


void
build_loop_with_ccd_closure
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	bool const & full_atom
);


void
build_loop_with_ccd_move
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	bool const & full_atom
);


bool
loop_relax ();


void
show_decoy_status(
	pose_ns::Pose & pose
);


void
show_decoy_status(
	pose_ns::Pose & pose,
	std::string move_type
);


void
one_loop_choose_fragment_cst_pose(
	pose_ns::Pose & pose,
	float tolerance,
	int size,
	int & frag_begin,
	const int cutpoint
);



void
one_loop_choose_fragment_coord_pose(
	pose_ns::Pose & pose,
//	pose_ns::Pose const & ref_pose,
	float tolerance,
	int size,
	int & frag_begin,
	const int cutpoint
);


bool
accept_coord_cst(
	std::vector<float> const & check_score,
	std::vector<float> const & cst_score,
	float tolerance
);


bool
get_coord_cst_exist(
);


void
set_coord_cst_exist(
	bool truefalse
);


void
read_coord_cst(
);


void
read_obligate_loop_file(
	std::vector<int> & loop_begin,
	std::vector<int> & loop_end
);


void
choose_fragment_cst_pose(
	pose_ns::Pose * const pose,
	float tolerance,
	int size,
	int & frag_begin
);


float
get_coord_cst(
	int i
);


void
alter_homologous_seqs(
	pose_ns::Pose & pose,
	int const & start,
	int const & end
);


bool
acceptable_overall_rmsd_change(
	pose_ns::Pose const & init_pose,
	pose_ns::Pose const & pose
);


bool
acceptable_rmsd_change(
	pose_ns::Pose const & stage_pose,
	pose_ns::Pose const & pose
);


void
extend_barcode_regions_if_chain_break(
	pose_ns::Pose const & pose,
	int const & loop_begin,
	int const & loop_end,
	int & n_chain_break_fail,
	bool & is_chain_break,
	int & barcst_extend_begin,
	int & barcst_extend_end
);


std::vector<std::string>
read_alter_seqs(
);


bool
get_alter_seqs_exist(
);


void restore_seq(
	pose_ns::Pose & pose,
	pose_ns::Pose const & old_pose,
	int const & loop_begin,
	int const & loop_end
);


float
get_loop_combine_rate(
);


void
set_loop_combine_rate(
	float const & rate
);


float
get_score_filter_cutoff(
);


float
get_skip_loop_rate(
);


void
set_skip_loop_rate(
	float const & rate
);


bool get_loop_modeling_exist(
);

void
loop_fa_relax(
	      pose_ns::Pose & pose,
	      std::vector<int> const & loop_begin,
				std::vector<int> const & loop_end
);


void
loop_refinement(
	pose_ns::Pose & pose,
	pose_ns::Loops & loops
);


bool
get_loop_farlx_flag();

bool
get_loop_rebuild();

bool
get_fullatom_loop_flag();

bool
get_pose_idlz_flag();

bool
get_obligate_loop_exist();


int
desired_loops();


bool
get_desired_loops_exist();


void set_loop_modeling_exist(
	bool truefalse
);


void get_loop_modeling_option(
);


void
looprlx_fast_ccd_close_loops(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int const & cut_point
);


bool
Abuild_random_loops (
	pose_ns::Pose & pose,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	bool const & full_atom
);


void model_one_loop
(
	pose_ns::Pose & pose,
	int loop_begin,
	int loop_end,
	bool const & full_atom
);


bool
get_ccd_closure_exist();


bool
get_loop_fast_refine_exist(
);


bool
get_loop_fix_natsc_exist(
);


bool
shorten_long_terminal_loop();


void
fillin_loop_bvalue(
	pose_ns::Loops const & output_loops,
	float bfactor
);


void
fillin_loop_occupancy(
	pose_ns::Loops const & output_loops
);


bool
get_output_loops_file();


void
repack_loops(
	pose_ns::Loops const & loops,
	pose_ns::Pose & pose
);


void
pose_set_allow_chi_move_loops(
	pose_ns::Loops const & loops,
	pose_ns::Pose & pose
);

bool
get_combine_if_fail_exist(
);


float
get_total_chain_break_score(
);


bool
get_looprlx_exist();



void
reset_loop_chain_breaks(
);


void
output_loop_chain_breaks(
	std::ostream & iunit
);


float
get_looprlx_cycle_ratio(
);


bool
get_random_cutpoint(
);


bool
get_use_rg_during_looprlx(
);


bool
get_use_hb_during_looprlx(
);

bool
get_use_sspair_during_looprlx(
);

bool
get_use_rsigma_during_looprlx(
);


int
get_use_9mer_frag_cutoff(
);

void
frag_move_xyz(
	FArray1Da_float xyz,
	FArray2Da_float R,
	FArray1Da_float L
);


void
inverse_frag_move_xyz(
	FArray1Da_float xyz,
	FArray2Da_float R,
	FArray1Da_float L
);

#endif

