// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16023 $
//  $Date: 2007-07-14 13:12:57 -0400 (Sat, 14 Jul 2007) $
//  $Author: tex $

#ifndef INCLUDED_make_pdb
#define INCLUDED_make_pdb


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>

// make_pdb Function Declarations

namespace  make_pdb_ns {
	extern std::string nonscored_hetero_atoms;
	extern FArray2D_float bfactor;
	extern FArray2D_float occupancy;
}


bool
get_remark_option();

void
dump_pdb( std::string const & filename );


void
dump_native_pdb( std::string const & filename );


void
dump_fullatom_pdb( std::string const & filename );


void
output_position_pdb( utility::io::orstream & iunit );


void
output_native_pdb( utility::io::orstream & iunit );


void
make_pdb(
	utility::io::ozstream & iunit, // file stream to which to write
	bool fullatom
);


void
make_pdb_orstream(
	utility::io::orstream & iunit, // stream to which to write
	bool fullatom
);


void
output_torsion_angles( utility::io::orstream & iunit /* stream to which to write */ );


void
output_dna_params( utility::io::orstream & iunit);


void
output_pdb_stats(
	utility::io::orstream & iunit, // stream to which to write
	bool fullatom
);


float
torsion_diff(
	float angle1,
	float angle2
);


void
output_fullcoord_pdb( utility::io::orstream & iunit );


void
output_fullatom_pdb(
	FArray3Da_float xyz, // (xyz,atom#,res#) coordinates
	FArray1Da_int aan, // specifies amino acid at each seqpos
	FArray1Da_int aav, // amino acid variant at each position
	int const nres, // # of residues in the protein
	char const chain, // protein chain
	int const ndomains, // how many domains?
	FArray1Da_int dom_end, // end residues of each domain
	utility::io::orstream & iunit
);


void
output_residueE(
	utility::io::orstream & iunit,
	int const total_residue,
	FArray1Da_int res
);


void
output_residueE_partI(
	utility::io::orstream & iunit,
	int const total_residue,
	FArray1Da_int res
);


void
output_residueE_partII(
	utility::io::orstream & iunit,
	int const total_residue,
	FArray1Da_int res
);


void
output_rotamer_stats( utility::io::orstream & iunit );


void
output_chi( utility::io::orstream & iunit );


void
output_residueresidueE(
	utility::io::orstream & iunit,
	int const total_residue,
	FArray1Da_int res
);

void
sasapack_bfactor(
	int const toatl_residue
);

void
looprlx_set_bfactor(
	float & bval,
	int i,
	int j
);


void
looprlx_set_occupancy(
	float & occ,
	int i,
	int j
);


void
alter_pdb_fields( std::string filename );

void
alter_bfactor_pdbfile( std::string filename, FArray1D_float data );

#endif
