// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_maps
#define INCLUDED_maps


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// maps Function Declarations

//functions for tracking what is allowed to move

void
insert_map_get_max_contig_size(
	int & max_contig_size,
	int & total_size
);

bool
reset_insert_map();

void
initialize_maps();

void
set_allow_insert_by_region(
	int const first_res,
	int const last_res,
	bool const yes_no,
	bool & exist
);

void
retrieve_allow_insert(
	FArray1DB_bool & allow,
	int total_residue
);

void
retrieve_insertmap(
	FArray1DB_int & map, // should be declared of size MAX_RES
	int & length
);

void
setup_variable_regions();


//functions for tracking what has moved
FArray2D_bool const &
retrieve_pair_moved(
	bool const bb_only = false
);

FArray1D_bool const &
retrieve_res_moved(
	bool const bb_only = false
);


void
update_pair_moved();


void
maps_set_new_phipsi(
  int const begin,
  int const end,
  int const seg_begin,
  int const seg_end,
  int const dir = 1);


void
maps_set_new_rotamer(
	int const residue
);


void
maps_set_new_rigidbody(
  int const begin,
	int const end
);


void
reset_move_map();


void
maps_set_new_pose();


void
debug_move_maps(
	bool on
);

void
maps_get_pair_moved_region(
	int & begin,
	int & end
);

#endif
