// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#include "misc_removal.h"

#include "constraints.h"
#include "structure.h"

namespace misc_removal {

//// yab: misc removal
// these are temporary calls to setup singleton instances of some newly
// re-wrapped classes since pose disregards the classical Rosetta
// initialization route; this function is called from pose_from_pdb and
// pose_to_misc (in jumping_refold.cc), and is the only way to consistently
// ensure correct initialization.  Please DO NOT add anything here without
// consulting yab, as this function is scheduled for removal.
void
init_modules_TEMPORARY()
{
	if (!structure::BOUNDARY::init_module_called_once()) {
	  structure::BOUNDARY::init_module();
	}

	if (!classical_constraints::BOUNDARY::init_module_called_once()) {
	  classical_constraints::BOUNDARY::init_module();
	  classical_constraints::BOUNDARY::reset_cst_res_wt(); // FORCED, see the issue in initialize_query() and the comments at the top of constraints.cc.
	}
}
//// yab: misc removal

}
