// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19901 $
//  $Date: 2008-01-24 20:37:36 -0500 (Thu, 24 Jan 2008) $
//  $Author: aroop $


// Rosetta Headers
#include "monte_carlo.h"
#include "after_opts.h"
#include "cenlist.h"
#include "counters.h"
#include "diagnostics_rosetta.h"
#include "design.h"
#include "docking.h"
#include "docking_movement.h"
#include "files_paths.h"
#include "force_barcode.h"
#include "fullatom.h"
#include "fullatom_energy.h"
#include "ise_movies.h"
#include "ligand.h"
#include "ligand_ns.h"
#include "loops.h"
#include "maps.h"
#include "misc.h"
#include "namespace_low_pose.h"
#include "nblist.h"
#include "orient_rms.h"
#include "param.h"
//#include "pose.h"
#include "random_numbers.h"
#include "recover.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "status.h"
#include "taboo_search.h"
#include "trajectory.h"
#include "vdw.h"
#include "runlevel.h"
#include "SurfaceMode.h"//KMa surface 2006-02

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/ozstream.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

#ifdef GL_GRAPHICS
#include "gl_graphics.h"
#endif

// Namespaces
namespace mc_converge {
	using namespace param;
	int converged;
	float converge_rms;
	FArray2D_float very_old_position( 3, MAX_POS * MAX_RES() );
}
namespace mc_quench {
	float quench_temp = { 2.0 };
}
namespace mc_simanneal {
	bool simannealing = { false };
	int last_accept = { 0 };
}
namespace mc_status {
	float temperature = { 2.0 };
	int monte_carlo_accept;
	float monte_carlo_energy_drop;
}
namespace movie_data {
	using namespace param;
	FArray2D_float old_position( 3, MAX_POS * MAX_RES() );
	int counter = { 1 };
	int orient_start = { 1 };
	int orient_end = { 0 };
}

//// yab: misc removal
////   temporarily move tracking variables from misc to here
////   we will finalize later by either encapsulation inside
////   monte carlo/sampling class or score tracking class
namespace mc_global_track {
	//---------------------
	//  monte carlo scores
	//---------------------
	//car WARNING!! These variable belong to monte carlo. They are included
	//car here for diagnostic access only. Only monte carlo is allowed to
	//car change the value of best_score or low_score
	//car score should be set by scorefxn prior to calling monte carlo
	namespace mc_score {
		float score;
		float best_score;
		float low_score;
	}

	//-------------
	// diagnostics
	//-------------
	//CAR WARNING!! these variables belong to monte carlo, and are included
	//car here for diagnostic access only.
	//car best_rms,low_rms car and rms_min should only be changed by monte
	//car carlo, rms_err should be set only by calc_rms().
	namespace diagnose {
		float rms_err; // last evaluated rms
		float low_rms; // rms  of "low" strucure
		float best_rms; // rms  of "best" strucure
		float rms_min; // rms minimum encountered by mc
	}
}
//// yab: misc removal

//car  input- score, current arrays
//car  output- position, best arrays, low arrays, sc arrays, vdw arrays


//car monte-carlo compares the current "score" (ie global in misc.h) to the
//car static internal variable "best_score" to decide if a new structure
//car is accepted. If accepted, "best" arrays are updated. If the score is
//car the lowest ever seen, the the "low" arrays are updated. If a move
//car is accepted, the internal arrays of scoring functions are updated
//car (vdw_compute, fullatom_energy0

//car Checks for convergence and sets external convergence flag
//car
//car Lower scoring structures are always accepted, higher scoring structures
//car are accepted using a metropolis criterion. The temrpature is maintained
//car internally. Temp is raised if too may rejects occur sequentially, and
//car quenched after every accept.

//car For diagnostic purposes, low_rms arrays are maintained to track the
//car lowest rms structure, are low_sc arrays are maintained to track the
//car structure with the lowest constraints score.

//car public functions:
//
//   monte_carlo is the main function.
//
//   monte_carlo_reset
//   forces move to be accepted (ie and arrays updated)
//   ALWAYS call after a non-standard choose-frag type insertion.
//

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_reset
///
/// @brief
/// this function has lots of desirable side effects:
///        1) resets the internal arrays in monte-carlo (low_phi and best_phi)
///        2) resets the internal arrays in vdw_compute
///
/// @detailed
///car accompished by setting best and low scores to very high values
///car and setting cycle_number to -999 so no counters increment
///car also quenches temp (any accept results in quench)
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_reset()
{

	using namespace counters;
	// using namespace misc; // yab: misc removal
	using namespace mc_global_track::mc_score;

	if ( move_type == "unknown" ) move_type = "unknown_reset";
	best_score = 9.9e8 + score;
	low_score = score + 9.9e9;
	monte_carlo(-999);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_set_simannealing
///
/// @brief
///
/// @detailed
///car in simannealing mode, monte carlo never adjusts it's own temp
///car the user can control the temp as desired
///
///car in non-simannealing mode, mc increments it's own temp when moves
///car are not being accepted, then quenches once a move is accepted.
///
///car switching from simmannealing to non-simannealing mode causes the
///car last_accept counter to be reset
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_set_simannealing( bool setting )
{

	using namespace mc_simanneal;

	if ( !setting && simannealing ) last_accept = 0;
	simannealing = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_set_quench_temp
///
/// @brief
///
/// @detailed
///
/// @param  set_temp - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_set_quench_temp( float set_temp )
{
//car debug

	using namespace mc_quench;
	using namespace mc_simanneal;

	if ( simannealing ) std::cout << "no need to set quench temp" << std::endl;
//car end debug

	quench_temp = set_temp;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_set_temp
///
/// @brief
///
/// @detailed
///
/// @param  set_temp - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_set_temp( float set_temp )
{
	using namespace mc_status;

	temperature = set_temp;
}
////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_set_accept
///
/// @brief
///
/// @detailed
///
/// @param  accept_type - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_set_accept( int accept_type )
{
	using namespace mc_status;

	monte_carlo_accept = accept_type;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_get_temp
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
monte_carlo_get_temp()
{
	using namespace mc_status;

	return temperature;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_monte_carlo_accept
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
int
get_monte_carlo_accept()
{
	using namespace mc_status;

	return monte_carlo_accept;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_monte_carlo_energy_drop
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
get_monte_carlo_energy_drop()
{
	using namespace mc_status;

	return monte_carlo_energy_drop;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_monte_carlo_converged
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
int
get_monte_carlo_converged()
{
	using namespace mc_converge;

	return converged;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo
///
/// @brief
///  THIS FUNCTION DETERMINES WHETHER TO KEEP THE
///    NEW CONFORMATION
///
/// @detailed
/// return values:
///                3 = accepted:score beat low score and best_score,
///                2 = accepted:score beat best_score,
///                1 = thermally accepted: score worse than best_score
///                0 = not accepted,
///
///car cycle_number < -.5 flags mc to accept without incrementing naccepts
///car cycle_number > 100000 enables checking for convergence
///
///car note that if movies are being made, the position array (but not
///car centroid or fullcoord) will be modified by a call to monte_carlo
///
/// @param  cycle_number - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo( int cycle_number )
{

	using namespace counters;
	using namespace files_paths;
	using namespace mc_converge;
	using namespace mc_quench;
	using namespace mc_simanneal;
	using namespace mc_status;
	using namespace misc;
	using namespace runlevel_ns;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

//------------------------------------------------------------------------------
	if ( cycle_number > -.5 ) ++ntrials;

	calc_rms();

	monte_carlo_accept = 2;

	if ( get_taboo_exist() ) {
		taboo_new_move();
		score += scores::taboo_score;
	}

	monte_carlo_energy_drop = score - best_score;

	if ( score > best_score ) {
		monte_carlo_accept = 0;
		if ( !simannealing ) {
			if ( last_accept == 150 ) {
				++temperature;
				last_accept = -1;
				temperature = std::min(temperature,20.0f);
			}
			++last_accept;
		}
		float const boltz_factor = ( best_score - score ) / temperature;
		float const probability = std::exp(std::min(40.0f,std::max(-40.0f,boltz_factor)) );
		float const crap = ran3(); // bug if call to ran3 in "if" statement

		if ( crap >= probability ) { // reject
			if ( make_ise_movie ) {
				output_movie_frame(score,best_score,monte_carlo_accept);
			}
			// for debugging and to get more complete
			// picture of trajectories, write line to status file for all attempted
			// moves
			if ( runlevel > standard ) {
				output_status_file(monte_carlo_accept,temperature);
			}
			monte_carlo_energy_drop = 0.0;
			increment_trial_counters(cycle_number);
			resetphipsi();
			retrieve_best_nblist();
			reset_status_info();
			return;
		}
		monte_carlo_accept = 1; // accepted by chance, you lucky bastard
	}                     // score vs bestscore

// accepted!!
	if ( cycle_number > -.5 ) ++naccept;

	if ( get_taboo_exist() ) {
		score -= scores::taboo_score; // give back the original score for next step
		taboo_accept();
	}

// barcode update when accepted
	barcode_accept();

	if ( !simannealing ) {    // quench
		temperature = quench_temp;
		last_accept = 0;
	}

	monte_carlo_accept_best();

//******  keep track of low rms structure (diagnostic only) ******
	if ( rms_err < rms_min ) rms_min = rms_err;
// ********* low ***************
// accept ties (on assumption that later is better) to allow forced accept
// when low_score==score

	if ( score <= low_score ) {
		monte_carlo_accept = 3;
		monte_carlo_accept_low();
//		if ( get_taboo_exist() ) {//currently only keep the lowest score one
//				aspiration_sites.clear();
//				aspiration_sites.update( phi,psi,score );
//		}
		low_cycle = cycle_number; // diagnostic only
		if ( cycle_number > -.5 ) ++n_low_accept; // diagnostic only
	}                     // low score

	if ( make_ise_movie ) {
		output_movie_frame(score,best_score,monte_carlo_accept);
	}

// ****  check for convergence  ************
	converged = 0;
	if ( mod(naccept,100) == 0 && cycle_number > 100000 ) {
		if ( naccept > 500 ) {
			orient_rms(position,very_old_position,total_residue,converge_rms);
			if ( converge_rms < 3.0 ) {
				std::cout << "converged" << SS( converge_rms ) << SS( cycle_number ) <<
				 std::endl;
				converged = 1;
			}
		}

		for ( int i = 1; i <= total_residue*5; ++i ) {
			for ( int j = 1; j <= 3; ++j ) {
				very_old_position(j,i) = position(j,i);
			}
		}
	}

//****** keep track of trial statistics**************
	increment_trial_counters(cycle_number);

//******  write out status file info   **********
	output_status_file(monte_carlo_accept,temperature);

//******** superimpose and write out coords for movie *******
	write_xyz();
#ifdef GL_GRAPHICS
	while ( wait_on_graphics() ) {
	}
#endif
	reset_status_info();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_accept_best
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_accept_best()
{
	using namespace ligand;
	using namespace misc;
	using namespace param;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	assert( !pose_flag() );

//car update coordinates:
	best_phi = phi;
	best_psi = psi;
	best_omega = omega;
	best_secstruct = secstruct;
	best_name = name;
	best_res = res;
	best_res_variant = res_variant;
	best_position = position;
	best_centroid = centroid;
	best_centroid_parm_eachres = centroid_parm_eachres;

	if ( get_fullatom_flag() ) {
		best_full_coord = full_coord;
	}
//KMa surface
if(surface::mode.flag.is_enabled())surface::mode.protein_surfacemove_symmetry();

//mj copy best ligand coordinates in ligand mode
	if ( get_ligand_flag() ) {
    ligand::ligand_one->set_best_coordinates();
  }

	docking_mc_accept_best();
	loop_accept_best_pose();

	best_rms = rms_err;
	best_score = score;
	append_trajectory( score, rms_err );
	//	trajectory::rmsd_vector.push_back(rms_err);
	//	trajectory::energy_vector.push_back(score);

//car update scoring functions
	mc_update_scorefxns();
}

///////////////////////////////////////////////////////////////////////////////
void
accept_best_coord()
{
	// used in loop modeling with dunbrack closure where each ccd move has to
	// update best_pose to be used as the reference for the next move, but we do
	// not want to update scorefxn

	using namespace ligand;
	using namespace misc;
	using namespace param;

//car update coordinates:
	best_phi = phi;
	best_psi = psi;
	best_omega = omega;
	best_secstruct = secstruct;
	best_name = name;
	best_res = res;
	best_res_variant = res_variant;
	best_position = position;
	best_centroid = centroid;
	best_centroid_parm_eachres = centroid_parm_eachres;

	if ( get_fullatom_flag() ) {
		best_full_coord = full_coord;
	}

//mj copy best ligand coordinates in ligand mode
  if ( get_ligand_flag() ) {
		ligand::ligand_one->set_best_coordinates();
  }
}

////////////////////////////////////////////////////////////////////////////////
/// @begin mc_update_scorefxns
///
/// @brief
///car this function is responsible for ensuring that scoring functions
///car that rely on stored information about the current or best structure
///car remain up to date.
///
/// @detailed
///car this function should be called after a new structure
///car is copied into the best arrays at the time when position and best_position
///car agree  (ie in mc_accept_best)
///
///car functions that rely on stored values:
///car  vdw_compute, cendist, fullatom_energy)
///
///car update nblist and rescore, nblist may not have completely correct
///car before calling monte_carlo; need to ensure that future calculations
///car based from the best arrays will be correct
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
mc_update_scorefxns()
{

	using namespace misc;
	using namespace scorefxns;

	using namespace mc_global_track::mc_score; // yab: misc removal

	assert( !pose_flag() );

	update_sequence(); // correct all seqeunce info
	update_nblist();

	if ( get_use_nblist() ) {
		// if somebody already called score_enable_rotamer_trials(false)
		// we dont want to undo their work, so we cant just nest the
		// score-call inside enable(false) ... enable(true)
		// they may be counting on enable(false) for a while longer...
		bool const save_try_rotamers( score_get_try_rotamers() );
		score_enable_rotamer_trials( false );
		score = scorefxn();
		if ( save_try_rotamers ) {
			score_enable_rotamer_trials( true );
		}
	}

	copy_fullatom_energies_to_best(total_residue);
	accept_best_cendist();
	accept_best_vdw_bumps();
	accept_best_nblist();

	reset_move_map();

	best_score = score;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin monte_carlo_accept_low
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
monte_carlo_accept_low()
{
	using namespace ligand;
	using namespace low_pose;
	using namespace misc;
	using namespace param;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	assert( !pose_flag() );
	low_phi = phi;
	low_psi = psi;
	low_omega = omega;
	low_secstruct = secstruct;
	low_name = name;
	low_res = res;
	low_res_variant = res_variant;
	Elow_position = Eposition;
	low_centroid = centroid;
	low_centroid_parm_eachres = centroid_parm_eachres;

	low_rms = rms_err;
	low_score = score;

//car save rotamers
	if ( get_fullatom_flag() ) {
		low_full_coord = full_coord;
	}

//mj copy low ligand coordinates in ligand mode
  if ( get_ligand_flag() ) {
    low_hetero_atom_coord.clear();
    low_hetero_atom_coord.reserve(ligand::ligand_one->atom_vector.size());
    for ( size_t k = 0; k < ligand::ligand_one->atom_vector.size(); ++k ) {
        low_hetero_atom_coord.push_back(ligand::ligand_one->atom_vector[k]->get_coordinates());
    }
  }

	docking_mc_accept_low();
	loop_accept_low_pose();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin reset_movie
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
reset_movie()
{
	using namespace misc;
	using namespace movie_data;

	for ( int i = 1; i <= total_residue; ++i ) {
		for ( int j = 1; j <= 3; ++j ) {
			old_position(j,i) = position(j,i);
		}
	}
	counter = 1;
	orient_start = std::max(1,total_residue/2 -2);
	orient_end = std::max( std::min(total_residue/2 +2,total_residue),orient_start);
  if ( files_paths::multi_chain && !design::dna_interface && !files_paths::antibody_modeler ) {
		orient_start = 1;
		orient_end = std::max(get_docking_part2_begin()-1,orient_start);
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin write_xyz
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
write_xyz()
{
	using namespace counters;
	using namespace files_paths;
	using namespace misc;
	using namespace movie_data;
	using namespace param;
	using namespace runlevel_ns;

//car local
	float occ,bfactor;
	char chain;
	int docking_part2_begin;
	float local_rms;

	static bool init = { false };
	static bool make_movie = { false };
	static bool make_trajectory = { false };


//------------------
//car setup movie file
//------------------
	if ( !init ) {
		init = true;
		if ( runlevel == silent ) return;
		make_movie = truefalseoption("movie");
		make_trajectory = truefalseoption("trajectory");
		if ( !make_movie && ! make_trajectory ) return;
		movie_file = '-';
		if ( query_defined ) movie_file = code + protein_name;
		stringafteroption( "moviefile", movie_file, movie_file );
		if ( make_movie || make_trajectory ) {
			if ( movie_file == "-" ) {
				std::cout << "WARNING: unable to make movies/trajectories: " <<
				 " no filename defined" << std::endl;
				std::cout << "either specify series_code and protein_name" << std::endl;
				std::cout << "or use -moviefile option" << std::endl;
				make_movie = false;
				make_trajectory = false;
				return;
			} else {
				std::cout << "movie file: " << movie_path << movie_file << std::endl;
			}
		}
	}
//------------------------------------------------------------------------------

	if ( !make_movie && !make_trajectory ) return;
	if ( move_type == "initialize" ) return;
	if ( multi_chain && !design::dna_interface && !antibody_modeler ) {
		chain = 'Y';
		docking_part2_begin = get_docking_part2_begin();
	} else {
		chain = ' ';
		docking_part2_begin = 0;
	}

//car if anything is in domain 1, it's fixed in cartesian space?
	if ( !multi_chain || design::dna_interface || antibody_modeler ) {
		orient_region(total_residue,position,full_coord,old_position,1,
		 orient_start,orient_end,1,1,total_residue,local_rms);
		for ( int i = 1; i <= total_residue*MAX_POS; ++i ) {
			for ( int j = 1; j <= 3; ++j ) {
				old_position(j,i) = position(j,i);
			}
		}
	}


//car pdb format
	std::string const filename( movie_path + movie_file + "movie.pdb" );

	std::string const filename2( movie_path + movie_file + lead_zero_string_of( counter, 4 ) + "T.pdb" );

	++counter;

	std::string const tmp( movie_path + movie_file + "_tmp.pdb" );

	utility::io::ozstream movie_x( tmp );

	if ( !movie_x ) {
		std::cout << "Open failed for file: " << tmp << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	occ = 1.0;
	for ( int i = 1; i <= total_residue; ++i ) {
		if ( !multi_chain || design::dna_interface || antibody_modeler ) {
			bfactor = i*80.0/total_residue;
			if ( i >= insert_pt && i < insert_pt+insert_size ) bfactor = 99.0;
		} else {
			if ( i >= docking_part2_begin ) {
				chain = 'Z';
				bfactor = 80;
			} else {
				chain = 'Y';
				bfactor = 1;
			}
		}
		movie_x << "ATOM  " << I( 5, i ) << "  CA  " << residue3(i) <<
		 ' ' << chain << I( 4, i ) << "    " << F( 8, 3, Eposition(1,1,i) ) <<
		 F( 8, 3, Eposition(2,1,i) ) << F( 8, 3, Eposition(3,1,i) ) << "  " <<
		 F( 4, 2, occ ) << ' ' << F( 5, 2, bfactor ) << '\n'; //std::endl;
		movie_x << "ATOM  " << I( 5, i ) << "  N   " << residue3(i) <<
		 ' ' << chain << I( 4, i ) << "    " << F( 8, 3, Eposition(1,2,i) ) <<
		 F( 8, 3, Eposition(2,2,i) ) << F( 8, 3, Eposition(3,2,i) ) << "  " <<
		 F( 4, 2, occ ) << ' ' << F( 5, 2, bfactor ) << '\n'; //std::endl;
		movie_x << "ATOM  " << I( 5, i ) << "  C   " << residue3(i) <<
		 ' ' << chain << I( 4, i ) << "    " << F( 8, 3, Eposition(1,4,i) ) <<
		 F( 8, 3, Eposition(2,4,i) ) << F( 8, 3, Eposition(3,4,i) ) << "  " <<
		 F( 4, 2, occ ) << ' ' << F( 5, 2, bfactor ) << '\n'; //std::endl;
		movie_x << "ATOM  " << I( 5, i ) << "  O   " << residue3(i) <<
		 ' ' << chain << I( 4, i ) << "    " << F( 8, 3, Eposition(1,5,i) ) <<
		 F( 8, 3, Eposition(2,5,i) ) << F( 8, 3, Eposition(3,5,i) ) << "  " <<
		 F( 4, 2, occ ) << ' ' << F( 5, 2, bfactor ) << '\n'; //std::endl;
		movie_x << "ATOM  " << I( 5, i ) << "  CB  " << residue3(i) <<
		 ' ' << chain << I( 4, i ) << "    " << F( 8, 3, Eposition(1,3,i) ) <<
		 F( 8, 3, Eposition(2,3,i) ) << F( 8, 3, Eposition(3,3,i) ) << "  " <<
		 F( 4, 2, occ ) << ' ' << F( 5, 2, bfactor ) << '\n'; //std::endl;
	}
	movie_x.close();
	movie_x.clear();
	std::string command;
	if ( make_trajectory ) {
		if ( make_movie ) {
			command = "cp " + tmp + ' ' + filename;
			std::system( command.c_str() );
		}
		command = "mv " + tmp + ' ' + filename2;
	} else {
		command = "mv " + tmp + ' ' + filename;
	}
	std::system( command.c_str() );


//car format for xmol

//$$$      f_unit << total_residue*3 << std::endl;
//$$$      f_unit << "New Structure:" <<
//$$$       SS( score ) << SS( cycle_number ) << SS( seq_num ) << std::endl;
//$$$
//$$$      for ( int j = 1; j <= total_residue; ++j ) {
//$$$         f_unit << " N  " << F( 10, 2, Eposition(1,1,j) ) <<
//$$$           F( 10, 2, Eposition(2,1,j) ) << F( 10, 2, Eposition(3,1,j) ) << std::endl;
//$$$         f_unit << " CA " << F( 10, 2, Eposition(1,2,j) ) <<
//$$$           F( 10, 2, Eposition(2,2,j) ) << F( 10, 2, Eposition(3,2,j) ) << std::endl;
//$$$         f_unit << " C  " << F( 10, 2, Eposition(1,4,j) ) <<
//$$$           F( 10, 2, Eposition(2,4,j) ) << F( 10, 2, Eposition(3,4,j) ) << std::endl;
//$$$      }
//$$$
}
