// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16636 $
//  $Date: 2007-08-21 18:47:16 -0400 (Tue, 21 Aug 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_multistate_design
#define INCLUDED_multistate_design

//Rosetta Headers
#include "ga_seq_opt.h"
#include "ligand_ns.h"
#include "pose.h"
#include "RotamerSet.h"


#include<vector>
#include<string>

// forward declarations
#include "dna_fwd.h"
#include "PackerTask_fwd.h" // DesignMap

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

////////////////////////////////////////////////////////////////////////////////
class SingleState {
	public:

	float best_score;

	// Storage for coordinates
	pose_ns::Pose pose;
	ligand::LigandCartesianCoord hetero_atom_coord;

	// Storage for packer stuff
	RotamerSet p_rotamer_set_;
	pack::InteractionGraphBase * ig;
	int tot_res;
	FArray1D_int current_rot_index;
	FArray1D_float ligenergy1b_old;

	SingleState(){};

	SingleState( SingleState const & other_state ) :
			best_score( 9999.99 ),
			hetero_atom_coord( other_state.hetero_atom_coord ),
			ig( NULL ) {
				pose = other_state.pose;
			};

	void copy_rotamers_and_ig_from( SingleState const & in )
	{
		p_rotamer_set_ = in.p_rotamer_set_; // is not a pointer... but that's ok
		ig = in.ig; // is a pointer
	}

};

////////////////////////////////////////////////////////////////////////////////
// multistate_design Function Declarations

void
multistate_design( std::string const & packmode );

void
output_population(
	std::vector< ga_seq_opt::PopMember > const & population,
	std::string const outfile_root,
	int const iteration
);

void
load_checkpoint(
	std::vector< ga_seq_opt::PopMember > & population,
	int & ms_iter,
	std::string const outfile_root
);

void
copy_ms_set_to_current( SingleState const & state );

SingleState
single_state_from_misc();

void
ms_set_limit_rotamer_set(
	std::vector< int > & limited_rotamer_set,
	FArray1DB_bool const & is_res_designed,
	FArray1DB_int const & inv_res_mapping,
	std::vector< SingleState >::iterator state_itr,
	std::vector< ga_seq_opt::PopMember >::iterator p_itr
);

void
ms_get_working_array(
  DesignMap & design_map
);

void
ms_evolve_next_gen(
	int ms_iter,
	int num_states,
	DesignMap const & mdm,
	FArray1DB_int const & res_mapping,
	std::vector< ga_seq_opt::PopMember > & pop
);

int
ms_tournament_select( std::vector< ga_seq_opt::PopMember > & pop);

void
read_ms_filenames(
	std::vector< std::string > & return_values,
	std::string & file_with_names_in_it
);

void
recombine_int_vectors(
	std::vector< int > & parent1,
	std::vector< int > & parent2,
	std::vector< int > & child
);

void
check_for_cached(
	ga_seq_opt::PopMember & this_member
);

void
build_DNA_competitors(
	DnaPose const & dnapose,
	std::vector< SingleState > & states
);

#endif
