// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13347 $
//  $Date: 2007-03-08 07:43:32 -0500 (Thu, 08 Mar 2007) $
//  $Author: ion $


// Rosetta Headers
#include "native.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>


// Using
using namespace param;


//------------------
// native structure
//------------------


namespace native {
	FArray1D_float native_phi( MAX_RES() );
	FArray1D_float native_psi( MAX_RES() );
	FArray1D_float native_omega( MAX_RES() );
	FArray2D_float native_ca( 3, MAX_RES() );
	FArray3D_float native_coord( 3, MAX_ATOM(), MAX_RES() );
	std::vector< numeric::xyzVector_double > native_hetero_atom_coord;
//	FArray2D_float native_hetero_atom_coord( 3, HETERO_ATOM_MAX() );
	FArray3D_float native_Eposition( 3, MAX_POS, MAX_RES() );
	FArray2D_float native_centroid( 3, MAX_RES() );
	FArray3D_float native_centroid_parm_eachres( 5, DRange( -1, 1), MAX_RES(), 0.0f );
	FArray1D_char nat_secstruct( MAX_RES(), ' ' );
	FArray2D_float native_occupancy( MAX_ATOM(), MAX_RES(), 1.0 );

	bool native_exists = { false };

}
