// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10422 $
//  $Date: 2006-09-27 00:14:01 -0400 (Wed, 27 Sep 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_nblist
#define INCLUDED_nblist


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// nblist Function Declarations




void
setup_allatom_list();

// <murphp>
int
count_total_atoms(
  const bool fullatom,
	const FArray1D_bool& ha,
	const FArray1D_bool& ha2,
	const FArray1D_bool& hn,
	const FArray4D_bool& closest_chi
);
// </murphp>

void
append_atom_maps(
	int res_num,
	int res_atm_num,
	int torsion_res_num,
	int torsion_type
);


void
update_nblist();


void
add_to_nblist(
	int & i,
	int & ii,
	int & j,
	int & jj,
	bool const drv
);


void
reset_nblist_ends();


void
reset_nblist();


void
copy_neighbors(
	int const res1,
	int const first_res1,
	int const last_res2,
	int const total_residue
);


void
copy_nblist(
	int const total_atoms,
	FArray2Da_int nb_in,
	FArray1Da_int nb_len_in,
	FArray1Da_int nb_start_in,
	FArray1Da_int nb_end_in,
	FArray2Da_int nb_out,
	FArray1Da_int nb_len_out,
	FArray1Da_int nb_start_out,
	FArray1Da_int nb_end_out
);


void
accept_best_nblist();


void
retrieve_best_nblist();


void
set_use_nblist( bool setting );


void
pose_set_use_nblist( bool setting );


bool
get_use_nblist();


bool
get_use_nblist_during_minimization();


void
write_nblist();


void
update_cst_nblist();


void
update_hblist();


void
add_to_hblist(
	int const donh_atm,
	int const don_res,
	int const act_atm,
	int const act_res
);


void
copy_hblist(
	int & nhbonds_in,
	FArray1Da_int don_atm_in,
	FArray1Da_int don_res_in,
	FArray1Da_int act_atm_in,
	FArray1Da_int act_res_in,
	int & nhbonds_out,
	FArray1Da_int don_atm_out,
	FArray1Da_int don_res_out,
	FArray1Da_int act_atm_out,
	FArray1Da_int act_res_out
);


void
accept_best_hblist();


void
retrieve_best_hblist();


void
reset_hblist();


#endif
