// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8380 $
//  $Date: 2006-05-15 23:52:03 -0400 (Mon, 15 May 2006) $
//  $Author: murphp $

#ifndef INCLUDED_nblist_ns
#define INCLUDED_nblist_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace nblist {


extern int const undefined_global_atm;

//car conversions between all atom lists and residue and atom numbers
//car atoms are numbered starting from residues at the nterminus
//car within each residue, the atom order is
//car centroid: n,(hn),ca,(ha),(cb,centroid/sc),c,o


//car pointers into residue and atom lists
//	FArray1D_int global_atm_num2res_atm_num_map_start( MAX_RES() );

//car neighbor lists

//car neighbor list lengths
//car  for global_atm_num2res_num_map(nb(k,i)) < global_atm_num2res_num_map(i)  (ie nb nterminal to i)
//car    neighbors are listed in ascending order (n to c)
//car  for global_atm_num2res_num_map(nb(k,i)) < global_atm_num2res_num_map(i)  (ie nb cterminal to i)
//car        nb's are listed desending order (c to n)
//car intraresidue neighbors are on the list

//car relevant list portion (ie avoid double counting ie i > j & constant regions
//car for a scoring function, only neighbors nb_start(i) to nb_end(i) must
//car be evaluated

//car


extern int const MAX_NB;

// <murphp>
//car parameters for total number of total atoms
//extern Dimension const MAX_TOTAL_ATOMS; // residues in protein chain
extern Dimension MAX_TOTAL_ATOMS;
// </murphp>


namespace nb_list {
	extern int total_atoms;
	extern FArray1D_int global_atm_num2res_num_map;
	extern FArray1D_int global_atm_num2res_atm_num_map;
	extern FArray2D_int res_atm_num2global_atm_num_map;
	extern FArray2D_int torsion2rigid_body_start_map;
	extern FArray2D_int nb;
	extern FArray1D_int nb_len; // neighbors relevant for LJ/vdw
	extern FArray1D_int drv_nb_len; // neighbors relevant for deriv
	extern FArray1D_int nb_start;
	extern FArray1D_int nb_end;
}
using namespace nb_list;


namespace bestnb_list {
	extern FArray2D_int best_nb;
	extern FArray1D_int best_nb_len; // neighbors relevant for LJ/vdw
	extern FArray1D_int best_nb_start;
	extern FArray1D_int best_nb_end;
}
using namespace bestnb_list;


} // nblist


#endif
