// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// Rosetta Headers
#include "param.h"
#include "param_aa.h"
#include "pH_ns.h"

// ObjexxFLC Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


using namespace param;


namespace pH_ns {

	float pH = 7.4;
	float WpH = 1.00;
	float Wgb = 1.00;
	float Wscale = 1.00;
//KMa phospho_ser -> MAX_AA_PLUS()
	FArray2D_float dGprotonation_table( MAX_AA_PLUS(), MAX_AA_VARIANTS(), 0.0 );
	FArray1D_float aa_pKa( MAX_AA_PLUS(), 0.0 );
	using namespace pH_ns;
}


namespace LookUp_aav_pH {
	int asp_duplicate1 = 0;        // Duplicate of base variant of Aspartic Acid
	int asp_duplicate2 = 0;        // Duplicate of base variant of Aspartic Acid
	int asp_duplicate3 = 0;        // Duplicate of base variant of Aspartic Acid
	int asp_duplicate4 = 0;        // Duplicate of base variant of Aspartic Acid
	int asp_duplicate5 = 0;        // Duplicate of base variant of Aspartic Acid
	//rh Duplicate used to keep an equal number of degrenerate states for protonated and deprotonated variants.
	int asp_OD1protonated = 0;    // Protonated variant for Apsartic Acid (1HD1-->OD1)
	int asp_OD2protonated = 0;    // Protonated variant for Apsartic Acid (1HD2-->OD2)

	int glu_duplicate1 = 0;        // Duplicate of base variant of Glutamic Acid
	int glu_duplicate2 = 0;        // Duplicate of base variant of Glutamic Acid
	int glu_duplicate3 = 0;        // Duplicate of base variant of Glutamic Acid
	int glu_duplicate4 = 0;        // Duplicate of base variant of Glutamic Acid
	int glu_duplicate5 = 0;        // Duplicate of base variant of Glutamic Acid
	int glu_OE1protonated = 0;    // Protonated variant for Glutamic Acid (1HE1-->OE1)
	int glu_OE2protonated = 0;    // Protonated variant for Glutamic Acid (1HE2-->OE2)

	int his_protonated1 = 0;      // Fully protonated variant for Histidine. Both HD1 and HE1.
	int his_protonated2 = 0;      // Duplicate fully protonated variant for Histidine. Both HD1 and HE1.
	//rh Duplicate used to keep an equal number of degrenerate states for protonated and deprotonated variants.

	int tyr_HHdeprotonated = 0;   // Deprotonated variant for Tyrosine (HH // OH)
	int lys_3HZdeprotonated = 0;  // Deprotonated variant for Lysine ( 3HZ // NZ)
	int arg_1HH2deprotonated = 0; // Deprotonated variant for Arginine ( 1HH2 // NH2)

	using namespace LookUp_aav_pH;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_aa_pKa()
///
/// @brief Loads array containing aa IpKa
///
/// @detailed
///
/// @return
///
/// @global_read
/// aa_pKa
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Ryan Harrison 05/31/05
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_aa_pKa()
{
	using namespace pH_ns;
	using namespace param_aa;

	aa_pKa( aa_asp ) = 4.00;  // Asp - D
	aa_pKa( aa_glu ) = 4.40;  // Glu - E
	aa_pKa( aa_his ) = 6.30;  // His - H
	aa_pKa( aa_lys ) = 10.40; // Lys - K
	aa_pKa( aa_arg ) = 12.50; // Arg - R
	aa_pKa( aa_tyr ) = 9.60;  // Tyr - Y
}
