// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_pKa_mode
#define INCLUDED_pKa_mode

//ObjexxFLC Headers
#include <ObjexxFCL/ObjexxFCL.hh>

#include <utility/vector1.hh>



// forward declaration
class RotamerSet;

////////////////////////////////////////////////////////////////////////////////80
// pKa mode: (Ryan Harrison, JHU) rharrison@jhu.edu
// This mode is used for pKa simulations in Rosetta.
// pKa mode uses the pH packing flag to include alternate protonation state
// amino acid variant rotamers with modified hydrogen, hydrogen bonding,
// electrostatics and solvation paranaters. pKa mode then uses the packer to
// sample and minimize over both rotamer sets. pKa mode then hyjacks the Simulated
// Annealing procedure to output an ensemble (instead of just the Monte Carlo minima
// this step usually outputs) of both the rotamer frequencies and rotamer variants.
// This ensemble is then output to the pKa file.
//
// Usage:
//     -pH_titrate <start_pH> <end_pH> <step_pH>
//					               Titrates a pdb from <start_pH> to <end_pH> at
//					               intervals of <step_pH>
//     -full_repack		       Repacks the entire protein with pH flag set to true
//     -neighbor_repack <file>		 Repacks only the neighbors of the residues
//					                       given in the file (based on repack file input)
//     -site_repack <file>	 Repacks only the residues given in the file
//     -full_rt				       Rotamer Trials on the entire protein
//     -neighbor_rt <file>	 Rotamer Trials only the neighbors of the residues
//					                 given in the file (based on constraints file input)
//     -site_rt <file>			 Rotamer Trials only the residues given in the file
//     -use_monte_carlo			 Use an outer loop of monte carlo and repack 3 times
//     -output_ensemble_stats <file>	 Output an ensemble file containing
//					                           rotamer frequencies
//
// Notes:
// * See pH overview in pH_main.h *
// pKa mode using standard misc and get_energies(), not the pose or trie
//
////////////////////////////////////////////////////////////////////////////////

namespace pKa_mode {

	// Mode Control Options
	extern bool pKa_flag;
	namespace pH_titration {
		extern bool pH_titration_flag;
		extern float start_pH;
		extern float end_pH;
		extern float delta_pH;
		extern FArray1D_float titration_array;
		using namespace pH_titration;
	}

	namespace pKa_control_flags {
		// General Options
		extern bool use_monte_carlo_flag;

		// Repack Options
		extern bool read_repack_flag;
		extern bool full_repack_flag;
		extern bool neighbor_repack_flag;
		extern bool site_repack_flag;
		extern bool optH_repack_flag;

		// Rotamer Trials Options
		extern bool full_rt_flag;
		extern bool neighbor_rt_flag;
		extern bool site_rt_flag;

		// File Output Options
		extern bool output_ensemble_stats_flag;
		extern bool condensed;

		// Global Options
		extern std::string repack_file; // In - Repack Filename
		extern std::string ensemble_file; // Out - Ensemble file. Used only if ensemble_stats_flag is true
		extern std::string ensemble_outfile; // Out - Ensemble output file name. Used only if_ensemble_stats_flag is true

		extern FArray1D_int repack_site_index; // In - Repack File Indexes of sites to repack.
		extern int nrepack_sites; // In - Repack File. Number of sites to repack.
		                          //extern std::string const & mode;
		extern int current_repack_number;

		using namespace pKa_control_flags;
	}

	namespace pKa_packer_flags {
		// Packer Options
		extern std::string packer_mode;
		extern bool calc_rot_freq; // Used in Sim Annealing
		extern bool track_pack;
		extern int pKa_outputnum;
		extern bool packer_set_temp;
		extern float packer_temp;
		extern FArray1D_float store_rot_delta_energy;
		extern FArray1D_float store_rotstep_E;
		extern FArray1D_float theo_sum_rot_poll;
		using namespace pKa_packer_flags;
	}

	void get_commandline_options();
	void set_options();
	void setup_titration_list();
	void initialize_pKa_start(int const curr_outnum);
	void read_repack_file();
	void setup_allow_repack();
	void setup_allow_full_repack();
	void setup_allow_neighbor_repack();
	void setup_allow_site_repack();
	void setup_allow_full_rt();
	void setup_allow_neighbor_rt();
	void setup_allow_site_rt();
	void main_protocol();
	void output_ensemble_stats( FArray1DB_float & rot_freq, RotamerSet const & rotamer_set );
	void output_pdb_name( std::string & filename, int const curr_outnum );


	// Get Flags
	inline bool get_pKa_flag() { return pKa_flag; }
	inline bool get_read_repack_flag() { return pKa_control_flags::read_repack_flag; }
	inline bool get_full_repack_flag() { return pKa_control_flags::full_repack_flag; }
	inline bool get_neighbor_repack_flag() { return pKa_control_flags::neighbor_repack_flag; }
	inline bool get_site_repack_flag() { return pKa_control_flags::site_repack_flag; }
	inline bool get_optH_repack_flag() { return pKa_control_flags::site_repack_flag; }
	inline bool get_full_rt_flag() { return pKa_control_flags::full_rt_flag; }
	inline bool get_neighbor_rt_flag() { return pKa_control_flags::neighbor_rt_flag; }
	inline bool get_site_rt_flag() { return pKa_control_flags::site_rt_flag; }
	inline bool get_output_ensemble_stats_flag() { return pKa_control_flags::output_ensemble_stats_flag; }

	// Set Flags
	inline void set_pKa_flag( bool true_false ) { pKa_flag = true_false; }
	inline void set_read_repack_flag( bool true_false ) { pKa_control_flags::read_repack_flag = true_false; }
	inline void set_full_repack_flag( bool true_false ) { pKa_control_flags::full_repack_flag = true_false; }
	inline void set_neighbor_repack_flag( bool true_false ) { pKa_control_flags::neighbor_repack_flag = true_false; }
	inline void set_site_repack_flag( bool true_false ) { pKa_control_flags::site_repack_flag = true_false; }
	inline void set_optH_repack_flag( bool true_false ) { pKa_control_flags::site_repack_flag = true_false; }
	inline void set_full_rt_flag( bool true_false ) { pKa_control_flags::full_rt_flag = true_false; }
	inline void set_neighbor_rt_flag( bool true_false ) { pKa_control_flags::neighbor_rt_flag = true_false; }
	inline void set_site_rt_flag( bool true_false ) { pKa_control_flags::site_rt_flag = true_false; }


}


#endif
