// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20570 $
//  $Date: 2008-02-22 22:05:24 -0500 (Fri, 22 Feb 2008) $
//  $Author: johnk $

//apl - Ion, please remove the following code at some point
#ifndef NDEBUG // Debug version
#define ASSERT_ONLY(x) x
#else
#define ASSERT_ONLY(x)
#endif

// Rosetta Headers
#include "pack.h"
#include "aaproperties_pack.h"
#include "add_pser.h"
#include "analyze_interface_ddg.h"
#include "analyze_interface_ddg_ns.h"
#include "angles.h"
#include "are_they_neighbors.h"
#include "current_packer_cst.h"
#include "constraints.h"
#include "CorrelatedSimAnnealer.h"
#include "count_pair.h"
#include "current_pose.h"
#include "DebuggingAnnealer.h"
#include "decoystats.h"
#include "design.h"
#include "design_structure.h"
#include "disulfides.h"
#include "dna.h"
#include "InteractionGraphBase.h"
#include "InteractionGraphSupport.h"
#include "etable_manager.h"
#include "enzyme.h"
#include "fast_pairenergy.h"
#include "favor_residue_ns.h"
#include "files_paths.h"
#include "FixbbSimAnnealer.h"
#include "force_barcode.h"
#include "fullatom.h"
#include "fullatom_energies.h"
#include "fullatom_energy.h"
#include "fullatom_sasa.h"
#include "fullatom_setup.h"
#include "gb_elec.h"
#include "gb_elec_ns.h"
#include "geometric_solvation.h"
#include "gl_graphics.h"
#include "hbonds.h"
#include "hbonds_ns.h"
#include "input_pdb.h"
#include "interface.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "LazyInteractionGraph.h"
#include "ligand.h"
#include "ligand_ns.h"
#include "LinearMemoryInteractionGraph.h"
#include "make_pdb.h"
#include "maps.h"
#include "maps_ns.h"
#include "MinimalistInteractionGraph.h"
#include "minimize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "MultiCoolAnnealer.h"
#include "multistate_design.h"
#include "namespace_rotamers_setting.h"
#include "nblist.h"
#include "NegativeDesign.h"
#include "OneGeneTwoProteins.h"
#include "OnTheFlyInteractionGraph.h"
#include "output_decoy.h"
#include "pack_bump_selector.h"
#include "pack_geom_inline.h"
#include "PackerTask.h"
#include "ParallelSimAnneal.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "param_rotamer_trie.h"
#include "param_torsion.h"
#include "PDInteractionGraph.h"
#include "pdb.h"
#include "pdbstatistics_pack.h"
#include "pH_main.h"
#include "pH_ns.h"
#include "pKa_mode.h"
#include "planes.h"
#include "pose.h"
#include "pose_io.h"
#include "prof.h"
#include "random_numbers.h"
#include "read_aaproperties.h"
#include "recover.h"
#include "relax_structure.h"
#include "RotamerOptions.h"
#include "RotamerSet.h"
#include "rotamer_explosion.h"
#include "rotamer_functions.h"
#include "rotamer_trial_energies.h"
#include "rotamer_trials.h"
#include "rotamer_trie_calc_energies.h"
#include "runlevel.h"
#include "SASAInteractionGraph.h"
#include "scale_res_energy.h"
#include "score.h"
#include "score_ns.h"
#include "SimAnnealerBase.h"
#include "start.h"
#include "symmetric_design.h"
#include "template_pack.h"
#include "termini.h"
#include "util_basic.h"
#include "util_interpolate.h"
#include "void.h"
#include "water.h"
#include "water_ns.h"
#include "DesignMap.h"
#include "ConformerLibHandler.h"
//KMa phospho_ser
#include "add_pser.h"

// ObjexxFCL Headers
#include <ObjexxFCL/byte.hh>
#include <ObjexxFCL/ChunkVector.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4Da.hh>
#include <ObjexxFCL/FArray5D.hh>
#include <ObjexxFCL/FArray.io.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/constants.hh>
#include <numeric/conversions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <algorithm>
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <ctime>
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>


using namespace pack; //apl, new namespace that packer will eventually occupy



////////////////////////////////////////////////////////////////////////////////
/// @begin select_rotamer_set
///
/// @brief
/// Sets whether the default or a large rotamer set is used for repacking.
///
/// @detailed
///
/// This function selects the rotamer set that will be used for repacking.
/// The choices are 'large' and 'default'.  The selection is stored in
/// a namespace (rotamers_setting) that is shared only with
/// the companion function get_rotamer_set(). The effects of the rotamer
/// set have to do with limits on the number of rotamers used in the
/// representation of a given amino acid. These limits are:
/// perc_limit_surface, perc_limit_buried, rot_limit_surface, and
/// rot_limit_buried.
///
/// @param[in]   setting - in
/// The parameter 'setting' is an input string that had better be
/// either 'large' or 'default'.
///
/// @global_read
///
/// The runlevel variable is accessed for conditional
/// diagnostic purposes.  The variables perc_limit_surface_(large/default),
/// etc., are used to set the working rotamer limit variables.  All of these
/// limits are declared in param_pack.h
///
/// @global_write
///
/// This function sets the variables perc_limit_surface, perc_limit_buried,
/// rot_limit_surface, and rot_limit_buried.  These are declared in
/// param_pack.h
///
///
/// This is a pretty simple interface to the rotamer limits
///
/// @references
///
/// @authors
///   jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
select_rotamer_set( std::string const & setting )
{
	using namespace param_pack;
	using namespace rotamers_setting;
	using namespace runlevel_ns;

	if ( setting == "large" ) {
		perc_limit_surface   = perc_limit_surface_large;
		perc_limit_buried   = perc_limit_buried_large;
		rot_limit_surface   = rot_limit_surface_large;
		rot_limit_buried     = rot_limit_buried_large;
		rotamer_set = "large";
	} else {
		if ( setting != "default" ) {
			std::cout << "unrecognized rotamer set: " << setting << std::endl;
			std::cout << "using default set" << std::endl;
		}
		perc_limit_surface   = perc_limit_surface_default;
		perc_limit_buried   = perc_limit_buried_default;
		rot_limit_surface   = rot_limit_surface_default;
		rot_limit_buried     = rot_limit_buried_default;
		rotamer_set = "default";
	}

	if ( runlevel >= yap ) std::cout << A( 10, setting ) <<
	 " rotamer set selected: " << F( 4, 2, perc_limit_surface ) << ' ' <<
	 F( 4, 2, perc_limit_buried ) << ' ' << I( 2, rot_limit_surface ) << ' ' <<
	 I( 2, rot_limit_buried ) << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_rotamer_set
///
/// @brief
///
/// Reports the rotamer set previously selected by select_rotamer_set()
///
/// @detailed
///
/// See the full description of select_rotamer_set() above.
///
/// @param[out]  setting - out
/// The only parameter is an output.  It returns a string that gives
/// the currently selected rotamer set.
///
/// @global_read
///
/// The rotamer setting is stored in a namespace shared only with
/// companion function select_rotamer_set()
///
/// @global_write
///
/// No global variables are altered.
///
/// @remarks
///
/// @references
///
/// @authors
///
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_rotamer_set( std::string & setting )
{
	using namespace rotamers_setting;

	setting = rotamer_set;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin pack_rotamers
///
/// @brief
/// Wrapper for packer functions.
/// 1) rotamer building and energy precomputation
/// 2) simulated annealing
///
/// res, xyz, res_variant, etc. arrays to eventually be replaced with pose_ns::Pose
///
/// ashworth, help from jk
///
////////////////////////////////////////////////////////////////////////////////
void
pack_rotamers(
	pose_ns::Pose & pose,
	PackerTask const & Task
)
{
	using namespace param;

	initialize_fullatom();
	FArray1D_float ligenergy1b_old;
	FArray1D_int current_rot_index( pose.total_residue() );

	//yl set the template_pack phi&psi from the input pose
	for ( int i = 1; i <= pose.total_residue(); ++i ) {
		template_pack::phi(i) = pose.phi(i);
		template_pack::psi(i) = pose.psi(i);
	}

	RotamerSet rotamer_set;

	// ig passing method copied from johnk
	InteractionGraphBase * ig = NULL;
	// build rotamers, compile energies

	// jk turn on soft rep and change weights, if desired
	enable_packing_etables(pose.total_residue(),pose.res(),pose.res_variant(),pose.full_coord());

	pack_rotamers_setup( Task, rotamer_set, ig, pose, current_rot_index, ligenergy1b_old );

	FArray1D_float before;
	FArray1D_float after;

	// simulated annealing
	pack_rotamers_run( Task, rotamer_set, ig, pose, current_rot_index, ligenergy1b_old );

	// jk disable soft rep
	disable_packing_etables(pose.total_residue(), pose.res(), pose.res_variant(), pose.full_coord());

	delete ig;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin pack_rotamers_setup
///
/// @brief
/// Builds rotamers, gets energies
///
////////////////////////////////////////////////////////////////////////////////
void
pack_rotamers_setup(
	PackerTask const & Task,
	RotamerSet & rotamer_set,
	InteractionGraphBase * & ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old
)
{
	using namespace aaproperties_pack;
	using namespace design;
	using namespace design_sym;
	using namespace param;
	using namespace param_aa;
	using namespace template_pack;
	using namespace water;

	int aa, seqpos, aav, total_residue( pose.total_residue() );
	int run = 1;
	//ctsa neighbor_indexno:ordered residue nbr num for nbrs higher than self
	//ctsa current_rot_index :rotno of the current/native rotamer at each residue
	FArray2D_short neighbor_indexno( MAX_RES(), MAX_RES() );


//lin set the water flags
	set_water_rotamer_for_packer( Task.get_mode() );

	// jk get phi,psi and chi angles
	ang_from_pdb_wsc( total_residue, pose.res(), pose.res_variant(),
	 pose.full_coord(), template_pack::phi,template_pack::psi, chiarray,
	 rotarray );

	//bk determie the coordinates for the action center of each sidechain
	for ( seqpos = 1; seqpos <= total_residue; ++seqpos ) {
		aa = pose.res(seqpos);
		if ( is_protein(aa) || is_nonnatural(aa) ) {
			put_wcentroid(pose.full_coord()(1,1,seqpos),actcoord(1,seqpos),aa);
		}
	}

	//bk determine how many neighbors each residue has and make neighbor list
	make_neighbor_info( pose.res(), total_residue, pose.full_coord(), neighborlist, neighbors );

	//ctsa record the order of all neighbor residues of higher number than self
	make_neighbor_indexno( neighbor_indexno, Task.get_designmap(),pose);

	//lin determine how many neighbors each hetero water has
	if ( use_hetero_h2o ) {
		count_native_water_neighbors( pose.res(), total_residue, pose.full_coord(),
		 N_h2oatom, h2o_position, hetero_water_neighbors );
	}

	float junk1, junk2, junk3, junk4; // hbond energy total dummies
	fill_hbond_arrays( false, pose.res(), pose.res_variant(), pose.full_coord(),
	 total_residue, neighborlist, neighbors, hbonds::hbderiv_NONE, junk1, junk2,
	 junk3, junk4 );

//kwk discard ligand rotamers that clash with the backbone
	if( get_ligand_flexible_flag() && ! get_enable_ligaa_flag() ){
		std::multimap< float, ligand::LigandInternalCoord > conformations;
		for( std::vector<Ligand *>::iterator cur_ligand=
			ligand::ligand_ptr_vector.begin(); cur_ligand!=
			ligand::ligand_ptr_vector.end(); cur_ligand++){

			conformations.clear();
			float lig_bb_vdw=1000.0;
			//kwk evaluate and store ligand backbone van der Waals scores
			//kwk for each ligand rotamer
			if( (*cur_ligand)->ligand_conformations.size() == 0 ){
				(*cur_ligand)->ligand_conformations.push_back(
					get_ligand_internal_conformation(**cur_ligand));
			}
			for( size_t lig_rot=0;
				lig_rot<(*cur_ligand)->ligand_conformations.size();
				lig_rot++){

				(*cur_ligand)->change_to_ligand_conformation(lig_rot);
				ligand_bb_vdw( lig_bb_vdw, (**cur_ligand));
				conformations.insert(std::pair<float, ligand::LigandInternalCoord>(lig_bb_vdw,
					get_ligand_internal_conformation(**cur_ligand)));
			}
			//kwk if the best conformation in greater than 10 store just
			//kwk the best ligand rotamer
			//kwk else store all ligand rotamers up to 10
			(*cur_ligand)->ligand_conformations.clear();
//			std::cout << "lowest bb clash " << (*conformations.begin()).first << std::endl;
			if( (*conformations.begin()).first > 10){
				(*cur_ligand)->ligand_conformations.push_back(
					(*conformations.begin()).second
				);
			}else{
				std::multimap< float, ligand::LigandInternalCoord >::const_iterator
					last_conf=conformations.upper_bound(10);
//				std::cout << "kwk got here add multiple conformations" << std::endl;
				for(std::multimap< float, ligand::LigandInternalCoord >::iterator
					c_conf=conformations.begin(); c_conf!=last_conf; c_conf++){
						(*cur_ligand)->ligand_conformations.push_back((*c_conf).second);
//	  				std::cout << "push back conf" << std::endl;
				}
			}
		}
	}

//	std::cout << "Getting rotamers..." << std::endl;
	rotamer_set.get_rotamers( total_residue, pose.res(), pose.res_variant(),
	 pose.full_coord(), current_rot_index, Task );

	if(!active_rotamer_options.rot_opt && active_rotamer_options.minimize_best_rotamers && (Task.get_mode() == "design") ){

		rotamer_set.rotamer_optimize(pose,Task.get_designmap());

	}

	if ( Task.get_mode() == "design" ) {
		std::cout << "designing with this many rotamers " <<
		 SS( rotamer_set.nrotamers() ) << std::endl;
	}

	if ( ( active_rotamer_options.rot_opt )
	   && ( Task.get_mode() == "design" || Task.get_mode() == "packrot" )
	   && ( Task.get_mode() != "optimizeH" ) ) {
		std::cout << "optimizing rotamers" << std::endl;
		rotamer_set.rotamer_optimize(pose,Task.get_designmap());
	}

//jjh if the rotamerize option is selected, we don't need to calculate
//jjh energies.  But even when rotamerize is true, there are cases where
//jjh you don't want to rotamerize, such as the "packrot" call in clean_pdb
//jjh to fill missing sidechains

	if( Task.rotamerizing() ) {
		FArray1D_int bestrotindex( MAX_RES() );

		rotamer_set.select_closest_rotamer(pose,bestrotindex);

		// mb for debugging
		int repack_allowed (0);
		for ( int i = 1; i <= total_residue; ++i ) {
			if ( runlevel_ns::runlevel == runlevel_ns::chat ) {
				std::cout << "allow_repack(" << i << ") is " <<
				 Task.get_designmap().repack_residue(i) << std::endl;
			}
			if ( Task.get_designmap().repack_residue(i) ) {
				++repack_allowed;
				aa = rotamer_set.report_aa(bestrotindex(i) );
				pose.set_res(i,aa);
				aav = rotamer_set.report_aav( bestrotindex(i) );
				pose.set_res_variant(i,aav);
				//pose.set_rotcoord(i,rotamer_set,bestrotindex(i));
				pose.copy_sidechain(i,aa,aav,rotamer_set.get_rotcoord(bestrotindex(i)));
			}
		}
		if ( runlevel_ns::runlevel == runlevel_ns::chat ) {
			std::cout << "You are allowing repacking of this many positions: " <<
			 repack_allowed << std::endl;
		}

		if ( Task.get_make_output_file() ) {
			pose.pose_to_design_output(run);
		}
		return;
	}

//bs if designing disulfides, determine where the cys are.
//bs this sets some global vars used in disulfide scoring functions.
	if ( Task.get_mode() == "design" ) disulfides::BOUNDARY::identify_cys();

  // jk setup transforms to produce symmetric rotamers
	if ( num_clones > 0 ) {
		for ( int i = 1; i <= total_residue; ++i ) {
			if (clone_follows(i) != 0) {
				get_sym_rotamer_transform( pose.full_coord()(1,1,clone_follows(i)),
				 pose.full_coord()(1,1,i), clone_Mgl(1,1,i) );
			}
		}
	}

//bk get energies: rotamer-rotamer, rotamer-backbone, rotamer self-energy
//bk uses the namespaces template_pack,rotamers,pdbstatistics


	delete ig; ig = 0; // important according to jk: now replace with new pointer

	ig = get_interaction_graph( rotamer_set, Task, neighbor_indexno );

	precompute_rotamer_energies( ig, rotamer_set, Task, neighbor_indexno,
	 ligenergy1b_old,pose);


	if ( output_interaction_graph_memory_usage )
	{
		ig->prepare_for_simulated_annealing();
		unsigned int num_rotamer_pair_energies = ig->get_edge_memory_usage();
		unsigned int total_memory = ig->getTotalMemoryUsage();
		std::cerr << "Number of stored rotamer pair energies " <<
		 num_rotamer_pair_energies << " (" <<
		 num_rotamer_pair_energies * sizeof( float ) << " bytes)" <<  std::endl;
		std::cerr << "Total spent on entire interaction graph " << total_memory  <<
		 " (" << total_memory - num_rotamer_pair_energies * sizeof ( float ) <<
		 " not spent on rpes)" << std::endl;
	}

	//ja output rotamers and their energies to a pdb file
	if ( active_rotamer_options.dump_rotamers_pdb_flag ) {
		std::ofstream rotsfile;
		rotsfile.open( "rotamers.pdb" );
		int seqpos(0);
		for ( int i(1); i <= total_residue; ++i ) {
			if ( pdb::pdb_res_num(i) ==
				   active_rotamer_options.dump_rotamers_pdb_res ) seqpos = i;
		}
		if ( seqpos != 0 ) {
			dump_rotamers_pdb( Task, rotamer_set, ig, seqpos, rotsfile, pose.res(seqpos) );
		}
		rotsfile.close();
	}
}

////////////////////////////////////////////////////////////////////////////////
void
save_sa_energies( SimAnnealerBase const *sa ){

	scores::delG        = sa->get_delG();
	scores::energy_pack = sa->get_bestenergy();
}

////////////////////////////////////////////////////////////////////////////////
///	@begin pack_rotamers_run
///
/// simulated annealing, structure building+outputting
///
////////////////////////////////////////////////////////////////////////////////
void
pack_rotamers_run(
	PackerTask const & Task,
	RotamerSet const & rotamer_set,
	InteractionGraphBase * ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old,
	std::vector<int> rot_to_pack //ja defaults to empty vector if not given
)
{
	//ja copied from above not all of these may be necessary
	using namespace aaproperties_pack;
	using namespace design;
	using namespace design_sym;
	using namespace param;
	using namespace param_aa;
	using namespace template_pack;
	using namespace water;

	bool start_with_current;
	int aa,aav;
	float bestenergy;
	FArray1D_int bestrotindex( MAX_RES() );
	FArray1D_float ligenergy1b_new( rotamer_set.nrotamers() );
	int number_of_rotamers=rotamer_set.nrotamers();
	if( get_ligand_flexible_flag() ){
		for( std::vector< Ligand * >::iterator ligand_begin=
				ligand::ligand_ptr_vector.begin(); ligand_begin!=
				ligand::ligand_ptr_vector.end(); ligand_begin++){

			number_of_rotamers+=(*ligand_begin)->ligand_conformations.size();
		}
	}
	FArray1D_float rot_freq( number_of_rotamers );

	//jjh For rotamerizing tasks, output is done at the end of
	//jjh pack_rotamers_setup(), and we jump out here.
	if( Task.rotamerizing() ) {
		return;
	}

	//bk if calc_rot_freq is set to true than simulated annealing
	//bk will keep track of how often each rotamer is populated during
	//bk the pack simulation
	bool calc_rot_freq = false;
	if ( mcmin_trials )	calc_rot_freq = true;

	if ( pKa_mode::get_pKa_flag() && pKa_mode::get_output_ensemble_stats_flag() ) {
		calc_rot_freq = pKa_mode::pKa_packer_flags::calc_rot_freq;
	}
	pKa_mode::pKa_packer_flags::packer_mode = Task.get_mode();

	if ( Task.get_include_current() && Task.get_mode() != "design" ) {
		start_with_current = true;
	} else start_with_current = false;

	if ( desock ) {
    start_with_current = true;
  }

	//mj local variables for energy filter
	int count( 0 );
	float ligand_reduced_score( ligand_filter_score );
	float ligand_best_score( 100 );

	//apl sasaIG + fixed-ligand: OK
	//apl sasaIG + moving ligand: not supported
	//apl temp 9/04/06 disabling fixed-ligand support
	//if ( ligand::ligand_one != 0 && ligand::ligand_one->ligand_flag
	//	&& dynamic_cast< SASAInteractionGraph* > (ig) != 0)
	//{
	//	(dynamic_cast< SASAInteractionGraph* > (ig))->
	//		initialize_overlap_with_ligand( * ligand::ligand_one );
	//}

	// mechanism for choosing the best solution for packing
	// if nloop >1
	bool const pick_best_solution
		( Task.get_mode() == "packrot" && Task.get_nloop() > 1 &&
			!Task.get_make_output_file());

	float best_bestenergy(999.9/*this value is unused*/);

	for ( int run = 1; run <= Task.get_nloop(); ++run ) {
		if ( Task.get_mode() == "design" && design_dock_pert ) {
			//lin perturb the partner 2 of protein complex
			//lin currently it effects the design_inter, onlypack and fixbb
			apply_dock_perturbation(pose.total_residue(),pose.Eposition()); //apply translation and rotation

			if( get_ligand_flexible_flag() ){
				//compute all ligand energies
				compute_ligand_energies(
					dynamic_cast< PrecomputedPairEnergiesInteractionGraph * > ( ig ),
					Task.get_designmap(), rotamer_set, pose.total_residue(), pose.res(), pose.res_variant(), pose.full_coord());
			}else{
				//lin calculate energy subset
				get_ligenergies( ligenergy1b_new, rotamer_set );
				//lin update the energy 1b
				ig->update_one_body_energies(ligenergy1b_old,ligenergy1b_new);
			}
		}

		if ( pKa_mode::get_pKa_flag() ) {
			calc_rot_freq = pKa_mode::pKa_packer_flags::calc_rot_freq;
		}

//xa specialized sim_annealing function which can be used to make parallel
//xa amino acid substitutions at desired sequence positions
//xa e.g. designing homo-oligomers or switch sequences
		SimAnnealerBase * sa;
		if ( design::debug_annealer_design && Task.get_mode()  == "design" )
		{
			std::cout << "Instantiating DebuggingAnnealer" << std::endl;
			sa = new DebuggingAnnealer( bestrotindex, bestenergy, start_with_current,
					ig, &rotamer_set, current_rot_index, calc_rot_freq, rot_freq );
		}
		else if(  pack_in_parallel && chain_in_preferred_state != "none" && Task.get_make_output_file() )
		{
			sa = new NegativeDesign( &rotamer_set, neighborlist, bestrotindex, bestenergy,
				start_with_current, ig, current_rot_index, calc_rot_freq, rot_freq );
		}
		else if( reverse_comp && Task.get_make_output_file() )
		{
			sa = new OneGeneTwoProteins( &rotamer_set, neighborlist, bestrotindex, bestenergy,
				start_with_current, ig, current_rot_index, calc_rot_freq, rot_freq );
		}
		else if( pack_in_parallel && Task.get_make_output_file() )
		{
			sa = new ParallelSimAnneal( &rotamer_set, neighborlist, bestrotindex, bestenergy,
				start_with_current, ig, current_rot_index, calc_rot_freq, rot_freq );
		}
		else if ( use_multi_cool_annealer )
		{
			sa = new MultiCoolAnnealer( bestrotindex, bestenergy, start_with_current,
				ig, &rotamer_set, current_rot_index, calc_rot_freq, rot_freq );
		}
		else if ( use_CorrelatedSimAnnealer && Task.get_mode() == "design" ) {

			// define basepairing rotamer correlates
			std::vector< std::vector<int> > rotamer_correlations(
				basepair_rotamers( rotamer_set )
			);
			// Enforce basepairing by trying correlated substitutions in pairs.
			if ( rot_to_pack.size() == 0 ) {
				sa = new CorrelatedSimAnnealer( rotamer_correlations, bestrotindex,
				 bestenergy, start_with_current, ig, &rotamer_set, current_rot_index,
				 calc_rot_freq, rot_freq );

			} else { // ja allow rotamer sublist
				sa = new CorrelatedSimAnnealer( rot_to_pack, rotamer_correlations,
				 bestrotindex, bestenergy, start_with_current, ig, &rotamer_set,
				 current_rot_index, calc_rot_freq, rot_freq );
			}
		}
		else
		{
			if ( rot_to_pack.size() == 0 )
			{ // default: uses full rotamer_set
				sa = new FixbbSimAnnealer( bestrotindex, bestenergy, start_with_current,
					ig, &rotamer_set, current_rot_index, calc_rot_freq, rot_freq );
			}
			else
			{ // ja allow for rotamer sublist ( passed into pack_rotamers_run() )
				sa = new FixbbSimAnnealer( rot_to_pack, bestrotindex, bestenergy,
					start_with_current, ig, &rotamer_set, current_rot_index, calc_rot_freq, rot_freq );
			}
		}

//		std::cout << "Packer: simulated annealing..." << std::endl;
		//Strategy pattern
		PROF_START( prof::PACKER_SIMANNEALING );
		GRAPHICS_LOG( "packer: simannealing" );
		sa->scale_outeriterations( param_pack::scale_outer_iterations_value );
		sa->scale_inneriterations( param_pack::scale_inner_iterations_value);
		sa->save_trajectory( output_design_movie );

		sa->run();
		PROF_STOP( prof::PACKER_SIMANNEALING );

		//Save calculated best energy and "free energy", estimated during sim annealing.
		save_sa_energies( sa );

		// Write output PDBs which comprise the movie
		if ( ( output_design_movie ) &&
			( Task.get_mode() != "packrot" ) && ( Task.get_mode() != "optimizeH" ) ) {

			std::cout << "Writing PDBs for movie" << std::endl;
			int const num_frames = sa->get_num_frames();
			int frame_freq = 1;
			if ( ( num_movie_frames != -1 ) && ( num_movie_frames < num_frames ) ) {
				frame_freq = num_frames / num_movie_frames;
			}
			std::cout << num_frames << " total frames, will write one of every " << frame_freq << std::endl;

			for ( int fnum = 0; fnum < num_frames; ++fnum ) {
				std::string movie_pdbname = "pack_movie_frame_" + lead_zero_string_of(fnum,8) + ".pdb";
				int movie_rot_index = sa->get_frame( fnum );

				if ( movie_rot_index != -1 ) {
					int rot_seqpos = rotamer_set.report_seqpos(movie_rot_index);
					int const aa = rotamer_set.report_aa(movie_rot_index);
					int const aav = rotamer_set.report_aav(movie_rot_index);
					pose.copy_sidechain( rot_seqpos, aa, aav,
						rotamer_set.get_rotcoord( movie_rot_index ) );

					for (int c=1; c<=num_clones; ++c) {
						int const clone_res=clone_list(rot_seqpos, c);
						FArray2D_float clone_coord( 3, MAX_ATOM() );
						FArray1D_float clone_actcoord( 3 );
						transfer_sym_rotamer( aa, aav, clone_Mgl(1,1,clone_res),
							rotamer_set.get_rotcoord(movie_rot_index),
							rotamer_set.get_rotactcoord(movie_rot_index), clone_coord,
							clone_actcoord);
						pose.copy_sidechain( clone_res, aa, aav, clone_coord );
					}
				}

				if ( ( fnum % frame_freq ) == 0 ) {
					pose.dump_pdb( movie_pdbname );
				}

			}

			// Make sure that the final frame is written
			std::string movie_pdbname = "pack_movie_frame_" + lead_zero_string_of(num_frames,8) + ".pdb";
			pose.dump_pdb( movie_pdbname );

		} // if output_movie

		delete sa;

		//ig->print_vertices();

		// mechanism for choosing the best solution for packing
		// if nloop >1
		if ( pick_best_solution) {
			std::cout << "packrunE: " << run << ' ' << bestenergy << std::endl;
			if ( run > 1 && bestenergy > best_bestenergy ) continue;
			best_bestenergy = bestenergy;
		}

		//bk fill in final structure
		for ( int i = 1; i <= pose.total_residue(); ++i ) {
			if ( clone_follows(i) == 0 ) { // jk this is not a clone position
				//apl temp 9/04/06 disable output_dot_kinemage
				//if ( pack::output_dot_kinemage)
				//{
			//	writeDotsForRotamerAssignment( ig, design_map, rotamer_set, bestrotindex, run );
			//}

				if ( Task.get_designmap().repack_residue(i) ) {
					aa = rotamer_set.report_aa(bestrotindex(i));
					aav = rotamer_set.report_aav(bestrotindex(i));
					pose.copy_sidechain( i, aa, aav,
															 rotamer_set.get_rotcoord( bestrotindex(i) ) );
				}
			} else {
				// jk this is a clone position
				if ( Task.get_designmap().repack_residue(i) ) {
					// jk Put back clone positions so that
					// they match the positions they follow
					int fres=clone_follows(i);
					aa = rotamer_set.report_aa(bestrotindex(fres));
					aav = rotamer_set.report_aav(bestrotindex(fres));
					FArray2D_float clone_coord( 3, MAX_ATOM() );
					FArray1D_float clone_actcoord( 3 );

					transfer_sym_rotamer( aa, aav, clone_Mgl(1,1,i),
																rotamer_set.get_rotcoord(bestrotindex(fres)),
																rotamer_set.get_rotactcoord(bestrotindex(fres)), clone_coord,
																clone_actcoord);

					if ( !pack_check_current_pose() ) {
						pose.set_res(i,aa);
						pose.set_res_variant(i,aav);
						for ( int j = 5; j <= natoms(aa,aav); ++j ) {
							for ( int k = 1; k <= 3; ++k ){
								pose.set_coords_pos(i,j,k, clone_coord(k,j));
							}
						}
					} else {
						pose.copy_sidechain( i, aa, aav, clone_coord );
					}
				}
			}
		} // end fill in final structure

		if ( mcmin_trials && Task.get_make_output_file() ) {
			design_mcmin_trials( pose,rotamer_set, neighborlist, rot_freq, start_with_current );
		}

		if ( design_trials && Task.get_make_output_file() ) {
			std::cout << "Calling rotamer trials for design" << std::endl;
			design_rotamer_trials( Task.get_designmap(), pose);
		}
		if ( Task.get_make_output_file() ) {
			if ( !ligand_filter ) { // default
				pose.pose_to_design_output(run);
				if ( Task.get_mode() == "design" ) {
					update_design_profile( pose.res(), pose.total_residue(), run );
				}
			} else if ( ligand_filter) { // ligand_filter mode
				//mj set new filter energy
				//design_score( pose.total_residue(), pose.res(), pose.res_variant(),
				//							pose.full_coord_simple_return_packer(), run );
				design_score(pose,run);
				ligand_best_score =
					std::min( ligand_best_score, ligand::ligand_one->lig_sumE );
				if ( count++ >= ligand_filter_count ) {
					ligand_reduced_score = 0.9 * ligand_best_score;
				}
				//mj ouput decoy or if no filter or better then filter_score
				if ( ligand::ligand_one->lig_sumE <= ligand_reduced_score ) {
					pose.pose_to_design_output(run);
					if ( Task.get_mode() == "design" ) {
						update_design_profile( pose.res(),pose.total_residue(), run );
					}
				}
				else --run;	//mj another trial
				//mj output filter state
				std::cout << "filter state: " << ligand_filter_score << ' ' <<
					ligand_reduced_score << ' ' << count << ' ' << ligand_filter_count <<
				 ' ' <<  ligand::ligand_one->lig_sumE << ' ' << ligand_best_score <<
						std::endl;
			}
		}
	}
	if ( Task.get_make_output_file() && Task.get_mode() == "design" ) {
		output_design_profile(pose.total_residue());
	}

	pack_update_new_rotamer( Task.get_designmap(), pose.total_residue() );

}

////////////////////////////////////////////////////////////////////////////////
/// @begin pack_update_new_rotamer
///
/// @brief
///
/// @detailed
///
/// @param  which_res - [in/out]? -
/// @param  total_residue - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
pack_update_new_rotamer(
	const DesignMap & design_map,
	int total_residue
)
{
	for ( int i = 1; i <= total_residue; ++i ) {
		if ( design_map.repack_residue(i) ) maps_set_new_rotamer(i);
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_design_matrix
///
/// @brief
///
/// @detailed
///
/// @param  total_residue - [in/out]? -
/// @param  input_matrix - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_design_matrix(
	const DesignMap & input_design_map,
	int const total_residue
)
{
	using namespace misc;
	using namespace param;
	using namespace template_pack;

	for ( int pos = 1; pos <= total_residue; ++pos ) {
		for ( int aa = 1, aae = MAX_AA(); aa <= aae; ++aa ) {
				designed_matrix(aa,pos) = input_design_map.get(pos,aa);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_design_matrix
///
/// @brief
///
/// @detailed
///
/// @param  total_residue - [in/out]? -
/// @param  output_matrix  [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_design_matrix(
	DesignMap & output_design_map,
	int const total_residue
)
{

	using namespace misc;
	using namespace param;
	using namespace template_pack;

	for ( int pos = 1; pos <= total_residue; ++pos ) {
		for ( int aa = 1, aae = MAX_AA(); aa <= aae; ++aa ) {
			if (designed_matrix(aa,pos)){
				output_design_map.set(pos,aa);
			}
			else {
				output_design_map.disable(pos,aa);
			}
		}
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin ang_from_pdb_wsc
///
/// @brief
///bk determines phi,psi,chi angles and rotamer from a
///bk protein structure
///
/// @detailed
///
/// @param  nres - [in/out]? - # of residues in the protein
/// @param  aan - [in/out]? - specifies amino acid at each seqpos
/// @param  aa_variant - [in/out]? - amino acid variation at each position
/// @param  xyz - [in/out]? -
/// @param  phi - [in/out]? -
/// @param  psi - [in/out]? -
/// @param  chi - [in/out]? -
/// @param  rot - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
/// am 11/04
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
ang_from_pdb_wsc(
	int nres, // # of residues in the protein
	FArray1Da_int aan, // specifies amino acid at each seqpos
	FArray1Da_int aa_variant, // amino acid variation at each position
	FArray3Da_float xyz,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray2Da_float chi,
	FArray2Da_int rot
)
{
	using namespace param;
	using namespace param_aa;

	aan.dimension( nres );
	aa_variant.dimension( nres );
	xyz.dimension( 3, MAX_ATOM(), nres );
	phi.dimension( nres );
	psi.dimension( nres );
	chi.dimension( MAX_CHI, nres );
	rot.dimension( MAX_CHI, nres );

	float angle,dis;

// measure phi,psi angles
// first, set to zero
	for ( int i = 1; i <= nres; ++i ) {
		if ( is_protein(aan(i)) || is_nonnatural(aan(i) ) ) {
			phi(i) = -90.0;
			psi(i) = 130.0;
		} else {
			phi(i) = 0.0;
			psi(i) = 0.0;
		}
	}

	if ( nres > 1 && ( is_protein(aan(1)) || is_nonnatural(aan(1)) )
			 && ( is_protein(aan(2)) || is_nonnatural(aan(2)) ) ) {
		dihedral_bk(xyz(1,1,1),xyz(1,2,1),xyz(1,3,1),xyz(1,1,2),angle);
		psi(1) = angle;
		phi(1) = 0.0;
	}

	for ( int i = 2; i <= (nres-1); ++i ) {
		if ( !is_protein(aan(i)) && !is_nonnatural(aan(i)) ) continue;

		if ( is_protein(aan(i-1)) || is_nonnatural(aan(i-1)) ) {
			distance_bk(xyz(1,3,i-1),xyz(1,1,i),dis);
			// jk if there's no phi angle due to chain break, set phi = 0
			if ( dis > 3.0 ) {
				phi(i) = 0.0;
			} else {
				dihedral_bk(xyz(1,3,i-1),xyz(1,1,i),xyz(1,2,i),xyz(1,3,i),angle);
				phi(i) = angle;
			}
		}

		if ( is_protein(aan(i+1)) || is_nonnatural(aan(i+1)) ) {
			distance_bk(xyz(1,3,i),xyz(1,1,i+1),dis);
			// jk if there's no psi angle due to chain break, set psi = 0
			if ( dis > 3.0 ) {
				psi(i) = 0.0;
			} else {
				dihedral_bk(xyz(1,1,i),xyz(1,2,i),xyz(1,3,i),xyz(1,1,i+1),angle);
				psi(i) = angle;
			}
		}

	}
	if ( nres > 1 && ( is_protein(aan(nres-1)) || is_nonnatural(aan(nres-1)) )
			 && ( is_protein(aan(nres)) || is_nonnatural(aan(nres)) ) ) {
		dihedral_bk(xyz(1,3,nres-1),xyz(1,1,nres),xyz(1,2,nres),xyz(1,3,nres),angle);
		phi(nres) = angle;
		psi(nres) = 0.0;
	}
//      std::cout << "ang_from line 62" << std::endl;

//** determine chi angles and rotamers
	get_chi_and_rot_from_coords(nres,aan,aa_variant,xyz,chi,rot);

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_chi_and_rot_from_coords
///
/// @brief
///ctsa  (after bk) determines chi angles and rotamers from fa coordinates
///
/// @detailed
///
/// @param  total_residue - [in/out]? -
/// @param  res - [in/out]? -
/// @param  aavn - [in/out]? -
/// @param  full_coord - [in/out]? -
/// @param  chi_out - [in/out]? -
/// @param  rot_out - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
/// am 11/04
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_chi_and_rot_from_coords(
	int total_residue,
	FArray1Da_int res,
	FArray1Da_int aavn,
	FArray3Da_float full_coord,
	FArray2Da_float chi_out,
	FArray2Da_int rot_out
)
{
	using namespace aaproperties_pack;
	using namespace param;

	res.dimension( total_residue );
	aavn.dimension( total_residue );
	full_coord.dimension( 3, MAX_ATOM(), total_residue );
	chi_out.dimension( MAX_CHI, total_residue );
	rot_out.dimension( MAX_CHI, total_residue );

	for ( int seqpos = 1; seqpos <= total_residue; ++seqpos ) {
		for ( int chino = 1; chino <= MAX_CHI; ++chino ) {
			chi_out(chino,seqpos) = 0.;
			rot_out(chino,seqpos) = 0;
		}
		// don't bother to continue if nucleic acid
		if ( !param_aa::is_protein(res(seqpos)) && !param_aa::is_nonnatural(res(seqpos)) ) continue;
		int aa = 0;
		for ( int chino = 1; chino <= MAX_CHI; ++chino ) {
			//chi_out(chino,seqpos) = 0.;
			//rot_out(chino,seqpos) = 0;
			aa = res(seqpos);
			int const aav = aavn(seqpos);
			if ( nchi(aa,aav) >= chino ) {     // if has chino, measure it
				chi_out(chino,seqpos) =
					periodic_range(
						dihedral(
							full_coord(1,chi_atoms(1,chino,aa,aav),seqpos),
							full_coord(1,chi_atoms(2,chino,aa,aav),seqpos),
							full_coord(1,chi_atoms(3,chino,aa,aav),seqpos),
							full_coord(1,chi_atoms(4,chino,aa,aav),seqpos) ), 360.0 );
			}
		}
		//revert symmetric consideration for chi angle calculations --chu
		// set_all_chi_to_periodic_range(chi_out(1,seqpos),aa);
		rotamer_from_chi(chi_out(1,seqpos),aa,rot_out(1,seqpos));
	}
}
///////////////////////////////////////////////////////////////////////////////
void
get_real_chi_from_coords(
	int nres,
	FArray1Da_int aan,
	FArray1Da_int aavn,
	FArray3Da_float xyz,
	FArray2Da_float chi_out
)
{
	// copied from get_chi_and_rot_from_coords, but no set_periodic_range for
	// symmetric sidechains and no rotamer numbers
	using namespace aaproperties_pack;
	using namespace param;

	aan.dimension( nres );
	aavn.dimension( nres );
	xyz.dimension( 3, MAX_ATOM(), nres );
	chi_out.dimension( MAX_CHI, nres );

	for ( int seqpos = 1; seqpos <= nres; ++seqpos ) {
		for ( int chino = 1; chino <= MAX_CHI; ++chino ) {
			chi_out(chino,seqpos) = 0.;
		}
		// don't bother to continue if nucleic acid
		if ( !param_aa::is_protein(aan(seqpos)) && !param_aa::is_nonnatural(aan(seqpos)) ) continue;
		int aa = 0;
		for ( int chino = 1; chino <= MAX_CHI; ++chino ) {
			aa = aan(seqpos);
			int const aav = aavn(seqpos);
			if ( nchi(aa,aav) >= chino ) {     // if has chino, measure it
				chi_out(chino,seqpos) = periodic_range(
					dihedral(xyz(1,chi_atoms(1,chino,aa,aav),seqpos),
						xyz(1,chi_atoms(2,chino,aa,aav),seqpos),
						xyz(1,chi_atoms(3,chino,aa,aav),seqpos),
						xyz(1,chi_atoms(4,chino,aa,aav),seqpos)), 360.0 );
			}
		}
	}
}
////////////////////////////////////////////////////////////////////////////////
/// @begin set_all_chi_to_periodic_range
///
/// @brief standardize amino acid chi values
///
/// @detailed
///
/// set all the chi values for an amino acid to fall within the
/// ranges defined in dunbrack's rotamer definitions
///
/// @param  chi - [in/out]? - array of chi values for one sidechain
/// @param[in]   aa - in - amino acid value
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors ctsa 10-2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_all_chi_to_periodic_range(
	FArray1Da_float chi,
	int aa
)
{
	using namespace param;

	chi.dimension( MAX_CHI );

	for ( int chino = 1; chino <= MAX_CHI; ++chino ) {
		chi(chino) = set_chi_to_periodic_range(chi(chino),aa,chino);
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_chi_to_periodic_range
///
/// @brief standardize amino acid chi value
///
/// @detailed
///
/// set one chi value for an amino acid to fall within the
/// ranges defined in dunbrack's rotamer definitions.
///
/// @param[in]   chi - in - chi angle value
/// @param[in]   aa - in - amino acid type
/// @param[in]   chino - in - no of chi value
///
/// @return standardized chi angle
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors ctsa 10-2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
set_chi_to_periodic_range(
	float chi,
	int aa,
	int chino
)
{
	using namespace param_aa;

//------------------------------------------------------------------------------
	if ( chino == 2 ) {   // handle symmetry cases for chi2
		//  -- not for HIS in new dunbrack version
		if ( aa == aa_phe || aa == aa_tyr ) {
			return periodic_range(chi-60.,180.) + 60.;
		} else if ( aa == aa_asp ) {
			return periodic_range(chi,180.);
		}
	} else if ( chino == 3 ) {   // handle symmetry cases for chi3
		if ( aa == aa_glu ) {
			return periodic_range(chi,180.);
		}
	}
	return periodic_range(chi,360.);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin subtract_chi_angles
///
/// @brief angle subtraction for chi angles
///
/// @detailed
///
/// special angle subtraction for chi values ensures that results are
/// valid for special cases where the periodicity is not 360.
///
/// @param[in]   chi1 - in - chi angle value
/// @param[in]   chi2 - in - another chi angle value
/// @param[in]   aa - in - amino acid type
/// @param[in]   chino - in - chi angle number
///
/// @return chi1-chi2, accounting for periodicity
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors ctsa 10-2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
subtract_chi_angles(
	float chi1,
	float chi2,
	int aa,
	int chino
)
{
	using namespace param_aa;

//------------------------------------------------------------------------------
	if ( chino == 2 ) {   // handle symmetry cases for chi2
		//  -- not for HIS in new dunbrack version
		if ( aa == aa_phe || aa == aa_tyr ) {
			return periodic_range((chi1-chi2),180.);
		} else if ( aa == aa_asp ) {
			return periodic_range((chi1-chi2),180.);
		}
	} else if ( chino == 3 ) {   // handle symmetry cases for chi3
		if ( aa == aa_glu ) {
			return periodic_range((chi1-chi2),180.);
		}
	}
	return periodic_range((chi1-chi2),360.);
}




void
precompute_rotamer_energies(
	InteractionGraphBase * ig,
	RotamerSet & rotamer_set,
	PackerTask const & Task,
	FArray2D_short & neighbor_indexno,
	FArray1D_float & ligenergy1b_old,
	pose_ns::Pose & pose
)
{
	using namespace aaproperties_pack;
	using namespace design;
	using namespace design_sym;
	using namespace param;
	using namespace param_aa;
	using namespace template_pack;
	using namespace water;

	ligenergy1b_old.dimension( rotamer_set.nrotamers() );

	//apl Following variable used for interaction graph I/O purposes:
	//apl were pair energies computed using rotamer_trie_calc_energies
	//apl or with get_energies()?  Makes a difference since bb/sc
	//apl energies are in the two body energies for rtce and in the
	//apl one body energies for ge.
	char energy_calculation_function;

	bool const is_on_the_fly_graph = ( dynamic_cast< OnTheFlyInteractionGraph * > (ig) != 0 );

	if ( ! is_on_the_fly_graph )
	{
		if ( Task.get_mode() == "design" && read_interaction_graph_file )
		{
			energy_calculation_function =
				read_pair_energy_file(
				dynamic_cast< PDInteractionGraph* > ( ig ),
				rotamer_set,
				Task,
				neighbor_indexno,
				ligenergy1b_old
			);
		}
		else
		{
			PrecomputedPairEnergiesInteractionGraph * pcig =
				dynamic_cast< PrecomputedPairEnergiesInteractionGraph *> ( ig );

			GRAPHICS_LOG( "packer: get_energies: nrotamers= "+ // status output
										string_of( rotamer_set.nrotamers() ));

			//apl compute rotamer/background and rotamer-pair energies
			if ( param_rotamer_trie::use_rotamer_trie &&
				!design::explicit_h2o && ! water::use_hetero_h2o && !design::hydrate_dna &&
				( num_clones == 0 ) &&
				( MAX_AA()() == 20  || Task.get_mode() != "optimizeH") )
			{

				energy_calculation_function = 'r'; // r for rotamer_trie_calc_energies
				PROF_START( prof::RTCALC_ENERGIES );
				rotamer_trie_calc_energies( rotamer_set, Task,
				ligenergy1b_old, neighbor_indexno, *pcig );
				PROF_STOP ( prof::RTCALC_ENERGIES );
			}	else {
				energy_calculation_function = 'g'; // g for get_energies
				PROF_START( prof::GET_ENERGIES );
				get_energies( rotamer_set, Task, ligenergy1b_old,
				neighbor_indexno, *pcig, pose.total_residue(), pose.res(), pose.res_variant(), pose.full_coord() );
				PROF_STOP ( prof::GET_ENERGIES );
			}
		}

		if ( Task.get_mode() == "design" && write_interaction_graph_file ) {
			write_pair_energy_file(	dynamic_cast< PDInteractionGraph* > ( ig ),
			rotamer_set,	energy_calculation_function );
		}
	}
	else
	{
		calc_one_body_energies_for_on_the_fly_graph(
			* (dynamic_cast< OnTheFlyInteractionGraph * > (ig)),
			ligenergy1b_old,
			neighbor_indexno,
			rotamer_set,
			Task,
			pose.total_residue(),
			pose.res(),
			pose.res_variant(),
			pose.full_coord());

		assign_weight_map_for_on_the_fly_graph(
			* (dynamic_cast< OnTheFlyInteractionGraph * > (ig)), Task);

	}

	if ( design_interface_electrostatic_complementarity ) {
		apply_electrostatic_complementarity_shift( ig, rotamer_set,
			interface_electrostatic_complementarity_shift);
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin count_moltenres
///
/// @brief
/// given a DesignMap, count the number of residues to be repacked
///
/// @detailed
///
/// @param  design_map
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
/// jk, kaufmann
///
/// @last_modified 5-16-2006
////////////////////////////////////////////////////////////////////////////////
int
count_moltenres( const DesignMap & design_map )
{
	using namespace design_sym;
	using namespace misc;

	int nmoltenres(0);

	// jk note: "clone" positions don't count as molten
	for (int ii = 1; ii <= total_residue; ++ii) {
		if ( design_map.repack_residue(ii) && ( clone_follows(ii) == 0 ) ) {
			++nmoltenres;
		}
	}
	if( get_ligand_flexible_flag() && ! get_enable_ligaa_flag() ){
		nmoltenres=nmoltenres+int(ligand::ligand_ptr_vector.size());
	}
	return nmoltenres;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_energies
///
/// @brief
///bk gets energies for rotamers and rotamer pairs
///
/// @detailed
///
/// @param  design_map
/// @param  ligenergy1b - [out] - the rotamer/ligand one body energies
/// @param  neighbor_indexno - [in] - order of neighbors for all res of
///    higher number
/// @param  ig - [in/out] - the interaction graph in which to store rotamer
///    one body and two body energies.
///
/// @global_read
/// namespace template_pack
/// namespace design
/// namespace hbonds
/// namespace water
/// namespace param_pack
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_energies(
	RotamerSet & rotamer_set,
	const PackerTask & Task,
	FArray1D_float & ligenergy1b,
	FArray2DB_short const & neighbor_indexno,
	PrecomputedPairEnergiesInteractionGraph & ig,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
)
{
	using namespace design;
	using namespace design_sym;
	using namespace param;
	using namespace param_pack;
	using namespace runlevel_ns;
	using namespace template_pack;

//	std::cout << "Adding energies using get_energies()" << std::endl;

	// used often
	bool are_neighbors;

	//car
	float const CSTE_THRESHOLD = { 0.0001 }; //ignore cstE values less than this

//bs Count disulfides that satisfy centroid criteria.
//bs After this point, disulfide connectivity is set,
//bs so fullatom disulfide scoring below
//bs will score these cys pairs only.
//bs This must be done before first call to get_sc_scE.
	disulfides::BOUNDARY::evaluate_disulfides_centroid();


	//jjh generalized Born prep work, if needed
	if ( gen_born ) {
		gb_build_placeholders( total_residue, full_coord, res, res_variant,
		 Task.get_designmap() );
		gb_get_template_born_radii( total_residue, full_coord, born_radius,
			res, res_variant, Task.get_designmap() );
		gb_get_rotamers_born_radii( total_residue, full_coord, res, res_variant,
		 rotamer_set, Task.get_designmap());
	}

	//fill nrotoffest arrays....
	int const nmoltenres = ig.get_num_nodes();
	if (nmoltenres == 0) return;

//bk loop through rotamers, calculate self energies, rotamer-template energies
// one-body
	FArray1D_float energy1b_base( rotamer_set.nrotamers(), 0. );
	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {

		int const rotres = rotamer_set.report_seqpos(rot);
		int const aarot = rotamer_set.report_aa(rot);
		int const aavrot = rotamer_set.report_aav(rot);

		float energy1b_this_rotamer = get_1body_energy( rotamer_set, rot, rotres, aarot,
			aavrot, rotamer_set.get_rotcoord(rot), energy1b_base, Task );

		if ( num_clones > 0 ) {

			// add sidechain-sidechain interaction energy for symmetric positions
			float sym_selfE(0.);
			for (int c=1; c<=num_clones; ++c) {
				int const clone_res=clone_list(rotres, c);
				FArray2D_float clone_coord( 3, MAX_ATOM()() );
				FArray1D_float clone_actcoord( 3 );

				// jk Transfer this rotamer from position rotres onto position clone_res
				transfer_sym_rotamer(aarot, aavrot, clone_Mgl(1,1,clone_res),
					rotamer_set.get_rotcoord(rot), rotamer_set.get_rotactcoord(rot), clone_coord, clone_actcoord);

				// jk Check whether this clone is a neighbor of
				// jk the symmetry-related independent residue
				float dis2;
				bool clone_self_neighbor(false);
				are_they_neighbors(aarot,aarot,rotamer_set.get_rotcoord(rot),clone_coord,
													 dis2,clone_self_neighbor);

				if ( clone_self_neighbor ) {

					// jk Compute the rotamer-clone energy as the 2-body energies
					sym_selfE += get_base_2body_energy( rotres, aarot, aavrot,
						rotamer_set.get_rotcoord(rot), rotamer_set.get_rotactcoord(rot), clone_res, aarot,
						aavrot, clone_coord, clone_actcoord, Task );
					sym_selfE += get_variant_2body_energy( rotres, aarot, aavrot,
						rotamer_set.get_rotcoord(rot), rotamer_set.get_rot_born_radius(rot), clone_res, aarot,
						aavrot, clone_coord, rotamer_set.get_rot_born_radius(rot), Task );

				}
			}

			energy1b_this_rotamer += (sym_selfE / 2.0);

		}

		int const rot_molten_res = rotamer_set.resid_2_moltenres( rotres );
		int const rot_index_on_molten_res = rot - rotamer_set.nrotoffset( rot_molten_res );

		ig.add_to_nodes_one_body_energy( rot_molten_res, rot_index_on_molten_res, energy1b_this_rotamer );
	} // end looping through rotamers

	//mj compute all ligand energies
	//lin calculate the energy subset
	//currently only energy between ligand and protein
	if(get_ligand_flexible_flag()){
		//compute all ligand energies
		compute_ligand_energies(&ig,Task.get_designmap(), rotamer_set,total_residue, res,res_variant,full_coord);
	}else{
	//lin calculate the energy subset
	//currently only energy between ligand and protein
	get_ligenergies(ligenergy1b, rotamer_set);
	//lin add the subset of ligand energy into energy1b;
	ig.add_to_one_body_energies(ligenergy1b);
	}
	//mj end

//bk get rotamer-rotamer pair energies, store in InteractionGraph ig

	FArray3D_float all_clone_coord( 3, MAX_ATOM()(), MAX_CLONES() );
	FArray2D_float all_clone_actcoord( 3, MAX_CLONES() );

	FArray4D_float all_aa_clone_coord( 3, MAX_ATOM()(), MAX_CLONES(), MAX_AA() );
	FArray3D_float all_aa_clone_actcoord( 3, MAX_CLONES(), MAX_AA() );

	FArray2D_bool aa_are_they_indep_neighbors( MAX_AA(), MAX_AA(), false );
	FArray3D_bool aa_are_they_clone_neighbors( MAX_AA(), MAX_AA(), MAX_CLONES(), false );

	FArray2D_bool aa_are_they_neighbors( MAX_AA(), MAX_AA(), false );
	FArray2D_bool aa_constrained_neighbors( MAX_AA(), MAX_AA(), false );

	// two-body
	for ( int ii = 1; ii <= nmoltenres; ++ii ) {
		int const iiresid = rotamer_set.moltenres_2_resid(ii);
		if( iiresid < 0 ) continue;//kwk jump out if non amino acid molten residue
		int const ii_num_states = rotamer_set.num_states_for_moltenres(ii);
		int const iirotindexoffset = rotamer_set.nrotoffset(ii);

		// jk build all clones of the first rotamer of ii for each amino acid
		for (int kk = 1; kk <= MAX_AA(); ++kk) {
			if (rotamer_set.first_rot_for_aa(kk, ii) == 0 ) continue;
			for (int c=1; c<=num_clones; ++c) {
				int const clone_res=clone_list(iiresid,c);
				int const aav=1;
				transfer_sym_rotamer(kk, aav, clone_Mgl(1,1,clone_res),
														 rotamer_set.get_first_rotcoord_for_aa(kk,ii),
														 rotamer_set.get_first_rotactcoord_for_aa(kk,ii),
														 all_aa_clone_coord(1,1,c,kk),
														 all_aa_clone_actcoord(1,c,kk));
			}
		}

		for ( int jj = ii+1; jj <= nmoltenres; ++jj ) {
			int const jjresid = rotamer_set.moltenres_2_resid(jj);
			if (jjresid < 0 ){continue;}//kwk jump out if non amino acid molten residue
			int const jj_num_states = rotamer_set.num_states_for_moltenres(jj);
			int const jjrotindexoffset = rotamer_set.nrotoffset(jj);

			bool neighbor_index_val(false);
			if ( neighbor_indexno(iiresid, jjresid) != 0 ) neighbor_index_val = true;
			for (int c=1; (c<=num_clones) && ! neighbor_index_val; ++c) {
				int const jj_clone_res=clone_list(jjresid,c);
				if ( neighbor_indexno(iiresid, jj_clone_res) != 0 ) neighbor_index_val = true;
			}

			if ( neighbor_index_val ) {
				bool found_aa_neighbor(false);
				aa_are_they_neighbors = false;
				aa_are_they_indep_neighbors = false;
				aa_are_they_clone_neighbors = false;

				for (int kk = 1; kk <= MAX_AA(); ++kk) {
					if (rotamer_set.first_rot_for_aa(kk, ii) == 0 ) continue;
					for (int ll = 1; ll <= MAX_AA(); ++ll) {
						if (rotamer_set.first_rot_for_aa(ll, jj) == 0 ) continue;

						float dis2;
						bool found_ll_kk_neighbor(false);
						are_they_neighbors( kk, ll,
																rotamer_set.get_first_rotcoord_for_aa(kk,ii),
																rotamer_set.get_first_rotcoord_for_aa(ll,jj),
																dis2, are_neighbors );

						if ( are_neighbors ) {
							found_ll_kk_neighbor = true;
							aa_are_they_indep_neighbors(ll,kk) = true;
						}

						// jk look for neighbors in each clone of rot1
						for (int c=1; c<=num_clones; ++c) {
							are_they_neighbors( kk, ll, all_aa_clone_coord(1,1,c,kk),
																	rotamer_set.get_first_rotcoord_for_aa(ll,jj),
																	dis2, are_neighbors );

							if (are_neighbors) {
								found_ll_kk_neighbor = true;
								aa_are_they_clone_neighbors(ll,kk,c) = true;
							}
						}
						if ( found_ll_kk_neighbor ) found_aa_neighbor = true;
						aa_are_they_neighbors(ll,kk) = found_ll_kk_neighbor;
					}
				}
				aa_constrained_neighbors = false;

				if ( found_aa_neighbor ) {
					ig.add_edge(ii, jj);
					ig.set_sparse_aa_info_for_edge(ii, jj, aa_are_they_neighbors );

					for ( int rot1 = 1; rot1 <= ii_num_states; ++rot1 ) {
						int const rot1rotindex = iirotindexoffset + rot1;
						int const rot1res = rotamer_set.report_seqpos(rot1rotindex);
						int const aarot1 = rotamer_set.report_aa(rot1rotindex);
						int const aavrot1 = rotamer_set.report_aav(rot1rotindex);
						are_neighbors = false;

						// jk build all clones for rot1
						for (int c=1; c<=num_clones; ++c) {
							int const clone_res=clone_list(rot1res,c);
							transfer_sym_rotamer(aarot1, aavrot1, clone_Mgl(1,1,clone_res),
								rotamer_set.get_rotcoord(rot1rotindex), rotamer_set.get_rotactcoord(rot1rotindex),
								all_clone_coord(1,1,c), all_clone_actcoord(1,c));
						}

						for ( int rot2 = 1; rot2 <= jj_num_states; ++rot2 ) {
							int const rot2rotindex = jjrotindexoffset + rot2;
							int const rot2res = rotamer_set.report_seqpos(rot2rotindex);
							int const aarot2 = rotamer_set.report_aa(rot2rotindex);
							int const aavrot2 = rotamer_set.report_aav(rot2rotindex);

							are_neighbors = aa_are_they_neighbors(aarot2, aarot1) || aa_constrained_neighbors(aarot2, aarot1);

							if ( are_neighbors ) {

								float esum(0.);

								// both base rotamers (main)
								if ( rot1rotindex == rotamer_set.get_base_rotamer(rot1rotindex) &&
										 rot2rotindex == rotamer_set.get_base_rotamer(rot2rotindex) ) {

									if ( aa_are_they_indep_neighbors(aarot2,aarot1) ) {

										// main two-body energy calculation
										esum = get_base_2body_energy( rot1res, aarot1, aavrot1,
											rotamer_set.get_rotcoord(rot1rotindex),
											rotamer_set.get_rotactcoord(rot1rotindex),
										  rot2res, aarot2, aavrot2,
											rotamer_set.get_rotcoord(rot2rotindex),
											rotamer_set.get_rotactcoord(rot2rotindex), Task );
									}

									for (int c=1; c<=num_clones; ++c) {
										if ( aa_are_they_clone_neighbors(aarot2,aarot1,c) ) {
											int const clone_res=clone_list(rot1res,c);
											esum += get_base_2body_energy( clone_res, aarot1, aavrot1,
															  all_clone_coord(1,1,c), all_clone_actcoord(1,c),
																rot2res, aarot2, aavrot2,
																rotamer_set.get_rotcoord(rot2rotindex),
																rotamer_set.get_rotactcoord(rot2rotindex), Task );
										}
									}

								} else {
									// use saved energy
									int const b1 = rotamer_set.get_base_rotamer(rot1rotindex) - iirotindexoffset;
									int const b2 = rotamer_set.get_base_rotamer(rot2rotindex) - jjrotindexoffset;
									esum = ig.get_two_body_energy_for_edge(ii,jj,b1,b2);
								}

								// variants
								if ( aa_are_they_indep_neighbors(aarot2,aarot1) ) {
									esum += get_variant_2body_energy( rot1res, aarot1, aavrot1,
										rotamer_set.get_rotcoord(rot1rotindex), rotamer_set.get_rot_born_radius(rot1rotindex),
										rot2res, aarot2, aavrot2, rotamer_set.get_rotcoord(rot2rotindex),
										rotamer_set.get_rot_born_radius(rot2rotindex), Task );
								}

								for (int c=1; c<=num_clones; ++c) {
									if ( aa_are_they_clone_neighbors(aarot2,aarot1,c) ) {
										int const clone_res=clone_list(rot1res,c);
										esum += get_variant_2body_energy( clone_res, aarot1, aavrot1,
											all_clone_coord(1,1,c), rotamer_set.get_rot_born_radius(rot1rotindex),
											rot2res, aarot2, aavrot2, rotamer_set.get_rotcoord(rot2rotindex),
											rotamer_set.get_rot_born_radius(rot2rotindex), Task );
									}
								}
								ig.add_to_two_body_energies_for_edge(ii, jj, rot1, rot2, esum);

							}

						} // end rot2 loop
					} // end rot1 loop
				} // end if (found_aa_neighbor)
			} // end if ( non-zero neighbor_indexno )

			//apl extra loop for constraint energies, fixing old
			//apl bug that ignored constraints between residues
			//apl too far away to have a non-zero neighbor_indexno.
			if ( classical_constraints::BOUNDARY::get_constraints_exist() && classical_constraints::BOUNDARY::residue_pair_has_constraints(iiresid, jjresid) ) {
				ig.force_all_aa_neighbors_for_edge(ii, jj);

				for ( int rot1 = 1; rot1 <= ii_num_states; ++rot1 ) {
					int const rot1rotindex = iirotindexoffset + rot1;
					int const rot1res = rotamer_set.report_seqpos(rot1rotindex);
					int const aarot1 = rotamer_set.report_aa(rot1rotindex);
					int const aavrot1 = rotamer_set.report_aav(rot1rotindex);
					are_neighbors = false;

					// jk build all clones for rot1
					for (int c=1; c<=num_clones; ++c) {
						int const clone_res=clone_list(rot1res,c);
						transfer_sym_rotamer(aarot1, aavrot1, clone_Mgl(1,1,clone_res),
							rotamer_set.get_rotcoord(rot1rotindex), rotamer_set.get_rotactcoord(rot1rotindex),
              all_clone_coord(1,1,c), all_clone_actcoord(1,c));
					}

					for ( int rot2 = 1; rot2 <= jj_num_states; ++rot2 ) {
						int const rot2rotindex = jjrotindexoffset + rot2;
						int const rot2res = rotamer_set.report_seqpos(rot2rotindex);
						int const aarot2 = rotamer_set.report_aa(rot2rotindex);
						int const aavrot2 = rotamer_set.report_aav(rot2rotindex);

						//car add constraint energy, no neighbor cutoff
						float cstE =  classical_constraints::BOUNDARY::get_res_res_cstE(rot1res,rot2res,aarot1,
							aavrot1,aarot2,aavrot2,rotamer_set.get_rotcoord(rot1rotindex),
							rotamer_set.get_rotcoord(rot2rotindex),false,true,false,true);

						// add constraint energy for symmetric positions
						for (int c=1; c<=num_clones; ++c) {
							cstE +=  classical_constraints::BOUNDARY::get_res_res_cstE(clone_list(rot1res,c),rot2res,aarot1,
							  aavrot1,aarot2,aavrot2,all_clone_coord(1,1,c),
								rotamer_set.get_rotcoord(rot2rotindex),false,true,false,true);
						}

						if ( cstE > CSTE_THRESHOLD ) ig.add_to_two_body_energies_for_edge(ii,jj,rot1,rot2, cstE);
					}
				}
			}
			ig.declare_edge_energies_final(ii, jj);


		} // end for jj
	}// end for ii

	if ( runlevel >= verbose ) {
		std::cout << "rotamer pair_energies occupy " << ig.get_edge_memory_usage();
		std::cout << " floats" << std::endl;
	}

}

void
calc_one_body_energies_for_on_the_fly_graph(
	OnTheFlyInteractionGraph & ig,
	FArray1D_float & ligenergy1b,
	FArray2DB_short const & neighbor_indexno,
	RotamerSet & rotamer_set,
	const PackerTask & Task,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
)
{
	using namespace design;
	using namespace design_sym;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace runlevel_ns;
	using namespace template_pack;


	// used often
	bool are_neighbors;

	//on the fly code does not handle disulfides;

	//jjh generalized Born prep work, if needed
	if ( gen_born ) {
		gb_build_placeholders(total_residue, full_coord, res, res_variant,Task.get_designmap());
		gb_get_template_born_radii(total_residue, full_coord, born_radius,
			res, res_variant, Task.get_designmap());
		gb_get_rotamers_born_radii(total_residue, full_coord, res, res_variant, rotamer_set,
      Task.get_designmap());
	}

	int const nmoltenres = ig.get_num_nodes();
	if (nmoltenres == 0) return;

	// add edges first;
	FArray2D_bool aa_are_they_neighbors( MAX_AA(), MAX_AA(), false );
	//add edges and set aa-neighbor info
	for ( int ii = 1; ii <= nmoltenres; ++ii ) {
		int iiresid = rotamer_set.moltenres_2_resid(ii);
		if( iiresid < 0 ) continue;//kwk jump out if non amino acid molten residue

		for ( int jj = ii+1; jj <= nmoltenres; ++jj ) {
			int jjresid = rotamer_set.moltenres_2_resid(jj);

			bool neighbor_index_val(false);
			if ( neighbor_indexno(iiresid, jjresid) != 0 ) neighbor_index_val = true;
			if ( classical_constraints::BOUNDARY::get_constraints_exist() &&
				classical_constraints::BOUNDARY::residue_pair_has_constraints(iiresid, jjresid) )
			{
				aa_are_they_neighbors = true;
				ig.add_edge(ii, jj);
				ig.set_sparse_aa_info_for_edge(ii, jj, aa_are_they_neighbors );
			}
			else if ( neighbor_index_val )
			{
				bool found_aa_neighbor(false);
				aa_are_they_neighbors = false;

				for (int kk = 1; kk <= MAX_AA(); ++kk) {
					if (rotamer_set.first_rot_for_aa(kk, ii) == 0 ) continue;
					for (int ll = 1; ll <= MAX_AA(); ++ll) {
						if (rotamer_set.first_rot_for_aa(ll, jj) == 0 ) continue;

						float dis2;
						are_they_neighbors(kk,ll,
															 rotamer_set.get_first_rotcoord_for_aa(kk,ii),
															 rotamer_set.get_first_rotcoord_for_aa(ll,jj),
															 dis2,are_neighbors);

						if ( are_neighbors ) found_aa_neighbor = true;
						aa_are_they_neighbors(ll,kk) = are_neighbors;
					}
				}
				if (found_aa_neighbor) {
					ig.add_edge(ii, jj);
					ig.set_sparse_aa_info_for_edge(ii, jj, aa_are_they_neighbors );
				} // end if (found_aa_neighbor)
			} // end if ( non-zero neighbor_indexno )
		} // end for jj
	}// end for ii

	//calculate one body energies for sc/bb pairs between molten residues
	for (int ii = 1; ii <= nmoltenres; ++ii)
	{
		int const ii_num_states = rotamer_set.num_states_for_moltenres ( ii );

		int ii_non_pro_rotamer = 0;
		int ii_pro_rotamer = 0;
		//get a glycine backbone, if one can be found
		if ( rotamer_set.first_rot_for_aa( aa_gly, ii ) != 0 )
		{
			ii_non_pro_rotamer = rotamer_set.first_rot_for_aa( aa_gly, ii );
		}
		else
		{
			for (int kk = 1; kk <= MAX_AA(); ++kk)
			{
				if ( kk == aa_pro ) continue;
				if ( rotamer_set.first_rot_for_aa( kk, ii ) != 0)
				{
					ii_non_pro_rotamer = rotamer_set.first_rot_for_aa( kk, ii );
					break;
				}
			}
		}
		if ( rotamer_set.first_rot_for_aa( aa_pro, ii) != 0 )
		{
			ii_pro_rotamer = rotamer_set.first_rot_for_aa( aa_pro, ii );
		}


		for (int jj = ii + 1; jj <= nmoltenres; ++jj)
		{
			if ( ! ig.get_edge_exists( ii, jj ) ) continue;

			int const jj_num_states = rotamer_set.num_states_for_moltenres( jj );

			int jj_non_pro_rotamer = 0;
			int jj_pro_rotamer = 0;

			//get a glycine backbone, if one can be found
			if ( rotamer_set.first_rot_for_aa( aa_gly, jj ) != 0 )
			{
				jj_non_pro_rotamer = rotamer_set.first_rot_for_aa( aa_gly, jj );
			}
			else
			{
				for (int kk = 1; kk <= MAX_AA(); ++kk)
				{
					if ( kk == aa_pro ) continue;
					if ( rotamer_set.first_rot_for_aa( kk, jj ) != 0 )
					{
						jj_non_pro_rotamer = rotamer_set.first_rot_for_aa( kk, jj );
						break;
					}
				}
			}

			if ( rotamer_set.first_rot_for_aa( aa_pro, jj ) )
			{
				jj_pro_rotamer = rotamer_set.first_rot_for_aa( aa_pro, jj );
			}

			//std::cerr << "Molten res " << ii << " with moltenres " <<  jj << " non-pro rot: " << jj_non_pro_rotamer << " and pro rot: " << jj_pro_rotamer << std::endl;
			for (int kk = 1; kk <= ii_num_states; ++kk)
			{
				int kk_rot_index = kk +  rotamer_set.nrotoffset( ii );

				float bb_bbnonproE( 0 ), bb_bbproE( 0 );
				float sc_npbb_energy( 0 ), sc_probb_energy( 0 );
				//calc sc_npbb_energy;
				if ( jj_non_pro_rotamer != 0 )
				{
					bb_bbnonproE = get_bb_bbE( rotamer_set, kk_rot_index, jj_non_pro_rotamer );
					sc_npbb_energy = get_sc_bbE( rotamer_set, kk_rot_index, jj_non_pro_rotamer );
				}
				//calc sc_probb_energy
				if ( jj_pro_rotamer != 0 )
				{
					bb_bbproE = get_bb_bbE( rotamer_set, kk_rot_index, jj_pro_rotamer );
					sc_probb_energy = get_sc_bbE( rotamer_set, kk_rot_index, jj_pro_rotamer );
				}

				//std::cerr << "Moltres " << ii << " state " << kk << " with moltres " << jj << " sc_npbbE: " << sc_npbb_energy << " bb_bbnpE: " << bb_bbnonproE << std::endl;

				//add sc_npbb_energy and npbb_npbb energy to energy1b
				ig.add_to_one_body_energy_for_node_state( ii, kk, sc_npbb_energy +  0.5 * bb_bbnonproE  );

				//store sc_npbb and sc_probb energy on ig_edge;
				ig.set_ProCorrection_values_for_edge( ii, jj, ii, kk,
					bb_bbnonproE, bb_bbproE, sc_npbb_energy, sc_probb_energy );

			}
			//std::cerr << "Molten res " << jj << " with moltenres " <<  ii << " non-pro rot: " << ii_non_pro_rotamer << " and pro rot: " << ii_pro_rotamer << std::endl;
			for (int kk = 1; kk <= jj_num_states; ++kk)
			{
				int kk_rot_index = kk + rotamer_set.nrotoffset( jj );

				float bb_bbnonproE( 0 ), bb_bbproE( 0 );
				float sc_npbb_energy( 0 ), sc_probb_energy( 0 );
				//calc sc_npbb_energy;
				if ( ii_non_pro_rotamer != 0 )
				{
					bb_bbnonproE = get_bb_bbE( rotamer_set, kk_rot_index, ii_non_pro_rotamer );
					sc_npbb_energy = get_sc_bbE( rotamer_set, kk_rot_index, ii_non_pro_rotamer );
				}
				//calc sc_probb_energy
				if ( ii_pro_rotamer != 0 )
				{
					bb_bbproE = get_bb_bbE( rotamer_set, kk_rot_index, ii_pro_rotamer );
					sc_probb_energy = get_sc_bbE( rotamer_set, kk_rot_index, ii_pro_rotamer );
				}

				//std::cerr << "Moltres " << jj << " state " << kk << " with moltres " << ii << " sc_npbbE: " << sc_npbb_energy << " bb_bbnpE: " << bb_bbnonproE << std::endl;

				//add sc_npbb_energy and npbb_npbb energy to energy1b
				ig.add_to_one_body_energy_for_node_state( jj, kk, sc_npbb_energy + 0.5 * bb_bbnonproE );

				//store sc_npbb and sc_probb energy on ig_edge;
				ig.set_ProCorrection_values_for_edge( ii, jj, jj, kk,
					bb_bbnonproE, bb_bbproE, sc_npbb_energy, sc_probb_energy );

			}
		}
	}

	//bk loop through rotamers, calculate self energies, rotamer-template energies
	FArray1D_float energy1b_base( rotamer_set.nrotamers(), 0. );

	bool temp_eval_sc_bbE_for_energy1b = eval_sc_bbE_for_energy1b;
  eval_sc_bbE_for_energy1b = false; //apl sc/bb energies for moltres already calculated
	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {

		int const rotres = rotamer_set.report_seqpos(rot);
		int const aarot = rotamer_set.report_aa(rot);
		int const aavrot = rotamer_set.report_aav(rot);

		float energy1b_this_rotamer = get_1body_energy( rotamer_set, rot, rotres, aarot,
			aavrot, rotamer_set.get_rotcoord(rot), energy1b_base, Task );

		int const rot_molten_res = rotamer_set.resid_2_moltenres( rotres );
		int const rot_index_on_molten_res = rot - rotamer_set.nrotoffset( rot_molten_res );

		//std::cerr << "State: " << rot_index_on_molten_res << " on node " << rot_molten_res;
		//std::cerr << " with one body energy: ";
		//std::cerr << ig.get_one_body_energy_for_node_state(rot_molten_res,rot_index_on_molten_res);
		//std::cerr << " + " << energy1b_this_rotamer << " = ";
		//std::cerr << ig.get_one_body_energy_for_node_state(rot_molten_res,rot_index_on_molten_res) + energy1b_this_rotamer;
		//std::cerr << std::endl;

		ig.add_to_one_body_energy_for_node_state(
			rot_molten_res,
			rot_index_on_molten_res,
			energy1b_this_rotamer );
	} // end looping through rotamers
	eval_sc_bbE_for_energy1b = temp_eval_sc_bbE_for_energy1b; //restore

	//mj compute all ligand energies
	//lin calculate the energy subset
	//currently only energy between ligand and protein
	//lin calculate the energy subset
	//currently only energy between ligand and protein
	get_ligenergies(ligenergy1b, rotamer_set);
	//lin add the subset of ligand energy into energy1b;
	ig.add_to_one_body_energies(ligenergy1b);
	//mj end

}


void
assign_weight_map_for_on_the_fly_graph(
	OnTheFlyInteractionGraph & ig,
	const PackerTask & Task
)
{
	ig.set_residue_weight_map(Task.get_residue_weight_map());
	return;
}


float
get_bb_bbE
(
	RotamerSet & rotamer_set,
	int rot1,
	int rot2
)
{
	using namespace param_pack;
	using namespace hbonds;
	using namespace template_pack;

	float repE, atrE, solE, elecE;
	get_bb_bbE_P( rotamer_set.report_seqpos(rot1), rotamer_set.report_seqpos(rot2),
								rotamer_set.report_aa(rot1), rotamer_set.report_aa(rot2),
								rotamer_set.report_aav(rot1), rotamer_set.report_aav(rot2),
								rotamer_set.get_rotcoord(rot1), rotamer_set.get_rotcoord(rot2),
								repE, atrE, solE,elecE );
	float esum = pack_wts.Wrep() * repE + pack_wts.Watr() * atrE + pack_wts.Wsol() * solE;
	float schbE,sc_bbhbE;
	float srbbhbE,lrbbhbE; // short and long range bb hbond energy

	get_hbE(true,
					rotamer_set.report_aa(rot1),
					rotamer_set.report_aa(rot2),
					rotamer_set.report_aav( rot1),
					rotamer_set.report_aav( rot2),
					rotamer_set.report_seqpos(rot1),
					rotamer_set.report_seqpos(rot2),
					neighbors( rotamer_set.report_seqpos(rot1) ),
					neighbors( rotamer_set.report_seqpos(rot2) ),
					rotamer_set.get_rotcoord(rot1),
					rotamer_set.get_rotcoord(rot2),
					schbE,srbbhbE,lrbbhbE,sc_bbhbE
					);

	esum += pack_wts.Whbond_bb() * ( srbbhbE + lrbbhbE );
	return esum;
}

float
get_sc_bbE
(
	RotamerSet & rotamer_set,
	int scrot,
	int bbrot
)
{
	using namespace param_pack;
	using namespace hbonds;
	using namespace template_pack;

	float repE, atrE, solE,elecE;
	get_sc_bbE(
						 rotamer_set.report_aa(scrot),
						 rotamer_set.report_aav( scrot),
						 rotamer_set.report_aa(bbrot),
						 rotamer_set.report_aav( bbrot),
						 rotamer_set.get_rotcoord(scrot),
						 rotamer_set.get_rotcoord(bbrot),
						 rotamer_set.report_seqpos(scrot),
						 rotamer_set.report_seqpos(bbrot),
						 solE, atrE, repE, elecE );
	float esum = pack_wts.Wrep() * repE + pack_wts.Watr() * atrE + pack_wts.Wsol() * solE;
	float schbE,sc_bbhbE;
	float sc_bbhbE_1_to_2, sc_bbhbE_2_to_1;
	float srbbhbE,lrbbhbE; // short and long range bb hbond energy

	get_hbE(true,
					rotamer_set.report_aa(scrot),
					rotamer_set.report_aa(bbrot),
					rotamer_set.report_aav( scrot),
					rotamer_set.report_aav( bbrot),
					rotamer_set.report_seqpos(scrot),
					rotamer_set.report_seqpos(bbrot),
					neighbors( rotamer_set.report_seqpos( scrot) ),
					neighbors( rotamer_set.report_seqpos( bbrot) ),
					rotamer_set.get_rotcoord(scrot),
					rotamer_set.get_rotcoord(bbrot),
					schbE,srbbhbE,lrbbhbE,sc_bbhbE,
					sc_bbhbE_1_to_2, sc_bbhbE_2_to_1
					);
	esum += pack_wts.Whbond_bb_sc() * sc_bbhbE_1_to_2;
	return esum;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_1body_energy
///
/// @brief
///jk get 1-body energy for repacking
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
get_1body_energy(
	RotamerSet & rotamer_set,
	int const & rot,
	int const & rotres,
	int const & aarot,
	int const & aavrot,
	FArray2Da_float rotcoord,
	FArray1DB_float & energy1b_base,
	const PackerTask & Task
)
{

	using namespace aaproperties_pack;
	using namespace design;
	using namespace design_sym;
	using namespace favor_residue;
	using namespace hbonds;
	using namespace misc;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace template_pack;
	using namespace water;

	rotcoord.dimension( 3, MAX_ATOM() );

	// jk used often
	bool are_neighbors;
	float dis2;

	// return value
	float energy1b_this_rotamer = -pack_wts.Waa(aarot); // reference energy

	//bk a mechanism for favoring the native sequence
	//ja favor_residue namespace can now retain its own idea of what is "native",
	//ja independently of what happens to misc::res if desired
	if ( get_favor_native_residue() && ( aarot == res_native(rotres) ) ) {
		energy1b_this_rotamer += get_native_bonus();
	}

	//rh Include protonation potential - the energy bias for being in a protonated state at a given pH
	///jjh Not defined for nucleic acids
	//kwk not defined for ligands
	if( !is_NA( aarot ) && !is_ligand(aarot) ) {
		float const pHE = pH_ns::dGprotonation_table(aarot,aavrot);
		energy1b_this_rotamer += pack_wts.WpH() * pHE;
	}

	//mj a mechanism for favoring aromatics, polar, nonpolar, charged AA
	if ( favor_property_residue ) {
		if ( aa_is_polar(aarot) ) energy1b_this_rotamer += favor_polar;
		if ( aa_is_nonpolar(aarot) ) energy1b_this_rotamer += favor_nonpolar;
		if ( aa_is_charged(aarot) ) energy1b_this_rotamer += favor_charged;
		if ( aa_is_aromatic(aarot) ) energy1b_this_rotamer += favor_aromatic;
	}
	//mj end


	//bk Paa_ppE     :amino acid phi,psi energy
	float Paa_ppE, tmp1, tmp2;
	get_Paa_ppE(template_pack::phi(rotres),template_pack::psi(rotres),aarot,Paa_ppE,tmp1,tmp2);
	energy1b_this_rotamer += pack_wts.Wone()*Paa_ppE;

	//bk dunE       :rotamer self energy from dunbrack percentages
	double const dunE = -std::log( rotamer_set.get_rperc(rot) );
	energy1b_this_rotamer += pack_wts.Wdun()*dunE;

	float intra_atrE, intra_repE;
	get_intra_resE(aarot,aavrot,rotcoord,intra_atrE,intra_repE);
	energy1b_this_rotamer += pack_wts.Wintra()*intra_repE;

	//bk      evaluate explicit solvation energy
	energy1b_this_rotamer += pack_wts.Wh2o_intra()*nh2o(aarot,aavrot);

	//lin  get rotamer-water lj replusive energies
	float h2oE = 0.0;
	if ( use_hetero_h2o ) get_sc_hetero_h2oE(aarot,aavrot,rotcoord,h2oE);
	energy1b_this_rotamer += pack_wts.Wh2o()*pack_wts.Wh2o_lj()*h2oE;

	//car cst sc self energy
	if ( classical_constraints::BOUNDARY::get_constraints_exist() && rot == rotamer_set.get_base_rotamer(rot) ) {
		float const cstE = classical_constraints::BOUNDARY::get_res_res_cstE(rotres,rotres,aarot,aavrot,aarot,aavrot,
			rotcoord,rotcoord,false,true,false,true);
		energy1b_this_rotamer += cstE;
		energy1b_base(rot) += cstE;
	}

	//lin add cst into packer
	if ( pack_check_current_cst_set() ) {
		packer_cst_ns::Packer_cst_set const & packer_cst
			( pack_get_current_cst_set() );
		float const cstE = packer_cst.get_res_res_cstE(rotres,rotres,aarot,aavrot,aarot,
			aavrot,rotcoord,rotcoord,false,true,false,true);
		energy1b_this_rotamer += cstE;
		energy1b_base(rot) += cstE;
	}

	float const self_res_weight = Task.get_residue_weights(rotres, aarot, rotres, aarot );
	energy1b_this_rotamer *= self_res_weight;
	energy1b_base(rot) *= self_res_weight;

	//bk loop through backbone atoms,get rotamer-backbone energies

	for ( int bbres = 1; bbres <= total_residue; ++bbres ) {

		if ( ! eval_sc_bbE_for_energy1b && (rotres != bbres) &&
				 Task.get_designmap().repack_residue(bbres) ) {
			continue;
		}

		float const res_res_weight = Task.get_residue_weights(rotres, aarot, bbres, res(bbres) );

		float & xyz_11b( full_coord(1,1,bbres) );
		are_they_neighbors(aarot,res(bbres),rotcoord,xyz_11b,dis2,
		 are_neighbors);
		if ( are_neighbors ) {
			//bk            if an res_variant contains atoms in common with another variant,
			//bk            try to calculate the energy of those atoms only once, the array
			//bk            base_rotamer identifies the starting point for each rotamer
			if ( rot == rotamer_set.get_base_rotamer(rot) ) {

				float solvE,atrE,repE,elecE;
				get_sc_bbE(aarot,aavrot,res(bbres),res_variant(bbres),
				 rotcoord,xyz_11b,rotres,bbres,solvE,atrE,repE,elecE);

				// jk rotamer-backbone geometric solvation term
				if ( geometric_sol::geometric_sol_flag ) {
					solvE = 0.;
					// any polar groups on the rotamer sidechain occluded by backbone
					solvE += res_res_geometric_sol(rotres,bbres,aarot,aavrot,res(bbres),res_variant(bbres),
					  rotcoord,xyz_11b,false,true,true,false);
					// any polar groups on the backbone occluded by rotamer sidechain
					solvE += res_res_geometric_sol(bbres,rotres,res(bbres),res_variant(bbres),aarot,aavrot,
					  xyz_11b,rotcoord,true,false,false,true);
				}

				// glb if scale_res_energy_flag then SCALE atrE,solvE based on bbres and rotres
				solvE = scale_res_energy(bbres,rotres,solvE); //glb
				atrE = scale_res_energy(bbres,rotres,atrE); //glb
				repE = scale_res_rep_energy(bbres,rotres,repE); //glb

				energy1b_this_rotamer += res_res_weight * pack_wts.Wsol() * solvE;
				energy1b_this_rotamer += res_res_weight * pack_wts.Watr() * atrE;
				energy1b_this_rotamer += res_res_weight * pack_wts.Wrep() * repE;
				energy1b_base(rot) += res_res_weight * ( pack_wts.Wsol() * solvE + pack_wts.Watr() * atrE + pack_wts.Wrep() * repE );
			}

			float h2oE, h2ohbE;
			get_sc_bb_h2oE(aarot,aavrot,res(bbres),res_variant(bbres),
			 rotcoord,xyz_11b,rotres,bbres,h2oE,h2ohbE);
			energy1b_this_rotamer += res_res_weight * pack_wts.Wh2o() * ( pack_wts.Wh2o_lj() * h2oE + h2ohbE );

		}
		//car add cst rotamer to bb energy
		//car only base rotamer, independent of neighbors
		if ( classical_constraints::BOUNDARY::get_constraints_exist() && rot == rotamer_set.get_base_rotamer(rot) ) {
			float cstE = classical_constraints::BOUNDARY::get_res_res_cstE(rotres,bbres,aarot,aavrot,res(bbres),
				res_variant(bbres),rotcoord,xyz_11b,false,true,true,false);
			float const new_cst_energy = res_res_weight * cstE;
			energy1b_this_rotamer += new_cst_energy;
			energy1b_base(rot) += new_cst_energy;
		}

		//lin add cst into packer
		if ( pack_check_current_cst_set() && rot == rotamer_set.get_base_rotamer(rot)  ) {
			packer_cst_ns::Packer_cst_set const & packer_cst
				( pack_get_current_cst_set() );
			float cstE = packer_cst.get_res_res_cstE(rotres,bbres,aarot,aavrot,
				res(bbres),res_variant(bbres),rotcoord,xyz_11b,false,true,true,false);
			float const new_cst_energy = res_res_weight * cstE;
			//std::cout<<"res_res_weight: "<<rotres<<" "<<bbres<<" "<<res_res_weight<<std::endl;
			energy1b_this_rotamer += new_cst_energy;
			energy1b_base(rot) += new_cst_energy;
		}

	}  // end looping through backbone positions

	//bk get energies with fixed sidechains
	for ( int scres = 1; scres <= total_residue; ++scres ) {
		if ( Task.get_designmap().repack_residue(scres) ) continue;
		if ( rotres == scres ) continue;
		{ // Scope
			float & xyz_11s( full_coord(1,1,scres) );
			int scaa = res(scres);
			int scaav = res_variant(scres);
			float const res_res_weight = Task.get_residue_weights(rotres, aarot, scres, scaa );
			are_they_neighbors(aarot,scaa,rotcoord,xyz_11s,dis2,are_neighbors);
			if ( are_neighbors ) {

				//bk if an res_variant contains atoms in common with another variant,
				//bk try to calculate the energy of those atoms only once, the array
				//bk base_rotamer identifies the starting point for each rotamer
				if ( rot == rotamer_set.get_base_rotamer(rot) ) {
					float solvE,atrE,repE,elecE,pairE,plane_totalE;
					get_sc_scE(aarot,aavrot,rotcoord,scaa,scaav,xyz_11s,
					 rotamer_set.get_rotactcoord(rot),actcoord(1,scres),rotres,scres,solvE,atrE,repE,
					 pairE,plane_totalE,elecE);

					// jk geometric solvation term due to fixed residues
					if ( geometric_sol::geometric_sol_flag ) {
						solvE = 0.;
						// any polar groups on the rotamer sidechain occluded by fixed sidechain
						solvE += res_res_geometric_sol(rotres,scres,aarot,aavrot,res(scres),res_variant(scres),
																					 rotcoord,xyz_11s,false,false,true,true);
						// any polar groups on fixed sidechain occluded by rotamer sidechain
						solvE += res_res_geometric_sol(scres,rotres,res(scres),res_variant(scres),aarot,aavrot,
																					 xyz_11s,rotcoord,false,false,true,true);
					}

					//glb if scale_res_energy_flag then SCALE atrE,solvE based on scres and rotres
					solvE = scale_res_energy(rotres,scres,solvE); //glb
					atrE = scale_res_energy(rotres,scres,atrE); //glb
					repE = scale_res_rep_energy(rotres,scres,repE); //glb

					//bk hydrogen bonding with fixed residues
					float schbE,sc_bbhbE;
					float srbbhbE,lrbbhbE; // short and long range bb hbond energy

					get_hbE(true,aarot,scaa,aavrot,scaav,rotres,scres,neighbors(rotres),
					 neighbors(scres),rotcoord,xyz_11s,schbE,srbbhbE,
					 lrbbhbE,sc_bbhbE);

					//glb if scale_res_energy_flag then SCALE schbE, srbbhbE, lrbbhbE,  based on scres and rotres
					schbE = scale_res_energy(rotres,scres,schbE); //glb
					srbbhbE = scale_res_energy(rotres,scres,srbbhbE); //glb
					lrbbhbE = scale_res_energy(rotres,scres,lrbbhbE); //glb

					float newenergy = pack_wts.Wsol() * solvE +
						pack_wts.Watr() * atrE +
						pack_wts.Wrep() * repE +
						pack_wts.Wpair() * pairE +
						pack_wts.Wplane_total() * plane_totalE +
						pack_wts.Whbond_sc() * schbE +
						pack_wts.Whbond_bb() * ( srbbhbE + lrbbhbE ) +
						pack_wts.Whbond_bb_sc() * sc_bbhbE;
					newenergy *= res_res_weight;
					energy1b_this_rotamer += newenergy;
					energy1b_base(rot) += newenergy;
				}

				float h2oE,h2ohbE;
				get_sc_sc_h2oE(aarot,aavrot,rotcoord,scaa,scaav,xyz_11s,
				 rotres,scres,h2oE,h2ohbE);
				energy1b_this_rotamer += res_res_weight * pack_wts.Wh2o()*(pack_wts.Wh2o_lj()*h2oE+h2ohbE);

			}      // neighbors
			//car add cst energy, sc to sc only
			//car only base rotamer, 	independent of neighbors
			if ( classical_constraints::BOUNDARY::get_constraints_exist() && rot == rotamer_set.get_base_rotamer(rot) ) {
				float cstE = classical_constraints::BOUNDARY::get_res_res_cstE(scres,rotres,scaa,scaav,aarot,aavrot,
					full_coord(1,1,scres),rotcoord,false,true,false,true);
				float const new_cst_energy = res_res_weight * cstE;
				energy1b_this_rotamer += new_cst_energy;
				energy1b_base(rot) += new_cst_energy;
			}

		//lin add cst into packer
			if ( pack_check_current_cst_set() && rot == rotamer_set.get_base_rotamer(rot)  ) {
				packer_cst_ns::Packer_cst_set const & packer_cst
						( pack_get_current_cst_set() );
				float cstE = packer_cst.get_res_res_cstE(scres,rotres,scaa,scaav,
					aarot,aavrot,full_coord(1,1,scres),rotcoord,false,true,false,true);
				float const new_cst_energy = res_res_weight * cstE;
				energy1b_this_rotamer += new_cst_energy;
				energy1b_base(rot) += new_cst_energy;
			}

		}
	}                 // end looping through fixed sidechains


	//jjh Get GB electrostatics
	if ( gen_born ) {
		for ( int bbres = 1; bbres <= total_residue; ++bbres ) {

			if ( ! eval_sc_bbE_for_energy1b &&
					 Task.get_designmap().repack_residue(bbres) && ( bbres != rotres ) ) {
				continue;
			}

			float & xyz_11b( full_coord(1,1,bbres) );

			float gb_elecE(0.);
			if ( bbres == rotres ) {
				gb_elecE = self_res_weight * gb_get_res_res_elecE( rotres, aarot, aavrot,
					rotcoord, rotamer_set.get_rot_born_radius(rot),
					rotres, aarot, aavrot, rotcoord, rotamer_set.get_rot_born_radius(rot));
			} else if ( !Task.get_designmap().repack_residue(bbres) ) {
				are_they_neighbors(aarot,res(bbres),rotcoord,xyz_11b,dis2,
			   are_neighbors);
				if ( are_neighbors ) {
					float const res_res_weight = Task.get_residue_weights(rotres, aarot, bbres, res(bbres) );
					gb_elecE = res_res_weight * gb_get_res_res_elecE( rotres, aarot, aavrot,
						rotcoord, rotamer_set.get_rot_born_radius(rot), bbres, res(bbres),
            res_variant(bbres), xyz_11b, born_radius(1,bbres));
				}
			}
			energy1b_this_rotamer += pack_wts.Wgb_elec() * gb_elecE;
		}
	}                 // end looping through backbone positions

	//bk      add energy from base rotamer
	if ( rot != rotamer_set.get_base_rotamer(rot) ) {
		energy1b_this_rotamer += energy1b_base(rotamer_set.get_base_rotamer(rot));
	}

	return energy1b_this_rotamer;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_base_2body_energy
///
/// @brief
///jk get 2-body energy for repacking
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
get_base_2body_energy(
	int const & rot1res,
	int const & aarot1,
	int const & aavrot1,
	FArray2Da_float coord1,
	FArray1Da_float actcoord1,
	int const & rot2res,
	int const & aarot2,
	int const & aavrot2,
	FArray2Da_float coord2,
	FArray1Da_float actcoord2,
	const PackerTask & Task
)
{

	using namespace aaproperties_pack;
	using namespace design;
	using namespace hbonds;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace template_pack;
	using namespace water;

	assert ( rot1res != rot2res);

	// return value
	float esum = 0;

	float solvE,atrE,repE,elecE,pairE,plane_totalE;
	get_sc_scE(aarot1,aavrot1,coord1,aarot2,aavrot2,coord2,actcoord1,actcoord2,
						 rot1res,rot2res,solvE,atrE,repE,pairE,plane_totalE,elecE);


	// jk geometric solvation term between rotamers
	if ( geometric_sol::geometric_sol_flag ) {

	  bool const bb( eval_sc_bbE_for_energy1b );

		solvE += res_res_geometric_sol( rot1res, rot2res, aarot1, aavrot1, aarot2,
		 aavrot2, coord1, coord2, bb, bb, true, true );

		solvE += res_res_geometric_sol( rot2res, rot1res, aarot2, aavrot2, aarot1,
		 aavrot1, coord2, coord1, bb, bb, true, true );
	}

	//bk get hydrogen bonding between residues
	float schbE,sc_bbhbE;
	float srbbhbE,lrbbhbE; // short and long range bb hbond energy

	get_hbE(true, aarot1, aarot2, aavrot1, aavrot2, rot1res, rot2res,
	 neighbors(rot1res), neighbors(rot2res), coord1, coord2,
	 schbE, srbbhbE, lrbbhbE, sc_bbhbE);

	// jk this allows energies computed for compatability with trie
	float cstE(0.);
	if ( ! eval_sc_bbE_for_energy1b ) {

		float dis2;
		bool are_neighbors;
		are_they_neighbors(aarot1,aarot2,coord1,coord2,dis2,
		 are_neighbors);
		if ( are_neighbors ) {

			float bb_solvE(0.),bb_atrE(0.),bb_repE(0.),bb_elecE(0.0);
			get_sc_bbE(aarot1,aavrot1,aarot2,aavrot2,coord1,coord2,
								 rot1res,rot2res,bb_solvE,bb_atrE,bb_repE,bb_elecE);
			atrE += bb_atrE;
			repE += bb_repE;
			if ( ! geometric_sol::geometric_sol_flag ) {
				solvE += bb_solvE;
			}
			get_sc_bbE(aarot2,aavrot2,aarot1,aavrot1,coord2,coord1,
								 rot2res,rot1res,bb_solvE,bb_atrE,bb_repE,bb_elecE);
			atrE += bb_atrE;
			repE += bb_repE;
			if ( ! geometric_sol::geometric_sol_flag ) {
				solvE += bb_solvE;
			}
			// jk note: rotamer-backbone geometric solvation term computed earlier (if needed)

		} // end if are_neighbors

		//car add cst rotamer to bb energy
		//car only base rotamer, independent of neighbors
		if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
			cstE += classical_constraints::BOUNDARY::get_res_res_cstE(rot1res,rot2res,aarot1,aavrot1,aarot2,
				aavrot2,coord1,coord2,true,false,false,true);
			cstE += classical_constraints::BOUNDARY::get_res_res_cstE(rot2res,rot1res,aarot2,aavrot2,aarot1,
				aavrot1,coord2,coord1,true,false,false,true);
		}

		//lin add cst into packer
		if ( pack_check_current_cst_set() ) {
			packer_cst_ns::Packer_cst_set const & packer_cst
				( pack_get_current_cst_set() );
			cstE += packer_cst.get_res_res_cstE(rot1res,rot2res,aarot1,aavrot1,aarot2,
				aavrot2,coord1,coord2,true,false,false,true);
			cstE += packer_cst.get_res_res_cstE(rot2res,rot1res,aarot2,aavrot2,aarot1,
				aavrot1,coord2,coord1,true,false,false,true);
		}

	} // end eval_sc_bbE_for_energy1b

		//lin add cst into packer
	if ( pack_check_current_cst_set() ) {
		packer_cst_ns::Packer_cst_set const & packer_cst
			( pack_get_current_cst_set() );
		cstE += packer_cst.get_res_res_cstE(rot1res,rot2res,aarot1,aavrot1,aarot2,
			aavrot2,coord1,coord2,false,true,false,true);
	}

	// glb SCALE atrE,solvE,schbE,sc_bbhbE, based on rot1res,rot2res
	solvE = scale_res_energy(rot1res,rot2res,solvE); //glb
	atrE = scale_res_energy(rot1res,rot2res,atrE); //glb
	schbE = scale_res_energy(rot1res,rot2res,schbE); //glb
	sc_bbhbE = scale_res_energy(rot1res,rot2res,sc_bbhbE); //glb

	esum =
	  pack_wts.Watr() * atrE +
		pack_wts.Wsol() * solvE +
		pack_wts.Wrep() * repE +
		pack_wts.Wpair() * pairE +
		pack_wts.Wplane_total() * plane_totalE +
		pack_wts.Whbond_sc() * schbE +
		pack_wts.Whbond_bb() * (srbbhbE+lrbbhbE) +
		pack_wts.Whbond_bb_sc() * sc_bbhbE +
		cstE;
	//std::cout<<"residue_weight: "<<rot1res<<" "<<" "<<Task.get_residue_weights(rot1res, aarot1, rot2res, aarot2 )<<std::endl;
	esum *= Task.get_residue_weights(rot1res, aarot1, rot2res, aarot2 );

	return esum;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_variant_2body_energy
///
/// @brief
///jk get 2-body energy for repacking
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
get_variant_2body_energy(
	int const & rot1res,
	int const & aarot1,
	int const & aavrot1,
	FArray2Da_float coord1,
	FArray1Da_float born_radius1,
	int const & rot2res,
	int const & aarot2,
	int const & aavrot2,
	FArray2Da_float coord2,
	FArray1Da_float born_radius2,
	const PackerTask & Task
)
{

	using namespace aaproperties_pack;
	using namespace design;
	using namespace disulfides::BOUNDARY;
	using namespace hbonds;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace template_pack;
	using namespace water;


	// return value
	float e_var_sum = 0.;

	float h2oE(0.),h2ohbE(0.);
	get_sc_sc_h2oE(aarot1,aavrot1,coord1,aarot2,aavrot2,
	  coord2,rot1res,rot2res,h2oE,h2ohbE);
	e_var_sum += pack_wts.Wh2o()*(pack_wts.Wh2o_lj()*h2oE+h2ohbE);

	//jjh twobody GB electrostatics
	float gb_elecE(0.);
	if ( pack_wts.Wgb_elec() != 0.0 ) {
		gb_elecE = gb_get_res_res_elecE( rot1res, aarot1, aavrot1,
		  coord1, born_radius1, rot2res, aarot2, aavrot2, coord2,
			born_radius2);
		e_var_sum += pack_wts.Wgb_elec()* gb_elecE;
	}

	//bs Add disulfide scores to rot-rot pair energy for the appropriate cys-cys pairs.
	if ( get_disulf_flag() && aarot1 == aa_cys && aarot2 == aa_cys &&
			 cys_pair_in_disulf(rot1res,rot2res) ) {
		e_var_sum += getTotWtdScThisDisulf_pack(rot1res,coord1,rot2res,coord2);
	}

	e_var_sum *= Task.get_residue_weights(rot1res, aarot1, rot2res, aarot2 );

	return e_var_sum;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_Paa_ppE
///
/// @brief
///bk derive energies from P(aa|phi,psi)
///
/// @detailed
///
/// @param  phi - [in/out]? -
/// @param  psi - [in/out]? -
/// @param  aa - [in/out]? - amino acid
/// @param  Paa_ppE - [in/out]? - -lnP(aa|phi,psi)
/// @param  dlog_Paa_dphi - [in/out]? - -lnP(aa|phi,psi)
/// @param  dlog_Paa_dpsi - [in/out]? - -lnP(aa|phi,psi)
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_Paa_ppE(
	float phi,
	float psi,
	int aa, // amino acid
	float & Paa_ppE, // -lnP(aa|phi,psi)
	float & dlog_Paa_dphi,
	float & dlog_Paa_dpsi
)
{

	using namespace param_aa;
	using namespace pdbstatistics_pack;
	//dr okay for dupes but not other nnaa where we won't have this info
	if ( !is_protein(aa) && !is_nonnatural(aa) ) {
		Paa_ppE = 0.0;
		dlog_Paa_dphi = 0.0;
		dlog_Paa_dpsi = 0.0;
		return;
	}

	// jk default values for chain breaks / terminii
	if ( std::abs(phi) < 0.0001 ) {
		phi = template_pack::neutral_phi;
	}
	if ( std::abs(psi) < 0.0001 ) {
		psi = template_pack::neutral_psi;
	}

//KMa phospho_ser
	if ( aa==param_aa::aa_sep ) aa=param_aa::aa_ser;

	if ( phi == -90. || psi == 130. ) { // chainbreak
		Paa_ppE = 0.0;
		dlog_Paa_dphi = 0.0;
		dlog_Paa_dpsi = 0.0;
		return;
	}

	float const phi_t = phi + 180.0;
	float const psi_t = psi + 180.0;
	float interp_p, dp_dphi, dp_dpsi;
	interpolate_2d_func_of_angles(phi_t,psi_t,Paa_pp(1,1,aa),interp_p,dp_dphi,
	 dp_dpsi);
	Paa_ppE = -std::log( interp_p / Paa(aa) );

	dlog_Paa_dphi = -( 1.0 / interp_p ) * dp_dphi;
	dlog_Paa_dpsi = -( 1.0 / interp_p ) * dp_dpsi;

}

////////////////////////////////////////////////////////////////////////////////
float
get_Paa_pp_deriv(
	int const aa,
	float const phi,
	float const psi,
	int const torsion
)
{
//db   copied from Chris's rama deriv function
//tsa cheap interface to Paa derivs

	using namespace param_torsion;

	float const rama_dont_care = { 0.0 };

	float deriv(0.); // Return value
	float tmp1,tmp2;

//---------------------------------------------------------------------------
	if ( torsion == phi_torsion ) {
		get_Paa_ppE(phi,psi,aa,tmp1,deriv,tmp2);
	} else if ( torsion == psi_torsion ) {
		get_Paa_ppE(phi,psi,aa,tmp1,tmp2,deriv);
	} else if ( torsion <= total_torsion ) {
		// Paa not dependent on omegas and chis
		deriv = rama_dont_care;
	} else {
		std::cout << "invalid torsion code in get_Paa_pp_deriv:" <<
		 SS( torsion ) << std::endl;;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return deriv;
}

//------------------------------------------------------------------------------
void
get_intra_resE(
	int const aa, // amino acid type
	int const aav, // amino acid variants
	FArray2Da_float coord, // coordinates
	float & atrE, // attractive energy
	float & repE // repulsive energy
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;

	atrE = 0.0;
	repE = 0.0;
	//dr okay for dupes but not other nnaa where we won't have this info
	//lin check ligaa intra res
	if ( !is_protein(aa) && !is_nonnatural(aa) && !is_ligand(aa) ) return;

	coord.dimension( 3, MAX_ATOM() );

//chu intra_res energy, all the atoms within the residue, currently only LJ

// jk if geometric solvation is used, intra res solvation is computed later

	float solE = 0.0, d2, repE_old;
	float const cp_weight = { 1.0 };
	int const ict_size1 = intra_cp_table.size1();

	for ( int atom1 = 1, atome = natoms(aa,aav); atom1 <= atome; ++atom1 ) {
		float & coord_a1( coord(1,atom1) );
		int const fullatom_type_1aa = fullatom_type(atom1,aa,aav);
		for ( int atom2 = atom1+1, lict = intra_cp_table.index(atom1,atom2,aa,aav);
		 atom2 <= atome; ++atom2, lict += ict_size1 ) {
			float const intra_cp = intra_cp_table[ lict ]; // intra_cp_table(atom1,atom2,aa,aav)
			if ( intra_cp != 0.0 ) {
				repE_old = repE;
				fast_pairenergy( coord_a1, coord(1,atom2), fullatom_type_1aa,
				 fullatom_type(atom2,aa,aav), solE, atrE, repE, d2, cp_weight );
				repE = repE_old + intra_cp * ( repE - repE_old );
			}
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_with_hydrogens
///
/// @brief
///bk  retrieve energy between atom1 and atom2 and any hydrogens that
///bk  are attached to atom1 and atom2.
///
/// @detailed
///
/// @param  atom1 - [in/out]? -
/// @param  atom2 - [in/out]? -
/// @param  aa1 - [in/out]? -
/// @param  aa2 - [in/out]? -
/// @param  aav1 - [in/out]? -
/// @param  aav2 - [in/out]? -
/// @param  coord1 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  coord2 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  solvE - [in/out]? -
/// @param  atrE - [in/out]? -
/// @param  repE - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
inline
void
fast_pairenergy_with_hydrogens(
	int const res1,
	int const res2,
	int const atom1,
	int const atom2,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2DB_float & coord1, // Dims: ( 3, MAX_ATOM )
	FArray2DB_float & coord2, // Dims: ( 3, MAX_ATOM )
	float & solvE,
	float & atrE,
	float & repE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace pdbstatistics_pack;

//bk   local
	float d2;
	float cp_weight;

	int const atype1 = fullatom_type(atom1,aa1,aav1);
	int const atype2 = fullatom_type(atom2,aa2,aav2);

//cmd This is for turning Rosetta-built 5' phosphates into ignored virtual
// atoms. Causes a 15% hit in performance time.
//int const atype1 = design::dna_interface ? sub_missing_atomtypes(atom1,
//  aa1,aav1,res1) : fullatom_type(atom1,aa1,aav1);
//int const atype2 = design::dna_interface ? sub_missing_atomtypes(atom2,
//  aa2,aav2,res2) : fullatom_type(atom2,aa2,aav2);

	if ( count_pair(res1,atom1,aa1,aav1,res2,atom2,aa2,aav2,true,cp_weight) ) {
		fast_pairenergy(coord1(1,atom1),coord2(1,atom2),atype1,atype2,
		 solvE,atrE,repE,d2,cp_weight);
	} else {
		d2 =
		 square( coord1(1,atom1) - coord2(1,atom2) ) +
		 square( coord1(2,atom1) - coord2(2,atom2) ) +
		 square( coord1(3,atom1) - coord2(3,atom2) );
	}

//bk   hydrogens are done separately so that a very short cutoff can be
//bk   used before entering the hbond energy calculation - this can be
//bk   done because hydrogens are only being used for repulsions

	if ( d2 < hydrogen_interaction_cutoff ) {
		fast_pairenergy_attached_h(res1,res2,atom1,atom2,aa1,aa2,aav1,aav2,
		 coord1,coord2,repE,elecE);
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_flexible
///
/// @brief
///
/// wrapper for calling directly to fast_pairenergy_with_hydrogens with
/// flexible (input) atom range
///
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
/// ashworth
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////

void
fast_pairenergy_flexible(
	int res1,
	int aa1,
	int startatom1,
	int endatom1,
	FArray2Da_float tcoord,
	int res2,
	int aa2,
	int startatom2,
	int endatom2,
	FArray2Da_float tcoord2,
	float & solE,
	float & atrE,
	float & repE,
  float & elecE
)
{
	using namespace param; // MAX_ATOM()

	tcoord.dimension( 3, MAX_ATOM() );
	tcoord2.dimension( 3, MAX_ATOM() );

	for ( int atom1 = startatom1; atom1 <= endatom1; ++atom1 ) {
		for ( int atom2 = startatom2; atom2 <= endatom2; ++atom2 ) {
			fast_pairenergy_with_hydrogens(res1,res2,atom1,atom2,aa1,aa2,1,1,
																		tcoord,tcoord2,solE,atrE,repE,elecE);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_bb_bbE
///
/// @brief
///bk get energy between non-hydrogen backbone atoms
///
/// @detailed
///
/// @param  res1 - [in/out]? -
/// @param  res2 - [in/out]? -
/// @param  aa1 - [in/out]? -
/// @param  aa2 - [in/out]? -
/// @param  aav1 - [in/out]? -
/// @param  aav2 - [in/out]? -
/// @param  coord1 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  coord2 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  repE - [in/out]? -
/// @param  atrE - [in/out]? -
/// @param  solE - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
inline
void
get_bb_bbE(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2DB_float & coord1, // Dims: ( 3, MAX_ATOM )
	FArray2DB_float & coord2, // Dims: ( 3, MAX_ATOM )
	float & repE,
	float & atrE,
	float & solE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	repE = 0.0;
	atrE = 0.0;
	solE = 0.0;

	if ( res1 == res2 ) {
		return;
	}

	for ( int atom1 = 1, atom1e = first_scatom(aa1,aav1),
	 atom2e = first_scatom(aa2,aav2); atom1 < atom1e; ++atom1 ) {
		for ( int atom2 = 1; atom2 < atom2e; ++atom2 ) {
			fast_pairenergy_with_hydrogens(res1,res2,atom1,atom2,aa1,aa2,aav1,aav2,
			 coord1,coord2,solE,atrE,repE,elecE);
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_bb_bbE_P
///
/// @brief
///bk get energy between non-hydrogen backbone atoms
///jjh this version is for proxy arrays
///
/// @detailed
///
/// @param  res1 - [in/out]? -
/// @param  res2 - [in/out]? -
/// @param  aa1 - [in/out]? -
/// @param  aa2 - [in/out]? -
/// @param  aav1 - [in/out]? -
/// @param  aav2 - [in/out]? -
/// @param  coord1 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  coord2 - [in/out]? - Dims: ( 3, MAX_ATOM )
/// @param  repE - [in/out]? -
/// @param  atrE - [in/out]? -
/// @param  solE - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_bb_bbE_P(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1, // Dims: ( 3, MAX_ATOM )
	FArray2Da_float coord2, // Dims: ( 3, MAX_ATOM )
	float & repE,
	float & atrE,
	float & solE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );

	repE = 0.0;
	atrE = 0.0;
	solE = 0.0;

	if ( res1 == res2 ) {
		return;
	}

	for ( int atom1 = 1, atom1e = first_scatom(aa1,aav1),
	 atom2e = first_scatom(aa2,aav2); atom1 < atom1e; ++atom1 ) {
		for ( int atom2 = 1; atom2 < atom2e; ++atom2 ) {
			fast_pairenergy_with_hydrogens(res1,res2,atom1,atom2,aa1,aa2,aav1,aav2,
			 coord1,coord2,solE,atrE,repE,elecE);
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_bbE_B
///
/// @brief Same as get_sc_bbE but with non-proxy array arguments (for speed)
///
/// @detailed
///bk sidechain backbone energies (only considers non-hydrogen backbone
///bk atoms, doesn't consider explicit waters)
///
/// @param  aasc - [in/out]? - sidechain amino acid
/// @param  aavsc - [in/out]? - sidechain amino acid variant
/// @param  aabb - [in/out]? - backbone amino acid
/// @param  aavbb - [in/out]? - backbone amino acid variant
/// @param  sccoord - [in/out]? - sidechain coordinates dimension( 3, MAX_ATOM() )
/// @param  bbcoord - [in/out]? - backbone coordinates dimension( 3, MAX_ATOM() )
/// @param  scres - [in/out]? - sidechain residue number
/// @param  bbres - [in/out]? - backbone redidue number
/// @param  sc_bbsolvE - [in/out]? - sidechain backbone solvation energy
/// @param  sc_bbatrE - [in/out]? - sidechain backbone attractive energy
/// @param  sc_bbrepE - [in/out]? - sidechain backbone repulsive energy
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
inline
void
get_sc_bbE_B(
	int aasc,
	int aavsc,
	int aabb,
	int aavbb,
	FArray2DB_float & sccoord, // dimension( 3, MAX_ATOM )
	FArray2DB_float & bbcoord, // dimension( 3, MAX_ATOM )
	int scres,
	int bbres,
	float & sc_bbsolvE,
	float & sc_bbatrE,
	float & sc_bbrepE,
  float & sc_bbelecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	sc_bbsolvE = 0.0;
	sc_bbatrE = 0.0;
	sc_bbrepE = 0.0;
  sc_bbelecE = 0.0;

	for ( int scatom = first_scatom(aasc,aavsc), scatome = nheavyatoms(aasc,aavsc),
	 bbatome = first_scatom(aabb,aavbb); scatom <= scatome; ++scatom ) {
		for ( int bbatom = 1; bbatom < bbatome; ++bbatom ) {
			fast_pairenergy_with_hydrogens(scres,bbres,scatom,bbatom,aasc,aabb,aavsc,
			 aavbb,sccoord,bbcoord,sc_bbsolvE,sc_bbatrE,sc_bbrepE, sc_bbelecE);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_bbE
///
/// @brief
///bk sidechain backbone energies (only considers non-hydrogen backbone
///bk atoms, doesn't consider explicit waters)
///
/// @detailed
///
/// @param  aasc - [in/out]? - sidechain amino acid
/// @param  aavsc - [in/out]? - sidechain amino acid variant
/// @param  aabb - [in/out]? - backbone amino acid
/// @param  aavbb - [in/out]? - sidechain coordinates
/// @param  sccoord - [in/out]? - sidechain coordinates
/// @param  bbcoord - [in/out]? - backbone coordinates
/// @param  scres - [in/out]? - sidechain residue number
/// @param  bbres - [in/out]? - backbone redidue number
/// @param  sc_bbsolvE - [in/out]? - sidechain backbone solvation energy
/// @param  sc_bbatrE - [in/out]? - sidechain backbone attractive energy
/// @param  sc_bbrepE - [in/out]? - sidechain backbone repulsive energy
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_bbE(
	int aasc,
	int aavsc,
	int aabb,
	int aavbb,
	FArray2Da_float sccoord,
	FArray2Da_float bbcoord,
	int scres,
	int bbres,
	float & sc_bbsolvE,
	float & sc_bbatrE,
	float & sc_bbrepE,
  float & sc_bbelecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	sccoord.dimension( 3, MAX_ATOM() );
	bbcoord.dimension( 3, MAX_ATOM() );

	sc_bbsolvE = 0.0;
	sc_bbatrE = 0.0;
	sc_bbrepE = 0.0;
  sc_bbelecE = 0.0;

	for ( int scatom = first_scatom(aasc,aavsc), scatome = nheavyatoms(aasc,aavsc),
	 bbatome = first_scatom(aabb,aavbb); scatom <= scatome; ++scatom ) {
		for ( int bbatom = 1; bbatom < bbatome; ++bbatom ) {
			fast_pairenergy_with_hydrogens(scres,bbres,scatom,bbatom,aasc,aabb,aavsc,
			 aavbb,sccoord,bbcoord,sc_bbsolvE,sc_bbatrE,sc_bbrepE,sc_bbelecE);
		}
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_scE_B
///
/// @brief Same as get_sc_scE but with non-proxy array arguments (for speed)
///
/// @detailed
///
/// @param  aa1 - [in/out]? - amino acid 1
/// @param  aav1 - [in/out]? - amino acid variant 1
/// @param  coord1 - [in/out]? - coordinates amino acid 1 dimension( 3, MAX_ATOM )
/// @param  aa2 - [in/out]? - amino acid 2
/// @param  aav2 - [in/out]? - amino acid variant 2
/// @param  coord2 - [in/out]? - coordinates amino acid 2 dimension( 3, MAX_ATOM )
/// @param  actcoord1 - [in/out]? - coordinates of action centers dimension( 3 )
/// @param  actcoord2 - [in/out]? - dimension( 3 )
/// @param  res1 - [in/out]? - residue number for sc1
/// @param  res2 - [in/out]? - residue number for sc2
/// @param  solvE - [in/out]? - solvation energy
/// @param  atrE - [in/out]? - atractive part of LJ
/// @param  repE - [in/out]? - repulsive energy
/// @param  pairE - [in/out]? - statistical pair energy
/// @param  plane_totalE - [in/out]? - statistical orientation dependent
///       pi/cation/hydrophobic energy
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
inline
void
get_sc_scE_B(
	int aa1,
	int aav1,
	FArray2DB_float & coord1, // dimension( 3, MAX_ATOM )
	int aa2,
	int aav2,
	FArray2DB_float & coord2, // dimension( 3, MAX_ATOM )
	FArray1DB_float & actcoord1, // dimension( 3 )
	FArray1DB_float & actcoord2, // dimension( 3 )
	int res1,
	int res2,
	float & solvE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

//bk gets energies between amino acid sidechains

	solvE = 0.0;
	atrE = 0.0;
	repE = 0.0;
  elecE = 0.0;
	pairE = 0.0;
	plane_totalE = 0.0;

	{ for ( int atom1 = first_scatom(aa1,aav1), atom1e = nheavyatoms(aa1,aav1),
	 atom2s = first_scatom(aa2,aav2), atom2e = nheavyatoms(aa2,aav2);
	 atom1 <= atom1e; ++atom1 ) {
		for ( int atom2 = atom2s; atom2 <= atom2e; ++atom2 ) {
			fast_pairenergy_with_hydrogens(res1,res2,atom1,atom2,aa1,aa2,aav1,aav2,
			 coord1,coord2,solvE,atrE,repE,elecE);
		}
	} } //Objexx:SGM Extra {} scope is a VC++ work-around

	float tmp1;
	get_pairtermE(aa1,aa2,res1,res2,actcoord1,actcoord2,pairE,tmp1);
//km comment this call out for now
// put it back in Nov. 1, 2006.
  if (param_pack::pack_wts.Wplane_total() > 0.0) find_plane_orientation(aa1,aav1,aa2,aav2,coord1,coord2,plane_totalE);

// **temporary**  use to change packing energy function during relax
	if ( get_score_variant() == "loc_lj" ) {
		if ( std::abs( res1 - res2 ) > 4 ) atrE *= 3.0;
		solvE *= 0.6;
	} else if ( get_score_variant() == "lk_sol" ) {
		solvE = 0.0;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_scE
///
/// @brief
///bk gets energies between amino acid sidechains
///
/// @detailed
///
/// @param  aa1 - [in/out]? - amino acid 1
/// @param  aav1 - [in/out]? - amino acid variant 1
/// @param  coord1 - [in/out]? - coordinates amino acid 1
/// @param  aa2 - [in/out]? - amino acid 2
/// @param  aav2 - [in/out]? - amino acid variant 2
/// @param  coord2 - [in/out]? - coordinates amino acid 2
/// @param  actcoord1 - [in/out]? -
/// @param  actcoord2 - [in/out]? - coordinates of action centers
/// @param  res1 - [in/out]? - residue number for sc1
/// @param  res2 - [in/out]? - residue number for sc2
/// @param  solvE - [in/out]? - solvation energy
/// @param  atrE - [in/out]? - atractive part of LJ
/// @param  repE - [in/out]? - repulsive energy
/// @param  pairE - [in/out]? - statistical pair energy
/// @param  plane_totalE - [in/out]? - statistical orientation dependent
///       pi/cation/hydrophobic energy
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_scE(
	int aa1,
	int aav1,
	FArray2Da_float coord1,
	int aa2,
	int aav2,
	FArray2Da_float coord2,
	FArray1Da_float actcoord1,
	FArray1Da_float actcoord2,
	int res1,
	int res2,
	float & solvE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );
	actcoord1.dimension( 3 );
	actcoord2.dimension( 3 );

	solvE = 0.0;
	atrE = 0.0;
	repE = 0.0;
  elecE = 0.0;
	pairE = 0.0;
	plane_totalE = 0.0;

	{ for ( int atom1 = first_scatom(aa1,aav1), atom1e = nheavyatoms(aa1,aav1),
	 atom2s = first_scatom(aa2,aav2), atom2e = nheavyatoms(aa2,aav2);
	 atom1 <= atom1e; ++atom1 ) {
		for ( int atom2 = atom2s; atom2 <= atom2e; ++atom2 ) {
			fast_pairenergy_with_hydrogens(res1,res2,atom1,atom2,aa1,aa2,aav1,aav2,
			 coord1,coord2,solvE,atrE,repE,elecE);
		}
	} } //Objexx:SGM Extra {} scope is a VC++ work-around

	float tmp1;
	get_pairtermE(aa1,aa2,res1,res2,actcoord1,actcoord2,pairE,tmp1);
//km comment this call out for now.
// put it back in Nov. 1, 2006.
  if (param_pack::pack_wts.Wplane_total() > 0.0) find_plane_orientation(aa1,aav1,aa2,aav2,coord1,coord2,plane_totalE);

// **temporary**  use to change packing energy function during relax
	if ( get_score_variant() == "loc_lj" ) {
		if ( std::abs( res1 - res2 ) > 4 ) atrE *= 3.0;
		solvE *= 0.6;
	} else if ( get_score_variant() == "lk_sol" ) {
		solvE = 0.0;
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_res_resE
///
/// @brief
///bk residue-residue energies, all atoms on each residue. solvation only
///bk between sidechain atoms, and between backbone atoms only lj is looked at.
///
/// @detailed
///
/// @param  aa1 - [in/out]? - amino acid type
/// @param  aa2 - [in/out]? -
/// @param  aav1 - [in/out]? - amino acid variants
/// @param  aav2 - [in/out]? -
/// @param  coord1 - [in/out]? - coordinates dimension( 3, MAX_ATOM )
/// @param  coord2 - [in/out]? -
/// @param  actcoord1 - [in/out]? - dimension( 3 )
/// @param  actcoord2 - [in/out]? -
/// @param  res1 - [in/out]? - residue numbers
/// @param  res2 - [in/out]? -
/// @param  solE - [in/out]? - solvation energy
/// @param  atrE - [in/out]? - attractive energy
/// @param  repE - [in/out]? - repulsive energy
/// @param  pairE - [in/out]? - statistical pair energy
/// @param  plane_totalE - [in/out]? - statistical pi/cation/hydrophobic energy
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_res_resE(
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2DB_float & coord1, // dimension( 3, MAX_ATOM )
	FArray2Da_float coord2,
	FArray1DB_float & actcoord1, // dimension( 3 )
	FArray1Da_float actcoord2,
	int res1,
	int res2,
	float & solE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
)
{
	using namespace param;

	coord2.dimension( 3, MAX_ATOM() );
	actcoord2.dimension( 3 );

	float sol,atr,rep,pair,elec,plane;

//bk sidechain-sidechain
	get_sc_scE_B(aa1,aav1,coord1,aa2,aav2,coord2,actcoord1,actcoord2,res1,res2,
	 sol,atr,rep,pair,plane,elec);
	atrE = atr;
	repE = rep;
	pairE = pair;
	plane_totalE = plane;
	solE = sol;
  elecE = elec;

//bk sidechain-backbone
	get_sc_bbE_B(aa1,aav1,aa2,aav2,coord1,coord2,res1,res2,sol,atr,rep,elec);
	atrE += atr;
	repE += rep;
	solE += sol;
  elecE += elec;

	get_sc_bbE_B(aa2,aav2,aa1,aav1,coord2,coord1,res2,res1,sol,atr,rep,elec);
	atrE += atr;
	repE += rep;
	solE += sol;
  elecE += elec;

//bk backbone-backbone energy
	get_bb_bbE(res1,res2,aa1,aa2,aav1,aav2,coord1,coord2,rep,atr,sol,elec);
	repE += rep;
	atrE += atr;
	solE += sol;
  elecE += elec;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_pairtermE
///
/// @brief
///bk corrected pair term
///
/// @detailed
///
/// @param  aa1 - [in/out]? - amino acids
/// @param  aa2 - [in/out]? - amino acids
/// @param  res1 - [in/out]? -
/// @param  res2 - [in/out]? -
/// @param  actcoord1 - [in/out]? - action center coordinates
/// @param  actcoord2 - [in/out]? - action center coordinates
/// @param  pairE - [in/out]? -
/// @param  dpairE_dr - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///ctsa 10-15-02 added interpolation and derivative
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_pairtermE(
	int const aa1,
	int const aa2,
	int const res1,
	int const res2,
	FArray1Da_float actcoord1,
	FArray1Da_float actcoord2,
	float & pairE,
	float & dpairE_dr
)
{
	using namespace misc;
	using namespace param_aa;
	using namespace pdbstatistics_pack;
	using namespace template_pack;

//Objexx: Only pass these to argument arrays so don't need to set dimensions
//  actcoord1.dimension( 3 );
//  actcoord2.dimension( 3 );

//     fixed parameters
	int const maxbin = { 3 };


//bk local variables
	int e1,e2,r12bin;
	float r12,r12bin_real,r12_binerr;
	float pair_lhood_ratio_low,pair_lhood_ratio_high,pair_lhood_ratio;
//------------------------------------------------------------------------------
	pairE = 0.0;
	dpairE_dr = 0.0;

	//// cbk 3/9/00 only look at pair term between polar amino acids
	if ( aa_is_nonpolar(aa1) || aa_is_nonpolar(aa2) ||
	 ( !is_protein(aa1)  ||  !is_protein(aa2) ) ) return;
	//dr okay for dupes but not other nnaa where we won't have this info

	// jk option to suppress computing pair term for histidine
	// (numbers are skewed due to metal-binding sites)
	if ( design::no_his_his_pairE && ( ( aa1 == aa_his ) && ( aa2 == aa_his ) ) ) return;

	if ( std::abs(res1-res2) < pair_score_min_sep ) return;

	e1 = 1;
	e2 = 1;
	if ( neighbors(res1) > pair_score_cb_thresh ) e1 = 2;
	if ( neighbors(res2) > pair_score_cb_thresh ) e2 = 2;


	//// cbk 01/26/01 changing pair term to work on a finer bin
	////
	//// ctsa - add interpolation to pair term
	////
	distance_bk(actcoord1,actcoord2,r12);

	//// 1. get the lower of the two bin averages bracketing
	////   r12 and set r12bin to this value. consider 'bin average'
	////   to exist halfway through bin's range
	////
	//// 2. find the error between the lowbin average and the
	////   actual value of r12, in bin units
	////
	r12bin_real = ((r12-(pair_score_binbase+0.5*pair_score_binrange))/
	 pair_score_binrange) + 1.;

	//// first bin officially ranges from 3. A <= r12 < 4.5 A,
	////  but we use it to represent r12 down to 0. A, therefore
	////  we need to adjust negative bin values
	////
	if ( r12bin_real < 1.0 ) r12bin_real = 1.0;

	r12bin = static_cast< int >( r12bin_real );

	if ( r12bin > maxbin ) return;

	r12_binerr = r12bin_real - r12bin;

	////
	//// interpolate aa pair lhood ratio between low and high bins...
	////
	pair_lhood_ratio_low = ( paircorr(aa1,aa2,e1,e2,r12bin) +
	 paircorr(aa2,aa1,e2,e1,r12bin) ) / 2.0;

	if ( r12bin == maxbin ) {
		pair_lhood_ratio_high = 1.;
	} else if ( r12bin_real == 1. ) {
		pair_lhood_ratio_high = pair_lhood_ratio_low;
	} else {
		pair_lhood_ratio_high = ( paircorr(aa1,aa2,e1,e2,r12bin+1) +
		 paircorr(aa2,aa1,e2,e1,r12bin+1) ) / 2.0;
	}

	pair_lhood_ratio = pair_lhood_ratio_low +
	 r12_binerr * ( pair_lhood_ratio_high - pair_lhood_ratio_low );

	////
	////  and finally get the energy + derivative
	////
	pairE = -std::log( pair_lhood_ratio );
	dpairE_dr = -(1/pair_lhood_ratio) *
	 ( pair_lhood_ratio_high - pair_lhood_ratio_low ) / pair_score_binrange;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_ligenergies
///
/// @brief
///    move all ligand energy subroutine into this function
///    this function should be called in order to get all ligand energy
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
get_ligenergies(
  FArray1D_float & energy1b,
	RotamerSet const & rotamer_set
)
{
	using namespace aaproperties_pack;
	using namespace design;
	using namespace hbonds;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace runlevel_ns;
	using namespace template_pack;
	using namespace water;
	using namespace ligand;

//lin move all ligand energy subroutine into this function
//lin this function should be called in order to get all ligand energy

	FArray1D_float energy1b_base( rotamer_set.nrotamers(), 0. );
	float newenergy;
	int aarot,rotres,aavrot;
	float lig_solE,lig_couE,lig_virE,lig_h2oE,lig_hbE,lig_atrE,lig_repE;

	FArray2D_float f1( 3, MAX_ATOM() );
	FArray2D_float f2( 3, MAX_ATOM() );


//bk loop through rotamers, calculate self energies, rotamer-template energies
	energy1b = 0.;
	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {
		rotres = rotamer_set.report_seqpos(rot);
		aarot = rotamer_set.report_aa(rot);
		aavrot = rotamer_set.report_aav(rot);
		FArray2D_float const & rotcoord_11r = rotamer_set.get_rotcoord(rot);

//mj add energies from rotamer - ligand interactions
		if ( get_ligand_flag() ) {             // start check full atom ligand flag
//bk if an res_variant contains atoms in common with another variant,
//bk try to calculate the energy of those atoms only once, the array
//bk base_rotamer identifies the starting point for each rotamer
			if ( rot == rotamer_set.get_base_rotamer(rot) ) {           // start base_rotamer identifaction

//mj compute virtual energies
				get_sc_ha_virtualE(rotres,aarot,aavrot,rotcoord_11r,lig_virE,
													 false,true,true,(*ligand::ligand_one));

//mj compute vdw atr, vdw rep
				get_sc_haE(rotres,aarot,aavrot,rotcoord_11r,lig_solE,lig_atrE,
									 lig_repE,false,true,(*ligand::ligand_one));


//mj compute h bond energies
				get_sc_ha_hbondE(rotres,aarot,aavrot,rotcoord_11r,false,true,(*ligand::ligand_one),lig_hbE);

//mj compute electrostatics
				if ( !gen_born )
					get_sc_ha_coulombE(rotres,aarot,aavrot,rotcoord_11r,ligand::ligand_one,lig_couE,false,
														 true);
//jjh get the gb interactions between the residues and the ligand
				else{
					FArray2D_float het_atom_coord;
					FArray1D_float het_atom_charge;
        			FArray1D_int het_atom_type;
					ligand::ligand_one->get_FArray2D_of_coordinates(ligand::ligand_one->atom_vector,het_atom_coord);
					ligand::ligand_one->get_FArray1D_of_charge(ligand::ligand_one->atom_vector, het_atom_charge);
       				ligand::ligand_one->get_FArray1D_of_atom_type(ligand::ligand_one->atom_vector, het_atom_type);
					lig_couE = gb_get_ligand_elecE(natoms( aarot, aavrot ), MAX_ATOM(),
																				 rotcoord_11r, rotamer_set.get_rot_born_radius(rot),
																				 atomic_charge( 1, aarot, aavrot ),
																				 fullatom_type( 1, aarot, aavrot),
																				 ligand::ligand_one->atom_vector.size(), HETERO_ATOM_MAX(),
																				 het_atom_coord( 1, 1 ),
																				 ligand::ligand_one->hetero_born_radius( 1 ),
																				 het_atom_charge( 1 ),
																				 het_atom_type( 1 ),
																				 false
																				 );
				}
//mj add energies
				newenergy =
				 pack_wts.Wlig_sol() * lig_solE +
				 pack_wts.Wlig_atr() * lig_atrE +
				 pack_wts.Wlig_rep() * lig_repE +
				 pack_wts.Wlig_cou() * lig_couE +
				 pack_wts.Wlig_hb() * lig_hbE +
				 pack_wts.Wlig_vir() * lig_virE;
				energy1b(rot) += newenergy;
				energy1b_base(rot) += newenergy;

//mj print energies
				// if ( runlevel >= verbose )
				// std::cout << "ligand energies: " <<
				//	SS( pack_wts.Wlig_sol() * lig_solE ) << ' ' <<
				//	SS( pack_wts.Wlig_atr() * lig_atrE ) << ' ' <<
				//	SS( pack_wts.Wlig_rep() * lig_repE ) << ' ' <<
				//	SS( pack_wts.Wlig_hb() * lig_hbE ) << ' ' <<
				//	SS( pack_wts.Wlig_cou() * lig_couE ) << ' ' <<
				//	SS( pack_wts.Wlig_vir() * lig_virE ) << ' ' << newenergy << std::endl;
			}

//mj compute h2o energies
			get_sc_ha_h2oE(rotres,aarot,aavrot,rotcoord_11r,lig_h2oE,(*ligand::ligand_one));

//mj add h20 energy
			energy1b(rot) += pack_wts.Wlig_h2o() * lig_h2oE;

//mj print energies
			// if ( runlevel >= verbose )
			// std::cout << "ligand water: " <<
			//	pack_wts.Wlig_h2o()*lig_h2oE << std::endl;

		}                                         // end check full atom ligand flag

//mj end rotamer - ligand interactions

//

//bk      add energy from base rotamer
		if ( rot != rotamer_set.get_base_rotamer(rot) ) {
			energy1b(rot) += energy1b_base(rotamer_set.get_base_rotamer(rot));
		}

	} // end looping through rotamers

	//mj end

}

////////////////////////////////////////////////////////////////////////////////
/// @begin compute_ligand_energies
///
/// @brief
///    Computes ligand energies and stores in an interaction
/// graph.
///
/// @detailed
///		This function is written to be used in flexible ligand docking.
/// The current version relies on a mapping of the interaction graph nodes
/// where the ith ligand corresponds to the num_protein_moltenres+ith node.
/// This relationship is constructed through a call to
/// create_moltenres_2_resid_mapping passing resid_2_moltenres as the input
/// FArray. The function then proceeds to zero the energies and edges of all ligand
/// nodes. Once the ligand nodes have been zeroed the function proceeds to assign
/// all the one body energies. For ligand nodes this consists of internal energy
/// of the conformation, interaction with any
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////


void
compute_ligand_energies(
	PrecomputedPairEnergiesInteractionGraph * ig,
	DesignMap const & design_map,
	RotamerSet const & rotamer_set,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
){

	//kwk setting up parameters used in the rest of the function
	int const nmoltenres=ig->get_num_nodes();
	//kwk zero ligand nodes zero 1 body energy and erase all edges to ligand nodes
	for( int ii=1; ii<=nmoltenres;++ii){
		int iiresid=rotamer_set.moltenres_2_resid(ii);
		//kwk if molten residue if a ligand node
		if(iiresid<=0 && size_t(-1*iiresid)>ligand::ligand_ptr_vector.size()){
			ig->zero_one_body_energies_for_node( ii );
			ig->drop_all_edges_for_node( ii );
		}
	}


	//kwk One body interactions for ligands include ligand internal energy
	//kwk ligand sidechain interactions with immovable sidechains
	//kwk In fixed backbone situation the ligand interactions with the backbone
	//kwk would also be included, however following the logic apl outline in
	//kwk setting of the trie-rotamers ligand interactions with backbone energies will be considered
	//kwk two body to allow for use of the forth coming flexible backbone algorithms

	//kwk first iterate over all molten residues to locate the ligand moltenres
	for( int ii=1; ii<=nmoltenres;++ii){
		int iiresid=rotamer_set.moltenres_2_resid(ii);
		//kwk check for ligand molten residue
		if(iiresid>=0 || size_t(-1*iiresid)<ligand::ligand_ptr_vector.size()){continue;}
		//kwk set ligand vector index for this molten residue
		Ligand * c_ligand_ptr= ligand::ligand_ptr_vector[size_t(-1*iiresid-1)];
		c_ligand_ptr->recompute_ligand_interface=true;//
		detect_ligand_interface(*c_ligand_ptr, true, total_residue, res, full_coord);//kwk recomputation of the interface for each conformation may be excessive. Also this call really needs to take place elsewhere. A change to a neighbor list similar to surface mode might be warranted
		for(int jj=1; jj<=rotamer_set.num_states_for_moltenres(ii);++jj){
			if(c_ligand_ptr->change_to_ligand_conformation(size_t(jj-1))<0){
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}
			c_ligand_ptr->get_ligand_internal_energy(false);//kwk update ligand internal energy fields should have already been initialized.
			float sumE_1b=0.0; //kwk zero 1 body energy for this conformation
			//kwk note to self weights need to optimized
			sumE_1b+=param_pack::packer_misc_parameters::Wlig_int_atr *c_ligand_ptr->lig_int_atrE
				+param_pack::packer_misc_parameters::Wlig_int_rep *c_ligand_ptr->lig_int_repE
				+param_pack::packer_misc_parameters::Wlig_int_solv *c_ligand_ptr->lig_int_solvE
				+param_pack::packer_misc_parameters::Wlig_int_hb *c_ligand_ptr->lig_int_hbE
				+param_pack::packer_misc_parameters::Wlig_int_cou *c_ligand_ptr->lig_int_coulombE
				+param_pack::packer_misc_parameters::Wlig_int_dihed *c_ligand_ptr->lig_int_dihedE;
		//kwk note to self the above should really be encapsulation into a function returning the internal energy of a ligand
			for ( int bgres = 1; bgres <= total_residue; ++bgres ){  // bg = background, ie !protamers(bgres)

			if (design_map.repack_residue(bgres) || !interface::int_res(bgres)) continue;//kwk if  not repack residue or not interface residue jump to next iteration

			int bgaa=res(bgres);//kwk set residue amino acid type
			int bgaav=res_variant(bgres); //kwk set residue amino acid variant

			//variables needed in energy function calls.
			float solvE=0.0; //solvation energy
			float atrE=0.0; // van der waals attractive energy
			float repE=0.0; // van der Waals repulsive energy
			float hbE=0.0; // hydrogen bonding energy
			float couE=0.0;// electrostatic energy
			float virE=0.0;// virtual atom energy
			FArray2D_float f1,f2; //arrays needed for hbond function call

			float const & coord( full_coord(1,1,bgres) );//kwk set residue coordinates note to self may need to make it a Farray

			//get sc ligand energy for virtual atoms
			get_sc_ha_virtualE(bgres,bgaa, bgaav, coord,virE, true,true,true,*c_ligand_ptr);
			//get sc ligand energy solv atr rep evaluate for both side chain and backbone
			get_sc_haE( bgres, bgaa, bgaav, coord, solvE, atrE, repE, true, true, *c_ligand_ptr);
			//get sc ligand hydorgen bond energy
			get_sc_ha_hbondE( bgres, bgaa, bgaav, coord, true, true, *c_ligand_ptr, hbE);//no deriv

			//get sc ligand electrostatic energy
			if ( !param_pack::packer_logical::gen_born )
				get_sc_ha_coulombE(bgres,bgaa,bgaav,coord, c_ligand_ptr,couE,true,true);
//jjh get the gb interactions between the residues and the ligand
			else{
				FArray2D_float het_atom_coord;
				FArray1D_float het_atom_charge;
        FArray1D_int het_atom_type;
				c_ligand_ptr->get_FArray2D_of_coordinates(c_ligand_ptr->atom_vector,het_atom_coord);
				c_ligand_ptr->get_FArray1D_of_charge(c_ligand_ptr->atom_vector, het_atom_charge);
        c_ligand_ptr->get_FArray1D_of_atom_type(c_ligand_ptr->atom_vector, het_atom_type);

				couE = gb_get_ligand_elecE(
							aaproperties_pack::natoms( bgaa, bgaav ), param::MAX_ATOM(),
							coord, template_pack::born_radius( 1, bgres ),
							aaproperties_pack::atomic_charge( 1, bgaa, bgaav ),
							aaproperties_pack::fullatom_type( 1, bgaa, bgaav),
							c_ligand_ptr->atom_vector.size(),
							param::HETERO_ATOM_MAX(), het_atom_coord,
							c_ligand_ptr->hetero_born_radius,
							het_atom_charge, het_atom_type,
							false);
			}// gen_born if statement

			if(water::water_flags::use_hetero_h2o){
				float h2oE=0.0;
				get_sc_ha_h2oE(bgres,bgaa,bgaav, coord, h2oE,(*ligand::ligand_one));
				sumE_1b+=param_pack::pack_wts.Wlig_h2o() * h2oE;
			}
			sumE_1b+=param_pack::pack_wts.Wlig_sol() * solvE +
				 param_pack::pack_wts.Wlig_atr() * atrE +
				 param_pack::pack_wts.Wlig_rep() * repE +
				 param_pack::pack_wts.Wlig_cou() * couE +
				 param_pack::pack_wts.Wlig_hb() * hbE +
				 param_pack::pack_wts.Wlig_vir() * virE;
		}// background residue for loop
		//kwk set 1 body energy for conformation or state jj of ligand or node ii
		ig->add_to_nodes_one_body_energy(ii, jj, sumE_1b);

	}// end of jj for loop
	//kwk calculate two body energies.
		for( int jj=1; jj<=nmoltenres; jj++){
			if( ii==jj){continue;}
			int jjresid=rotamer_set.moltenres_2_resid(jj);
			int jjnrotoffset = rotamer_set.nrotoffset(jj);
			FArray2D_bool aa_are_they_neighbors( param::MAX_AA(), param::MAX_AA(), false );
			int const ii_num_states = rotamer_set.num_states_for_moltenres(ii);
			int const jj_num_states = rotamer_set.num_states_for_moltenres(jj);
			FArray2D_float oversize_energy_array( jj_num_states, ii_num_states, 0.);
			for(int kk=1; kk<=ii_num_states; ++kk){
				if(c_ligand_ptr->change_to_ligand_conformation(size_t(kk-1))<0){
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}
				detect_ligand_interface(*c_ligand_ptr, true, total_residue, res, full_coord);
				//kwk recomputation of the interface for each conformation may
				//kwk be excessive. Also this call really needs to take place
				//kwk elsewhere. A change to a neighbor list similar to surface
				//kwk mode might be warranted
				if( jjresid <0 && jj > ii){
					// if ligand molten residue
					size_t ligand_vector_index=-1*jjresid-1;
					for( int ll=1; ll<=jj_num_states;++ll){
						if(ligand::ligand_ptr_vector[ligand_vector_index]->change_to_ligand_conformation(size_t(ll-1))<0){
							utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
						}
						float lig_lig_repE=0.0;
						float lig_lig_atrE=0.0;
						float lig_lig_solvE=0.0;
						float lig_lig_couE=0.0;
						float lig_lig_hbE=0.0;
						float total_lig_ligE=0.0;
						total_lig_ligE=get_ligand_ligandE(*c_ligand_ptr,
											 *ligand::ligand_ptr_vector[ligand_vector_index],
											 lig_lig_repE,lig_lig_atrE,
											 lig_lig_solvE,lig_lig_couE,
											 lig_lig_hbE);
						if( total_lig_ligE >= 0.001 || total_lig_ligE <= -0.001){
							aa_are_they_neighbors(1,1)=true;
							oversize_energy_array(kk,ll)=total_lig_ligE;
						}
					}// end of ll for loop
				}else{
					if( jjresid > 0){
					if( !interface::int_res(jjresid)) continue;
					//kwk calculate ligand sidechain energies
					//kwk note to self may want to figure out how to handle base_rotamer options in get_ligand_energies
						for( int ll=1; ll<=jj_num_states;++ll){
							int llrotindex = jjnrotoffset + ll;

							FArray2D_float const & coord = rotamer_set.get_rotcoord(llrotindex);
							int llaa = rotamer_set.report_aa(llrotindex);
							int llaav = rotamer_set.report_aav(llrotindex);

							//variables needed in energy function calls.
							float sumE_2b=0.0;
							float solvE=0.0; //solvation energy
							float atrE=0.0; // van der waals attractive energy
							float repE=0.0; // van der Waals repulsive energy
							float hbE=0.0; // hydrogen bonding energy
							float couE=0.0;// electrostatic energy
							float virE=0.0;// virtual atom energy
							FArray2D_float f1,f2; //arrays needed for hbond function call

							//get sc ligand energy for virtual atoms
							get_sc_ha_virtualE(jjresid,llaa, llaav, coord, virE,
																 true,true,true,*c_ligand_ptr);
							//get sc ligand energy solv atr rep evaluate for both side chain and backbone
							get_sc_haE( jjresid, llaa, llaav, coord, solvE, atrE, repE,
										true, true, *c_ligand_ptr);
							//get sc ligand hydorgen bond energy
							get_sc_ha_hbondE( jjresid, llaa, llaav, coord, true, true, *c_ligand_ptr, hbE); // no deriv

							//get sc ligand electrostatic energy
							if ( !param_pack::packer_logical::gen_born )
								get_sc_ha_coulombE(jjresid,llaa,llaav,coord,
											c_ligand_ptr,couE,true,true);
				//jjh get the gb interactions between the residues and the ligand
							else{
								FArray2D_float het_atom_coord;
								FArray1D_float het_atom_charge;
				      			FArray1D_int het_atom_type;
								c_ligand_ptr->get_FArray2D_of_coordinates(
									c_ligand_ptr->atom_vector,het_atom_coord);
								c_ligand_ptr->get_FArray1D_of_charge(
									c_ligand_ptr->atom_vector, het_atom_charge);
				      			c_ligand_ptr->get_FArray1D_of_atom_type(
				      				c_ligand_ptr->atom_vector, het_atom_type);

								couE = gb_get_ligand_elecE(
											aaproperties_pack::natoms( llaa, llaav ), param::MAX_ATOM(),
											coord, template_pack::born_radius( 1, jjresid ),
											aaproperties_pack::atomic_charge( 1, llaa, llaav ),
											aaproperties_pack::fullatom_type( 1, llaa, llaav),
											c_ligand_ptr->atom_vector.size(),
											param::HETERO_ATOM_MAX(), het_atom_coord,
											c_ligand_ptr->hetero_born_radius,
											het_atom_charge, het_atom_type,
											false);
							}// gen_born if statement

							if(water::water_flags::use_hetero_h2o){
								float h2oE=0.0;
								get_sc_ha_h2oE(jjresid,llaa,llaav, coord, h2oE,(*ligand::ligand_one));
								sumE_2b+=param_pack::pack_wts.Wlig_h2o() * h2oE;
							}
							sumE_2b+=param_pack::pack_wts.Wlig_sol() * solvE +
								 param_pack::pack_wts.Wlig_atr() * atrE +
								 param_pack::pack_wts.Wlig_rep() * repE +
								 param_pack::pack_wts.Wlig_cou() * couE +
								 param_pack::pack_wts.Wlig_hb() * hbE +
								 param_pack::pack_wts.Wlig_vir() * virE;
							if( sumE_2b >= 0.001 || sumE_2b <= -0.001){
								aa_are_they_neighbors(1,llaa)=true;
								oversize_energy_array(ll,kk)=sumE_2b;
							}
						}// ll for loop
					}
				}// jjresid > 0 if
			}// kk for loop
			ig->add_edge( jj,ii);
			ig->set_sparse_aa_info_for_edge(ii, jj, aa_are_they_neighbors );
			ig->add_to_two_body_energies_for_edge(ii,jj,oversize_energy_array);
			ig->declare_edge_energies_final(ii,jj);
		}//end jj for loop
}// end of ii for loop

return;
}// end of function
////////////////////////////////////////////////////////////////////////////////
/// @begin add_to_energy1b
///
/// @brief
///    add additional energy term to current energy1b array
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
add_to_energy1b(
	FArray1Da_float energy1b,
	FArray1Da_float subenergy1b,
	int const nrotamers
)
{
	using namespace param;

	energy1b.dimension( nrotamers );
	subenergy1b.dimension( nrotamers );

	for ( int rot = 1; rot <= nrotamers; ++rot ) {
	  energy1b(rot) += subenergy1b(rot);
	}// end looping through rotamers
}


////////////////////////////////////////////////////////////////////////////////
/// @begin bump_check
///
/// @brief
///bk looks for bumps between a sidechain and the rest of a protein
///
/// @detailed
///
/// @param  aa - [in/out]? - amino acid of sidechain
/// @param  aav - [in/out]? - amino acid variant
/// @param  res - [in/out]? - residue number
/// @param  coord - [in/out]? - coordinates of sidechain
/// @param  full_coord - [in/out]? - coordinates of protein
/// @param  res - [in/out]? - protein sequence
/// @param  res_variant - [in/out]? -
/// @param  design_map
/// @param  total_residue - [in/out]? - number of residues in the protein
/// @param  bumpenergy - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
bump_check(
	int const aa,
	int const aav,
	int const resnum,
	FArray2Da_float coord,
	FArray3Da_float full_coord,
	FArray1Da_int res,
	FArray1Da_int res_variant,
	const DesignMap & design_map,
	int & total_residue,
	float & bumpenergy
)
{
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;

	coord.dimension( 3, MAX_ATOM() );
	full_coord.dimension( 3, MAX_ATOM(), star );
	res.dimension( star );
	res_variant.dimension( star );

//bk local variables
	int bbres,scres,scaa,i;
	FArray1D_float dummyactcoord1( 3 );
	FArray1D_float dummyactcoord2( 3 );
	float solvE, atrE, repE, pairE, plane_totalE, dis2, h2oE, h2ohbE;
  float elecE;

	bumpenergy = 0.0;

	// loop through backbone positions
	for ( bbres = 1; bbres <= total_residue; ++bbres ) {

		distance2_bk(coord(1,1),full_coord(1,2,bbres),dis2);
		if ( dis2 > 18*18 ) goto L60;

		get_sc_bbE( aa, aav, res(bbres), res_variant(bbres), coord,
		 full_coord(1,1,bbres), resnum, bbres, solvE, atrE, repE, elecE );

		get_sc_bb_h2oE( aa, aav, res(bbres), res_variant(bbres), coord,
		 full_coord(1,1,bbres), resnum, bbres, h2oE, h2ohbE );

		///jjh Assume the non-water portions of DNA are from a native, and
		///jjh don't clash
		if( !is_DNA( aa ) ) {
			bumpenergy += ( pack_wts.Watr() * atrE ) + ( pack_wts.Wrep() * repE );
		}
		bumpenergy += pack_wts.Wh2o() * h2oE;

L60:;
	} // end looping through backbone positions

	for ( i = 1; i <= 3; ++i ) {
		dummyactcoord1(i) = 1.0;
		dummyactcoord2(i) = 3.0;
	}

	// loop through sidechain positions
	for ( scres = 1; scres <= total_residue; ++scres ) {
		if ( resnum == scres ) continue; // ignore self

		// fixed neighbors only
		if ( design_map.repack_residue(scres) ) continue;


		// distance cutoff for speed
		distance2_bk( coord(1,1), full_coord(1,2,scres), dis2 );
		if ( dis2 > 18*18 ) continue;

		scaa = res(scres);

		get_sc_scE( aa, aav, coord, scaa, res_variant(scres), full_coord(1,1,scres),
		 dummyactcoord1, dummyactcoord2, resnum, scres, solvE, atrE, repE,pairE,
		 plane_totalE,elecE );

		get_sc_sc_h2oE( aa, aav, coord, scaa, res_variant(scres),
		 full_coord(1,1,scres), resnum, scres, h2oE, h2ohbE );

		///jjh Assume the non-water portions of DNA are from a native, and
		///jjh don't clash
		if( !is_DNA( aa ) ) {
				bumpenergy += ( pack_wts.Watr() * atrE ) + ( pack_wts.Wrep() * repE );
		}
		bumpenergy += pack_wts.Wh2o() * h2oE;

	} // end looping through fixed sidechains

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_attached_h
///
/// @brief
///bk  retrieve energies involving hydrogens attached to atom1 and atom2.
///bk  currently only repulsive is evaluated with hydrogens
///
/// @detailed
///
/// @param  atom1 - [in/out]? -
/// @param  atom2 - [in/out]? -
/// @param  aa1 - [in/out]? -
/// @param  aa2 - [in/out]? -
/// @param  aav1 - [in/out]? -
/// @param  aav2 - [in/out]? -
/// @param  coord1 - [in/out]? -
/// @param  coord2 - [in/out]? -
/// @param  repE - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fast_pairenergy_attached_h(
	int const res1,
	int const res2,
	int const atom1,
	int const atom2,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE,
  float & elecE
)
{
	using namespace aaproperties_pack;
	using namespace param;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );


	float cp_weight;
	int const n2e = nhydrogens_on_atm(atom2,aa2,aav2);
	int const l2s = hydrogens_on_atm.index(1,atom2,aa2,aav2);
	float & coord2_a2( coord2(1,atom2) );
	int const fullatom_type_a2 = fullatom_type(atom2,aa2,aav2);

  float const chrg_a2 = atomic_charge(atom2,aa2,aav2);


//cmd This is for turning Rosetta-built 5' phosphates into ignored virtual
// atoms. Causes a 15% hit in performance time.
//int const fullatom_type_a2 = design::dna_interface ? sub_missing_atomtypes
//  (atom2,aa2,aav2,res2) : fullatom_type(atom2,aa2,aav2);

	int const lf10 = fullatom_type.index(1,aa1,aav1) - 1;
	int const lf20 = fullatom_type.index(1,aa2,aav2) - 1;
	for ( int n1 = 1, l1 = hydrogens_on_atm.index(n1,atom1,aa1,aav1),
	 n1e = nhydrogens_on_atm(atom1,aa1,aav1); n1 <= n1e; ++n1, ++l1 ) {
		int const hatom1 = hydrogens_on_atm[ l1 ];
		 // hydrogens_on_atm(n1,atom1,aa1,aav1)
		float & coord1_h1( coord1(1,hatom1) );
		int const fullatom_type_h1 = fullatom_type[ lf10 + hatom1 ];
		 // fullatom_type(hatom1,aa1,aav1)

    float const chrg_h1 = atomic_charge[ lf10 + hatom1 ];


		if ( count_pair(res1,hatom1,aa1,aav1,res2,atom2,aa2,aav2,true,cp_weight) )
     fast_pairenergy_hydrogens(coord1_h1,coord2_a2,
     fullatom_type_h1,fullatom_type_a2,chrg_h1, chrg_a2,repE,elecE,cp_weight);

		for ( int n2 = 1, l2 = l2s; n2 <= n2e; ++n2, ++l2 ) {
			int const hatom2 = hydrogens_on_atm[ l2 ];
			 // hydrogens_on_atm(n2,atom2,aa2,aav2)
      float const chrg_h2 = atomic_charge[ lf20 + hatom2 ];
      if ( count_pair(res1,hatom1,aa1,aav1,res2,hatom2,aa2,aav2,true,cp_weight) )
       fast_pairenergy_hydrogens(coord1_h1,coord2(1,hatom2),
       fullatom_type_h1,fullatom_type[ lf20 + hatom2 ],chrg_h1,chrg_h2,repE,elecE,cp_weight);
			// fullatom_type(hatom2,aa2,aav2)
		}
	}

	float & coord1_a1( coord1(1,atom1) );
	int const fullatom_type_a1 = fullatom_type(atom1,aa1,aav1);
  float const chrg_a1 = atomic_charge(atom1,aa1,aav1);



//cmd This is for turning Rosetta-built 5' phosphates into ignored virtual
// atoms. Causes a 15% hit in performance time.
//int const fullatom_type_a1 = design::dna_interface ? sub_missing_atomtypes
//  (atom1,aa1,aav1,res1) : fullatom_type(atom1,aa1,aav1);

	for ( int n2 = 1, l2 = l2s; n2 <= n2e; ++n2, ++l2 ) {
		int const hatom2 = hydrogens_on_atm[ l2 ];
    float const chrg_h2 = atomic_charge[ lf20 + hatom2 ];

     // hydrogens_on_atm(n2,atom2,aa2,aav2)
    if ( count_pair(res1,atom1,aa1,aav1,res2,hatom2,aa2,aav2,true,cp_weight) )
     fast_pairenergy_hydrogens(coord1_a1,coord2(1,hatom2),
     fullatom_type_a1,fullatom_type[ lf20 + hatom2 ],chrg_a1,chrg_h2,repE,elecE,cp_weight);
			// fullatom_type(hatom2,aa2,aav2)
	}

}




////////////////////////////////////////////////////////////////////////////////
/// @begin dang_from_chi
///
/// @brief
///cc given two chi angles, what is the angle between them
///
/// @detailed
///
/// @param  chi1 - [in/out]? -
/// @param  chi2 - [in/out]? -
/// @param  dang - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
dang_from_chi(
	float chi1,
	float chi2,
	float & dang
)
{

	if ( std::abs(chi1-chi2) <= 180.0 ) dang = std::abs(chi1-chi2);
	if ( std::abs(chi1-chi2) >= 180.0 ) dang = 360.0f - std::abs(chi1-chi2);

}

//////////////////////////////////////////////////////////////////////////////
/// @begin wcentroid_closest_chi_initializer
///
/// @brief
///
/// @detailed
///
/// @param  wcentroid_closest_chi - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
wcentroid_closest_chi_initializer( FArray1D_int & wcentroid_closest_chi )
{
	int i = 0;
	wcentroid_closest_chi( ++i ) = 0;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 2;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 0;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 4;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 2;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 0;
	wcentroid_closest_chi( ++i ) = 2;
	wcentroid_closest_chi( ++i ) = 4;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 1;
	wcentroid_closest_chi( ++i ) = 2;
	wcentroid_closest_chi( ++i ) = 1;
	if ( add_pser() ) {
	wcentroid_closest_chi( ++i ) = 3;//KMa phospho_serine
	}
	if ( dna_enabled() ) {
		wcentroid_closest_chi( ++i ) = 3;  // KMa phospho_ser
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
	}
	if( get_enable_ligaa_flag() ){
		wcentroid_closest_chi( ++i ) = 0;
		wcentroid_closest_chi( ++i ) = 0;
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_wcentroid_closest_chi
///
/// @brief
///
/// @detailed
///
/// @param  chi - [in/out]? - highest chi angle controling the centroid
/// @param  aa - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_wcentroid_closest_chi(
	int & chi, // highest chi angle controling the centroid
	int aa
)
{
	// (phi = chi #0)
	using namespace param;

	static FArray1D_int const wcentroid_closest_chi( MAX_AA(),
	 wcentroid_closest_chi_initializer );

	//// Note that I and L are aproximate b/c chi2 can affect the centroid
	//// position too!
	// A C D E F G H I K L M N P Q R S T V W Y G A C TrGrArCrU

	chi = wcentroid_closest_chi(aa);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin put_wcentroid
///
/// @brief
///bk given the coordinates for an amino acid sidechain, determine the coordinates
///bk for its location of action, i.e. for a lysine its amino group
///
/// @detailed
///
/// @param  aa_coord - [in/out]? - coordinates of sidechain
/// @param  wcentroidxyz - [in/out]? -
/// @param  aa - [in/out]? - amino acid type
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
put_wcentroid(
	FArray2Da_float aa_coord, // coordinates of sidechain
	FArray1Da_float wcentroidxyz,
	int aa // amino acid type
)
{

	using namespace param;
	using namespace param_aa;

	aa_coord.dimension( 3, MAX_ATOM() );
	wcentroidxyz.dimension( 3 );

	if ( aa == aa_ala ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,5);
		}
	} else if ( aa == aa_cys ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,6);
		}
	} else if ( aa == aa_asp ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,7)+aa_coord(i,8))/3.0f;
		}
	} else if ( aa == aa_glu ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,7)+aa_coord(i,8)+aa_coord(i,9))/3.0f;
		}
	} else if ( aa == aa_phe ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,11))/2.0f;
		}
	} else if ( aa == aa_gly ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,2));
		}
	} else if ( aa == aa_his ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,7)+aa_coord(i,8))/2.0f;
		}
	} else if ( aa == aa_ile ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,7)+aa_coord(i,8))/3.0f;
		}
	} else if ( aa == aa_lys ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,9);
		}
	} else if ( aa == aa_leu ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,7)+aa_coord(i,8))/3.0f;
		}
	} else if ( aa == aa_met ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,7);
		}
	} else if ( aa == aa_asn ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,7)+aa_coord(i,8))/3.0f;
		}
	} else if ( aa == aa_pro ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,5)+aa_coord(i,6)+aa_coord(i,7))/3.0f;
		}
	} else if ( aa == aa_gln ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,7)+aa_coord(i,8)+aa_coord(i,9))/3.0f;
		}
	} else if ( aa == aa_arg ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,9);
		}
	} else if ( aa == aa_ser ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,6);
		}
	} else if ( aa == aa_thr ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,6);
		}
	} else if ( aa == aa_val ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,5)+aa_coord(i,6)+aa_coord(i,7))/3.0f;
		}
	} else if ( aa == aa_trp ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,8)+aa_coord(i,10))/2.0f;
		}
	} else if ( aa == aa_tyr ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = (aa_coord(i,6)+aa_coord(i,11))/2.0f;
		}
	}
//KMa phospho_ser
	else if ( aa == aa_sep ) {
		for ( int i = 1; i <= 3; ++i ) {
			wcentroidxyz(i) = aa_coord(i,6);
		}
	}




}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_phibin
///
/// @brief
///
/// @detailed
///
/// @param  phi - [in/out]? -
/// @param  psi - [in/out]? -
/// @param  iphi - [in/out]? -
/// @param  ipsi - [in/out]? -
/// @param  resnum - [in/out]? -
/// @param  total_residue - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_phibin(
	float phi,
	float psi,
	int & iphi,
	int & ipsi,
	int resnum,
	int total_residue
)
{
	int jot;

	// jk default values for chain breaks / terminii
	if ( std::abs(phi) < 0.0001 ) {
		phi = template_pack::neutral_phi;
	}
	if ( std::abs(psi) < 0.0001 ) {
		psi = template_pack::neutral_psi;
	}

	iphi = static_cast< int >( phi+185 );
	jot = iphi/(-360);
	if ( iphi < 0 ) ++jot;
	iphi = (iphi+jot*360)/10;
	iphi = mod(iphi,36)+1;

	ipsi = static_cast< int >( psi+185 );
	jot = ipsi/(-360);
	if ( ipsi < 0 ) ++jot;
	ipsi = (ipsi+jot*360)/10;
	ipsi = mod(ipsi,36)+1;

	if ( resnum == 1 ) {
		iphi = 10;
	} else if ( resnum == total_residue ) {
		ipsi = 32;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_phi_interpolate_bin
///
/// @brief
/// Determines the bracketing bins in the Dunbrack map for interpolating
/// between different phi and psi values when getting rotamer chi values
/// and standard deviations.
///
/// @detailed
///
/// @param[in]   phi - in
/// Backbone phi value for the site under consideration.
///
/// @param[in]   psi - in
/// Backbone psi value for the site under consideration.
///
/// @param[out]  phibin - out
/// lower bin for interpolation of phi angles
///
/// @param[out]  psibin - out
/// lower bin for interpolation of psi angles
///
/// @param[out]  phibin_next out
/// upper bin for interpolation of phi angles
///
/// @param[out]  psibin_next out
/// upper bin for interpolation of psi angles
///
/// @param[out]  phi_err out
/// Difference between actual phi angle and bin value
///
/// @param[out]  psi_err out
/// Difference between actual psi angle and bin value
///
/// @param[in]   seqpos - in
/// The position under consideration
///
/// @param[in]   total_residue - in
/// Total number of residues - used to see if this is the final residue
///
/// @global_read
///
/// No include files.
///
/// @global_write
///
/// No include files.
///
/// @remarks
///
/// Treats first and last as special cases, with identical lower and
/// upper bins, which makes sure there's a flat derivative.
///
/// @references
///
/// @authors
///
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_phi_interpolate_bin(
	float phi,
	float psi,
	int & phibin,
	int & psibin,
	int & phibin_next,
	int & psibin_next,
	float & phi_err,
	float & psi_err,
	int seqpos,
	int total_residue
)
{
//ctsa
//  Get bins appropriate for bilinear interpolation. To work with the
//   dunbrack maps, we add 180 to reflect that bin 1 is -180 degrees,
//   and we add 5 (binrange/2.) to reflect that dunbrack's
//   bins are labeled at the *center* of the binrange rather
//   than the min value.
//ctsa

// fixed parameters
	float const binrange = { 10. };

	// jk default values for chain breaks / terminii
	if ( std::abs(phi) < 0.0001 ) {
		phi = template_pack::neutral_phi;
	}
	if ( std::abs(psi) < 0.0001 ) {
		psi = template_pack::neutral_psi;
	}

// parameters

// return
//******************************************************************************
	interpolate_get_angle_bins(phi+185.,binrange,phibin,phibin_next,phi_err);
	interpolate_get_angle_bins(psi+185.,binrange,psibin,psibin_next,psi_err);

//  adjust edges
	if ( seqpos == 1 ) {
		phibin = 10;
		phibin_next = 10; // force flat deriv
		phi_err = 0.0;
	} else if ( seqpos == total_residue ) {
		psibin = 32;
		psibin_next = 32; // force flat deriv
		psi_err = 0.0;
	}

}

///////////////////////////////////////////////////////////////////////////////
// handle symmetric poses to correct for edge effects
//
void
symmetrize_neighbors(
	FArray1DB_int & neighbors
)
{
	// check for current pose:
	if ( !score_check_current_pose() &&
			 !minimize_check_current_pose() &&
			 !pack_check_current_pose() ) return; // no pose

	pose_ns::Pose const * pose( 0 );
	if ( score_check_current_pose() ) {
		pose = &score_get_current_pose();
	} else if ( minimize_check_current_pose() ) {
		pose = &minimize_get_current_pose();
	} else if ( pack_check_current_pose() ) {
		pose = &pack_get_current_pose();
	}
	if ( !pose->symmetric() ) return; // not symmetric

	pose_ns::Symmetry_info const & s( pose->symmetry_info() );

	int const nres( pose->total_residue_for_scoring() );
	for ( int i=1; i<= nres; ++i ) {
		if ( s.chi_independent( i ) ) {
			int const num_clones( s.chi_clones(i).size() );
			for ( int j=0; j< num_clones; ++j ) {
				int const clone_pos( s.chi_clones(i)[j] );
				neighbors( clone_pos ) = neighbors( i );
			}
		}
	}

	// we could use this code to handle the non-pose symm case
// 	// handle symmetric case
// 	// this will correct for edge effects
// 	if ( design_sym::num_clones > 0 ) {
// 		for ( int i=1; i<= total_residue; ++i ) {
// 			if ( design_sym::clone_follows(i) ) {
// 				neighbors(i) = neighbors( design_sym::clone_follows(i) );
// 			}
// 		}
// 	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin make_neighbor_info
///
/// @brief
/// Sets some arrays that determine which positions can interact with each other
/// and how many neighbors each position has.
///
/// @detailed
/// Calls are_they_neighbors() to determine if two sites are interacting.
/// Sets the 2d array 'neighbor_list' to 'true' for neighbor pairs and 'false'
/// otherwise.  Also counts up how many neighbors each site has in the
/// array 'neighbors'.
///
/// @param[in]   res - in
/// The amino acid type at each position
///
/// @param[in]   total_residue - in
/// The total number of residues in the structure.
///
/// @param[in]   full_coord - in
/// The coordinates for the structure
///
/// @param[out]  neighborlist - out
/// A bool array that is returned - true if (A,B) are neighbors
///
/// @param[out]  neighbors - out
/// This array has the total number of neighbors for each position.
///
/// @global_read
/// Just the parameters max_cb_neighbors
///
/// @global_write
/// No global data is altered.
///
/// @remarks
///
/// @references
///
/// @authors
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
make_neighbor_info(
	FArray1DB_int const & res,
	int total_residue,
	FArray3DB_float const & full_coord,
	FArray2DB_bool & neighborlist,
	FArray1DB_int & neighbors
)
{

	using namespace ligand;
	using namespace param;
	using namespace pdbstatistics_pack;

	int aa1, aa2;
	float dis2;
	bool neighbor;

	int const neighborlist_size1 = neighborlist.size1();
	int const xyz_size12 = full_coord.size1() * full_coord.size2();

	float const dis2_cutoff = { 100.0 };
	for ( int res1 = 1; res1 <= total_residue; ++res1 ) {
		neighbors(res1) = 1;
	}

	for ( int res1 = 1; res1 < total_residue; ++res1 ) {
		aa1 = res(res1);
		float const & xyz_111( full_coord(1,1,res1) );
		for ( int res2 = res1+1,
		 lxyz = full_coord.index(1,1,res2),
		 l12 = neighborlist.index(res1,res2),
		 l21 = neighborlist.index(res2,res1);
		 res2 <= total_residue; ++res2, lxyz+=xyz_size12, l12+=neighborlist_size1, ++l21 ) {

			aa2 = res(res2);

			are_they_neighbors(aa1,aa2,xyz_111,full_coord[lxyz],dis2,neighbor); // [lxyz]==(1,1,res2)
			neighborlist[ l12 ] = neighborlist[ l21 ] = neighbor;
			// neighborlist(res1,res2) = neighborlist(res2,res1) = neighbor

			if ( dis2 < dis2_cutoff ) {
				++neighbors(res1);
				++neighbors(res2);
				if (dis2 < 1.0e-8 && res1 != res2)
					if (runlevel_ns::benchmark || runlevel_ns::runlevel > runlevel_ns::standard) {
						std::cout << "Warning: make_neighbor_info considers atoms at dist zero to be neighbors. r"<<res1<<" aa"<<aa1<<", r"<<res2<<" aa"<<aa2<<std::endl;
					}
			}
		}
		neighborlist(res1,res1) = false; // same res
	}
	neighborlist(total_residue,total_residue) = false; // same res

	//mj for ligands
	if ( get_ligand_flag() ) {
		ligand::ligand_one->lig_neighbors = 0;
		int contacts;
		for ( int res1 = 1; res1 <= total_residue; ++res1 ) {
			detect_number_of_contacts(res,full_coord,res1,contacts,(*ligand::ligand_one));
			neighbors(res1) += ( contacts + 9 ) / 10;
			ligand::ligand_one->lig_neighbors += ( contacts + 9 ) / 10;
//mj      if ( contacts > 0 ) std::cout << "xxx" << SS( res1 ) <<
//mj       SS( contacts ) << SS( ( contacts + 9) / 10 ) << std::endl;
		}
	}
//mj end ligands
	for ( int res1 = 1; res1 <= total_residue; ++res1 ) {
		if ( neighbors(res1) > max_cb_neighbors ) neighbors(res1) = max_cb_neighbors;
	}

	// handle symmetric poses
	symmetrize_neighbors( neighbors );

}

////////////////////////////////////////////////////////////////////////////////
/// @begin make_neighbor_indexno
///
/// @brief
/// Determines the 'neighbor count' for two positions.
///
/// @detailed
/// Given two positions A and B such that position B > position A,
/// the array neighbor_indexno() stores which neighbor of A position B is.
/// So, if position A interacts (is a neighbor with) 10 other positions,
/// and position B is 8th on that list, then neighbor_indexno(A,B) and
/// neighbor_indexno(B,A) are set to 8.
///
/// @param[in]   total_residue - in
/// The number os positions in the structure.
///
/// @param[out]  neighbor_indexno - out
/// The array of neighbor counts between two positions.
///
/// @param[in]   design_map - in
///
/// @param[in]   full_coord - in
/// The coordinates of the structre, which are required to determine if
/// two sites are neighbors.
///
/// @global_read
/// A few global parameters are accessed, such as MAX_AA and MAX_PACK_NEIGHBORS.
///
/// @global_write
/// No global variables are altered.
///
/// @remarks
///
/// @references
///
/// @authors
///
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
make_neighbor_indexno(
	FArray2Da_short neighbor_indexno,
	const DesignMap & design_map,
	pose_ns::Pose & pose
)
{

	using namespace param;

	neighbor_indexno.dimension( MAX_RES(), MAX_RES() );

//ctsa
//ctsa  record the global order of neighboring residues of higher residue number
//ctsa

//ctsa  local
	bool is_neighbor;
	float dis2;

//------------------------------------------------------------------------------

	for ( int res1 = 1; res1 <= pose.total_residue(); ++res1 ) {
		int res1_neighbor_count = 0;
		for ( int res2 = res1+1; res2 <= pose.total_residue(); ++res2 ) {
			neighbor_indexno(res1,res2) = 0;
			neighbor_indexno(res2,res1) = 0;

			for ( int aa1 = 1, aae = MAX_AA(); aa1 <= aae; ++aa1 ) {
				if ( !design_map.has_rotamers(res1,aa1) ) goto L312;
				for ( int aa2 = 1; aa2 <= aae; ++aa2 ) {
					if ( !design_map.has_rotamers(res2,aa2) ) goto L325;
					are_they_neighbors(aa1,aa2,pose.full_coord()(1,1,res1),pose.full_coord()(1,1,res2),dis2,
					 is_neighbor);
					if ( is_neighbor ) {
						++res1_neighbor_count;
						if ( res1_neighbor_count > MAX_PACK_NEIGHBORS ) {
							std::cout << "STOP :: MAX_PACK_NEIGHBORS exceeded" << std::endl;
							std::cout << "MAX_PACK_NEIGHBORS: " << MAX_PACK_NEIGHBORS << std::endl;
							utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
						}
						neighbor_indexno(res1,res2) = res1_neighbor_count;
						neighbor_indexno(res2,res1) = res1_neighbor_count;
//ctsa
//ctsa  move on to next residue, more neighboring aa combinations don't make a difference
//ctsa
						goto L542;
					}
L325:;
				}
L312:;
			}
L542:;
		}
	}

}



////////////////////////////////////////////////////////////////////////////////
/// @begin put_cah
///
/// @brief
/// Places all alpha hydrogens on the protein by calling place_atom().
///
/// @detailed
///
/// @param  full_coord - [in/out]?
/// This is just the full coordinate set. It is altered when
/// the HAs are built.
///
/// @param[in]   first - in
/// The starting residue for building HAs
///
/// @param[in]   last - in
/// The ending residue for building HAs
///
/// @param[in]   res - in
/// This array stores the amino acid identies of the entire structure
///
/// @param[in]   res_variant - in
/// This array stores the variant number for each amino acid in the structure
///
/// @global_read
/// The global array defining where each amino acid's HA is located is
/// accessed.
///
/// @global_write
/// No global data is accessed.
///
/// @remarks
///
/// @references
///
/// @authors
///
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
put_cah(
	FArray3DB_float & full_coord,
	int first,
	int last,
	FArray1DB_int const & res,
	FArray1DB_int const & res_variant
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;

//car calculate ha positions fro residues first,last in full_coord

	for ( int i = first; i <= last; ++i ) {
		int const aa = res(i);
		//dr okay for dupes but not other nnaa where we won't have this info
		if ( is_protein(aa) || is_nonnatural(aa) ) {
			int const aav = res_variant(i);
			int const atm = HApos(aa,aav);
			float & xyz_11i( full_coord(1,1,i) );
			place_atom(aa,aav,atm,xyz_11i);
			if ( aa == aa_gly ) { // glycine add other hydrogen, atm 6
				int HA2_pos = LookupByName(aa, aav, "1HA ");// use PDB conventions
				if ( HA2_pos < 1 ) HA2_pos = LookupByName(aa, aav, "2HA "); // non-PDB
				place_atom(aa,aav,HA2_pos,xyz_11i);
			}
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin place_atom
///
/// @brief
/// Places an atom of presumably unknown position.
///
/// @detailed
/// There are variables in aaproperties_pack.h that tell how to build
/// atoms that are missing. First, a complete coordinate set of each
/// amino acid is stored (icoor). Next, for each atom that must be placed,
/// three 'template' atoms are defined. The complete icoor set is
/// translated and rotated such that the template atoms are best fit.
/// { the coordinates for the missing atom can be taken from the
/// processed icoor set.
///
/// @param  aa - [in/out]? -
/// The amino acid type for this position
///
/// @param  aav - [in/out]? -
/// The variant number of the amino acid at this position.
///
/// @param  atom - [in/out]? -
/// The index of the missing atom in the amino acid array.
///
/// @param  res_coor - [in/out]? -
/// The coordinates for the residue that is missing an atom.
///
/// @global_read
/// The amino acid information that gives the template atoms and idealized
/// coordinates is used.
///
/// @global_write
/// No global data is altered.
///
/// @remarks
///
/// @references
///
/// @authors
/// jjh 8-19-03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
place_atom(
	int const aa,
	int const aav,
	int const atom,
	FArray2Da_float res_coor
)
{
	using namespace aaproperties_pack;
	using namespace param;

	res_coor.dimension( 3, MAX_ATOM() );

	static FArray2D_float tcoor( 3, 4 );
	static FArray2D_float mat( 3, 3 );
	static FArray1D_float vec( 3 );
	static FArray1D_int t( 3 );

	for ( int j = 1, l = ta.index(j,atom,aa,aav); j <= 3; ++j, ++l ) {
		t(j) = ta[ l ]; // ta(j,atom,aa,aav)
	}

//bk read in template coordinates
	int ltc = 0;
	for ( int j = 1; j <= 3; ++j ) {
		//assert( t(j) );
		for ( int i = 1, l = icoor.index(i,t(j),aa,aav); i <= 3; ++i, ++ltc, ++l ) {
			tcoor[ ltc ] = icoor[ l ]; // tcoor(i,j) = icoor(i,t(j),aa,aav)
		}
	}
	for ( int i = 1, l = icoor.index(i,atom,aa,aav); i <= 3; ++i, ++ltc, ++l ) {
		tcoor[ ltc ] = icoor[ l ]; // tcoor(i,4) = icoor(i,atom,aa,aav)
	}

//bk superimpose the template
	lineup_bk(tcoor(1,1),tcoor(1,2),res_coor(1,t(1)),res_coor(1,t(2)),mat,vec);
	for ( int i = 1; i <= 4; ++i ) {
		move_bk(tcoor(1,i),mat,vec);
	}
	align_bk(tcoor(1,1),tcoor(1,2),tcoor(1,3),res_coor(1,t(3)),mat,vec);
	for ( int i = 3; i <= 4; ++i ) {
		move_bk(tcoor(1,i),mat,vec);
	}

//bk read out the final coord
	for ( int i = 1; i <= 3; ++i ) {
		res_coor(i,atom) = tcoor(i,4);
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin design_output
///
/// @brief
///
/// This function writes out pdb files that result from a design or
/// repacking calculation.
///
/// @detailed
///
/// Following repacking/design, this function receives the built structure,
/// copies all necessary information into the Rosetta decoy arrays (declared
/// in misc.h), scores the structure using the Rosetta full atom score
/// (score12), and writes out the structure into a pdb file.
///
/// @param[in]   total_residue - in
/// This is the total number of residues in the structure.
///
/// @param[in]   res - in
/// This array stores the amino acid type at each position in the structure
///
/// @param[in]   aav - in
/// This array stores the variant number of the amino acid at each position.
///
/// @param[in]   full_coord - in
/// This array holds the actual coordinates of the structure.
///
/// @param[in]   run - in
/// This parameter stores which structure of a series is being output, so
/// the number can be appended to the filename.
///
/// @global_read
///
/// This function doesn't read any global data
///
/// @global_write
///
/// This function overwrites all of the information that defines a full-atom
/// decoy, such as total_residue, res, res_variant, and full_coord. The
/// call to score_set_new_pose() and score12() may set other variables
/// related to full-atom decoys.
///
/// @remarks
///
/// @references
///
/// @authors
///
/// jjh 8-19-03
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
design_output(
	int const & ASSERT_ONLY( total_residue_inout ),
	FArray1Da_int const res_inout,
	FArray1Da_int const res_variant_inout,
	FArray3Da_float const full_coord_inout,
	int const & run
)
{
	using namespace files_paths;
	using namespace misc;
	using namespace param;

	bool pose_flag_save = pose_flag_ns::pose_flag_setting;
	pose_flag_ns::pose_flag_setting = false;

//bk if normal rosetta methods are being used to output coordinates
//bk do not use this function
	if ( output_coord ) return;

	//open_design_pdb_file(run);

	std::string fullname;
	get_design_pdb_name( run, fullname );

//bk fill in sequences and coordinate arrays
  assert( ( total_residue == total_residue_inout ) ); //Objexx: Replaced total_residue = nres;
	for(int i=1;i<=total_residue;i++){
		res(i) = res_inout(i);
		res_variant(i) = res_variant_inout(i);
		for(int k=1;k<=3;k++){
			for(int j=1; j<=aaproperties_pack::natoms( res(i), res_variant(i)); j++){
				full_coord(k,j,i)= full_coord_inout(k,j,i);
			}
		}
	}

//bk fill in sequences and coordinate arrays
	// jk disable soft rep
	disable_packing_etables(total_residue, res, res_variant, full_coord);

//bk fill in sequences and coordinate arrays
//bk set fragment size to be whole protein so that score function counts
//bk everything
	score_set_new_pose();

//bk fill in sequences and coordinate arrays
	mc_global_track::mc_score::score = score12();
	calc_aprox_sasa();
	calc_sasa_pack_score(total_residue, res, res_variant, full_coord);

//bk fill in sequences and coordinate arrays
	decoystats_store_decoy();

//bk fill in sequences and coordinate arrays
	make_pdb( get_cat_pdb_stream( fullname ), true); // true indicates fullatom mode

	remove( (fullname+".in_progress").c_str() );

//bk fill in sequences and coordinate arrays
	// jk turn on soft rep and change weights, if desired
	enable_packing_etables(total_residue, res, res_variant,full_coord);

	//ja alter pdb fields post-output. Such as for adding residue ddg values to
	// the b-factor column--must allow initial structure output before starting
	// the ddg calculation.
	if ( analyze_interface_ddg_ns::ddg_per_residue ) alter_pdb_fields( fullname );

	pose_flag_ns::pose_flag_setting = pose_flag_save;
}

////////////////////////////////////////////////////////////////////////////////
void
design_score(
						 pose_ns::Pose & pose,
						 //const int & total_residue_inout,
						 //FArray1Da_int res_inout,
						 //FArray1Da_int res_variant_inout,
						 //FArray3Da_float full_coord_inout,
	int & //run //apl unused parameter fix; seems like cmj is still using run
)
{
	using namespace files_paths;
	//using namespace misc;
	using namespace param;

	//res_inout.dimension( MAX_RES() );
	//res_variant_inout.dimension( MAX_RES() );
	//full_coord_inout.dimension( 3, MAX_ATOM(), MAX_RES() );


//bk if normal rosetta methods are being used to output coordinates
//bk do not use this function
	if ( output_coord ) return;

//cmj	open_design_pdb_file(run);

////bk fill in sequences and coordinate arrays
//  total_residue = total_residue_inout;
//  for(int i=1; i<=total_residue; i++){
//		res(i) = res_inout(i);
//		res_variant(i) = res_variant_inout(i);
//		for(int k=1;k<=3;k++){
//			for(int j=1; j<=aaproperties_pack::natoms( res(i), res_variant(i)); j++){
//				full_coord(k,j,i)= full_coord_inout(k,j,i);
//			}
//		}
//	}


//bk set fragment size to be whole protein so that score function counts
//bk everything
	pose.new_score_pose();
	mc_global_track::mc_score::score = pose.score(score12);
	calc_sasa_pack_score(pose.total_residue(), pose.res(), pose.res_variant(), pose.full_coord());

//cmj	make_pdb(pdb_out_x,true); // true indicates fullatom mode
}

////////////////////////////////////////////////////////////////////////////////
void
pre_design_trials(
 pose_ns::Pose & pose
)
{
	using namespace param;
	pose.new_score_pose();
	mc_global_track::mc_score::score = pose.score(score12);
}

//////////////////////////////////////////////////////////////////////////////
/// @begin design_rotamer_trials
///
/// @brief
///
/// @detailed
///
/// @param  design_map
/// @param  res_inout - [in/out]? -
/// @param  res_variant_inout - [in/out]? -
/// @param  xyz_inout - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void

design_rotamer_trials(
	DesignMap const & design_map,
	pose_ns::Pose & pose
)
{
	using namespace design;
	using namespace param;
	using namespace template_pack;
	minimize_rot = true;
	pre_design_trials(pose);
  //jjh If you want, you can temporarily increase the chi
	//jjh values that are sampled with extra rotamers
	fullatom_rotamer_trials(pose.full_coord(), pose.res_variant(),design_map,
	 "multi");

	for ( int i = 1; i <= pose.total_residue(); ++i ) {
		maps_set_new_rotamer(i);
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_favor_native_residue
///
/// @brief
/// flag which turns on bonus scoring for native residue in design mode
///
/// @authors Brian Kuhlman
///
/// @last_modified 18 July 2004
////////////////////////////////////////////////////////////////////////////////
void set_favor_native_residue( bool const setting )
{
	favor_residue::favor_native_residue = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_favor_native_residue
///
/// @brief
/// check flag which turns on bonus scoring for native residue in design mode
///
/// @authors Brian Kuhlman
///
/// @last_modified 18 July 2004
////////////////////////////////////////////////////////////////////////////////
bool get_favor_native_residue()
{
	return favor_residue::favor_native_residue;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_native_bonus
///
/// @brief
///  return the bonus energy for being the native amino acid
///
/// @authors Brian Kuhlman
///
/// @last_modified 18 July 2004
////////////////////////////////////////////////////////////////////////////////
float get_native_bonus()
{
	return favor_residue::native_bonus;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_native_bonus
///
/// @brief
///  set the bonus energy for being the native amino acid
///
/// @authors Brian Kuhlman
///
/// @last_modified 18 July 2004
////////////////////////////////////////////////////////////////////////////////
void set_native_bonus( float const setting )
{
	favor_residue::native_bonus = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin design_mcmin_trials
///
/// @brief
///  rotamer search with full side chain flexibility
///
/// @detailed
///  following each rotamer substitution the chi of angle of the new rotamer and its
///  neighbors are minimized before calling monte_carlo
///
/// @global_read
/// @authors Brian Kuhlman
/// @last_modified October 2004
////////////////////////////////////////////////////////////////////////////////
void
design_mcmin_trials(
	pose_ns::Pose & pose,
  RotamerSet const & rotamer_set,
	FArray2DB_bool & neighborlist,
	FArray1DB_float & rot_freq,
	bool const start_with_current
	)
{
	using namespace param;
	using namespace aaproperties_pack;
	using namespace param_aa;
	using namespace protein_maps;

	// local variables
	int rot;
	int seqpos;
	int aa;
	bool gfrag( true );
	FArray1D_int start_sequence( MAX_RES()() );
	FArray1D_int pruned_rot_list( rotamer_set.nrotamers() );
	int npruned_rotamers;
	int list_pos;

	//bk set options for just side chain optimization
	score_set_lj_weight(1.0);
	score_set_try_rotamers(false);
	minimize_exclude_sstype(false, false);
	minimize_set_vary_chi(true);
	minimize_set_vary_phipsi(false);

	//yl temporarily copy pose to misc then use misc in the rest of this function
	//yl local variable for set temp pose
	//bool const fullatom( true );
	//bool const ideal_pose( false ); // non-ideal backbone geometry
  //bool const coords_init( true );
	//pose_to_misc(pose);

	start_sequence = pose.res();

	//bk create list of rotamers that were observed more often during the sim_annealing
	make_pruned_rotamer_list(rot_freq,rotamer_set,pruned_rot_list,npruned_rotamers);
	random_order(pruned_rot_list,npruned_rotamers);

	// jk turn off soft_rep for the minimization step, if it was on
	disable_packing_etables(pose.total_residue(),pose.res(),pose.res_variant(),pose.full_coord());

	//bk copy current arrays into the best, this is needed to set up nblist
	monte_carlo_accept_best();
	set_use_nblist(true);

	// jk fewer cycles and lower temperature if starting with current
	int ncycles;
	float start_temp = 0.3;
	if ( start_with_current ) {
		ncycles = npruned_rotamers / 3;
		start_temp = 0.1;
	} else {
		ncycles = npruned_rotamers * 3;
		start_temp = 0.3;
	}
	float end_temp = 0.03;
	monte_carlo_set_simannealing( true );

	//bk score the structure and force as best
	pose.new_score_pose();
	mc_global_track::mc_score::score = pose.score(score12);
	monte_carlo_reset();
	output_mcmin_status(-1,start_sequence,pose.total_residue(), pose.res());

	//bk minimize chi angles on starting structure
	for ( int seqpos = 1; seqpos <= pose.total_residue(); ++seqpos) {
		allow_insert(seqpos) = true;
		maps_set_new_rotamer(seqpos);
	}
	minimize("linmin","minimize",score12,1,pose.total_residue(),gfrag);
	monte_carlo_reset();
	output_mcmin_status(0,start_sequence,pose.total_residue(), pose.res());

	//bk main loop
	// 1) pick a rotamer and place it on the structure
	// 2) identify neighboring residues
  // 3) optimize the side chain conformation of new side chain and neighbors
  // 4) call monte carlo to determine if the change should be accepted

	for ( int cycle = 1; cycle <= ncycles; ++cycle ) {
		float fcycle = cycle;
		float temp = start_temp + (end_temp-start_temp)*(fcycle/ncycles);
		monte_carlo_set_temp( temp );
		list_pos = mod(cycle-1,npruned_rotamers) + 1;
		if ( list_pos == 1 ) {
			random_order(pruned_rot_list,npruned_rotamers);
		}
		rot = pruned_rot_list(list_pos);
		seqpos = rotamer_set.report_seqpos(rot);
		aa = rotamer_set.report_aa(rot);

		//bk place the rotamer on the protein
		place_rotamer(seqpos,aa,rotamer_set.report_aav(rot),rotamer_set.get_rotcoord(rot));

		//identify residues that will have their side chain torsion angles minimized
		set_maps_for_minimizing_neighbors(seqpos, neighborlist);

		minimize("linmin","minimize",score12,1,pose.total_residue(),gfrag);

		monte_carlo(cycle);
		retrieve_best_pose(); //make sure current arrays are best

		if ( mod(cycle, (npruned_rotamers/10) ) == 0 ) {
			output_mcmin_status(cycle,start_sequence,pose.total_residue(),pose.res());
		}
	}
	output_mcmin_status(ncycles,start_sequence,pose.total_residue(),pose.res());

	// jk turn on soft rep and change weights, if desired
	enable_packing_etables(pose.total_residue(), pose.res(), pose.res_variant(), pose.full_coord());

	set_use_nblist(false);
	//pose_from_misc(pose,fullatom, ideal_pose, coords_init);
}

//////////////////////////////////////////////////////////////////////////////
/// @begin place_rotamer
///
/// @brief  place the coordinates and sequence for a new rotamer into the misc.h
///         data structures.
/// @authors Brian Kuhlman
/// @last_modified October 2004
////////////////////////////////////////////////////////////////////////////////
void
place_rotamer(
	int const seqpos,
	int const aa,
	int const aav,
	FArray2Da_float coord
)
{
	using namespace param;
	using namespace misc;
	using namespace aaproperties_pack;

	coord.dimension( 3, MAX_ATOM() );

	res(seqpos) = aa;
	res_variant(seqpos) = aav;

	for ( int i = 1, atme = natoms( aa, aav ); i <= 3; ++i ) {
		for ( int atm = 1; atm <= atme; ++atm ) {
			full_coord( i, atm, seqpos ) = coord( i, atm );
		}
	}
	update_sequence();
	maps_set_new_rotamer(seqpos);
}

//////////////////////////////////////////////////////////////////////////////
/// @begin set_maps_for_minimizing_neighbors
///
/// @brief  set maps so neighboring side chains can be minimized
///
/// @authors Brian Kuhlman
/// @last_modified October 2004
////////////////////////////////////////////////////////////////////////////////
void
set_maps_for_minimizing_neighbors(
	int const seqpos,
	FArray2DB_bool & neighborlist
)
{
	using namespace param;
	using namespace misc;
	using namespace protein_maps;
	using namespace aaproperties_pack;
	using namespace param_aa;


	float cutoff = 4.3;
	float dis;

	for ( int pos = 1; pos <= total_residue; ++pos ) {
		allow_insert(pos) = false;
	}

	//bk allow insert used by minimizer to determine which residues will be minimized
	allow_insert(seqpos) = true;
	maps_set_new_rotamer(seqpos);

	//bk set allow_insert to true for neighbors
	for ( int pos = 1, atm2e = nheavyatoms( res(seqpos), res_variant(seqpos) );
	 pos <= total_residue; ++pos ) {
		if ( neighborlist(seqpos,pos) && (res(pos) != aa_cys ) ) {
			for ( int atm1 = 5, atm1e = nheavyatoms( res(pos), res_variant(pos) );
			 atm1 <= atm1e; ++atm1 ) {
				for ( int atm2 = 5; atm2 <= atm2e; ++atm2 ) {
					distance_bk( full_coord(1,atm1,pos), full_coord(1,atm2,seqpos), dis );
					if ( dis < cutoff ) {
						allow_insert(pos) = true;
						maps_set_new_rotamer(pos);
						goto L100;
					}
				}  //atm1
			}    //atm2
		}      //is neighbor

L100:;

	}        // loop through all sequence positions
}

//////////////////////////////////////////////////////////////////////////////
/// @begin output_mcmin_status
///
/// @brief  scores from mcmin protocol for sidechain optimization
/// @authors Brian Kuhlman
/// @last_modified October 2004
////////////////////////////////////////////////////////////////////////////////
void
output_mcmin_status(
	int const counter,
	FArray1DB_int & start_sequence,
	int total_residue,
	FArray1D_int const & res
)
{
	using namespace param;
	using namespace mc_global_track::mc_score; // yab: misc removal

	if ( counter == -1 ) {
		std::cout << "Beginning mcmin side chain optimization protocol " << std::endl;
		std::cout << "  cycle  best_score  low_score  seqid%" << std::endl;
	}

	// calculate sequence identity with start
	int nsame = 0;
	for ( int seqpos = 1; seqpos <= total_residue; ++seqpos ) {
		if ( res(seqpos) == start_sequence(seqpos) ) {
			++nsame;
		}
	}
	float seqid = ( static_cast< float >(nsame) / static_cast< float >(total_residue) ) * 100.;

	std::cout << I(6, counter) << " "
						<< F(7,1,best_score) << "     "
						<< F(7,1,low_score) << "       "
						<< F(5,1,seqid) << std::endl;

}
//////////////////////////////////////////////////////////////////////////////
/// @begin make_pruned_rotamer_list
///
/// @brief: using the rotamer frequencies output by sim_annealing make of a list
///   of the most favorable rotamers for a structure
///
/// @param  [in] rot_freq: rotamer frequencies from sim_annealing
/// @param  [out] pruned_rot_list: list of favorable rotamers
/// @param  [out] npruned_rotamers: number of elements in pruned_rot_list
/// @authors Brian Kuhlman
/// @last_modified October 2004
////////////////////////////////////////////////////////////////////////////////
void
make_pruned_rotamer_list(
	FArray1DB_float & rot_freq,
	RotamerSet const & rotamer_set,
	FArray1DB_int & pruned_rot_list,
	int & npruned_rotamers
)
{
	using namespace param;

	FArray1D_int nrot_per_seqpos( MAX_RES()() );
	int seqpos;

	nrot_per_seqpos = 0;
	npruned_rotamers = 0;

	//bk first determine how many rotamers are being considered at each sequence position
	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {
		seqpos = rotamer_set.report_seqpos(rot);
		++nrot_per_seqpos(seqpos);
	}

	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {
		float random_chance = 1. / static_cast< float > (nrot_per_seqpos(rotamer_set.report_seqpos(rot)));
		if ( rot_freq(rot) > random_chance ) {
			++npruned_rotamers;
			pruned_rot_list( npruned_rotamers ) = rot;
		}
	}

	std::cout << rotamer_set.nrotamers() << " rotamers pruned down to " << npruned_rotamers << " before mcmin"
						<< std::endl;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin apply_electrostatic_complementarity_shift
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void apply_electrostatic_complementarity_shift(
	InteractionGraphBase * ig,
	RotamerSet & rotamer_set,
  float const Eshift
) {

	// jk Add a weight to charged groups depending on which side of the interface they're on

	using namespace misc;
	using namespace param;
	using namespace param_aa;

	FArray1D_float energy1b_shift( rotamer_set.nrotamers(), 0. );
	for ( int rot = 1; rot <= rotamer_set.nrotamers(); ++rot ) {
		int const rotres = rotamer_set.report_seqpos(rot);
		int const aarot = rotamer_set.report_aa(rot);

		float shift_val(0.);
		if ( ( aarot == aa_lys ) || ( aarot == aa_arg ) ) shift_val = Eshift;
		if ( ( aarot == aa_asp ) || ( aarot == aa_glu ) ) shift_val = (-1. * Eshift);
		if ( rotres > domain_end(1) ) shift_val *= -1.;  // shift the sign for anything on chain 2
		energy1b_shift(rot) = shift_val;

	}

	ig->add_to_one_body_energies(energy1b_shift);

	return;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin dump_rotamers_pdb
///
/// @brief
/// Output to a PDB file rotamer coords and their energies as B-factors. For
/// example, can color by temperature in Rasmol, to color by energy term. Here
/// presently the energy outputted is the rotamer's one-body energy.
///
/// @authors
/// ashworth
///
////////////////////////////////////////////////////////////////////////////////

void
dump_rotamers_pdb(
	PackerTask const & Task,
	RotamerSet & rotamer_set, // would be const except that we need to slice it
	InteractionGraphBase * ig,
	int const pos,
	std::ofstream & rotsfile,
	int const aa
)
{
	using namespace aaproperties_pack;

	if ( Task.get_mode() != "design" ||
	     !design::active_rotamer_options.dump_rotamers_pdb_flag ) return;

	if ( !Task.get_designmap().repack_residue(pos) ) {
		std::cout << "ERROR: in dump_rotamers_pdb " <<
		 param_aa::aa_name3(aa)  << " " << pos <<
		 " is not repacking." << std::endl;
		return;
	}

	int node_index( rotamer_set.resid_2_moltenres( pos ) );
	int const num_states( ig->get_num_states_for_node( node_index ) );
	int model(0), rot, raa, raav;
	float oneb_energy;
	for ( int state(1); state <= num_states; ++state ){
		++model;
		rot = state + rotamer_set.rotindex_offsets( pos );
		raa = rotamer_set.report_aa(rot);
		raav = rotamer_set.report_aav(rot);

		std::string model_print = lead_zero_string_of( model, 4 );
		rotsfile << "MODEL     " << model_print << std::endl;


		if(design::active_rotamer_options.minimize_best_rotamers) {
			oneb_energy = rotamer_explosion::rotamer_lig_energies[rot];
		}
		else {
			oneb_energy =
				ig->get_one_body_energy_for_node_state( node_index, state );
		}

		print_residue_coords( rotsfile, pos, raa, raav,
		                      rotamer_set.get_rotcoord(rot), oneb_energy );

		rotsfile << "ENDMDL" << std::endl;
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin print_residue_coords
///
/// @brief
/// something is not right here, but it should be easy to fix
///
/// @authors
/// ashworth
////////////////////////////////////////////////////////////////////////////////
void
print_residue_coords(
	std::ostream & outstream,
	int const pos,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float const b_col
)
{
	using namespace aaproperties_pack; // nheavyatoms
	using namespace pdb; // pdb_res_num
	using namespace param; // MAX_ATOM()
	using namespace param_pack; // aa_name3

	coord.dimension( 3, MAX_ATOM() );

	//debug: "pdb" coords for contact pair
	for ( int atom = 1; atom <= natoms(aa,aav); ++atom ) {
		std::string atomname;
		atom_name_from_atom_num(atom,aa,aav,atomname);
		outstream << "ATOM  99999" << " " << atomname << " " <<
		 param_aa::aa_name3(aa) << " X " <<
		 I(3,pdb::pdb_res_num(pos)) << "    " <<
		 F( 8, 3, coord(1,atom)) <<
		 F( 8, 3, coord(2,atom)) <<
		 F( 8, 3, coord(3,atom)) <<
		 F( 6, 2, 1.00 ) << // occupancy (placeholder)
		 F( 6, 2, b_col ) << // energy printed in the B-factor column
		 std::endl;
	}
}
