// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18214 $
//  $Date: 2007-11-05 11:32:40 -0500 (Mon, 05 Nov 2007) $
//  $Author: ora $


// Rosetta Headers
#include "param.h"
#include "docking_ns.h"


namespace param {


//-------------
// parameters
//-------------

int const MAX_START = { 100000 }; // number of starting pdb structures
int const MAX_POS = { 5 }; // atoms/residue in position array
int const MAX_SEGMENTS = { 8 }; // foldable segments

float const init_phi = { -150.0 }; // extended
float const init_psi = { 150.0 };
float const init_omega = { 180.0 };


//-------------------------------
// full atom / packer parameters
//-------------------------------

int const MAX_AUTH_AA = { 20 }; // # of genuine amino acids
int const MAX_CHI = { 4 };
Dimension MAX_REALTYPES;
int const MAXANGLES_PER_CHI = { 20 };

//ctsa linear-memory packer parameters:
short const MAX_PACK_NEIGHBORS = { 100 };
 // max number of residues that can influence a rotamers pair-energy


//-------------------------------
// jumping params
//-------------------------------

int const max_jump = { 25 };
int const max_fold_tree_edges = { 1 + ( 3 * max_jump ) }; // somethin' like that

//-------------------------------
// RNA params
//-------------------------------
int const MAX_TORSIONS = { 10 };


// MAX_RES sizing function
void
MAX_RES_assign_res( int const nres )
{
	using namespace docking;
		MAX_RES().assign_if_bigger_nic( nres );
}


} // param
