// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16901 $
//  $Date: 2007-09-03 21:49:14 -0400 (Mon, 03 Sep 2007) $
//  $Author: kaufmann $

#ifndef INCLUDED_param_aa
#define INCLUDED_param_aa

// Utility Headers
#include <utility/vector1.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>


//ctsa
//     shared generic amino acid data and enumerators
//


namespace param_aa {


extern int const aa_ala;
extern int const aa_cys;
extern int const aa_asp;
extern int const aa_glu;
extern int const aa_phe;
extern int const aa_gly;
extern int const aa_his;
extern int const aa_ile;
extern int const aa_lys;
extern int const aa_leu;
extern int const aa_met;
extern int const aa_asn;
extern int const aa_pro;
extern int const aa_gln;
extern int const aa_arg;
extern int const aa_ser;
extern int const aa_thr;
extern int const aa_val;
extern int const aa_trp;
extern int const aa_tyr;
extern int const aa_sep;//KMa phospho_ser 2006-01
extern int const na_gua;
extern int const na_ade;
extern int const na_cyt;
extern int const na_thy;
extern int const na_rgu;
extern int const na_rad;
extern int const na_rcy;
extern int const na_ura;
//extern int lig1;
//extern int lig2;
extern utility::vector1<int> ligand_aa_vector;

namespace param_aa_data {
	extern FArray1D_bool const aa_is_polar;
	extern FArray1D_bool const aa_is_nonpolar;
	extern FArray1D_bool const aa_is_aromatic;
	extern FArray1D_bool const aa_is_charged;
	extern FArray1D_bool const is_nonnatural;
	extern FArray1D_bool const is_protein;
	extern FArray1D_bool const is_DNA;
	extern FArray1D_bool is_NA;
	extern FArray1D_bool is_RNA;
	extern FArray1D_int has_ligand_no;
	extern FArray1D_char const aa_name1;
	extern FArray1D_string const aa_name3;

	extern int const dna_bb_atoms;
	extern int const rna_bb_atoms;

	inline bool is_ligand( int aa_id ) {
		return ( has_ligand_no(aa_id) > 0 );
	}

}
using namespace param_aa_data;

}

#endif
