// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17813 $
//  $Date: 2007-10-16 16:49:26 -0400 (Tue, 16 Oct 2007) $
//  $Author: johnk $

#ifndef INCLUDED_param_pack
#define INCLUDED_param_pack


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

//Rosetta headers
#include "packer_weights.h"


namespace param_pack {

	extern PackerWeights pack_wts; // JSS these are the real packer weights used.

	//// ff flags
////
namespace packer_logical {
	extern bool dna_weights; // use dna weights
	extern bool soft_rep; // use jjh's soft repulsive potential
	extern bool soft_rep_design;	// use jjh's soft repulsive potential
																// with weights for design
	extern bool use_packing_etables_always;	// keep soft_rep on always
	extern bool gen_born; // use jjh's generalized born electrostatics
 	extern bool pH_rot;       // use pH-sensitive rotamers
	extern bool small_radii; // smaller radii as specified in fullatom_setup

	extern bool smooth_etable; //sheffler true if using smooth etables
	extern bool reduce_templates; //sheffler true if using possu's new templates

	extern bool use_aw; // if true, use weights for all fold proteins
	extern bool use_bw; // if true, use weights for beta protein
}
using namespace packer_logical;


//// other packer parameters:
////
namespace packer_misc_parameters {
	extern float perc_limit_surface_default;
	extern float perc_limit_buried_default;
	extern int rot_limit_surface_default;
	extern int rot_limit_buried_default;
	extern float perc_limit_surface_large;
	extern float perc_limit_buried_large;
	extern int rot_limit_surface_large;
	extern int rot_limit_buried_large;
	extern float perc_limit_surface;
	extern float perc_limit_buried;
	extern int rot_limit_surface;
	extern int rot_limit_buried;
	extern int rot_min_count;
	extern float Wdisulf_dist_sc;
	extern float Wdisulf_csang_sc;
	extern float Wdisulf_dihedral_sc;
	extern float Wdisulf_ca_dihedral_sc;
	extern float Wdisulf_cbs_dist_sc;

	extern float Wlig_int_rep;//kwk haven't fit the internal
	extern float Wlig_int_atr;//kwk ligand energy weights yet
	extern float Wlig_int_solv;
	extern float Wlig_int_hb;
	extern float Wlig_int_dihed;
	extern float Wlig_int_cou;
	extern float max_rot_bumpenergy; // ctsa -  rotamer culling controls
	extern float min_extrachi_rot_prob;
	extern float min_extrachi_sd;

	extern float scale_inner_iterations_value;
	extern float scale_outer_iterations_value;
}
using namespace packer_misc_parameters;


}


#endif
