// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $

#include "param_rotamer_trie.h"
#include "rotamer_descriptor.h"
#include <ObjexxFCL/FArray3D.hh>

namespace param_rotamer_trie
{
	int const trie_variant_for_base =  1;
	int const trie_variant_for_his_tautomer =  2;
	int const trie_variant_for_n_terminus =  3;
	int const trie_variant_for_c_terminus =  4;
	int const trie_variant_for_extra_protonation_1 = 5;
	int const trie_variant_for_extra_protonation_2 =  6;
	int const trie_variant_for_deprotonation =  7;
	int const trie_num_supported_variants =  7;

	//C style array initialization compiles rapidly; makes arrays easy to read.
	//beware (c/c++) row major and (fortran) column major differences.
	//beware (c/c++) index-by-0 and (fortran) index-by-1 difference.

	//dr changed hardcoded 20's to 28's for NNAA
	//KMa phospho_ser 29=aa+dna
	const int trie_2_fullatom_const[trie_num_supported_variants][29][rotamer_trie::MAX_ATS_PER_RES] =
	{
		{  // aa_variant == 1
		//row 1: aa_ala
		//C   O   N   H  CA  HA  CB 1HB 2HB 3HB
		{ 3,  4,  1,  6,  2,  7,  5,  8,  9, 10,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		// C   O   N   H   CA  HA  CB  1HB 2HB SG  HG
		{  3,  4,  1,  7,  2,  8,  5,  9,  10,  6, 11,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  OD1 OD2
		{ 3,  4,  1,  9,  2,  10,  5,  11, 12,  6,  7,  8,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 4: aa_glu
		//C   O  N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG CD  OE1 OE2
		{3,  4,  1, 10,  2, 11,  5, 12, 13,  6, 14, 15,  7,  8,  9,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 5: aa_phe
		// ORIGINAL directly-out-from-backbone ordering.
		//C  O   N   H   CA  HA  CB 1HB 2HB CG  CD1 HD1 CD2 HD2 CE1 HE1 CE2 HE2 CZ  HZ
		{3,  4,  1, 12,  2, 18,  5, 19, 20,  6,  7, 13,  8, 17,  9, 14, 10, 16, 11, 15,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C  O   N   H   CA  HA  CB 1HB 2HB CG  CE1 HE1 CD1 HD1 CD2 HD2 CE2 HE2 CZ  HZ
		//{3,  4,  1, 12,  2, 18,  5, 19, 20,  6,  9,  14,  7, 13,  8, 17, 10, 16, 11, 15,
		//0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 6: aa_gly
		//C  O  N   H   CA  3HA  2HA
		{3,  4,  1,  5,  2,  7,   6,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 7: aa_his
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  CE1 HE1 CD2 HD2 ND1 NE2 HE2
		{  3,  4,  1, 11,  2, 13,  5, 14, 15,  6,  9, 16,  8, 17,  7, 10, 12,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 8: aa_ile
		//C    O    N    H    CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 CG1  2HG1 3HG1 CD1  1HD1 2HD1 3HD1
		{ 3,   4,   1,   9,   2,  10,   5,  11,   7,  12,  13,  14,   6,  15,  16,   8,  17,  18,  19,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 9: aa_lys
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD CE  1HE 2HE NZ  1HZ 2HZ 3HZ
		{ 3,  4,  1, 10,  2, 14,  5, 15, 16,  6, 17, 18,  7, 19, 20,  8, 21, 22,  9, 11, 12, 13,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 10: aa_leu
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   HG   CD1  1HD1 2HD1 3HD1 CD2  1HD2 2HD2 3HD2
		{ 3,   4,   1,   9,   2,  10,   5,  11,  12,   6,  13,   7,  14,  15,  16,   8,  17,  18,  19,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 11: aa met
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG SD  CE  1HE 2HE 3HE
		{ 3,  4,  1,  9,  2, 10,  5, 11, 12,  6, 13, 14,  7,  8, 15, 16, 17,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 12: aa_asn
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG  OD1   ND2  1HD2 2HD2
		{ 3,   4,   1,   9,   2,  12,   5,  13,  14,   6,   7,   8,  10,  11,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 13: aa_pro
		//C   O   N   CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD
		{ 3,  4,  1,  2, 14,  5, 12, 13,  6, 10, 11,  7,  8,  9,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 14: aa_gln
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   OE1  NE2  1HE2 2HE2
		{ 3,   4,   1,  10,   2,  13,   5,  14,  15,   6,  16,  17,   7,   8,   9,  11,  12,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 15: aa_arg
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   1HD  2HD  NE   HE   CZ   NH1  1HH1 2HH1 NH2  1HH2 2HH2
		{ 3,   4,   1,  12,   2,  18,   5,  19,  20,   6,  21,  22,   7,  23,  24,   8,  17,   9,  10,  13,  14,  11,  15,  16,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
 		//row 16: aa_ser
		//C   O   N   H   CA  HA  CB  1HB 2HB OG  HG
	 	{ 3,  4,  1,  7,  2,  9,  5, 10, 11,  6,  8,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 17: aa_thr
		//C    O    N    H   CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 OG1  HG1
		{ 3,   4,   1,   8,   2,  10,   5,  11,   7,  12,  13,  14,   6,   9,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	  //row 18: aa_val
		//C    O    N    H    CA   HA   CB   HB   CG1  1HG1 2HG1 3HG1 CG2  1HG2 2HG2 3HG2
		{ 3,   4,   1,   8,   2,   9,   5,  10,   6,  11,  12,  13,   7,  14,  15,  16,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 19: aa_trp
		// ORIGINAL directly-out-from-backbone ordering.
		//C   O   N   H  CA  HA  CB  1HB 2HB CG  CD1 HD1 NE1 HE1 CD2 CE2 CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		{ 3,  4,  1, 15,  2, 22,  5, 23, 24,  6,  7, 17,  9, 16,  8, 10, 11, 21, 12, 18, 13, 20, 14, 19,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C   O   N   H   CA  HA  CB  1HB 2HB CG   CE2 CD1 HD1 NE1 HE1 CD2  CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		//{ 3,  4,  1, 15,  2, 22,  5, 23, 24,  6,  10,  7,  17,  9, 16,  8, 11, 21, 12, 18, 13, 20, 14, 19,
		//0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 20: aa_tyr
		// ORIGINAL directly-out-from-backbone ordering.
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   CD1  HD1  CD2  HD2  CE1  HE1  CE2  HE2  CZ   OH   HH
		{ 3,   4,   1,  13,   2,  19,   5,  20,  21,   6,   7,  15,   8,  18,   9,  16,  10,  17,  11,  12,  14,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   CE1  HE1  CD1  HD1  CD2  HD2  CE2  HE2  CZ   OH   HH
		//{ 3,   4,   1,  13,   2,  19,   5,  20,  21,   6,   9,  16,   7,  15,   8,  18,   10,  17,  11,  12,  14,
		//0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 }
		//dr row 21
		//C   O   N   H   CA  HA  CB  1HB 2HB  OG  P  O1P  O2P O3P
		{3,  4,  1,  11,  2,  12,  5, 13, 14,  6,  7, 8,  9,  10,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},//KMa phospho_ser
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 1;
		{ //aa_variant == 2;
		//row 1: aa_ala
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 2: aa_cys
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 4: aa_glu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 5: aa_phe
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 6: aa_gly
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 7: aa_his
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  CE1 HE1 CD2 HD2 NE2 ND1 HD1
		{  3,  4,  1, 11,  2, 13,  5, 14, 15,  6,  9, 16,  8, 17, 10, 7, 12,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 8: aa_ile
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 9: aa_lys
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 10: aa_leu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 11: aa met
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 12: aa_asn
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 13: aa_pro
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 14: aa_gln
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 15: aa_arg
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 16: aa_ser
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 17: aa_thr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 18: aa_val
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 19: aa_trp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 20: aa_tyr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 21 //KMa phospho_ser
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 2
		{  // aa_variant == 3: N-termini
		//row 1: aa_ala
		//C   O   N  1H  2H  3H  CA  HA  CB 1HB 2HB 3HB
		{ 3,  4,  1,  6,  7,  8,  2,  9,  5,  10,  11, 12,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		// C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB SG  HG
		{  3,  4,  1,  7,  8,  9,  2,  10,  5,  11,  12,  6, 13,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  OD1 OD2
		{ 3,  4,  1,  9, 10, 11,  2,  12,  5,  13, 14,  6,  7,  8,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 4: aa_glu
		//C   O  N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  1HG 2HG CD  OE1 OE2
		{3,  4,  1, 10, 11, 12,  2, 13,  5, 14, 15,  6, 16, 17,  7,  8,  9,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 5: aa_phe
		// ORIGINAL directly-out-from-backbone ordering.
		//C  O   N  1H  2H  3H  CA  HA  CB 1HB 2HB CG  CD1 HD1 CD2 HD2 CE1 HE1 CE2 HE2 CZ  HZ
		{3,  4,  1, 12, 13, 14,  2, 20,  5, 21, 22,  6,  7, 15,  8, 19,  9, 16, 10, 18, 11, 17,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C  O   N   H   CA  HA  CB 1HB 2HB CG  CE1 HE1 CD1 HD1 CD2 HD2 CE2 HE2 CZ  HZ
		//{3,  4,  1, 12,  2, 18,  5, 19, 20,  6,  9,  14,  7, 13,  8, 17, 10, 16, 11, 15,
		//0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 6: aa_gly
		//C  O   N  1H  2H  3H  CA  3HA  2HA
		{3,  4,  1,  5,  6,  7,   2,  9,   8,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 7: aa_his
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  CE1 HE1 CD2 HD2 ND1 NE2 HE2
		{ 3,  4,  1, 11, 12, 13,  2, 15,  5, 16, 17,  6,  9, 18,  8, 19,  7, 10, 14,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 8: aa_ile
		//C    O    N  1H  2H  3H  CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 CG1  2HG1 3HG1 CD1  1HD1 2HD1 3HD1
		{ 3,   4,   1,  9, 10, 11,  2,  12,   5,  13,   7,  14,  15,  16,   6,  17,  18,   8,  19,  20,  21,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 9: aa_lys
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD CE  1HE 2HE NZ  1HZ 2HZ 3HZ
		{ 3,  4,  1, 10, 11, 12,  2, 16,  5, 17, 18,  6, 19, 20,  7, 21, 22,  8, 23, 24,  9, 13, 14, 15,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 10: aa_leu
		//C    O    N   1H  2H  3H   CA   HA   CB   1HB  2HB  CG   HG   CD1  1HD1 2HD1 3HD1 CD2  1HD2 2HD2 3HD2
		{ 3,   4,   1,   9, 10, 11,  2,  12,   5,  13,  14,   6,  15,   7,  16,  17,  18,   8,  19,  20,  21,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 11: aa met
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  1HG 2HG SD  CE  1HE 2HE 3HE
		{ 3,  4,  1,  9, 10, 11,  2, 12,  5, 13, 14,  6, 15, 16,  7,  8, 17, 18, 19,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 12: aa_asn
		//C    O    N   1H   2H   3H   CA   HA   CB   1HB  2HB  CG  OD1  ND2 1HD2 2HD2
		{ 3,   4,   1,   9,  10,  11,   2,  14,   5,  15,  16,   6,   7,   8,  12,  13,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 13: aa_pro
		//C   O   N  1H  2H  CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD
		{ 3,  4,  1,  8,  9,  2, 16,  5, 14, 15,  6, 12, 13,  7, 10, 11,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 14: aa_gln
		//C    O    N   1H   2H   3H   CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   OE1  NE2 1HE2 2HE2
		{ 3,   4,   1,  10,  11,  12,   2,  15,   5,  16,  17,   6,  18,  19,   7,   8,   9,  13,  14,
		0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 15: aa_arg
		//C    O    N   1H   2H   3H   CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   1HD  2HD  NE   HE   CZ   NH1  1HH1 2HH1 NH2  1HH2 2HH2
		{ 3,   4,   1,  12,  13,  14,   2,  20,   5,  21,  22,   6,  23,  24,   7,  25,  26,   8,  19,   9,  10,  15,  16,  11,  17,  18,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
 		//row 16: aa_ser
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB OG  HG
	 	{ 3,  4,  1,  7,  8,  9,  2, 11,  5, 12, 13,  6, 10,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 17: aa_thr
		//C    O    N   1H   2H   3H   CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 OG1  HG1
		{ 3,   4,   1,   8,   9,  10,   2,  12,   5,  13,   7,  14,  15,  16,   6,   11,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	  //row 18: aa_val
		//C    O    N   1H   2H   3H   CA   HA   CB   HB   CG1 1HG1 2HG1 3HG1  CG2 1HG2 2HG2 3HG2
		{ 3,   4,   1,   8,   9,  10,   2,  11,   5,  12,   6,  13,  14,  15,   7,  16,  17,  18,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 19: aa_trp
		// ORIGINAL directly-out-from-backbone ordering.
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB CG  CD1 HD1 NE1 HE1 CD2 CE2 CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		{ 3,  4,  1, 15, 16, 17,  2, 24,  5, 25, 26,  6,  7, 19,  9, 18,  8, 10, 11, 23, 12, 20, 13, 22, 14, 21,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C   O   N   H   CA  HA  CB  1HB 2HB CG   CE2 CD1 HD1 NE1 HE1 CD2  CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		//{ 3,  4,  1, 15,  2, 22,  5, 23, 24,  6,  10,  7,  17,  9, 16,  8, 11, 21, 12, 18, 13, 20, 14, 19,
		//0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 20: aa_tyr
		// ORIGINAL directly-out-from-backbone ordering.
		//C    O    N   1H   2H   3H   CA   HA   CB   1HB  2HB  CG   CD1  HD1  CD2  HD2  CE1  HE1  CE2  HE2  CZ   OH   HH
		{ 3,   4,   1,  13,  14,  15,   2,  21,   5,  22,  23,   6,   7,  17,   8,  20,   9,  18,  10,  19,  11,  12,  16,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   CE1  HE1  CD1  HD1  CD2  HD2  CE2  HE2  CZ   OH   HH
		//{ 3,   4,   1,  13,   2,  19,   5,  20,  21,   6,   9,  16,   7,  15,   8,  18,   10,  17,  11,  12,  14,
		//0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 }
		//dr row 21
		//C   O   N  1H  2H  3H  CA  HA  CB  1HB 2HB  OG  P  O1P  O2P O3P
		{3,  4,  1,  11, 12, 13,  2,  14,  5, 15, 16,  6,  7, 8,  9,  10,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},//KMa phospho_ser
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 3;
		{  // aa_variant == 4 : C-termini
		//row 1: aa_ala
		//C   O OXT   N   H  CA  HA  CB 1HB 2HB 3HB
		{ 3,  4,  6,  1,  7,  2,  8,  5,  9, 10, 11,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		// C   O OXT   N   H   CA  HA  CB  1HB 2HB SG  HG
		{  3,  4,  7,  1,  8,  2,  9,  5,  10,  11,  6, 12,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		//C   O OXT   N   H   CA  HA  CB  1HB 2HB CG  OD1 OD2
		{ 3,  4,  9,  1, 10,  2,  11,  5,  12, 13,  6,  7,  8,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 4: aa_glu
		//C   O OXT   N   H  CA  HA  CB  1HB 2HB CG  1HG 2HG CD  OE1 OE2
		{ 3,  4, 10,  1, 11,  2, 12,  5, 13, 14,  6, 15, 16,  7,  8,  9,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 5: aa_phe
		// ORIGINAL directly-out-from-backbone ordering.
		//C  O OXT   N   H   CA  HA  CB 1HB 2HB CG  CD1 HD1 CD2 HD2 CE1 HE1 CE2 HE2 CZ  HZ
		{3,  4, 12,  1, 13,  2, 19,  5, 20, 21,  6,  7, 14,  8, 18,  9, 15, 10, 17, 11, 16,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C  O   N   H   CA  HA  CB 1HB 2HB CG  CE1 HE1 CD1 HD1 CD2 HD2 CE2 HE2 CZ  HZ
		//{3,  4,  1, 12,  2, 18,  5, 19, 20,  6,  9,  14,  7, 13,  8, 17, 10, 16, 11, 15,
		//0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 6: aa_gly
		//C  O OXT  N   H   CA  3HA  2HA
		{3,  4,  5,  1,  6,  2,  8,   7,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 7: aa_his
		//C   O OXT   N   H   CA  HA  CB  1HB 2HB CG  CE1 HE1 CD2 HD2 ND1 NE2 HE2
		{  3,  4,  11,  1, 12,  2, 14,  5, 15, 16,  6,  9, 17,  8, 18,  7, 10, 13,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 8: aa_ile
		//C    O  OXT    N    H    CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 CG1  2HG1 3HG1 CD1  1HD1 2HD1 3HD1
		{ 3,   4,   9,   1,  10,   2,  11,   5,  12,   7,  13,  14,  15,   6,  16,  17,   8,  18,  19,  20,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 9: aa_lys
		//C   O OXT  N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD CE  1HE 2HE NZ  1HZ 2HZ 3HZ
		{ 3,  4,  10,  1, 11,  2, 15,  5, 16, 17,  6, 18, 19,  7, 20, 21,  8, 22, 23,  9, 12, 13, 14,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 10: aa_leu
		//C    O  OXT   N    H    CA   HA   CB   1HB  2HB  CG   HG   CD1  1HD1 2HD1 3HD1 CD2  1HD2 2HD2 3HD2
		{ 3,   4,   9,   1,  10,   2,  11,   5,  12,  13,   6,  14,   7,  15,  16,  17,   8,  18,  19,  20,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 11: aa met
		//C   O OXT   N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG SD  CE  1HE 2HE 3HE
		{ 3,  4,  9,  1, 10,  2, 11,  5, 12, 13,  6, 14, 15,  7,  8, 16, 17, 18,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 12: aa_asn
		//C    O  OXT    N    H    CA   HA   CB   1HB  2HB  CG  OD1   ND2  1HD2 2HD2
		{ 3,   4,   9,   1,  10,   2,  13,   5,  14,  15,   6,   7,   8,  11,  12,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 13: aa_pro
		//C   O OXT   N   CA  HA  CB 1HB 2HB  CG 1HG 2HG  CD 1HD 2HD
		{ 3,  4,  8,  1,  2, 15,  5, 13, 14,  6, 11, 12,  7,  9, 10,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 14: aa_gln
		//C    O  OXT    N    H    CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   OE1  NE2  1HE2 2HE2
		{ 3,   4,  10,   1,  11,   2,  14,   5,  15,  16,   6,  17,  18,   7,   8,   9,  12,  13,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 15: aa_arg
		//C    O  OXT    N    H   CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   1HD  2HD  NE   HE   CZ   NH1  1HH1 2HH1 NH2  1HH2 2HH2
		{ 3,   4,  12,   1,  13,   2,  19,   5,  20,  21,   6,  22,  23,   7,  24,  25,   8,  18,   9,  10,  14,  15,  11,  16,  17,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
 		//row 16: aa_ser
		//C   O OXT   N   H   CA  HA  CB  1HB 2HB OG  HG
	 	{ 3,  4,  7,  1,  8,  2, 10,  5, 11, 12,  6,  9,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 17: aa_thr
		//C    O  OXT   N    H   CA   HA   CB   HB   CG2  1HG2 2HG2 3HG2 OG1  HG1
		{ 3,   4,  8,   1,   9,   2,  11,   5,  12,   7,  13,  14,  15,   6,  10,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	  //row 18: aa_val
		//C    O  OXT    N    H    CA   HA   CB   HB   CG1  1HG1 2HG1 3HG1 CG2  1HG2 2HG2 3HG2
		{ 3,   4,   8,   1,   9,   2,  10,   5,  11,   6,  12,  13,  14,   7,  15,  16,  17,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 19: aa_trp
		// ORIGINAL directly-out-from-backbone ordering.
		//C   O OXT   N   H  CA  HA  CB  1HB 2HB CG  CD1 HD1 NE1 HE1 CD2 CE2 CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		{ 3,  4, 15,  1, 16,  2, 23,  5, 24, 25,  6,  7, 18,  9, 17,  8, 10, 11, 22, 12, 19, 13, 21, 14, 20,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C   O   N   H   CA  HA  CB  1HB 2HB CG   CE2 CD1 HD1 NE1 HE1 CD2  CE3 HE3 CZ2 HZ2 CZ3 HZ3 CH2 HH2
		//{ 3,  4,  1, 15,  2, 22,  5, 23, 24,  6,  10,  7,  17,  9, 16,  8, 11, 21, 12, 18, 13, 20, 14, 19,
		//0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 20: aa_tyr
		// ORIGINAL directly-out-from-backbone ordering.
		//C    O OXT    N    H   CA   HA   CB   1HB  2HB  CG   CD1  HD1  CD2  HD2  CE1  HE1  CE2  HE2  CZ   OH   HH
		{ 3,   4, 13,   1,  14,   2,  20,   5,  21,  22,   6,   7,  16,   8,  19,   9,  17,  10,  18,  11,  12,  15,
		0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		// Reordered to create optimally small subtree sphere size
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   CE1  HE1  CD1  HD1  CD2  HD2  CE2  HE2  CZ   OH   HH
		//{ 3,   4,   1,  13,   2,  19,   5,  20,  21,   6,   9,  16,   7,  15,   8,  18,   10,  17,  11,  12,  14,
		//0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 }
		//dr row 21
		//C  O  OXT  N   H   CA  HA  CB  1HB 2HB  OG  P  O1P  O2P O3P
		{3,  4, 11,  1,  12,  2,  13,  5, 14, 15,  6,  7,  8,  9, 10,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},//KMa phospho_ser
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 4;
		{  // aa_variant == 5 -- extra protons, 1
		//row 1: aa_ala
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  OD1 HD1 OD2
		{ 3,  4,  1,  9,  2,  11,  5,  12, 13,  6,  7, 10,  8,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 4: aa_glu
		//C   O  N   H   CA  HA  CB 1HB 2HB CG 1HG 2HG CD  OE1 HE1 OE2
		{3,  4,  1, 10,  2, 12,  5, 13, 14,  6, 15, 16,  7,  8, 11,  9,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 5: aa_phe
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 6: aa_gly
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 7: aa_his
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  CE1 HE1 CD2 HD2 ND1 HD1 NE2 HE2
		{  3,  4,  1, 11,  2, 14,  5, 15, 16,  6,  9, 17,  8, 18,  7, 12, 10, 13,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 8: aa_ile
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 9: aa_lys
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
	 	//row 10: aa_leu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 11: aa met
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 12: aa_asn
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 13: aa_pro
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 14: aa_gln
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
	 	//row 15: aa_arg
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 16: aa_ser
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 17: aa_thr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 18: aa_val
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 19: aa_trp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 20: aa_tyr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 21
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 5;
		{  // aa_variant == 6 -- extra protons, 2
		//row 1: aa_ala
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  OD1 OD2 HD2
		{ 3,  4,  1,  9,  2,  11,  5,  12, 13,  6,  7,  8, 10,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 4: aa_glu
		//C   O  N   H   CA  HA  CB 1HB 2HB CG 1HG 2HG CD  OE1 OE2 HE2
		{3,  4,  1, 10,  2, 12,  5, 13, 14,  6, 15, 16,  7,  8,  9, 11,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//row 5: aa_phe
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 6: aa_gly
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 7: aa_his
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 8: aa_ile
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 9: aa_lys
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
	 	//row 10: aa_leu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 11: aa met
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 12: aa_asn
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 13: aa_pro
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 14: aa_gln
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
	 	//row 15: aa_arg
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 16: aa_ser
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 17: aa_thr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 18: aa_val
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 19: aa_trp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 20: aa_tyr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 21
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		}, //end aa_variant == 6;
		{  // aa_variant == 7 -- deprotonation variants
		//row 1: aa_ala
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
 		//row 2: aa_cys
 		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 3: aa_asp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 4: aa_glu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 5: aa_phe
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 6: aa_gly
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 7: aa_his
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 8: aa_ile
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 9: aa_lys
		//C   O   N   H   CA  HA  CB  1HB 2HB CG  1HG 2HG CD  1HD 2HD CE  1HE 2HE NZ  1HZ 2HZ
		{ 3,  4,  1, 10,  2, 13,  5, 14, 15,  6, 16, 17,  7, 18, 19,  8, 20, 21,  9, 11, 12,
		0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
	 	//row 10: aa_leu
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 11: aa met
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 12: aa_asn
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 13: aa_pro
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 14: aa_gln
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
	 	//row 15: aa_arg
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   1HG  2HG  CD   1HD  2HD  NE   HE   CZ   NH1  1HH1 2HH1 NH2  1HH2
		{ 3,   4,   1,  12,   2,  17,   5,  18,  19,   6,  20,  21,   7,  22,  23,   8,  16,   9,  10,  13,  14,  11,  15,
		0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
 		//row 16: aa_ser
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 17: aa_thr
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 18: aa_val
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 19: aa_trp
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//row 20: aa_tyr
		//C    O    N    H    CA   HA   CB   1HB  2HB  CG   CD1  HD1  CD2  HD2  CE1  HE1  CE2  HE2  CZ   OH
		{ 3,   4,   1,  13,   2,  18,   5,  19,  20,   6,   7,  14,   8,  17,   9,  15,  10,  16,  11,  12,
		0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 },
		//dr row 21
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 22
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 23
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 24
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 25
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 26
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 27
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 28
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0},
		//dr row 29
		{0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
		} //end aa_variant == 7;
	};

	void
	fullatom_2_trie_order_initializer(FArray3D_int & fullatom_2_trie_order)
	{
		fullatom_2_trie_order = 0;
		for (int ii = 1; ii <= trie_num_supported_variants; ++ii)
		{	for (int jj = 1; jj <= 29; ++jj)//KMa phospho_ser
			{	for (int kk = 1; kk <= rotamer_trie::MAX_ATS_PER_RES; ++kk)
				{	if ( trie_2_fullatom_const[ii-1][jj-1][kk-1] != 0)
					{	fullatom_2_trie_order( trie_2_fullatom_const[ii-1][jj-1][kk-1], jj, ii) = kk;
					}
				}
			}
		}
	}

	//dr changed hardcoded 20's to 28's for NNAA
//	void
//	trie_order_2_fullatom_initializer(FArray3D_int & trie_order_2_fullatom)
//	{
//
//		trie_order_2_fullatom = 0;
//		for (int ii = 1; ii <= trie_num_supported_variants; ++ii )
//		{	for (int jj = 1; jj <= 29; ++jj )//KMa phospho_ser
//			{	for (int kk = 1; kk <= rotamer_trie::MAX_ATS_PER_RES; ++kk)
//				{	trie_order_2_fullatom(kk, jj, ii) = trie_2_fullatom_const[ii-1][jj-1][kk-1];
//				}
//			}
//		}
//	}
	bool         use_rotamer_trie = { false };
	//dr changed hardcoded 20's to 28's for NNAA
	//KMa phospho_ser  29=aa+dna
	FArray3D_int const fullatom_2_trie_order(rotamer_trie::MAX_ATS_PER_RES, 29, trie_num_supported_variants, fullatom_2_trie_order_initializer);
//	FArray3D_int const trie_order_2_fullatom(rotamer_trie::MAX_ATS_PER_RES, 29, trie_num_supported_variants, trie_order_2_fullatom_initializer);

}
