/// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17053 $
//  $Date: 2007-09-08 21:26:28 -0400 (Sat, 08 Sep 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_pdb
#define INCLUDED_pdb

// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


namespace pdb {


//jg  data from the input pdb file
//car atom numbers in these arrays use the fullcoord numbering scheme: n,ca,c,o,cb...

	extern FArray1D_int pdb_res_num;
	extern FArray1D_char res_chain;
	extern FArray1D_char pdb_insert_let;
	extern FArray2D_float bvalue;
	extern FArray2D_float occupancy;
	extern FArray2D_bool missing_input_atom;
}


class Pdb_info {
private:
	FArray1D_int pdb_res_num_;
	FArray1D_char res_chain_;
	FArray1D_char pdb_insert_let_;
	FArray2D_float bvalue_;
	FArray2D_float occupancy_;
	FArray2D_bool missing_input_atom_;
	bool use_pdb_numbering_;
	bool multi_chain_;
  FArray1D_int docking_part_begin_;
  FArray1D_int docking_part_end_;

public:
	// constructor
	Pdb_info();

	// returns the private information to be seen globally
	inline FArray1D_int 					const & pdb_res_num					() const { return pdb_res_num_; }
	inline FArray1D_char 					const & res_chain						() const { return res_chain_; }
	inline FArray1D_char 					const & pdb_insert_let			() const { return pdb_insert_let_; }
	inline FArray2D_float					const & bvalue							() const { return bvalue_; }
	inline FArray2D_float					const & occupancy						() const { return occupancy_; }
	inline FArray2D_bool 					const & missing_input_atom	() const { return missing_input_atom_; }
	inline bool                           use_pdb_numbering   () const { return use_pdb_numbering_; }
  inline bool                           multi_chain         () const { return multi_chain_; }
  inline FArray1D_int 					const & docking_part_begin	() const { return docking_part_begin_; }
	inline FArray1D_int  					const & docking_part_end		() const { return docking_part_end_; }

	int pdb_res_num					( int const pos ) const;
	char res_chain						( int const pos ) const;
	char pdb_insert_let			( int const pos ) const;

	//lin fuction for set value
	void set_pdb_res(
				 int const pos,
				 int const value
				 );
	void set_pdb_occ(
				 int const pos,
				 float const value
				 );
	void set_pdb_bvalue(
											int const atom_index,
											int const pos,
											float const value
											);


	void set_pdb_chain(
				  int const pos,
					char const value
					);

	void set_pdb_insert_let(
					int const pos,
					char const value
					);

	//In case global pdb_info isn't filled (e.g., in some pose modes), fill in some default values.
	void set_pdb_info( int const size_in	);

	void
	figure_out_pdb_info( pose_ns::Pose & pose );

	// copies the pdb info to a global function so that it can later be accessed by things, such as
	// pose
void set_pdb_info(
		 bool const use_pdb_numbering_in,
		 FArray1D_int & res_num_in,
     FArray1D_char & res_chain_in,
     FArray1D_char & pdb_insert_let_in,
     FArray2D_float & bvalue_in,
     FArray2D_float & occupancy_in,
     FArray2D_bool & missing_input_atom_in
	);

void pdb_info_from_global();

void pdb_info_to_global( ) const;

void print_pdb_information(
		int const size
		) const;

//lin overload function
void set_pdb_info(
     int const begin, int const end,
     FArray1D_int const & res_num_in,
     FArray1D_char const & res_chain_in,
     FArray1D_char const & pdb_insert_let_in,
     FArray2D_float const & bvalue_in,
     FArray2D_float const & occupancy_in,
     FArray2D_bool const & missing_input_atom_in
  );

//lin stort the multi chain info :here is only docking_part, can be more
void set_multi_chain_info(
		 bool const use_multi_chain,
		 int const size_in,
     FArray1D_int const & docking_part_begin,
     FArray1D_int const & docking_part_end
);

//lin copy the local to the global
void get_multi_chain_info( int const begin, int const end ) const;

void pdb_info_to_global( int const begin, int const end) const;

void print_pdb_information(
    int const begin, int const end
    ) const;

void
copy_segment(
	int const size,
	Pdb_info const & p,
	int const begin,
	int const src_begin
	);

void
dimension(
		int const size_in
		);

Pdb_info & operator =( Pdb_info const & src );
};

#endif
