// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_planes
#define INCLUDED_planes


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>


// planes Function Declarations


void
read_plane_table();


void
find_plane_orientation(
	int const aa1,
	int const aav1,
	int const aa2,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & plane_totalE
);


void
select_plane_points(
	int const aa1,
	int const aa2,
	FArray1Da_int points_plane1,
	FArray1Da_int points_plane2
);


void
relevant_sidechain_atoms(
	int const aa1,
	int const aa2,
	int & relevant_aa1_start,
	int & relevant_aa1_end,
	int & relevant_aa2_start,
	int & relevant_aa2_end
);


void
calculate_angle_distance(
	numeric::xyzVector_float const & p1,
	numeric::xyzVector_float const & q1,
	numeric::xyzVector_float const & r1,
	numeric::xyzVector_float const & s1,
	numeric::xyzVector_float const & p2,
	numeric::xyzVector_float const & q2,
	numeric::xyzVector_float const & r2,
	numeric::xyzVector_float const & s2,
//	float & centroid_distance, //km don't need upstairs for anything as of now...
	float & plane_angle,
	float & vert_distance,
	float & horiz_distance
);


void
calculate_angle_distance_phobic(
	numeric::xyzVector_float const & p1,
	numeric::xyzVector_float const & q1,
	numeric::xyzVector_float const & r1,
	numeric::xyzVector_float const & p2,
	numeric::xyzVector_float const & q2,
	numeric::xyzVector_float const & r2,
	float & plane_angle,
	float & vert_distance,
	float & horiz_distance
);


void
get_contact_def(
	bool const plane_selected,
	bool const cation_selected,
	bool const proline_selected,
	bool const histadine_selected,
	bool const hydrophobic_selected,
	int & contact_def,
	float & distance_sep
);


void
select_pair(
	int const aa1,
	int const aa2,
	bool & plane_selected,
	bool & hydrophobic_selected,
	bool & cation_selected,
	bool & proline_selected,
	bool & histadine_selected
);


#endif
