// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:  $
//  $Date:  $
//  $Author:  $

// Rosetta Headers
#include "pose_disulfides.h"
#include "pose_abinitio.h"
#include "jumping_pairings.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "barcode_stats.h"
#include "crankshaft.h"
#include "fragments.h"
#include "fragment_class.h"
#include "files_paths.h"
#include "filters.h"
#include "fold_abinitio.h"
#include "force_barcode.h"
#include "fullatom_setup.h"
//#include "fragment_class.h"
#include "fragments.h"
#include "fragments_pose.h"
#include "fragments_ns.h"
#include "fullatom.h"
#include "gunn.h"
#include "idealize.h"
#include "initialize.h"
#include "jumping_diagnostics.h"
#include "jumping_ns.h"
#include "jumping_util.h"
#include "jumping_refold.h"
#include "make_pdb.h"
#include "map_sequence.h"
#include "maps.h"// for jump_relax
#include "maps_ns.h"
#include "misc.h"
#include "monte_carlo.h" // for jumprelax
#include "minimize.h"
#include "native.h"
#include "nblist.h"
#include "output_decoy.h" // for jumprelax
#include "pack_fwd.h"
#include "param.h"
#include "pose.h"
#include "pose_abinitio.h"
#include "pose_idealize.h" // for jumprelax
#include "pose_io.h"
#include "pose_relax.h"
#include "pose_rms.h"
#include "pose_util.h"
#include "pose_vdw.h" // for pose_update_cendist, to find disulfides.
#include "random_numbers.h"
#include "read_paths.h"
#include "read_aa_ss.h"
#include "relax_structure.h" //For jump relax.
#include "relax.h" //For jump relax.
#include "score.h"
#include "silent_input.h"
#include "ssblocks.h"
#include "termini.h"
#include "timer.h"

#include "options.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>

// C++ Headers
#include <algorithm>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

// BOINC
#ifdef BOINC
#include "boinc_rosetta_util.h"
#include "counters.h"
#include "trajectory.h"
#endif


namespace rvjumpdb {

	bool rvjumpdb_read = false;

  std::map<int, std::vector<pose_ns::Jump> > seqsep_dJumps;
	std::vector<pose_ns::Jump> dJumps;

}

namespace pose_disulf {

	bool found_disulf = false;
	FArray2D_int jump_point(2, 100); //roomy? Switch to vector...
	int num_jump = 0;

	int last_jumppos = 0;
	pose_ns::Jump last_jumpmove;
	pose_ns::Jump secondlast_jumpmove;



}


void find_disulfides( pose_ns::Pose & pose){
	using namespace pose_ns;
	using namespace pose_disulf;
	//using namespace numeric;
	int const nres = pose.total_residue();

	pose_update_cendist( pose );
	FArray2D_float const & cendist( pose.get_2D_score( CENDIST) );

	float const DISULFIDE_CUTOFF = 5.0*5.0;

	//FArray2D_float all_cys(nres, nres);
	//int cys_total = 0;
	//FArray1D_int cys_list(nres);

	FArray1D_bool cys_used(nres);

	std::map<float, FArray1D_int> dis_map;
	std::map<float, FArray1D_int>::iterator iter;
	FArray1D_int res_l(2);
	float cdist;

	for (int i = 1; i <= nres; i++){
		cys_used(i) = false;
		if (pose.res(i) != 2) continue; //cysteine = 2.
		//cys_total++;
		//cys_list(cys_total) = i;

		for (int j = i+2; j <= nres; j++){
			if (pose.res(j) != 2) continue; //cysteine = 2.

			cdist = cendist(i,j);

			//std::cout << i << " ----- " << j << " ----- " << cdist << std::endl;

			if (cdist < DISULFIDE_CUTOFF) {
				res_l(1) = i;
				res_l(2) = j;

				bool go_on = false;
				while(false == go_on){
					iter = dis_map.find(cdist);
					if (dis_map.end() == iter) {
						dis_map[cdist] = res_l;
						go_on = true;
					} else {
						cdist += 0.00001;
					}
				}
			}
		}
	}

	//std::ofstream dis_stream( "../disulfides.txt", std::ios::out | std::ios::app );


	for ( iter = dis_map.begin(); iter != dis_map.end(); iter++) {
		int i = iter->second[0];
		int j = iter->second[1];

		if (!cys_used(i) && !cys_used(j)) {
			num_jump++;
			jump_point(1,num_jump) = i;
			jump_point(2,num_jump) = j;
			cys_used(i) = true;
 			cys_used(j) = true;
 			//std::cout << "Hey, found a disulfide! " << i << " - " << j << " |" << std::endl;
			//dis_stream << "Hey, found a disulfide! " << std::abs(i-j) << std::endl;
		}
	}
	//dis_stream << num_jump << std::endl << "XXXXXXXXXXXXXXXXXXXXXXXXXX" << std::endl;

}
///////////////////////////////////////////////////////////////////////////////
void
copy_jumps( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace pose_disulf;

	Pose src_pose_local;
	src_pose_local = src_pose;

	Fold_tree const fold_tree = pose.fold_tree();
	src_pose_local.set_fold_tree( fold_tree );

	int const num_jump = pose.num_jump();
	for (int n = 1; n <= num_jump; n++ ){
		int const i = fold_tree.upstream_jump_residue(n);
		int const j = fold_tree.downstream_jump_residue(n);

		Jump const jump = src_pose_local.get_jump( n );
		pose.set_jump( n, jump );

		pose.set_phi(i, src_pose.phi(i));
		pose.set_psi(i, src_pose.psi(i));
		pose.set_omega(i, src_pose.omega(i));

		pose.set_phi(j, src_pose.phi(j));
		pose.set_psi(j, src_pose.psi(j));
		pose.set_omega(j, src_pose.omega(j));

		// Should we also disallow fragment insertions at these points???
		//pose.set_allow_bb_move( i, false );
		//pose.set_allow_bb_move( j, false );

	}
}

///////////////////////////////////////////////////////////////////////////////
void setup_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	int const nres = pose.total_residue();

	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	//Then set your fold tree!
	Fold_tree fold_tree;
	fold_tree.random_tree_from_jump_points( nres, num_jump, jump_point,
																					get_loop_fraction( nres) );
	pose.set_fold_tree( fold_tree );

	//Another total cheat, copy jumps from native_pose.
	// now go back and fill in the pose variables
	copy_jumps( pose, src_pose);

	//Done!
}

//////////////////////////////////////////////////////
//READ IN RVERNON DISULFIDE DATABASE
//////////////////////////////////////////////////////

void read_in_rvjumpdb( ) {

	using namespace pose_ns;
	using namespace rvjumpdb;

	std::string db_filename( "rv_jump_database.dat" );

	std::cout << "Reading rv_jump database" << std::endl;

	utility::io::izstream dbout( db_filename.c_str() );

	if ( !dbout ) {
		std::cout << "Open failed for file: " << db_filename << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string line;
	char ss_i, ss_j;
	int seq_sep;

	getline( dbout, line );


	rvjumpdb::dJumps.clear();

	std::map<int, std::vector<pose_ns::Jump> >::iterator iter;

  while( getline( dbout, line) ) {
		std::istringstream line_str( line );

		Jump jump;
		line_str >> ss_i >> ss_j >> seq_sep >> jump;

		rvjumpdb::dJumps.push_back(jump);

		int seq_sep_d = seq_sep;
		if (seq_sep_d > 100) seq_sep_d = 100;

		iter = rvjumpdb::seqsep_dJumps.find(seq_sep);
		if ( rvjumpdb::seqsep_dJumps.end() == iter) {
			rvjumpdb::seqsep_dJumps[seq_sep].clear();
			rvjumpdb::seqsep_dJumps[seq_sep].push_back(jump);
		} else {
			rvjumpdb::seqsep_dJumps[seq_sep].push_back(jump);
		}
	}

	std::cout << "end of reading " << std::endl;
	rvjumpdb::rvjumpdb_read = true;

	dbout.close();
	dbout.clear();
}

void setup_disulfide_fold_tree_with_onejump_from_seqsepdb( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	int const nres = pose.total_residue();

	//Figure out where the disulfides are.
// 	if (pose_disulf::found_disulf == false) {
// 		if ( barcode_exist() && barcode_feature_set().disulf_constraints_exist() ) {
// 			barcode_read_disulf_constraints( );
// 		} else {
// 			find_disulfides( src_pose );
// 			pose_disulf::found_disulf = true;
// 		}
// 	}

	if ( barcode_exist() && barcode_feature_set().disulf_constraints_exist() ) {
		barcode_read_disulf_constraints( );
	}

	if (pose_disulf::found_disulf == false) {
			find_disulfides( src_pose );
			pose_disulf::found_disulf = true;
	}

	//Then set your fold tree!
	Fold_tree fold_tree;
	fold_tree.random_tree_from_jump_points( nres, num_jump, jump_point,
																							get_loop_fraction( nres) );
	pose.set_fold_tree( fold_tree );

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	for (int n = 1; n <= num_jump; n++){

		int seq_sep = std::abs(jump_point(1,n)-jump_point(2,n));

		bool fold_tree_success ( false );
		while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!

			int c = pick_jump(seq_sep);

			int rnum = random_range(0,rvjumpdb::seqsep_dJumps[c].size()-1);

			if (pose.set_jump(	n, rvjumpdb::seqsep_dJumps[c][rnum] ) ) {
				//std::cout << " Jump Set: ";
				//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
				fold_tree_success = true;
			}
		}

	}
}



void move_disulfide_fold_tree_with_seqsep( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

 	int n = random_range(1,num_jump);
	pose_disulf::secondlast_jumpmove = pose.get_jump(n);

	int seq_sep = std::abs(jump_point(1,n)-jump_point(2,n));

 	bool fold_tree_success ( false );

 	while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!

 		int c = pick_jump(seq_sep);

 		int rnum = random_range(0,rvjumpdb::seqsep_dJumps[c].size()-1);

 		//std::cout << "seq_sep:" << seq_sep << " c: " << c << std::endl;
 		if (pose.set_jump(	n, rvjumpdb::seqsep_dJumps[c][rnum] ) ) {
 			//std::cout << " Jump Set: ";
 			//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
			pose_disulf::last_jumppos = n;
			pose_disulf::last_jumpmove = rvjumpdb::seqsep_dJumps[c][rnum];
 			fold_tree_success = true;
 		}
 	}
}

int pick_jump( int const & seq_sep ) {

	int range;

	if (seq_sep <= 10) {
		range = 0;
	} else if (seq_sep <= 20) {
		range = 1;
	} else if (seq_sep <= 30) {
		range = 2;
	} else if (seq_sep <= 50) {
		range = 5;
	} else if (seq_sep <= 80) {
		range = 10;
	} else {
		range = 20;
	}

	int rnum = seq_sep + random_range(-range,range);

	if (rnum > 100) rnum = 100;

	return rnum;

}



void setup_disulfide_fold_tree_with_onejump_from_db( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	int const nres = pose.total_residue();

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	//Then set your fold tree!
	Fold_tree fold_tree;
	fold_tree.random_tree_from_jump_points( nres, num_jump, jump_point,
																					get_loop_fraction( nres) );
	pose.set_fold_tree( fold_tree );

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	for (int n = 1; n <= num_jump; n++){

		//Jump jnow( rvjumpdb::dJumps[random_range(0,rvjumpdb::dJumps.size())] );

		bool fold_tree_success ( false );
		while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!

			int rnum = random_range(0,rvjumpdb::dJumps.size()-1);

			if (pose.set_jump(	n, rvjumpdb::dJumps[rnum] ) ) {
				//std::cout << " Jump Set: ";
				//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
				fold_tree_success = true;
			}
		}

	}
}

void move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	int n = random_range(1,num_jump);
	pose_disulf::secondlast_jumpmove = pose.get_jump(n);

	bool fold_tree_success ( false );

	while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!

		int rnum = random_range(0,rvjumpdb::dJumps.size()-1);

		if (pose.set_jump(	n, rvjumpdb::dJumps[rnum] ) ) {
			//std::cout << " Jump Set: ";
			//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
			pose_disulf::last_jumppos = n;
			pose_disulf::last_jumpmove = rvjumpdb::dJumps[rnum];
			fold_tree_success = true;
		}
	}
}

void smooth_move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}


	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	int n = random_range(1,num_jump);
	pose_disulf::secondlast_jumpmove = pose.get_jump(n);

	bool fold_tree_success ( false );

	while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!
		double dist, theta;
		dist = 2.0;

		int smooth = 0;

		while (smooth < 1000) {
			smooth++;

			int rnum = random_range(0,rvjumpdb::dJumps.size()-1);
			jump_distance(  pose.get_jump(n), rvjumpdb::dJumps[rnum], dist, theta );

			if ((dist <= 1.0) && (theta <= 1.0)) {
				smooth = 2000;
				//std::cout << "dist: " << dist << " theta: " << theta << std::endl;
				if (pose.set_jump(	n, rvjumpdb::dJumps[rnum] ) ) {
					//std::cout << " Jump Set: ";
					//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
					pose_disulf::last_jumppos = n;
					pose_disulf::last_jumpmove = rvjumpdb::dJumps[rnum];
					fold_tree_success = true;
				}
			}
		}
	}
}


void score25_move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}


	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	int n = random_range(1,num_jump);
	pose_disulf::secondlast_jumpmove = pose.get_jump(n);

	bool fold_tree_success ( false );

	while ( !fold_tree_success ) { //Ensure that the jumps are all good. Infinite loop if it can't!
		double dist, theta;
		dist = 2.0;

		int smooth = 0;

		while (smooth < 1000) {
			smooth++;

			int rnum = random_range(0,rvjumpdb::dJumps.size()-1);
			jump_distance(  pose.get_jump(n), rvjumpdb::dJumps[rnum], dist, theta );

			if ((dist <= 1.0)) {
				smooth = 2000;
				//std::cout << "dist: " << dist << " theta: " << theta << std::endl;
				if (pose.set_jump(	n, rvjumpdb::dJumps[rnum] ) ) {
					//std::cout << " Jump Set: ";
					//std::cout << rvjumpdb::dJumps[rnum] << std::endl;
					pose_disulf::last_jumppos = n;
					pose_disulf::last_jumpmove = rvjumpdb::dJumps[rnum];
					fold_tree_success = true;
				}
			}
		}
	}
}

///RVERNON: Proprietary! Used for new disulfide protocol tests
void
fold_posedisulf_abinitio(
	pose_ns::Pose & pose,
	bool const score_chainbreaks, // = true
	bool const choose_frag_ss_check, // = true
	float const cycle_factor,  // = 1.0
	float const init_temp // = 2.0
)
{
	using namespace pose_ns;

	//RVERNON
	Pose start_pose;
	Pose native_pose;

	// read native
	initialize_query_pose( start_pose );

	bool native_exists;
	FArray1D_int native_mapping; // from pose to native
	setup_homolog_native( start_pose, native_exists,native_pose,native_mapping );
	setup_disulfide_fold_tree_with_onejump_from_seqsepdb( pose, native_pose );

	int number3merfrags = get_number3merfrags(); // Default 25
	int number9merfrags = get_number9merfrags(); // Default 200

	float const increasecycles = cycle_factor * get_increase_cycles();

	// params
	int const score0_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score1_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score25_cycles( static_cast< int > (2000 * increasecycles) );
	int const score3_cycles(  static_cast< int > (4000 * increasecycles) );
	//float const init_temp( 2.0 );
	choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

	// init score:
	Score_weight_map score0_weight_map( score0 );
	//score0_weight_map.set_weight( CHAINBREAK, 1.0 );//RVERNON - SCORE0 CHAIN WEIGHT
	pose.score( score0_weight_map );

	// create Monte_carlo object that we will use throughout
	Monte_carlo mc( pose, score0_weight_map, init_temp );
	mc.set_autotemp( true, init_temp );

	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const size( 9 );

		for ( int j = 1; j <= score0_cycles; ++j ) {
			if ((j % 50) == 0) {
				move_disulfide_fold_tree_with_seqsep( pose, native_pose );
				mc.boltzmann( pose, "score0_jump" );
			} else {
				choose_fragment_pose( pose, size, choose_frag_ss_check, true );
				mc.boltzmann( pose, "score0_frag" );
			}
			if ( start_sim( pose ) ) break; // all swapped one or more times
			if ( j == score0_cycles ) {
				std::cout << "WARNING:: extended chain may still remain!" << std::endl;
			}
		}
		ai_stats( "score0", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const size(9);

		Score_weight_map weight_map( score1 );
		if ( score_chainbreaks ) {
			weight_map.set_weight( CHAINBREAK, 0.25 );
			weight_map.set_weight( CHAINBREAK_OVERLAP, 0 );
		}
		mc.set_weight_map( weight_map );

		mc.set_temperature( init_temp );

		for ( int j = 1; j <= score1_cycles; ++j ) {
			if ((j % 50) == 0) {
				move_disulfide_fold_tree_with_seqsep( pose, native_pose );
				mc.boltzmann( pose, "score1_jump" );
			} else {
				choose_fragment_pose( pose, size, choose_frag_ss_check, true );
				mc.boltzmann( pose, "score1_frag" );
			}

			if ((j % 1000) == 0) pose = mc.low_pose();

		}

		ai_stats( "score1", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 1;
		int const nloop2 = 10;
		int const size = 9;

		mc.set_temperature( init_temp );

		for ( int jj = 1; jj <= nloop; ++jj ) {
			for ( int kk = 1; kk <= nloop2; ++kk ) {

				float chainbreak_weight(0.0);
				Score_weight_map weight_map; // empty

				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					// score2
					chainbreak_weight = jj*kk*0.25;
					weight_map.set_weights( score2 );
				} else {
					// score5
					chainbreak_weight = jj*kk*0.05;
					weight_map.set_weights( score5 );
				}

				if ( score_chainbreaks ) {
					weight_map.set_weight( CHAINBREAK, chainbreak_weight );
					weight_map.set_weight( CHAINBREAK_OVERLAP, 0.0 );
				}
				mc.set_weight_map( weight_map );
				pose = mc.low_pose();

				for ( int j = 1; j <= score25_cycles; ++j ) {
					if ((j % 50) == 0) {
						score25_move_disulfide_fold_tree( pose, native_pose );
						mc.boltzmann( pose, "score25_jump" );
					} else {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						mc.boltzmann( pose, "score25_frag" );
					}
				}

				ai_stats( "score2/5", pose );
			}
		}
	}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 3;
		int const size = 3;
		float const gunn_cutoff( 7.0 );

		for ( int kk = 1; kk <= nloop; ++kk ) {
			Score_weight_map weight_map( score3 );
			if ( score_chainbreaks ) {
				weight_map.set_weight( CHAINBREAK, kk*0.5+2.5);
				weight_map.set_weight( CHAINBREAK_OVERLAP, kk );
			}
			mc.set_weight_map( weight_map );

			pose = mc.low_pose();

			mc.set_temperature( init_temp );

			if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
			for ( int j = 1; j <= score3_cycles; ++j ) {

				if ((j % 50) == 0) {
					smooth_move_disulfide_fold_tree( pose, native_pose );
					mc.boltzmann( pose, "score3_jump" );
				} else {
					if ( kk == 1 ) {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						mc.boltzmann( pose, "score3_frag" );
					} else {
						choose_fragment_gunn_pose( pose, size, gunn_cutoff );
						mc.boltzmann( pose, "score3_frag" );
					}
				}
			}                  // loop j
			ai_stats( "score3", pose );
		}                     // kk
	}

	score_set_evaluate_all_terms(true);
	pose = mc.low_pose();
	pose.score( score4 ); // output-score
	score_set_evaluate_all_terms(false);

	mc.show_counters();
}



void
fold_salvagejumpmoves_posedisulf_abinitio(
	pose_ns::Pose & pose,
	bool const score_chainbreaks, // = true
	bool const choose_frag_ss_check, // = true
	float const cycle_factor,  // = 1.0
	float const init_temp // = 2.0
)
{
	using namespace pose_ns;

	//RVERNON
	Pose start_pose;
	Pose native_pose;

	// read native
	initialize_query_pose( start_pose );

	bool native_exists;
	FArray1D_int native_mapping; // from pose to native
	setup_homolog_native( start_pose, native_exists,native_pose,native_mapping );
	setup_disulfide_fold_tree_with_onejump_from_seqsepdb( pose, native_pose );

	int number3merfrags = get_number3merfrags(); // Default 25
	int number9merfrags = get_number9merfrags(); // Default 200

	bool accepted = false;

	float const increasecycles = cycle_factor * get_increase_cycles();

	// params
	int const score0_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score1_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score25_cycles( static_cast< int > (2000 * increasecycles) );
	int const score3_cycles(  static_cast< int > (4000 * increasecycles) );
	//float const init_temp( 2.0 );
	choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

	// init score:
	Score_weight_map score0_weight_map( score0 );
	//score0_weight_map.set_weight( CHAINBREAK, 1.0 );//RVERNON - SCORE0 CHAIN WEIGHT
	pose.score( score0_weight_map );

	// create Monte_carlo object that we will use throughout
	Monte_carlo mc( pose, score0_weight_map, init_temp );
	mc.set_autotemp( true, init_temp );

	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const size( 9 );

		for ( int j = 1; j <= score0_cycles; ++j ) {
			if ((j % 50) == 0) {
				move_disulfide_fold_tree_with_seqsep( pose, native_pose );
				mc.boltzmann( pose, "score0_jump" );
			} else {
				choose_fragment_pose( pose, size, choose_frag_ss_check, true );
				mc.boltzmann( pose, "score0_frag" );
			}
			if ( start_sim( pose ) ) break; // all swapped one or more times
			if ( j == score0_cycles ) {
				std::cout << "WARNING:: extended chain may still remain!" << std::endl;
			}
		}
		ai_stats( "score0", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const size(9);

		Score_weight_map weight_map( score1 );
		if ( score_chainbreaks ) {
			weight_map.set_weight( CHAINBREAK, 0.25 );
			weight_map.set_weight( CHAINBREAK_OVERLAP, 0 );
		}
		mc.set_weight_map( weight_map );

		mc.set_temperature( init_temp );

		for ( int j = 1; j <= score1_cycles; ++j ) {
			if ((j % 50) == 0) {
				move_disulfide_fold_tree_with_seqsep( pose, native_pose );
				accepted = 	mc.boltzmann( pose, "score1_jump" );
			} else if (((j % 50) <= 25) && (accepted == false)) {
				redo_last_jump_move(pose, native_pose);
				choose_fragment_pose( pose, size, choose_frag_ss_check, true );
				accepted = mc.boltzmann( pose, "score1_force" );
				if (accepted) {
					revert_to_unmoved_jump(pose, native_pose);
					mc.boltzmann( pose, "score1_revert" );
				}
			} else {
				choose_fragment_pose( pose, size, choose_frag_ss_check, true );
				accepted = mc.boltzmann( pose, "score1_frag" );
			}
			if ((j % 1000) == 0) pose = mc.low_pose();

		}

		ai_stats( "score1", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 1;
		int const nloop2 = 10;
		int const size = 9;

		mc.set_temperature( init_temp );

		for ( int jj = 1; jj <= nloop; ++jj ) {
			for ( int kk = 1; kk <= nloop2; ++kk ) {

				float chainbreak_weight(0.0);
				Score_weight_map weight_map; // empty

				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					// score2
					chainbreak_weight = jj*kk*0.25;
					weight_map.set_weights( score2 );
				} else {
					// score5
					chainbreak_weight = jj*kk*0.05;
					weight_map.set_weights( score5 );
				}

				if ( score_chainbreaks ) {
					weight_map.set_weight( CHAINBREAK, chainbreak_weight );
					weight_map.set_weight( CHAINBREAK_OVERLAP, 0.0 );
				}
				mc.set_weight_map( weight_map );
				pose = mc.low_pose();

				for ( int j = 1; j <= score25_cycles; ++j ) {
				// 	if ((j % 50) == 0) {
// 						score25_move_disulfide_fold_tree( pose, native_pose );
// 						mc.boltzmann( pose, "score25_jump" );
// 					} else {
// 						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
// 						mc.boltzmann( pose, "score25_frag" );
// 					}

					if ((j % 50) == 0) {
						score25_move_disulfide_fold_tree( pose, native_pose );
						accepted = 	mc.boltzmann( pose, "score25_jump" );
					} else if (((j % 50) <= 25) && (accepted == false)) {
						redo_last_jump_move(pose, native_pose);
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						accepted = mc.boltzmann( pose, "score25_force" );
						if (accepted) {
							revert_to_unmoved_jump(pose, native_pose);
							mc.boltzmann( pose, "score25_revert" );
						}
					} else {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						accepted = mc.boltzmann( pose, "score25_frag" );
					}

				}

				ai_stats( "score2/5", pose );
			}
		}
	}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 3;
		int const size = 3;
		float const gunn_cutoff( 7.0 );

		for ( int kk = 1; kk <= nloop; ++kk ) {
			Score_weight_map weight_map( score3 );
			if ( score_chainbreaks ) {
				weight_map.set_weight( CHAINBREAK, kk*0.5+2.5);
				weight_map.set_weight( CHAINBREAK_OVERLAP, kk );
			}
			mc.set_weight_map( weight_map );

			pose = mc.low_pose();

			mc.set_temperature( init_temp );

			if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
			for ( int j = 1; j <= score3_cycles; ++j ) {

// 				if ((j % 50) == 0) {
// 					smooth_move_disulfide_fold_tree( pose, native_pose );
// 					mc.boltzmann( pose, "score3_jump" );
// 				} else {
 					if ( kk == 1 ) {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						mc.boltzmann( pose, "score3_frag" );
					} else {
						choose_fragment_gunn_pose( pose, size, gunn_cutoff );
						mc.boltzmann( pose, "score3_frag" );
					}
// 				}

				if ((j % 50) == 0) {
					smooth_move_disulfide_fold_tree( pose, native_pose );
					accepted = 	mc.boltzmann( pose, "score3_jump" );
				} else if (((j % 50) <= 25) && (accepted == false)) {
					redo_last_jump_move(pose, native_pose);
					if ( kk == 1 ) {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						accepted = mc.boltzmann( pose, "score3_force" );
					} else {
						choose_fragment_gunn_pose( pose, size, gunn_cutoff );
						accepted = mc.boltzmann( pose, "score3_force" );
					}
					if (accepted) {
						revert_to_unmoved_jump(pose, native_pose);
						mc.boltzmann( pose, "score3_revert" );
					}
				} else {
					if ( kk == 1 ) {
						choose_fragment_pose( pose, size, choose_frag_ss_check, true );
						accepted = mc.boltzmann( pose, "score3_frag" );
					} else {
						choose_fragment_gunn_pose( pose, size, gunn_cutoff );
						accepted = mc.boltzmann( pose, "score3_frag" );
					}
				}


			}                  // loop j
			ai_stats( "score3", pose );
		}                     // kk
	}

	score_set_evaluate_all_terms(true);
	pose = mc.low_pose();
	pose.score( score4 ); // output-score
	score_set_evaluate_all_terms(false);

	mc.show_counters();
}


void redo_last_jump_move( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	int n = pose_disulf::last_jumppos;
	if (n > 0) {
		pose.set_jump(	n, pose_disulf::last_jumpmove ) ;
	}
}

void revert_to_unmoved_jump( pose_ns::Pose & pose, pose_ns::Pose & src_pose ){
	using namespace pose_ns;
	using namespace rvjumpdb;
	using namespace pose_disulf;

	//Figure out where the disulfides are.
	if (pose_disulf::found_disulf == false) {
		find_disulfides( src_pose );
		pose_disulf::found_disulf = true;
	}

	if (rvjumpdb::rvjumpdb_read == false) {
		read_in_rvjumpdb();
	}

	int n = pose_disulf::last_jumppos;
	if (n > 0) {
		pose.set_jump(	n, pose_disulf::secondlast_jumpmove ) ;
	}
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
