// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_dna
#define INCLUDED_pose_dna


// Rosetta Headers
#include "dna_fwd.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>

// C++ Headers
#include <vector>

///////////////////////////////////////////////////////////////////////////////
//

void
analyze_dna();


void
dna_test();


void
jim_test();


void
bqian_dna_test();


void
setup_simple_dna_fold_tree(
	pose_ns::Pose & pose,
	FArray1Da_bool exclude
);


void
dna_info(
	pose_ns::Pose & pose,
	std::string const & tag
);


numeric::xyzVector_float
get_y_axis(
	int const aa,
	int const strand,
	FArray2Da_float coords
);


void
find_chainbreaks(
	int const nres,
	FArray1D_int const & res,
	FArray3D_float const & coords,
	int & ncuts,
	FArray1D_int & cuts
);


void
base_pair_params(
	int const aa1,
	int const aa2,
	FArray2Da_float base1_coords,
	FArray2Da_float base2_coords,
	FArray1D_float & params // output
);


void
calc_dna_dihedrals(
	int const nres,
	FArray1D_int const & aan,
	FArray3D_float const & xyz,
	FArray2D_float & dna_dihedrals
);


void
dna_pair_score(
	pose_ns::Pose & pose,
	float & aa_score_total,
	float & r_score_total
);


float
dna_vdw(
	pose_ns::Pose & pose,
	int const i, // amino acid position
	int const j // dna position
);


bool
setup_dna_scoring();

void
set_basepairs_from_pair_vector(
	pose_ns::Pose & pose,
	DnaSeqInfo & pairs
);

int
get_dna_bp_atom(
	int const aa,
	int const aav
);


void
calc_dna_bp_deriv(
	int const rsd1,
	pose_ns::Pose const & pose,
	numeric::xyzVector_float & F1,
	numeric::xyzVector_float & F2
);


void
calc_new_dna_bs_deriv(
	int const rsd1,
	pose_ns::Pose const & pose,
	numeric::xyzVector_float & F1,
	numeric::xyzVector_float & F2
);


float
eval_dna_bp_score(
	pose_ns::Pose const & pose
);


float
eval_new_dna_bs_score(
	pose_ns::Pose const & pose
);

bool
is_orthonormal(
							 numeric::xyzMatrix_float const & M,
							 float const tol
							 );

void
setup_base_atoms(
	int const aa,
	FArray2DB_float const & coords,
	std::vector< numeric::xyzVector_float > & atoms
);

numeric::xyzVector_float
lsf_normal(
	std::vector< numeric::xyzVector_float > const & atoms_in
);

#endif
