// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8705 $
//  $Date: 2006-06-06 16:15:21 -0700 (Tue, 06 Jun 2006) $
//  $Author: pbradley $


// Rosetta Headers
#include "pose_fold_and_dock.h"
#include "aaproperties_pack.h" //TEMPORARY!!
#include "after_opts.h"
#include "electron_density.h"
#include "files_paths.h"
#include "fold_abinitio.h"
#include "force_barcode.h"
#include "fragments.h"
#include "fragments_ns.h" //some stupid checks.
#include "fragments_pose.h"
#include "gunn.h"
#include "initialize.h"
#include "job_distributor.h"
#include "jumping_util.h"
#include "jumping_pairings.h" //for initialize_query_pose
#include "maps.h"
#include "native.h"
#include "param.h"
#include "param_aa.h"
#include "pdb.h"
#include "pose.h"
#include "pose_abinitio.h"
#include "pose_docking.h"
#include "pose_io.h"
#include "pose_relax.h"
#include "pose_symmetric_docking.h"
#include "pose_rms.h"
#include "pose_vdw.h"
#include "random_numbers.h"
#include "relax_structure.h" //for farlx_cycle_ratio.
#include "torsion_bbmove_trials.h"
#include "score.h"
#include "score_ns.h"
#include "silent_input.h"
#include "ssblocks.h"

// Docking
#include "docking.h"
#include "docking_score.h"
#include "docking_ns.h"
#include "dock_structure.h"
#include "docking_minimize.h"
#include "docking_movement.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.o.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>

// BOINC
#ifdef BOINC
#include "boinc_rosetta_util.h"
#include "counters.h"
#include "trajectory.h"
#endif

////////////////////////////////////////////////////////////////////////////
// Rhiju and Ingemar, March 2007.
//
//  Simple mash-up of docking (potentially symmetric) and folding.
//  This may be better off as a pose1 type routine, rather than
//  going through traditional Rosetta docking...
//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void
find_new_jump_residues( pose_ns::Pose & pose ){
  using namespace pose_ns;
  using namespace pose_param;


  pose_update_cendist( pose ); //may not be necessary if computing VDW anyway.
  FArray2D_float const & cendist( pose.get_2D_score( CENDIST ) );

  Fold_tree f = pose.fold_tree();

  int const cutpoint = f.cutpoint_by_jump( dock_jump );
  float mindist = 1000000.0;
  int interface_point1 = f.upstream_jump_residue( dock_jump );
  int interface_point2 = f.downstream_jump_residue( dock_jump );

  for (int i = 1; i <= cutpoint; i++) {
    for (int j = cutpoint+1; j <= pose.total_residue(); j++) {
      if (cendist(i,j) < mindist){
				mindist = cendist(i,j);
				interface_point1 = i;
				interface_point2 = j;
      }
    }
  }

  //Assume that fold tree will only have one jump, for now!!!
	assert( f.get_num_jump() == 1 );
  f.simple_tree( pose.total_residue() );
  f.new_jump( interface_point1, interface_point2, cutpoint );

  pose.set_fold_tree( f );

}


/////////////////////////////////////////////////////////////////////////////////
void
rotate_anchor_to_x_axis( pose_ns::Pose & pose ){

	using namespace pose_ns;
	using namespace numeric;
	using namespace numeric::conversions;

	//first anchor point -- assume its the first jump.
	Fold_tree f( pose.fold_tree() );
	int const anchor = f.downstream_jump_residue( 1 );


	//Where is this stupid anchor point now?
	FArray3D_float Epos = pose.Eposition();
	numeric::xyzVector_float Epos_anchor( &Epos(1, 2, anchor) );
	float theta = std::atan2(  Epos_anchor(2), Epos_anchor(1) );

  xyzMatrix_double M = Z_rot( -1.0 * degrees( theta ) );

	FArray2D_float Epos_new(3, param::MAX_POS, 0.0);
	//This is all a tad explicit, but I couldn't
	// get j.set_rotation() to work properly.
	for (int n = 1; n <= pose.fold_tree().get_num_jump(); n++){

		int const jump_point1 = f.upstream_jump_residue( n );
		int const jump_point2 = f.downstream_jump_residue( n );

		//Only look at jumps that connect a pseudoresidue to a real residue.
		if ( pose.pseudo(jump_point1) && !pose.pseudo( jump_point2) ) {

			for (int j = 1; j <= param::MAX_POS; j++){
				xyzVector_double Evec( & Epos(1,j,jump_point2) );
				Evec = M * Evec;
				for (int k = 1; k <= 3; k++)	Epos_new(k,j) = Evec(k);
			}
			Jump j( Epos(1,1,jump_point1),  Epos_new(1,1) );
			j.reverse();

			pose.set_jump( n, j );

		}
	}

}


//////////////////////////////////////////////////////////////////////////////
void
find_new_symmetric_jump_residues( pose_ns::Pose & pose ){
  using namespace pose_ns;
  using namespace pose_param;

  pose_update_cendist( pose ); //may not be necessary if computing VDW anyway.
  FArray2D_float const & cendist( pose.get_2D_score( CENDIST ) );

	int const N( pose.symmetry_info().N_bb() );
  Fold_tree f = pose.fold_tree();
	int nres_monomer = f.cutpoint_by_jump( 1 );

	//Looking in central half of each segment -- pick a random point.
	int anchor = static_cast<int>( ran3() * (nres_monomer/2) ) +
		(nres_monomer/4) + 1;
	//	int interface_point2 = cutpoint + interface_point1;

	static bool const set_anchor_at_closest_point = truefalseoption( "set_anchor_at_closest_point" );
	if ( set_anchor_at_closest_point )
	{
		//Find Closest point of contact.
		float mindist = cendist( anchor, anchor + nres_monomer);
		for (int i = 1; i <= nres_monomer; i++) {
			int const j = i + nres_monomer;
			if (cendist(i,j) < mindist){
				mindist = cendist(i,j);
				anchor = i;
			}
		}
	}


	// Following worked, but had to create a monomer pose,
	//  which led to jerky graphics.
	// 	if (false)
	// 	{
	// 		pose.dump_pdb("before_anchor.pdb");
	// 		std::string const type = pose.symmetry_info().symm_type();
	// 		Pose monomer_pose, new_pose;
	// 		create_monomer_pose( pose, monomer_pose, cutpoint );
	// 		monomer_pose.dump_pdb( "monomer_anchor.pdb");
	//
	// 		numeric::xyzVector_float origin( 0.0 );
	// 		numeric::xyzVector_float z_axis( 0.0, 0.0, 1.0 );
	// 		create_symmetric_pose( monomer_pose, pose.fullatom(),
	// 													 N, anchor, origin, z_axis, type, new_pose );
	// 		pose = new_pose;
	// 		pose.dump_pdb("after_anchor.pdb");
	// 	}


	//Can following be generalized to more monomers?
	if (true)
	{
		int njump;
		FArray2D_int jump_point( f.get_jump_point() );
		FArray1D_int cuts( f.get_fold_tree_cutpoint( njump) );

		for (int n = 1 ; n <= njump; n++) {
			if ( pose.pseudo( jump_point(1,n) ) && !pose.pseudo( jump_point(2,n) ) )
			{
				jump_point(1, n) = anchor + (n - 1) * nres_monomer;
				jump_point(2, n) = N * nres_monomer + n;
				cuts( n ) = n * nres_monomer;
			}
		}

		Fold_tree f_new;
		// this builds the tree:
		f_new.tree_from_jumps_and_cuts( pose.total_residue(), njump,
																		jump_point, cuts, false /* verbose */ );
		f_new.reorder( N * nres_monomer + 1);
		pose.set_fold_tree( f_new );
	}

	return;

	//Following no longer necessary -- slide into contact
	// does not assume anchor points are on z axis.
	//	{
	//		pose.dump_pdb("before_zrot.pdb");
	//	rotate_anchor_to_x_axis( pose );
	//	pose.dump_pdb("after_zrot.pdb");
	//	}
	//	std::exit( 0 );
}


//
// This function may no longer work, after changes to
// fold tree setup by rhiju and ingemar.
//
bool slide_away_from_z( pose_ns::Pose & pose, double const slide_increment ){
	using namespace pose_ns;
	using namespace numeric;

	//first anchor point -- assume its the first jump.
	Fold_tree f( pose.fold_tree() );
	//	int const anchor = f.downstream_jump_residue( 1 );

	FArray3D_float Epos = pose.Eposition();
	FArray2D_float Epos_new(3, param::MAX_POS, 0.0);
	bool hit_z_axis( false );

	for (int n = 1; n <= pose.fold_tree().get_num_jump(); n++){
		int const jump_point1 = f.upstream_jump_residue( n );
		int const jump_point2 = f.downstream_jump_residue( n );

		if ( pose.pseudo(jump_point1) && !pose.pseudo( jump_point2) ) {

			//translate amounts?
			xyzVector_float t_xy( & Epos(1,1,jump_point2) );
			t_xy(3) = 0.0; //don't shift z component.
			float const t_length = t_xy.length();
			t_xy.normalize();
			t_xy *= slide_increment;

			hit_z_axis = (t_length <= 1.0 );
			for (int j = 1; j <= param::MAX_POS; j++){
				for (int k = 1; k <= 3; k++)	Epos_new(k,j) = Epos(k,j,jump_point2) + t_xy(k) ;
			}

			Jump j( Epos(1,1,jump_point1),  Epos_new(1,1) );
			j.reverse();
			pose.set_jump( n, j );
		}
	}

	return hit_z_axis; //hit_z_axis?
}



//////////////////////////////////////////////////////////////////////////////
//
// This function may no longer work, after changes to
// fold tree setup by rhiju and ingemar.
//
void
pose_symm_slide_into_contact(
  pose_ns::Pose & pose
)
{
	using namespace pose_ns;
  using namespace docking;

	float const monomer_vdw = 0.0;
	float vdw = 999.9;
	bool hit_z_axis = false;

	Score_weight_map weight_map( score4d );

	static double const slide_increment = realafteroption( "slide_increment", 0.1);
	while ( vdw > monomer_vdw + 0.3 ) {
		slide_away_from_z( pose, slide_increment );
		pose.score( weight_map );
		vdw = pose.get_0D_score( pose_ns::DOCK_VDW );
	}


	int ntries( 0 );
	while ( vdw < monomer_vdw + 0.3 && !hit_z_axis && ntries++ < 1000) {
		hit_z_axis = slide_away_from_z( pose, -1.0 * slide_increment );
		pose.score( weight_map );
		vdw = pose.get_0D_score( pose_ns::DOCK_VDW );
	}

	slide_away_from_z( pose, 1.0 );

}

//////////////////////////////////////////////////////////////////////////////
void
fragment_trial( pose_ns::Pose & pose,
								pose_ns::Monte_carlo & mc,
								int const size,
								bool const smooth_move = false
) {

  using namespace pose_ns;

  float const gunn_cutoff( 7.0 );
	bool const choose_frag_ss_check = false;
	bool const do_end_bias_check = false;

	static bool const move_anchor_points = truefalseoption("move_anchor_points");
	if (move_anchor_points){
		if (get_pose_symmetry_docking_flag()) {
			find_new_symmetric_jump_residues( pose );
		} else {
			find_new_jump_residues( pose );
		}
	}

  if (smooth_move){
    choose_fragment_gunn_pose( pose, size, gunn_cutoff );
  } else {
    choose_fragment_pose( pose, size, choose_frag_ss_check, do_end_bias_check );
  }

  std::string tag = smooth_move ? "frag-smooth" : "frag";
	//	transform_to_principal_frame ( pose ); //for electron density.
	mc.boltzmann( pose, tag );
}

//////////////////////////////////////////////////////////////////////////////
void
rigid_body_trial( pose_ns::Pose & pose,
									pose_ns::Monte_carlo & mc,
									bool const smooth_move = false
									)
{
  //Docking options
	static float const rot_mag          = realafteroption( "rot_mag", 5.0 );
	static float const rot_mag_smooth   = realafteroption( "rot_mag_smooth", 1.0 );
	static float const trans_mag        = realafteroption( "trans_mag", 0.5 );
	static float const trans_mag_smooth = realafteroption( "trans_mag_smooth", 0.1 );

  float const rot_mag_trial = smooth_move ? rot_mag_smooth : rot_mag;
	float const trans_mag_trial = smooth_move ? trans_mag_smooth : trans_mag;
	//	float const trans_mag = 0.0;
  std::string tag = smooth_move ? "rb-smooth" : "rb";

	static int const rigid_body_cycles = intafteroption( "rigid_body_cycles", 100);

	static bool const dn_sixdim_search = truefalseoption( "dn_sixdim_search" );
	if (!dn_sixdim_search) rotate_anchor_to_x_axis( pose );


	for (int n = 1; n<= rigid_body_cycles; n++){
		if (get_pose_symmetry_docking_flag()){
			symm_move( pose, rot_mag_trial, trans_mag_trial );
		} else {
			pose_docking_set_rb_center( pose );
			pose_docking_gaussian_rigid_body_move( pose, 1/*jump*/, trans_mag_trial, rot_mag_trial );
		}

		//		transform_to_principal_frame ( pose ); //for electron density.
		mc.boltzmann( pose, tag );
	}

}

//////////////////////////////////////////////////////////////////////////////
void
slide_into_contact_trial( pose_ns::Pose & pose,
													pose_ns::Monte_carlo & mc )
{

  if (get_pose_symmetry_docking_flag()){
		// This function no longer works.
		//		pose_symm_slide_into_contact( pose );

		static bool const dn_sixdim_search = truefalseoption( "dn_sixdim_search" );
		if (!dn_sixdim_search)		rotate_anchor_to_x_axis( pose );
    pose_docking_symm_perturb_rigid_body( pose );
  } else {
    slide_into_contact( pose );
  }
	//	transform_to_principal_frame ( pose ); //for electron density.
  mc.boltzmann( pose, "slide" );
}

//////////////////////////////////////////////////////////////////////////////
// Following could occur during every score, right?
// wouldn't be too expensive.
void update_rms_min( pose_ns::Pose & pose ) {
	using namespace pose_ns;
	calc_rms( pose );

	Score_state rms_score_state, rms_min_score_state; //This is just in case RMSD_MIN is not initialized.
	float const rms     = pose.get_0D_score( RMSD,     rms_score_state );
	float const rms_min = pose.get_0D_score( RMSD_MIN, rms_min_score_state );

	if (rms_score_state != BAD) { //OK, got an rms in there.
		if	(rms_min == 0.0 || //rms_min not initialized
				 rms < rms_min) //new rms is better
			pose.set_0D_score( RMSD_MIN, rms );
		else
			pose.set_0D_score( RMSD_MIN, rms_min ); //Still need to "set", for book_keeping ?
	}
}

//////////////////////////////////////////////////////////////////////////////
void
move_trial( pose_ns::Pose & pose,
						pose_ns::Monte_carlo & mc,
						int const size,
						bool const smooth_move = false){

	fragment_trial( pose, mc, size, smooth_move );

	//Rigid body adjustment with some probability
	static float const rigid_body_frequency =
		realafteroption("rigid_body_frequency", 0.1);
	if  (ran3() < rigid_body_frequency) rigid_body_trial( pose, mc, smooth_move );

	//Slide into contact with some probability
	static float const slide_contact_frequency =
		realafteroption("slide_contact_frequency", 0.1);
	if  (ran3() < slide_contact_frequency) slide_into_contact_trial( pose, mc );

	update_rms_min( pose );
}


//////////////////////////////////////////////////////////////////////////////
void
fold_and_dock(
     pose_ns::Pose & pose,
     bool const score_chainbreaks /*= false*/,
     float const cycle_factor /*= 1.0*/,
     float const init_temp /*= 2.0*/
)
{
  using namespace pose_ns;

  int number3merfrags = get_number3merfrags(); // Default 25
  int number9merfrags = get_number9merfrags(); // Default 200

  float increasecycles = cycle_factor * get_increase_cycles();
	if (truefalseoption("benchmark")) increasecycles = 0.01; //super fast test.

  // params
  int const score0_cycles(  static_cast< int > (2000 * increasecycles) );
  int const score1_cycles(  static_cast< int > (2000 * increasecycles) );
  int const score25_cycles( static_cast< int > (2000 * increasecycles) );
  int const score3_cycles(  static_cast< int > (4000 * increasecycles) );
  //float const init_temp( 2.0 );
  choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

  // init score:
  Score_weight_map score0_weight_map( score0 );
  pose.score( score0_weight_map );
	update_rms_min( pose ); //might be useful in other trials/protocols too.

  // create Monte_carlo object that we will use throughout
  Monte_carlo mc( pose, score0_weight_map, init_temp );
  mc.set_autotemp( true, init_temp );

  std::cout << "starting fragment insertions..." << std::endl;

  decide_block_state();

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	if (!main_job_distributor::jd->skip_to_mc_checkpoint())  {

    int const size( 9 );

    for ( int j = 1; j <= score0_cycles; ++j ) {
      move_trial( pose, mc, size );

      if ( start_sim( pose ) ) break; // all swapped one or more times
      if ( j == score0_cycles ) {
	std::cout << "WARNING:: extended chain may still remain!" << std::endl;
      }
    }
    ai_stats( "score0", pose );
  }


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  {
    int const size(9);

    Score_weight_map weight_map( score1 );
    if ( score_chainbreaks ) {
			weight_map.set_weight( CHAINBREAK, 0.25 );
			weight_map.set_weight( CHAINBREAK_OVERLAP, 0 );
    }
    mc.set_weight_map( weight_map );

    mc.set_temperature( init_temp );

    for ( int j = 1; j <= score1_cycles; ++j ) {
			if (mc.checkpoint( pose )) continue;
      move_trial( pose, mc, size );
    }

    ai_stats( "score1", pose );
  }

  // XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
  //   Add cbeta, rg (collapse chain)
  //   alternate score2/score5 (high/low sheet weight)
  //   convergence-checking enabled in monte_carlo
  // XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  {
    int const nloop = 1;
    int const nloop2 = 10;
    int const size = 9;

    mc.set_temperature( init_temp );

    for ( int jj = 1; jj <= nloop; ++jj ) {
      for ( int kk = 1; kk <= nloop2; ++kk ) {

	float chainbreak_weight(0.0);
	Score_weight_map weight_map; // empty

	if ( mod( kk, 2 ) == 0 || kk > 7 ) {
	  // score2
	  chainbreak_weight = jj*kk*0.25;
	  weight_map.set_weights( score2 );
	} else {
	  // score5
	  chainbreak_weight = jj*kk*0.05;
	  weight_map.set_weights( score5 );
	}

	if ( score_chainbreaks ) {
	  weight_map.set_weight( CHAINBREAK, chainbreak_weight );
	  weight_map.set_weight( CHAINBREAK_OVERLAP, 0.0 );
	}
	mc.set_weight_map( weight_map );
	pose = mc.low_pose();

	for ( int j = 1; j <= score25_cycles; ++j ) {
		if (mc.checkpoint( pose )) continue;
		move_trial( pose, mc, size );
	}

	ai_stats( "score2/5", pose );
      }
    }
  }

  // XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
  //   regular moves/smooth moves
  //   score 3 ->all centroid based terms on
  // XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  {
    int const nloop = 3;
    int const size = 3;

    for ( int kk = 1; kk <= nloop; ++kk ) {
      Score_weight_map weight_map( score3 );
      if ( score_chainbreaks ) {
				weight_map.set_weight( CHAINBREAK, kk*0.5+2.5);
				weight_map.set_weight( CHAINBREAK_OVERLAP, kk );
      }
      mc.set_weight_map( weight_map );

      pose = mc.low_pose();

      mc.set_temperature( init_temp );

      if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
      for ( int j = 1; j <= score3_cycles; ++j ) {
				if (mc.checkpoint( pose )) continue;
				if ( kk == 1 ) {
					move_trial( pose, mc, size );
				} else {
					move_trial( pose, mc, size, true /*smooth_move*/ );
				}
      }                  // loop j
      ai_stats( "score3", pose );
    }                     // kk
  }

  score_set_evaluate_all_terms(true);
  pose = mc.low_pose();
  pose.score( Score_weight_map( score4 ) ); // output-score
  score_set_evaluate_all_terms(false);

  mc.show_counters();
}

//////////////////////////////////////////////////////////////////////////////
void
initialize_symmetric_pose( pose_ns::Pose & pose, int const nres_monomer )
{
	using namespace pose_ns;
  using namespace docking;

	Pose oligomer_pose,monomer_pose,tmp_pose;
	numeric::xyzVector_float origin, z_axis;
	int const N ( docking_pose_symm_subsystem_size );
	int anchor;
	std::string type ( symm_type );
	//	bool const fullatom ( get_docking_fullatom_flag() );

	//	pose.dump_pdb( "start_pose.pdb" );

	//Create oligomer_pose.
	if (pose.total_residue() < N * nres_monomer) {
		// starting pose is just the monomer
		oligomer_pose.simple_fold_tree( N * nres_monomer );
		for (int n = 1; n <= N; n++){
			oligomer_pose.copy_segment( nres_monomer, pose, nres_monomer*(n-1) + 1, 1, false);
		}
		create_monomer_pose( oligomer_pose, monomer_pose, nres_monomer );
	} else {
		//User has given the full pose. But this needs to
		// be oriented to the  symmetric coordinate system.

		//		create_monomer_pose( pose, monomer_pose, nres_monomer );
		Pose tmp_mon_pose;
		tmp_mon_pose.simple_fold_tree( nres_monomer );
		tmp_mon_pose.copy_segment( nres_monomer, pose, 1, 1, true );
		//		monomer_pose.dump_pdb("monomer_pose0.pdb");
		if ( pose_symm_n_monomers == 2 ) {
			prepare_native_dimer( pose, tmp_mon_pose, oligomer_pose );
			pose = oligomer_pose;
		} else if ( symm_type == "cn" && pose_symm_n_monomers > 2 ) {
			prepare_native_cn( pose, tmp_mon_pose, oligomer_pose );
			pose = oligomer_pose;
//		} else if ( symm_type == "dn" && pose_symm_n_monomers == 4 ) {
//			 prepare_native_d2( pose, tmp_mon_pose, oligomer_pose );
//			 pose = oligomer_pose;
		}	else {
			oligomer_pose = pose;
		}
		monomer_pose.simple_fold_tree( nres_monomer );
    monomer_pose.copy_segment( nres_monomer, oligomer_pose, 1, 1, true );
	}
	//	monomer_pose.dump_pdb("monomer_pose.pdb");
	//	oligomer_pose.dump_pdb("oligomer_pose.pdb");

	// Setup coordinate system this coordinate system is only used for cyclic
	// symmetry now
	pose_docking_symm_coordsys_setup(monomer_pose, oligomer_pose,
																	 anchor, z_axis, origin, 200);

	monomer_pose.set_fullatom_flag( false );
	monomer_pose.score( score4d );

	// Create symmetric pose
	create_symmetric_pose( monomer_pose, false /*fullatom*/, pose_symm_n_monomers, anchor,
												 origin, z_axis, type, pose );

	Pdb_info pdb_info;
	pdb_info.dimension( pose.total_residue());
	pdb_info.copy_segment( oligomer_pose.total_residue(), oligomer_pose.pdb_info(), 1, 1 );
	pose.set_pdb_information( pdb_info );

	//Following may be redundant, but doesn't hurt.
	for (int i=1; i <= pose.total_residue(); i++) {
		 bool const occ = !pose.pseudo(i);
		for (int k=1; k<=param::MAX_ATOM()(); k++) {
			pdb::occupancy( k, i ) = occ;
		}
	}

}

//////////////////////////////////////////////////////////////////////////////
pose_ns::Score_weight_map
setup_fullatom_scorefxn()
{
  static bool const use_score10d = truefalseoption("use_score10d");
	pose_ns::Score_weight_map w( score12 );

	if (use_score10d){
		w = pose_ns::Score_weight_map( score10d );
	}

	return w;
}


//////////////////////////////////////////////////////////////////////////////
void
pose_relax_symm(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;

	files_paths::mode_title = "Symmetric relax";

	int lj_ramp_cycles = 8;
	int const cycles_per_residue = { 1 };
	int cycles = static_cast<int> ( cycles_per_residue * pose.total_residue() * get_farlx_cycle_ratio() );
	if (truefalseoption("benchmark")){
		lj_ramp_cycles = 0;
		cycles = 1;
	}
	bool const vary_sidechain_bond_angles = truefalseoption("vary_sidechain_bond_angles");
	bool const allow_rb_moves = true; //truefalseoption("allow_rb_moves");
	pose.set_fullatom_flag(true);

	// Set allow bb_move
	pose.set_allow_bb_move(false);
	pose.set_allow_chi_move(false);
	pose_ns::Symmetry_info const & s( pose.symmetry_info() );
  for ( int i=1; i<= pose.total_residue_for_scoring(); ++i ){
    if ( s. bb_independent(i) ) pose.set_allow_bb_move ( i, true );
    if ( s.chi_independent(i) ) pose.set_allow_chi_move( i, true );
  }
	//Should we allow rb_moves?
	pose.set_allow_jump_move( false );
	if ( allow_rb_moves ) {
		if ( s.symm_type() == "cn" ) {
			set_allow_dg_free_cn(pose);
		} else if ( s.symm_type() == "helix" ) {
			set_allow_dg_free_helix(pose);
		} else if ( s.symm_type() == "dn" ) {
			set_allow_dg_free_dn(pose);
		} else {
			error_stop("fast_relax is only implemented for cn symmetry for now");
		}
	}

	Score_weight_map weight_map = setup_fullatom_scorefxn();
  static float const filter1  = realafteroption("filter1" ,9999999999.);
  static float const filter1a = realafteroption("filter1a",9999999999.);
  static float const filter1b = realafteroption("filter1b",9999999999.);
  static float const filter2  = realafteroption("filter2" ,9999999999.);

	// Set cut_weights to 0.0 for now. Problem with cut after last chain
	const Fold_tree & f( pose.fold_tree() );
  int const num_fold_tree_cutpoint( f.get_num_fold_tree_cutpoint() );
	FArray1D_float cut_weight( num_fold_tree_cutpoint, 0.0 );
  weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );
	pose.score(weight_map);

	//Symmetric minimize asumes anchor is along x-axis!
	rotate_anchor_to_x_axis( pose );

	//Keep track of where we started.
	calc_rms( pose );
	float const init_rmsd = pose.get_0D_score( RMSD );

	// We enter fast relax
	fast_relax_pose( pose, weight_map, lj_ramp_cycles, cycles, "tmp", 1.0, vary_sidechain_bond_angles,
                   filter1, filter1a, filter1b, filter2);

	pose.set_extra_score("INIT_RMSD", init_rmsd);

}
/////////////////////////////////////////////////////////////////////////////
void
convert_symmetric_to_regular( pose_ns::Pose & pose ){
	using namespace pose_ns;

	// Copy symmetric pose to a new pose without pseudo residues
	Pose  pose_out;
	int const N( pose.symmetry_info().N_bb() );
	int const nres_monomer( pose.symmetry_info().nres_monomer_bb() );

	std::cout << "Converting symmetric pose to regular pose" << std::endl;
	std::cout << "POSE     " << pose.show_scores() << std::endl;

	pose_out.simple_fold_tree( nres_monomer*N );
	pose_out.set_fullatom_flag( true, false );
	pose_out.copy_segment( nres_monomer*N, pose, 1, 1 );
	pose_out.update_backbone_bonds_and_torsions();
	pose_docking_build_simple_tree( pose_out, nres_monomer*N, nres_monomer );
	pose_out.set_fullatom_flag( pose.fullatom() );

  score_set_evaluate_all_terms(true);
	if (pose.fullatom()){
		Score_weight_map weight_map = setup_fullatom_scorefxn();
		pose_out.score( weight_map );
	} else {
		pose_out.score( score4 );
	}
  score_set_evaluate_all_terms(false);

	scores::symm_mon_score = pose_out.get_0D_score(pose_ns::SCORE);
	if (pose.native_pose_exists()) pose_out.set_native_pose( pose.native_pose() );
	calc_rms( pose_out );

	//RMS MIN INFO?
	Score_state dummy;
	float const rms_min = pose.get_0D_score( RMSD_MIN, dummy );
	if (rms_min > 0.0) pose_out.set_0D_score( RMSD_MIN, rms_min );

	//RELAX SCORE FILTERS, INIT RMSD, etc.
	pose_out.set_extra_scores( pose.get_extra_scores() );

	std::cout << "POSE_OUT " << pose_out.show_scores() << std::endl;

	pose = pose_out;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// Temporary!!
//////////////////////////////////////////////////////////////////////////////

/*void
mock_electron_density_map( pose_ns::Pose & pose ){
	using namespace electron_density_map;

	int const nres = pose.total_residue();
	FArray3D_float const & full_coord = pose.full_coord();

	int const NUMGRID = 20;
	float const spacing = 2.0;

	xgrid.dimension( NUMGRID );
	ygrid.dimension( NUMGRID );
	zgrid.dimension( NUMGRID );

	density_map.dimension( NUMGRID, NUMGRID, NUMGRID);

	float x_center( 0.0 ), y_center( 0.0), z_center( 0.0 );
	int numpoints( 0 );

	for (int i = 1; i <= nres; i++){
		int const natoms
			( aaproperties_pack::natoms( pose.res(i), pose.res_variant(i) ) );
		for (int j = 1; j <= natoms; j++){
			x_center += full_coord(1, j, i);
			y_center += full_coord(2, j, i);
			z_center += full_coord(3, j, i);
			numpoints++;
		}
	}
	x_center /= numpoints;
	y_center /= numpoints;
	z_center /= numpoints;


	for (int i = 1; i <= nres; i++){
		int const natoms
			( aaproperties_pack::natoms( pose.res(i), pose.res_variant(i) ) );
		for (int j = 1; j <= natoms; j++){
			int const x = static_cast<int>( (full_coord(1,j,i) - x_center) /spacing ) + NUMGRID/2;
			int const y = static_cast<int>( (full_coord(2,j,i) - y_center) /spacing ) + NUMGRID/2;
			int const z = static_cast<int>( (full_coord(3,j,i) - z_center) /spacing ) + NUMGRID/2;

			if ( x < 1 || x > NUMGRID) continue;
			if ( y < 1 || y > NUMGRID) continue;
			if ( z < 1 || z > NUMGRID) continue;

			density_map( x, y, z ) += 1;
		}
	}

	for (int i = 1; i <= NUMGRID; i++ ){
		xgrid(i) = spacing* (i -  NUMGRID/2) + x_center;
		ygrid(i) = spacing* (i -  NUMGRID/2) + y_center;
		zgrid(i) = spacing* (i -  NUMGRID/2) + z_center;
	}

	density_map_initialized = true;

	std::cerr << "Initialized DENSITY MAP." << std::endl;

}*/

/*void
fill_density_grid()
{
	using namespace electron_density_map;

	int const size1 = ( native_electron_density.data_point_size()(1) );
	int const size2 = ( native_electron_density.data_point_size()(1) );
	int const size3 = ( native_electron_density.data_point_size()(1) );

	xgrid.dimension(size1);
	ygrid.dimension(size2);
	zgrid.dimension(size3);

	for (int i = 1; i <= size1; ++i) {
		xgrid(i) = native_electron_density.grid_step()(1)*i;
	}
	for (int i = 1; i <= size2; ++i) {
	    ygrid(i) = native_electron_density.grid_step()(2)*i;
	}
	for (int i = 1; i <= size3; ++i) {
	    zgrid(i) = native_electron_density.grid_step()(3)*i;
	}

}*/
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void
copy_fragments_to_clones( int const nres_monomer, int const docking_pose_symm_subsystem_size ){

	for (int i = 1; i < docking_pose_symm_subsystem_size; i++ ) {
		//Copy fragments from first clone to other clones. Sigh. What a waste of memory.
		copy_fragments( 1 /*source*/, 1 + nres_monomer * i /*destination*/, nres_monomer /*number*/ );
	}

}

//////////////////////////////////////////////////////////////////////////////
void
pose_fold_and_dock_initialize( pose_ns::Pose & pose )
{
	using namespace pose_ns;
	using namespace docking;

	std::cout << "pose fold and dock protocol" << std::endl;
	// read options

	docking_pose_symmetry = truefalseoption("docking_pose_symmetry");
  docking_pose_symm_full = truefalseoption("docking_pose_symm_full");
  intafteroption("pose_symm_n_monomers",2,pose_symm_n_monomers);
	docking_pose_symm_subsystem = truefalseoption("docking_pose_symm_subsystem");
  docking_pose_symm_subsystem_size = docking_pose_symm_subsystem ? 3 : pose_symm_n_monomers;
	stringafteroption("symm_type", "cn", symm_type);
	docking_randomize1     = truefalseoption("randomize1");
	docking_randomize2     = truefalseoption("randomize2");
	docking_small_perturbation = truefalseoption("dock_pert") ||
    (!docking_randomize1 && !docking_randomize2);
	if ( docking_small_perturbation ) real3afteroption("dock_pert",3.0,
    normal_perturbation,8.0,parallel_perturbation,8.0,rotational_perturbation);
	flexbb_docking_flag = true;
	docking_local_refine = truefalseoption("docking_local_refine");
	docking::monomer_input = true;


	// Special case for dn because we have a subsystem size of 3-5
	if ( symm_type == "dn" && docking_pose_symm_subsystem ) {
		dn_with_3 = truefalseoption("dn_with_3");
		dn_with_5 = truefalseoption("dn_with_5");
		docking_pose_symm_subsystem_size = 4;
		if ( dn_with_3 ) {
			docking_pose_symm_subsystem_size = 3;
		} else if ( dn_with_5 ){
			docking_pose_symm_subsystem_size = 5;
		}
	}
	// setup flags
	docking_flag = true;

	bool const start_pdb = truefalseoption("s");
	bool const	native_exists = truefalseoption("n");

	//defines length, sequence of start_pose
	char chain_save = files_paths::protein_chain;
	// docking_pose_symmetry toggled off/on to avoid MAX_RES resize
	if (native_exists) docking::docking_pose_symmetry = false;

	initialize_query(); // Reads in bbdep, and all the stuff we need for full atom relax.

	docking::docking_pose_symmetry = true;

  initialize_maps();

	Pose start_pose;
  initialize_query_pose( start_pose );
	int const nres_monomer = start_pose.total_residue();

// resize max_res
// This actually needs to be done well in advance, during initialize_query.
// Changed fasta readin (inside read_aa_ss.cc) to set MAX_RES properly.
// for docking_pose_symmetry.
	int const nres = docking_pose_symm_subsystem_size  * (nres_monomer + 1);
	int const nres_real = docking_pose_symm_subsystem_size * nres_monomer;
	param::MAX_RES_assign_res( nres );

	//Define parts to help out in display.
	docking::docking_native::native_part_end(1) = nres_monomer;
	docking::docking_native::native_part_end(2) = nres_real;
	docking::docking_native::native_part_begin(2) = nres_monomer+1;
	docking::docking_native::native_part_end(2) = nres_real;

	docking::docking_query::part_begin(1) = 1;
	docking::docking_query::part_end(1) = nres_monomer;
	docking::docking_query::part_begin(2) = nres_monomer+1;
	docking::docking_query::part_end(2) = nres_real;

	files_paths::multi_chain = true;


	//////////////////////////////////////////////////////
	//More initialization.

	files_paths::protein_chain = chain_save; //stupid but necessary.
	read_fragments( nres_monomer );
	copy_fragments_to_clones( nres_monomer, docking_pose_symm_subsystem_size );

	if (start_pdb) {
	// Read starting structure into pose
		// docking_pose_symmetry toggled off/on to avoid MAX_RES resize
		docking::docking_pose_symmetry = false;
	  pose_from_pdb( pose, stringafteroption( "s" ), false /*fullatom*/, false /*ideal_pose*/, true /*read_all_chains*/);
		docking::docking_pose_symmetry = true;
	} else {
		//Start from scratch
		pose = start_pose;
		insert_init_frag( pose, 1, nres_monomer);
		pose.reset_bonds();
	}

	pose.set_fullatom_flag( false );
  if (get_pose_symmetry_docking_flag()){
		initialize_symmetric_pose( pose, nres_monomer );
		pose.set_fullatom_flag( false );
		pose.score( score4d );
		rotate_anchor_to_x_axis( pose );
    pose_docking_symm_perturb_rigid_body( pose );
  } else {
    pose_docking_perturb_rigid_body( pose); //randomize1, slide into contact, etc.
  }


	//	if (!start_pdb) pose.reset_bonds();

	//
	// THIS WILL LIKELY SCREW UP WITH PDBS THAT
	// HAVE NON-IDEAL BONDS. Ingemar, let's fix this,
	// and make sure we can handle symmetric output to
	// silent files with non-ideal bonds!
	//
	pose.reset_bonds();

	pose.set_allow_bb_move( false );
	pose_ns::Symmetry_info const & s( pose.symmetry_info() );
	for ( int i=1; i<= pose.total_residue_for_scoring(); ++i ){
    if ( s. bb_independent(i) ) pose.set_allow_bb_move ( i, true );
  }

	barcode_initialize_start( nres_monomer );

	//Setup native pose?
	static Pose native_pose;
	if (native_exists){
		docking::docking_pose_symmetry = false;
		pose_from_pdb( native_pose, stringafteroption("n"),
									 false /*fullatom*/, false /*ideal_pose*/, true /*read all chains*/);
		docking::docking_pose_symmetry = true;
		pose_to_native( native_pose );
		pose.set_native_pose( native_pose);

		//Make a mock electron density map
		//mock_electron_density_map( native_pose );
		//read_electron_density_map();
		//Following may be redundant, but doesn't hurt.
		native::native_occupancy = true;
		for (int i=1; i <= pose.total_residue(); i++) {
			if (pose.pseudo(i)) {
			for (int k=1; k<=param::MAX_ATOM()(); k++)
				native::native_occupancy( k, i ) = false;
			}
		}
	}
	// electron density read in
	read_electron_density_map();
	//fill_density_grid();

	return;
}

/////////////////////////////////////////////////////////////////////////////
void
pose_relax_symm_test()
{
	using namespace pose_ns;
	using namespace silent_io;

	if (!truefalseoption("s")){
		std::cout << "Hey, you need to specify a starting symmetric pdb:     -s <pdb> .";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//Initialize
	Pose init_pose;
	pose_fold_and_dock_initialize( init_pose );

	//Outfile
	std::string const output_file_name = stringafteroption("o","new.out");
	if (output_file_name == "new.out") {
		std::string command = "rm -f "+output_file_name+"  "+output_file_name+".list";
		std::system( command.c_str() );
	}
	Silent_out out( output_file_name );

	//Let's go!
	int nstruct =	intafteroption("nstruct",1);
	for (int n = 1; n<= nstruct; n++){

		std::string tag( "S_"+string_of(n) );
		if ( !out.start_decoy(tag) ) continue; // already done or started

		Pose pose;

		pose = init_pose;

		calc_rms( pose );
		float const init_rms = pose.get_0D_score( RMSD );

		pose_relax_symm( pose );

		//		convert_symmetric_to_regular( pose );

		pose.set_extra_score( "INIT_RMSD", init_rms );

		out.write( tag, pose );
	}


}

/////////////////////////////////////////////////////////////////////////////
void
pose_fold_and_dock_test()
{
  using namespace pose_ns;
  using namespace docking;
	using namespace silent_io;

	files_paths::mode_title="Fold+Dock";

	bool const  pose_relax = truefalseoption("pose_relax");
	bool const comb_rms = truefalseoption("combinatorial_rms_sym");

	//	if (!pose_relax) files_paths::skip_dun = true; //skip bbdep, avgE, all that protein crap.

	Pose init_pose;
	pose_fold_and_dock_initialize( init_pose );
	//	numeric::xyzVector_float center_of_mass (0);
	//	numeric::xyzMatrix_float PC(0);
	//	principal_moments_of_inertia( init_pose,center_of_mass, PC);
	//	init_pose.dump_pdb("before_pc.pdb");
	//	init_pose.score(score4);
	//	transform_to_principal_frame(init_pose, center_of_mass, PC);
	//	init_pose.dump_pdb("after_pc.pdb");
	//	std::exit(0);

	Silent_out out( files_paths_pdb_out_prefix_nochain()+".out" ); //The most common name of an outfile....

	//////////////////////////////////////////
	// Here we go!
	//////////////////////////////////////////
	int nstruct;
	intafteroption("nstruct",1000,nstruct);
	for (int n = 1; n<= nstruct; n++){
		std::string tag( "S_"+string_of(n) );
		if ( !out.start_decoy(tag) ) continue; // already done or started

		Pose pose;
		pose  = init_pose;

		barcode_initialize_decoy();

		//Do it!
		fold_and_dock( pose );
		if (pose_relax) 			pose_relax_symm( pose );

		// Turn on combinatorial symmetry calculation
		if ( comb_rms ) combinatorial_rms_sym = true;
		if (pose.native_pose_exists()) calc_rms( pose );
		combinatorial_rms_sym = false;
		if (pose.native_pose_exists()) calc_monomer_rms( pose );
		//		if (get_pose_symmetry_docking_flag())	 convert_symmetric_to_regular( pose );

		out.write( tag, pose );

		main_job_distributor::jd->reset_mc_checkpoint(); // reset monte carlo checkpoint counter
#ifdef BOINC
		out.append_to_list( tag ); // mark as done
		store_low_info(); // for trajectory plotting.
		clear_trajectory();
		counters::monte_carlo_ints::ntrials = 0;
		int farlx_stage = 0;
		bool ready_for_boinc_end = boinc_checkpoint_in_main_loop(n, n, nstruct, farlx_stage);
		if (ready_for_boinc_end)	return; // Go back to main, which will then go to BOINC_END and shut off BOINC.
#endif
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////
void
calc_monomer_rms(
	pose_ns::Pose & pose
	)
	{
		using namespace pose_ns;
		Fold_tree f = pose.fold_tree();
		int nres_monomer = f.cutpoint_by_jump( 1 );
		Pose monomer_pose, monomer_pose_native;
		monomer_pose.simple_fold_tree( nres_monomer );
		monomer_pose_native.simple_fold_tree( nres_monomer );
		monomer_pose.copy_segment( nres_monomer, pose, 1, 1, false);
		monomer_pose_native.copy_segment(  nres_monomer, pose.native_pose(), 1, 1, false);
		float	rms = CA_rmsd( monomer_pose_native, monomer_pose );
		pose.set_extra_score("MON_RMSD", rms);

	}


//////////////////////////////////////////////////////////////////////////////////////////////////////
void
convert_symmetric_outfile_to_regular_outfile()
{

	using namespace pose_ns;
	using namespace silent_io;

  const bool fullatom( truefalseoption("fa_input") );
	Pose pose;

	std::string silent_file_name= stringafteroption("s");

  // read silent file
  Silent_file_data decoys( silent_file_name, fullatom );
	if ( !decoys.size() ) {
    std::cout << "STOP:: couldnt open silent-file!! " << std::endl;
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

	//Setup new silent file for output.
	std::string default_output_file_name = silent_file_name;
	unsigned int n = default_output_file_name.rfind(".out");
	default_output_file_name.replace(n,4,"_regular.out");
	std::string const output_file_name = stringafteroption("o",default_output_file_name);

	//Overwrite any previous outfile.
	std::string command = "rm -f "+output_file_name;
	std::system( command.c_str() );
	Silent_out out( output_file_name );

  // setup tag list
  std::vector< std::string > tag_list;
	tag_list = decoys.tags();

	// loop through the tag list
  for ( std::vector< std::string >::const_iterator it=tag_list.begin(),
					it_end = tag_list.end(); it != it_end; ++it ) {

    std::string const & tag( *it );

    if ( ! decoys.has_key( tag ) ) {
      std::cout << "couldnt find tag in silent-file: " << tag << std::endl;
      continue;
    }

    // get the data
    Silent_structure const & decoy( decoys.get_structure( tag ) );

		//Fresh pose for each decoy. (Necessary for RNA stuff, which sets up atom trees.)
		Pose pose;

    // fill the pose
    decoy.fill_pose( pose, true );

		convert_symmetric_to_regular( pose );

		out.write( tag, pose );
  }

}


//////////////////////////////////////////////////////////////////////////////

/*void
setup_extra_jump_for_electron_density( pose_ns::Pose & pose ){
  using namespace pose_ns;
  using namespace pose_param;

	int const N( pose.symmetry_info().N_bb() );
	int const nres_monomer ( pose.symmetry_info().nres_monomer() );
  Fold_tree f = pose.fold_tree();

	float const length(  1.5 );
	float const z(-10.0);
	//Num_anchor should suffice, but
	// there's some fold_tree error if nres = 1.
  pseudo_pose.simple_fold_tree( 2 );

  // Set coordinates for pseudo glycines.
	FArray3D_float Epos(3, param::MAX_POS , 2 );
	for (int i=1; i<=2; ++i) {
		Epos(1,1,i) = length;
		Epos(2,1,i) = 0.0;
		Epos(3,1,i) = z;

		Epos(1,2,i) = 0.0;
		Epos(2,2,i) = 0.0;
		Epos(3,2,i) = z;

		Epos(1,3,i) = 0.0;
		Epos(2,3,i) = 0.0;
		Epos(3,3,i) = z + length;

		Epos(1,4,i) = 0.0;
		Epos(2,4,i) = length;
		Epos(3,4,i) = z;

		Epos(1,5,i) = length;
		Epos(2,5,i) = length;
		Epos(3,5,i) = z;

		pseudo_pose.set_res( i, param_aa::aa_gly );
		pseudo_pose.set_res_variant( i, 1 );
	}
  pseudo_pose.set_coords( false, Epos, FArray3D_float() );
  pseudo_pose.set_fullatom_flag( true, false ); // only glycine anyway

	int const njump = f.get_num_jump();
	FArray2D_int jump_point( 2, njump+1);
	FArray1D_int cuts( njump+1 );

	for (int n = 1 ; n <= njump; n++) {
		jump_point(1, n) = anchor + (n - 1) * nres_monomer;
		jump_point(2, n) = N * nres_monomer + n;
		cuts( n ) = n * nres_monomer;
	}
	// Add extra jump
		jump_point(1,njump+1) = N*nres_monomer + 1;
		jump_point(2,njump+1) = N*nres_monomer + njump + 1;
		cuts( njump+1) = N*nres_monomer + 1;
		Fold_tree f_new;
		// this builds the tree:
		f_new.tree_from_jumps_and_cuts( pose.total_residue()+1, njump+1,
																		jump_point, cuts, false );
		f_new.reorder( N * nres_monomer + 1);
		pose.set_fold_tree( f_new );
	}

	return;

	//Following no longer necessary -- slide into contact
	// does not assume anchor points are on z axis.
	//	{
	//		pose.dump_pdb("before_zrot.pdb");
	//	rotate_anchor_to_x_axis( pose );
	//	pose.dump_pdb("after_zrot.pdb");
	//	}
	//	std::exit( 0 );
}
*/

/*void
transform_pose_into_density(
	pose_ns::Pose & pose
)
{
	assert( electron_density_map::density_map_initialized );

	int const total_residue (pose.total_residue());
	FArray2D_float Eca ( 3, total_residue, 0.0f);
	FArray2D_float Eca_temp ( 3, total_residue, 0.0f);
  for (int i = 1; i <= total_residue; i++){
    for(int j = 1; j <= 3; j++){
      Eca( j, i) = pose.Eposition()( j, 2, i);
    }
  }
	Eca_temp=Eca;
	int score_save (0);
	for (int i = -1; i <= 1; i += 2){
    for (int res = 1; res <= total_residue; res++) Eca_temp(1, res) = Eca(1, res) * i;

    for (int j = -1; j <= 1; j += 2){
      for (int res = 1; res <= total_residue; res++) Eca_temp(2, res) = Eca(2, res) * j;

      int k = i*j;
      assert (i*j*k == 1); //can't violate parity.
      for (int res = 1; res <= total_residue; res++) Eca_temp(3, res) = Eca(3, res) * k;

			numeric::xyzVector_float center_of_mass(0);
			numeric::xyzMatrix_float PC(0);
			principal_moments_of_inertia(Eca_temp,center_of_mass,PC);
			transform_to_principal_frame(Eca_temp,center_of_mass,PC);
			score_density(Eca);
			score < score_save

}*/
