// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17056 $
//  $Date: 2007-09-08 22:32:06 -0400 (Sat, 08 Sep 2007) $
//  $Author: csmith $

#ifndef INCLUDED_pose_io
#define INCLUDED_pose_io


// Rosetta Headers
#include "pose_fwd.h"

#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <string>

namespace pose_io {
	enum BVAL_SRC { BORN_RADIUS, CHARGE, PDB_BVAL };
	extern BVAL_SRC bval_src;
}

void
pose_from_misc(
	pose_ns::Pose & pose,
	bool const fullatom,
	bool const ideal_pos,
	bool const coords_init
	);


void
fullatom_nonideal_initialized_pose_from_misc( pose_ns::Pose & pose );


void
read_ligand(
						std::string const & filename
						);

bool
pose_from_pdb(
	pose_ns::Pose & pose,
	std::string const & filename,
	bool const fullatom,
	bool const ideal_pose,
	bool const read_all_chains = false,
	char const chain = '-',
	bool const skip_missing = false,
	bool const allow_missing = false
);


void
copy_pose_fullatom_energies_to_best(
	pose_ns::Pose & pose
);


void
copy_fullatom_energies_to_pose(
	pose_ns::Pose & pose
);


void
dump_Eposition(
	const pose_ns::Pose & pose,
	const std::string filename,
	bool const overwrite = false
);


void
dump_Eposition(
	const pose_ns::Pose & pose,
	std::ostream & out
);


void
open_full_coord_outfile(
	utility::io::ozstream & out,
	std::string const & tag,
	bool const overwrite = false
);


void
dump_full_coord(
	pose_ns::Pose const & pose,
	std::string const & tag,
	bool const overwrite = false
);


void
dump_full_coord(
	pose_ns::Pose const & pose,
	std::ostream & out,
	std::string const extra_tag = ""
);


void
dump_rsd(
	int const seqpos,
	pose_ns::Pose const & pose,
	int & atom_number,
	std::ostream & out,
	std::string const extra_tag = ""
);


void
output_decoy_pose(
	pose_ns::Pose const & pose
);


void
output_torsions(
	pose_ns::Pose const & pose,
	std::ostream & out
);


void
output_CA_pdb(
	int const nres,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & xyz, // Epos or full_coord
	utility::io::orstream & out
);


#endif
