// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20460 $
//  $Date: 2008-02-18 23:02:35 -0500 (Mon, 18 Feb 2008) $
//  $Author: possu $


// Rosetta Headers
#include "pose_main.h"
#include "after_opts.h"
#include "barcode_stats.h"
#include "cluster_fragments.h"
#include "evolve.h"
#include "electron_density.h"
//#include "cfr.h"
#include "files_paths.h"
#include "free_energy_estimate.h"
#include "enzyme.h"
#include "featurizer.h"
#include "fibril.h"
#include "kin_test.h"
#include "homolog_distances.h"
#include "jumping_pairings.h"
#include "lig_looprlx.h"
#include "output_decoy.h"
#include "pose.h"
#include "pose_abinitio.h"
#include "pose_dna.h"
#include "pose_design.h"
#include "pose_benchmark.h"
#include "pose_fold_and_dock.h"
#include "pose_idealize.h"
#include "pose_backrub.h"
#include "pose_symmetric_docking.h"
#include "remodel.h"
#include "pose_io.h"
#include "pose_ligand.h"
#include "pose_relax.h"
#include "pose_rna.h"
#include "pose_sse.h"
#include "pdbstats.h" // for collect_hb_stats
#include "score.h"
#include "silent_input.h"
#include "pose_jjh_loops.h"

// ObjexxFCL Headers

// C++ Headers
#include <cstdlib>
#include <cstdio>
#include <fstream>

#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.o.hh>

//Utility Headers
#include <utility/basic_sys_util.hh>

//Graphics
#ifdef GL_GRAPHICS
#include "gl_graphics.h"
#include <pthread.h>
#endif

///////////////////////////////////////////////////////////////////////////////
// called if mode == "pose1"
//
// only do initialize_rosetta, no initialize_query, initialize_decoy, etc
//

void
main_pose1( int const n_struct, int const nstart)
{
#ifdef GL_GRAPHICS
	open_windows( true );
#endif
	if ( truefalseoption("pose_benchmark") ) {
		pose_benchmark();
	} else if ( truefalseoption("pose_barcode_stats") ) {
		pose_barcode_stats();
	} else if ( truefalseoption("bk_min" ) ) {
		bk_min_test();
	} else if ( truefalseoption("jumping" ) ) {
		pose_ai( true /* jumping */);
	} else if ( truefalseoption("pose_abinitio" ) ) {
		pose_ai( false /* jumping */ );
	} else if (truefalseoption("electron_density_score") ) {
		electron_density_score_test();
	} else if ( truefalseoption("extract") ) {
		extract_decoy();
	} else if ( truefalseoption("pose_rhiju") ) {
		pose_rhiju();
	} else if ( truefalseoption("close_chainbreaks" ) ) {
		main_close_chainbreaks();
	} else if ( truefalseoption("evolution") ){
		evolution_manager(n_struct, nstart);
	} else if ( truefalseoption("evol_recomb") ){
		evolution_manager_recomb(n_struct);
	} else if ( truefalseoption("pose_idealize") ) {
		main_pose_idealize();
	} else if ( truefalseoption("jjh_loops" ) ) {
		dna_jjh_loops();
	} else if ( truefalseoption("featurize" ) ) {
		featurize();
	} else if ( truefalseoption("centroid_information" ) ) {
		extract_centroid_information_wrapper();
	} else if ( truefalseoption("dna_water_refine" ) ) {
		dna_jjh_refine();
	} else if ( truefalseoption("dna_loop_min" ) ) {
		dna_loop_min();
	} else if ( truefalseoption("mj_min" ) ) {
		mj_min_test();
	} else if ( truefalseoption("backrub_mc" ) ) {
		pose_backrub_mc(n_struct, nstart);
	} else if ( truefalseoption("backrub_test" ) ) {
		pose_backrub_test();;
	} else if ( truefalseoption("adna" ) ) {
		analyze_dna();
	} else if ( truefalseoption("pdna" ) ) { // pose_dna
		dna_test();
	} else if ( truefalseoption("prna" ) ) { // pose_rna
		rna_test();
	} else if ( truefalseoption("pose_sse" ) ) {
		pose_sse_test();
	} else if ( truefalseoption("extract_segment" ) ) {
		extract_segment_test();
	} else if ( truefalseoption("cst_mode" ) ) {
		cst_mode_test();
	} else if ( truefalseoption("pose_stats") ) {
		pose_stats();
	} else if ( truefalseoption("fibril") ) {
		fibril_test();
	} else if ( truefalseoption("hb_stats") ) {
		collect_hb_stats();
	} else if ( truefalseoption("lig_looprlx" ) ) {
		lig_looprlx_wrapper();
	} else if ( truefalseoption("lig_min" ) ) {
		lig_min();
	}else if (truefalseoption("pose_ligand_docking")){
		ligand_docking_function();
	} else if ( truefalseoption("pose_relax_symm") ) {
		pose_relax_symm_test();
	} else if ( truefalseoption("pose_fold_and_dock") ) {
		pose_fold_and_dock_test();
	} else if ( truefalseoption("convert_symmetric_to_regular") ) {
		convert_symmetric_outfile_to_regular_outfile();
	} else if ( truefalseoption("prepare_native") ) {
		prepare_native();
	}	else if ( truefalseoption("prepare_native_dimer") ) {
		prepare_native_dimer();
	} else if ( truefalseoption("c1_symm_test") ) {
		c1_symm_test();
	} else if ( truefalseoption("pose_relax") ) {
		pose1_relax_main();
	} else if ( truefalseoption("homolog_rescore") ) {
		homolog_rescore();
	} else if ( truefalseoption("pose_rescore_silent") ) {
		pose_rescore_silent();
	} else if ( truefalseoption("pose_maxsub_score" ) ) {
		pose_maxsub_score();
	} else if ( truefalseoption("homolog_score_list") ) {
		make_homolog_scored_pdbs();
	} else if ( truefalseoption("remodel")){
		remodel();
	} else if ( truefalseoption("cluster_frags") ) {
		cluster_fragments();
	} else if ( truefalseoption("fragment_quality") ) {
		fragment_quality();
	} else if ( truefalseoption("cluster_by_maxsub") ) {
		cluster_by_maxsub();
	} else if ( truefalseoption("homolog_distances") ) {
		get_distances();
	} else if (truefalseoption("electron_density") ) {
		read_electron_density_map();
	} else if ( truefalseoption("free_energy") ) {
		free_energy_test();
	}	else {

		pose_relax_test();

		// you can put calls to routines you want to test here
		dna_test();

		kin_test();
		darpa_test();

		jim_test();


	}
#ifdef GL_GRAPHICS
	set_worker_done( true );
#endif
}


///////////////////////////////////////////////////////////////////////////////
void reduce_pose_to_first_chain( pose_ns::Pose & pose ){
	using namespace pose_ns;
	Pose first_chain_pose;

	//Find first cutpoint
	int i( 0 );
	for (i = 1; i <= pose.total_residue(); i++ ) {
		if (pose.is_cutpoint( i )) break;
	}
	int const cutpoint = i;

	first_chain_pose.simple_fold_tree( cutpoint );
	first_chain_pose.copy_segment( cutpoint, pose, 1, 1, false );
	pose = first_chain_pose;
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
// extract a tag " -t <> " from a silent-file " -s <> "
void
extract_decoy()
{
  using namespace silent_io;
  using namespace pose_ns;

  const bool fullatom( truefalseoption("fa_input") );
	Pose pose;


	std::string silent_file_name= stringafteroption("s");
	std::string start_pdb_name;
	stringafteroption("start_pdb","dummy",start_pdb_name);
	if ( start_pdb_name != "dummy" ) {
		Silent_out silent_out;
		bool const ideal_pose = { false }; // non-idealized structure
		bool read_all_chains = true; //default is to read all chains in
		char chain_id = '-';
		if ( truefalseoption("chain") ) stringafteroption("chain", '-', chain_id);
		if ( chain_id != '-' ) read_all_chains = false; // read only this chain
		files_paths::no_optH = truefalseoption("no_optH");
		bool const skip_missing = truefalseoption("skip_missing_residues");
		bool const allow_missing = skip_missing ? true : false;
		pose_from_pdb(pose, start_pdb_name, fullatom, ideal_pose,
			read_all_chains, chain_id, skip_missing, allow_missing );
		// dump out bonds and rot_templates files
		silent_out.store_rotamers( pose );
		silent_out_write_nonideal_geometry( pose, silent_out,
			silent_file_name);
	}

	files_paths::skip_dun = true;

  // read silent file
  Silent_file_data decoys( silent_file_name, fullatom );
	if ( !decoys.size() ) {
    std::cout << "STOP:: couldnt open silent-file!! " << std::endl;
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

  // setup tag list
  std::vector< std::string > tag_list;
  if ( truefalseoption("t") ) {
    tag_list.push_back( stringafteroption("t") );
	} else if ( truefalseoption("all") ) {
		tag_list = decoys.tags();
  } else if ( truefalseoption("l") ) {
    std::ifstream data( stringafteroption("l").c_str() );
    if ( !data.good() ) {
      std::cout << "STOP:: cant open tags file: " << std::endl;
      utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    }
    std::string tag;
    while ( getline(data,tag) ) {
      tag_list.push_back(tag);
    }
		data.close();
  }

	// silly:
	std::string prefix( files_paths_pdb_out_prefix() );
	if ( files_paths::protein_chain == '-' ||
			 files_paths::protein_chain == '_' ) {
		// who likes hyphens or underscores in their pdbs ?
		files_paths::protein_chain = ' ';
	}


	static bool const extract_first_chain = truefalseoption( "extract_first_chain" );

	// loop through the tag list
  for ( std::vector< std::string >::const_iterator it=tag_list.begin(),
					it_end = tag_list.end(); it != it_end; ++it ) {

    std::string const & tag( *it );

    if ( ! decoys.has_key( tag ) ) {
      std::cout << "couldnt find tag in silent-file: " << tag << std::endl;
      continue;
    }

    // get the data
    Silent_structure const & decoy( decoys.get_structure( tag ) );

		//Fresh pose for each decoy. (Necessary for RNA stuff, which sets up atom trees.)
		Pose pose;

    // fill the pose
    decoy.fill_pose( pose, true );

		if (extract_first_chain)  reduce_pose_to_first_chain( pose );

		pose.dump_pdb( prefix+tag+".pdb" );
  }
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void
pose_stats()
{
	using namespace pose_ns;

	// setup scoring function
	Score_weight_map w( score12 );

	// PBHACK
	w.set_weight( SIDECHAIN_BOND_ANGLE, 50.0 );


	// read dunbrack file
	std::vector< std::pair< std::string, char > > files;

	if ( truefalseoption("cullpdb") ) {
		std::ifstream data( stringafteroption("cullpdb").c_str() );
		std::string line, id, pdb;
		char chain;
		getline( data,line);
		while ( getline( data,line) ) {
			std::istringstream is( line );
			is >> id;
			pdb = lowercased( id.substr(0,4) );
			chain = id[4];
			if ( chain == '0' ) chain = ' ';
			std::string const filename( "/net/pdb/"+pdb.substr(1,2)+"/"+pdb+".pdb" );
			files.push_back( std::make_pair( filename, chain ) );
		}
		data.close();
	} else {
		std::ifstream data( stringafteroption("l").c_str() );
		std::string line;
		while ( getline( data,line) ) {
			files.push_back( std::make_pair( line, '-' ) );
		}
		data.close();
	}


	// now loop over pdbs
	for ( int c=0; c< int(files.size()); ++c ) {
		std::string const filename( files[c].first );
		char const chain( files[c].second );

		Pose pose;
		bool const ok
			( pose_from_pdb( pose, filename, true/*fa*/, false/*ideal*/,
											 false/*readallchains*/, chain, true/*skipmiss*/,
											 true /*allowmiss*/ ) );
		if ( !ok ) {
			std::cout << "io failed: " << filename << std::endl;
			continue;
		}

		pose.score( w );
	}
	exit(0);


}

void pose_rescore_silent() {
  using namespace silent_io;
  using namespace pose_ns;

  const bool fullatom( truefalseoption("fa_input") ); // ignored for now.
	std::string outfile( stringafteroption("silent_file" ) );
	std::string pdbfile( stringafteroption("pdbfile" ) );
	Pose pose;

	pose_from_pdb( pose, pdbfile, fullatom, false );

	pose.score( score3 );
	score_set_evaluate_all_terms(false);

	Silent_out out( outfile );

	out.write( pdbfile, pose );
} // pose_rescore_silent

void
pose_maxsub_score() {
	using namespace silent_io;
	using namespace pose_ns;

	Silent_file_data silent_data( stringafteroption("silent_file") );
	Pose current_decoy, native_pose;
	pose_from_pdb( native_pose, stringafteroption("native"), true, false );
	std::string output_file( stringafteroption("outfile") );


	std::ofstream c_stream( output_file.c_str() );
	if ( ! c_stream.is_open() ) {
		std::cerr << "Open failed for file: " << output_file << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__ );
	}

	c_stream 	<< "total_score" << '\t' << "CA_maxsub" << '\t' << "CA_rmsd" << '\t'
						<< "tag" << '\n';

	for ( Silent_file_data::const_iterator it = silent_data.begin(),
	 			it_end = silent_data.end(); it != it_end; ++it ) {
		double total_score = it->second->total_score;
		it->second->fill_pose( current_decoy );

		int ca_maxsub  = CA_maxsub( native_pose, current_decoy );
		float ca_rmsd  = CA_rmsd( native_pose, current_decoy );
		c_stream 	<< total_score << '\t'
							<< ca_maxsub   << '\t'
							<< ca_rmsd     << '\t'
							<< it->first   << '\n';
	}

	c_stream.close();
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

