// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14711 $
//  $Date: 2007-05-02 22:35:09 -0400 (Wed, 02 May 2007) $
//  $Author: rhiju $


// Rosetta Headers
#include "pose.h"
#include "aaproperties_pack.h" // nchi
#include "angles.h"
#include "bonds_class.h"
#include "current_pose.h"
#include "decoystats.h" // allatom_rms
#include "enzyme.h"
#include "fullatom.h" // for get_fullatom_flag()
#include "gl_graphics.h"
#include "input_pdb.h"
#include "jumping_diagnostics.h" // REMOVE ME LATER!!!!!!!!!!!!!
#include "jumping_refold.h"
#include "jumping_util.h"
//#include "make_pdb.h"
#include "minimize.h"
#include "misc.h" // for set_current_pose(...)
#include "orient_rms.h"
#include "pack.h" // pack_rotamers
#include "param.h" // MAX_POS, MAX_CHI, MAX_ATOM
#include "param_aa.h" // aa_XXX
#include "pose_io.h"
#include "pose_rna.h" //base centroid
#include "pose_util.h"
#include "prof.h"
#include "random_numbers.h" // ran3 in Monte_carlo
#include "refold.h" // get_GL_matrix, and build_actual_centroid.
#include "score.h"
#include "util_basic.h" // subtract_degree_angles
#include "util_vector.h" // Ddotprod, etc

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/formatted.o.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

// C++ Headers
#include <algorithm>
#include <cstddef>


//Utility Headers
#include <utility/basic_sys_util.hh>

namespace pose_ns {

	// this .cc file has the function declarations for all the
	// private methods of pose

	/////////////////////////////////////////////////////////
	///////////////////// POSE STUFF ////////////////////////
	/////////////////////////////////////////////////////////

	/////////////////////////////////////////////////////////////////////////////
	// refold
	//
	// this is a CONST method
	// that's why so much crap is mutable!!!
	//
	// note that this no longer **necessarily** has the side-effect of
	// copying to misc. actually it does, and if this changes routines
	// like copy_to_misc should be updated
	//
	// now if fullatom_ and the full_coord array does not appear to
	// have been filled in properly, refold will rebuild HN,HA
	// and copy from Eposition_
	//
	// also, this will rebuild centroids at moved positions
	// if pose_bonds != 0 and new_bb_refold is true
	//

	void
	Pose::refold(
  ) const
	{
		if ( atom_tree_ ) {
			atom_tree_refold();
			return;
		}

		if ( total_residue_ <= 0 ) return;
		assert( !refold_from_current || new_torsions == check_new_torsions() );

		if ( !new_torsions ) {
			if ( fullatom_ ) assert( check_xyz( full_coord_ ) );
			return;
		}

		const bool full_coord_init( fullatom_ && check_xyz( full_coord_ ) );

		// copy the coordinates into misc
		//
		// refolding_pose is a snapshot of the coordinates when
		// fold_from_here was called -- this can be used to prevent
		// skewing of the coords by multiple transformations
		//
		// note that the calls to get_Eposition() may trigger a refold
		// of the refolding pose -- tricky!
		FArray3D_float const & Epos
			( refold_from_current ? Eposition_ : refolding_pose->Eposition() );
		FArray2D_float const & cen
			( refold_from_current ? centroid_ : refolding_pose->centroid() );
		FArray3D_float const & fcoord
			( refold_from_current ? full_coord_ : refolding_pose->full_coord() );

		pose_update_MAX_RES( *this );

		copy_pose_torsions_to_misc( *this );

		// ensure that the rigid-body degrees of freedom have been
		// initialized. if not, just copy to misc and bail out
		if ( !torsions_init() ) {
			std::cout << "WARNING: refold called with uninit torsions\n" <<
				"I still copied your coordinates into misc::, hope that was " <<
				" the right thing to do!" << std::endl;
			copy_coordinates_pose( full_coord_init, total_residue_,
														 Epos, cen, fcoord,
														 misc::Eposition, misc::centroid,
														 misc::full_coord );
#ifdef GL_GRAPHICS
			gl_graphics_new_pose( total_residue_, fullatom_,
														fold_tree_.begin()->start /*anchor_pos*/);
#endif
			return;
		}

		copy_coordinates_pose( full_coord_init, total_residue_,
													 Epos, cen, fcoord,
													 misc::Ebest_position, misc::best_centroid,
													 misc::best_full_coord );


		// pb not sure if I need to do this here, but it cant hurt, right???
		init_fold();
		if ( use_st_bond() ) init_start_fold();

		refold_set_current_pose( *this );
		jmp_refold_tree( *this, full_coord_init, new_bb_refold, new_chi_refold,
										 new_jump_refold );
		refold_reset_current_pose();

		///////////////////////////////////////////
		// inverse hack: from misc back to the pose
		copy_coordinates_pose( fullatom_, total_residue_,
													 misc::Eposition, misc::centroid, misc::full_coord,
													 Eposition_, centroid_, full_coord_ );

#ifdef GL_GRAPHICS
		gl_graphics_new_pose( total_residue_, fullatom_,
													fold_tree_.begin()->start /* anchor_pos */);
#endif

		new_Eposition();

		if ( fullatom_ ) {
			//check that fullcoord and Eposition are in sync
			bool fail( false );
			for ( int i = 1; i <=  misc::total_residue; ++i ) {
				if ( std::abs( Eposition_(1,1,i)- full_coord_(1,1,i)) +
						 std::abs( Eposition_(1,2,i)- full_coord_(1,2,i)) +
						 std::abs( Eposition_(1,4,i)- full_coord_(1,3,i)) > .04 ) {
					fail = true;
					std::cout << "WARNING!!! position and full_coord disagree!" <<
						std::endl;
					std::cout << SS( i ) <<
						SS( Eposition_(1,1,i) ) << SS( full_coord_(1,1,i) ) <<
						SS( Eposition_(1,2,i) ) << SS( full_coord_(1,2,i) ) <<
						SS( Eposition_(1,4,i) ) << SS( full_coord_(1,3,i) ) << std::endl;
				}
				assert( !fail );
			}
			// ensure that chi-angles are synced w/full_coord
			//if ( !check_chi() ) {
			//	dump_fullatom_pdb( "test" );
			//}
			assert( check_chi() );

			//////////////////////////////////////
			// Rhiju this is a hack, doesn't
			// occur in normal Rosetta modes.
			//////////////////////////////////////
			// update centroids
			if (use_actual_centroids_){
				rebuild_centroids();
				//Actually just need to copy centroids back, but this function
				// will do that for now (wastes some time).
				copy_coordinates_pose( fullatom_, total_residue_,
															 Eposition_, centroid_, full_coord_,
															 misc::Eposition, misc::centroid,
															 misc::full_coord );
			}

		}

		// update new_XXX_score arrays using the new_XXX_refold arrays
		update_score_moved_arrays();

		// reset new_XXX_refold arrays
		new_torsions = false;
		if ( refold_from_current ) {
			reset_refold_moved_arrays();
		}

		// notify score book-keepers
		score_data.after_refolding();
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	Pose::atom_tree_refold(
  ) const
	{
		assert( fullatom_ );

		//std::cout << "atom_tree_refold: new_torsions= " << new_torsions <<
		//	std::endl;

		if ( !new_torsions ) {
			if ( fullatom_ ) assert( check_xyz( full_coord_ ) );
			return;
		}

		// call the atom_tree refolder
		PROF_START( prof::ATOM_TREE_REFOLD );
		atom_tree_->refold( full_coord_ );
		PROF_STOP ( prof::ATOM_TREE_REFOLD );

		// update Eposition from full_coord_
		for ( int i=1; i<= total_residue_; ++i ) {
			for ( int k=1; k<= 3; ++k ) {
				Eposition_(k,1,i) = full_coord_(k,1,i);
				Eposition_(k,2,i) = full_coord_(k,2,i);
				Eposition_(k,4,i) = full_coord_(k,3,i);
				Eposition_(k,5,i) = full_coord_(k,4,i);
				Eposition_(k,3,i) = full_coord_(k,5,i);
			}
		}
		new_Eposition();

		// update centroids
		rebuild_centroids();

		// copy everything to misc
		pose_update_MAX_RES( *this );
		copy_pose_torsions_to_misc( *this );
		copy_coordinates_pose( fullatom_, total_residue_,
													 Eposition_, centroid_, full_coord_,
													 misc::Eposition, misc::centroid,
													 misc::full_coord );


		// reset the flag
		new_torsions = false;


		// notify score book-keepers
		score_data.after_refolding();

#ifdef GL_GRAPHICS
		// notify graphics routines
		gl_graphics_new_pose( total_residue_, fullatom_,
													fold_tree_.begin()->start );
#endif

	}


	/////////////////////////////////////////////////////////////////////////////
	// check jumps that are flagged as having changed
	bool
	Pose::torsions_init() const
	{
		assert( !atom_tree_ );
		bool init( true );
		for ( int i=1; i<= total_residue_; ++i ) {
			if ( new_bb_refold(i) &&
					 std::abs( phi_(i) - pose_param::BAD_POS ) < 0.1 ) {
				init = false;
				break;
			}
		}

		if ( init ) {
			for ( int i=1; i<= num_jump_; ++i ) {
				if ( new_jump_refold(i) && !jump_transform(i).ortho_check() ) {
					init = false;
					break;
				}
			}
		}
		return init;
	}

	/////////////////////////////////////////////////////////////////////////////
	// try to detect that bb-coords have not been initialized
	//
	// essentially just checking that we are safe calculating a
	// jump from this position

	bool
	Pose::backbone_coords_init(
		int const seqpos
	) const
	{
		// checks to see if N,CA,C define a valid coord sys:
		// The N-CA and C-CA vectors are not 0 length, and are
		// not parallel to one another
		return (!pseudo(seqpos)) && Epos_init( Eposition_(1,1,seqpos) );
	}
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////
	void
	Pose::update_score_moved_arrays() const
	{
		domain_map_updated = false;
		if ( atom_tree_ ) return;
		// note the use of OR
		// if new_bb_score(i) is already true it stays true
		for ( int i = 1; i <= total_residue_; ++i ) {
			new_bb_score(i) = new_bb_score(i) || new_bb_refold(i);
			if ( fullatom_ ) new_chi_score(i) = new_chi_score(i) || new_chi_refold(i);
		}
		for ( int i=1; i<= num_jump_; ++i ) {
			new_jump_score(i) = new_jump_score(i) || new_jump_refold(i);
		}
	}

	/////////////////////////////////////////////////////////////////////
	void
	Pose::reset_refold_moved_arrays() const
	{
		new_torsions = false;
		if ( atom_tree_ ) return;
		for ( int i = 1; i <= total_residue_; ++i ) {
			new_bb_refold(i) = false;
			if ( fullatom_ ) new_chi_refold(i) = false;
		}
		for ( int i=1; i<= num_jump_; ++i ) {
			new_jump_refold(i) = false;
		}
	}



	/////////////////////////////////////////////////////////////////////
	// Check for new torsions, call refold() if necessary.
	// With this routine we dont necessarily have to call refold()
	// after making a single move.
	//
	// scorefxn calls get_current_pose()->before_scoring()
	// before starting
	//
	void
	Pose::before_scoring()
	{
		score_set_current_pose( *this );

		// very temporary hack: if the cendist state is GOOD
		// ensure that we are copying to cenlist_ns:: version
		score_data.set_score_state_OK_if_GOOD( CENDIST );

		// temporary hack: better in jumping_refactor version
		if ( fullatom_ ) copy_pose_fullatom_energies_to_best( *this );


		// exclude pseudo residues from score calculation
		if ( symm_info ) {
			symm_info->set_exclude_pseudo_from_total_residue( true );
			misc::total_residue = total_residue(); // HACK
		}
	}

	/////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////
	// Pose::score() calls after_scoring()
	// before returning
	//
	void
	Pose::after_scoring()
	{
		// temporary hack: better in jumping_refactor version
		if ( fullatom_ ) copy_fullatom_energies_to_pose( *this );

		// notify score_data that we are about to forget the most recent round
		// of changes to the pose
		score_data.after_scoring();

		// reset new_XXX_score arrays
		reset_score_moved_arrays();

		// debug:check torsions ( in jumping_refold.cc )
		assert( misc_in_sync( *this ));

		// reset
		score_reset_current_pose();

		// don't exclude the pseudo-residues anymore
		if ( symm_info ) {
			symm_info->set_exclude_pseudo_from_total_residue( false );
			misc::total_residue = total_residue(); // HACK
		}
	}

	/////////////////////////////////////////////////////////////////////
	void
	Pose::reset_score_moved_arrays()
	{
		domain_map_updated = false;
		if ( atom_tree_ ) {
			atom_tree_->root()->set_torsion_moved( false /* setting */,
																						 true /* include_fixed_torsions */,
																						 true /* recursive */ );
			return;
		}
		for ( int i = 1; i <= total_residue_; ++i ) {
			new_bb_score(i) = false;
			if ( fullatom_ ) new_chi_score(i) = false;
		}
		for ( int i=1; i<= num_jump_; ++i ) {
			new_jump_score(i) = false;
		}
	}



	/////////////////////////////////////////////////////////////////////////////
	void
	Pose::update_domain_map() const
	{
		// already done?
		if ( new_torsions ) {
			refold();
		}

		if ( domain_map_updated ) {
			return;
		}

		if ( int ( domain_map.size1() ) != total_residue_ ) {
			domain_map.dimension( total_residue_ );
		}

		if ( atom_tree_ ) {
			atom_tree_->update_domain_map( domain_map );
		} else {
			calc_domain_map( fold_tree_, fullatom_, new_bb_score, new_chi_score,
											 new_jump_score, domain_map );
		}

		domain_map_updated = true;
		pair_moved_updated = false; // depends on domain_map
	}


	/////////////////////////////////////////////////////////
	// updates res_moved, pair_moved based on the domain_map

	void
	Pose::update_pair_moved() const
	{
		// depends on domain_map; this way we can set domain_map_updated=false
		// and ensure pair_moved recalc
		update_domain_map();

		if ( pair_moved_updated ) return;
		pair_moved_updated = true;

		assert( check_dimensions() );
		if ( int ( res_moved.size1()) != total_residue_ ) {
			res_moved.dimension(total_residue_);
			pair_moved.dimension( total_residue_, total_residue_ );
		}

		for ( int i = 1; i <= total_residue_; ++i ) {
			int const imap = domain_map(i);
			bool const imoved ( imap == 0);
			res_moved(i) = imoved;
			// linear indexing: j is the first index, i is the second index!
			for ( int j = 1, l = pair_moved.index(j,i); j <= total_residue_; ++j,++l ) {
				if ( imap == domain_map(j) && !imoved ) {
					pair_moved[l] = false; // [l] = (j,i)
				} else {
					pair_moved[l] = true;
				}
			}
		}
	} // update_pair_moved

	/////////////////////////////////////////////////////////////////////////////
	// const method to assure syncing of array dimensions
	bool
	Pose::check_dimensions() const
	{
		if ( fold_tree_.get_nres() != total_residue_ ||
				 fold_tree_.get_num_jump() != num_jump_ ) {
			std::cout << "Pose::check_dimensions(): dimension mismatch in pose!\n";
			std::cout << fold_tree_.get_nres() << ' ' << total_residue_
								<< fold_tree_.get_num_jump() << ' ' << num_jump_ << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return true;
	}

	/////////////////////////////////////////////////////////////////////////////
	//
	void
	Pose::update_dimensions()
	{
		int const new_total_residue ( fold_tree_.get_nres() );
		int const old_total_residue ( total_residue_ );
		int const new_num_jump ( fold_tree_.get_num_jump() );
		int const old_num_jump ( num_jump_ );

		if ( new_total_residue != old_total_residue ) {
			assert( int(phi_.size1()) == old_total_residue );
			total_residue_ = new_total_residue;

			// now redimension the data; this will erase all existing stuff:
			// this will probably be slow but it shouldnt happen too often
			pdb_info_.dimension( total_residue_ );
			phi_.dimension( total_residue_ );
			phi_ = pose_param::BAD_POS; // signal uninit
			psi_.dimension( total_residue_ );
			omega_.dimension( total_residue_ );
			secstruct_.dimension( total_residue_ );
			secstruct_ = 'L'; // DEFAULT VALUE
			name_.dimension( total_residue_ );
			res_.dimension( total_residue_ );
			res_ = 0;
			res_variant_.dimension( total_residue_ );
			res_variant_ = 1; // DEFAULT VALUE
			//
			Eposition_.dimension(3,param::MAX_POS,total_residue_);
			centroid_.dimension(3,total_residue_);
			Eposition_ = pose_param::BAD_POS; // signal uninit
			new_Eposition();
			basepair_partner_.dimension( total_residue_ );
			basepair_partner_ = -1; // DEFAULT VALUE
			//
			allow_bb_move.dimension(total_residue_);
			allow_bb_move = true; // DEFAULT VALUE
			allow_chi_move.dimension(total_residue_);
			allow_chi_move = true; // DEFAULT VALUE
			//
			new_bb_refold.dimension(total_residue_);
			new_bb_score.dimension(total_residue_);
			new_bb_refold = true; // init
			new_bb_score = true; // init
			new_torsions = true;
			// book-keeping
			domain_map_updated = false;
			insert_maps_updated = false;
			// fullatom
			if ( fullatom_ ) redimension_fullatom_arrays(); // also called from set_fullatom_flag()
			if ( pose_bonds_ != 0 ) {
				pose_bonds_->set_nres( total_residue_ );
			}
		}
		if ( new_num_jump != old_num_jump ) {
			// may have to redimension stuff
			num_jump_ = new_num_jump;

			new_jump_refold.dimension( new_num_jump );
			new_jump_refold = true; // signal uninit?
			new_jump_score.dimension( new_num_jump );

			// PB 05/18/06 -- remove logic to save old values
			jump_transform.dimension( new_num_jump );
			allow_jump_move.dimension( new_num_jump );
			allow_jump_move = true; // DEFAULT VALUE
			allow_rb_move.dimension( 6, new_num_jump );
			allow_rb_move = true;
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Pose::redimension_fullatom_arrays()
	{
		chi_.dimension( param::MAX_CHI, total_residue_ );
		chi_ = 0;
		full_coord_.dimension( 3, param::MAX_ATOM(), total_residue_ );
		reset_xyz( full_coord_ ); // signal that nothing exists yet
		new_chi_refold.dimension( total_residue_ );
		new_chi_refold = true;
		new_torsions = true;
		new_chi_score.dimension( total_residue_ );
	}

	/////////////////////////////////////////////////////////////////////////////
	// private method for signalling change in Eposition
	// notify arrays that should stay synced
	void
	Pose::new_Eposition() const
	{
		if ( overlap_Eposition_.size4() >= 1 ) reset_xyz( overlap_Eposition_ );
		if ( !fullatom_ && full_coord_.size3() >= 1 ) reset_xyz( full_coord_ );
	}


	/////////////////////////////////////////////////////////////////////////////
	// calculate bond geometry
	// after this call, all refolding of this pose will be done with
	// non-ideal bonds
	// private method
	void
	Pose::calc_bonds()
	{
		// assumes that Eposition is valid, ie it's not necessary to refold
		if ( pose_bonds_ == 0 ) {
			pose_bonds_ = new bonds_class::Bonds;
		}
		pose_bonds_->calculate( total_residue_, Eposition_,
													 phi_, psi_, omega_ );
		// the way we are refolding has now changed, trigger
		// a complete refold of the backbone. coordinates will
		// be slightly different
		//new_bb_refold = true;
		//new_torsions = true;
		// now that this is private, let the calling routine worry about
		// the correct setting for new_bb_refold...
	}



	/////////////////////////////////////////////////////////////////////////////
	////////////////////
	// coordinate copier
	// everything to handle proper refolding
	// no scoring-related stuff -- constraints, etc
	// sets new_*_score to true
	//
	void
	Pose::copy_coords(
		Pose const & src,
		bool const trust_src_score_data //if true we will be copying src.score_data
	)
	{
		PROF_START( prof::POSE_COPY_COORDS );

		///////////////////////////////////////////////////////////////////////////
		// atom_tree logic
		if ( src.atom_tree_ ) {
			if ( atom_tree_ ) {
				bool same_tree( false );
				if ( fold_tree_ == src.fold_tree_ &&
						 !pose_param::slow_and_safe_atom_tree_copy ) {
					same_tree = true;
					for ( int i=1; i<= total_residue_; ++i ) {
						if ( res_        (i) != src.res_        (i) ||
								 res_variant_(i) != src.res_variant_(i) ) {
							same_tree = false;
							break;
						}
					}
				}
				if ( !same_tree ) {
					delete atom_tree_;
					atom_tree_ = 0;
				} else {
// 					std::cout << "WARNING:: Pose::copy_coords: assuming same " <<
//					" atom_tree!" << std::endl;
				}
			}
		} else if ( atom_tree_ ) {
			delete atom_tree_;
			atom_tree_ = 0;
		}


		///////////////////////////////////////////////////////////////////////////
		// tree:
		fold_tree_ = src.fold_tree_;

		// resize arrays
		// sets total_residue, num_jump; re-sizes arrays if necessary
		// note that this will trigger a check_topology() call in fold_tree
		// which will update all the topology-derived data
		bool const old_fullatom ( fullatom_ );
		fullatom_ = src.fullatom_;
		update_dimensions();
		// this might not have happened if total_residue == src.total_residue:
		if ( fullatom_ && !old_fullatom ) redimension_fullatom_arrays();

		// check that dimensions are equal
		src.check_dimensions();
		assert( total_residue_ == src.total_residue_ && num_jump_ == src.num_jump_ );

		///////////////////////////////////////////////////////////////////////////
		// secondary structure, sequence
		secstruct_ = src.secstruct_;
		name_ = src.name_;
		res_ = src.res_;
		res_variant_ = src.res_variant_;


		///////////////////////////////////////////////////////////////////////////
		// coords
		Eposition_ = src.Eposition_;
		centroid_ = src.centroid_;
		if ( fullatom_ ) full_coord_ = src.full_coord_;
		new_Eposition();


		///////////////////////////////////////////////////////////////////////////
		// torsions, allow_move
		if ( src.atom_tree_ ) {
			if ( atom_tree_ ) {
				// if we didn't zero it out, that's a sign that the fold_tree and
				// sequence matched, so we are assuming the two trees have the
				// same topology -- which may be false
				atom_tree_->copy_torsions( *src.atom_tree_ );
			} else {
				// new approach: copy the freakin tree
				atom_tree_ = new kin::Atom_tree;
				*atom_tree_ = *src.atom_tree_;
			}

			//std::cout << "copy_coords: Phil-- change this!" << std::endl;
 			new_torsions = src.new_torsions;

			if ( !trust_src_score_data ) {
				atom_tree_->new_score_pose();
			}


		} else {
			// torsions
			phi_ = src.phi_;
			psi_ = src.psi_;
			omega_ = src.omega_;
			pdb_info_ = src.pdb_info_;
			if ( fullatom_ ) chi_ = src.chi_;
			for ( int i=1; i<= num_jump_; ++i ) {
				jump_transform(i) = src.jump_transform(i); // notnecsamesize
			}

			// bonds
			if ( src.pose_bonds_ != 0 ) {
				if ( pose_bonds_ == 0 ) {
					pose_bonds_ = new bonds_class::Bonds;
				}
				*pose_bonds_ = *(src.pose_bonds_);
			} else {
				// src is ideal --> set me to ideal also
				if ( pose_bonds_ != 0 ) {
					delete pose_bonds_;
					pose_bonds_ = 0;
				}
			}

			// allow_move
			allow_bb_move = src.allow_bb_move;
			allow_chi_move = src.allow_chi_move;
			allow_jump_move = src.allow_jump_move;
			allow_rb_move = src.allow_rb_move;

			// new_*_refold
			new_bb_refold = src.new_bb_refold;
			new_jump_refold = src.new_jump_refold;
			if ( fullatom_ ) new_chi_refold = src.new_chi_refold;
			new_torsions = src.new_torsions;

			if (!trust_src_score_data ) {
				// reset all score_data:
				new_bb_score = true;
				new_chi_score = true;
				new_jump_score = true;
			}
		}


		// reset book-keeping, since we didnt copy insert_maps,
		// jmp_domain_map, pair_moved
		insert_maps_updated = false;
		domain_map_updated = false;
		PROF_STOP ( prof::POSE_COPY_COORDS );

	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Pose::update_insert_maps() const
	{
		//assert( !atom_tree_ );
		if ( insert_maps_updated ) return;
		insert_maps_updated = true;

		// debug: double check total_residue
		assert( check_dimensions() );
		if ( int ( insert_map.size1() ) != total_residue_ ) {
			insert_map.dimension( total_residue_ );
			insert_size.dimension( total_residue_ );
		}

		total_insert = 0;

		for ( int i=1; i<= total_residue_; ++i ) {
			if ( get_allow_bb_move( i ) ) {
				++total_insert;
				insert_map( total_insert ) = i;
			}
		}

		for ( int i=total_residue_, size=0; i>=1; --i ) {
			if ( get_allow_bb_move( i ) ) {
				++size;
			} else {
				size = 0;
			}
			insert_size( i ) = size;
		}
	}



	/////////////////////////////////////////////////////////////////////////////
// 	Stub
// 	get_jump_stub(
// 		int const pos
// 	)
// 	{
// 		if ( dna_exists() && is_NA( pos ) ) {
// 			return dna->get_stub( pos );
// 		} else {
// 			return stub_from_Eposition( Eposition_(1,1,pos) );
// 		}
// 	}

	/////////////////////////////////////////////////////////////////////////////
	// DONT call refold -- not safe if torsions haven't been filled in
	void
	Pose::update_jump_from_coords(
		int const jump_number
	)
	{
		assert( !atom_tree_ );
		assert( jump_number <= num_jump_ );
		int const pos1 ( fold_tree_.get_jump_point()( 1, jump_number ) );
		int const pos2 ( fold_tree_.get_jump_point()( 2, jump_number ) );

		//Jump jump( get_jump_stub( pos1 ), get_jump_stub( pos2 ) );

 		Jump jump( Eposition_( 1,1, pos1 ),
 							 Eposition_( 1,1, pos2 ));

		jump_transform( jump_number ) = jump;
		new_jump_refold( jump_number ) = false;
	}

	/////////////////////////////////////////////////////////////////////////////
	// Doesnt call REFOLD!
	void
	Pose::jumps_from_position()
	{
		for ( int i=1; i<= num_jump_; ++i ) {
			int const pos1 ( fold_tree_.get_jump_point()( 1, i ) );
			int const pos2 ( fold_tree_.get_jump_point()( 2, i ) );
			if ( backbone_coords_init( pos1 ) && backbone_coords_init( pos2 ) ) {
				update_jump_from_coords( i );
			} else {
				//std::cout << "WARNING:: jumps_from_position(): Not calculating " <<
				//	" jump-transform for positions " << pos1 << ' ' << pos2 <<
				//	". Coordinates are not initialized." << std::endl;
				//assert(false);
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	////
	// private
	// copies backbone from Eposition to full_coord
	// called by full_coord() if !fullatom

	void
	Pose::update_full_coord() const
	{
		if ( fullatom_ ) return;
		if ( int(full_coord_.size3()) == total_residue_ &&
				 check_xyz( full_coord_ ) ) {
			return;
		}
		if ( int(full_coord_.size3()) != total_residue_ ) {
			full_coord_.dimension( 3, param::MAX_ATOM(), total_residue_ );
		}

		refold(); // need Eposition up-to-date

		for ( int i = 1; i <= total_residue_; ++i ) {
			for ( int j = 1; j <= 3; ++j ) {
				full_coord_(j,1,i) = Eposition_(j,1,i);
				full_coord_(j,2,i) = Eposition_(j,2,i);
				full_coord_(j,3,i) = Eposition_(j,4,i);
				full_coord_(j,4,i) = Eposition_(j,5,i);
				full_coord_(j,5,i) = Eposition_(j,3,i);
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////////
// 	void
// 	Pose::setup_full_coord()
// 	{
// 		// assume that full_coord is empty
// 		// this routine copies from Eposition to full_coord, changing
// 		// the atom ordering and skipping gly c-betas
// 		// it also builds HA and HN atoms, but the HN atoms will
// 		// need to be fixed after chainbreaks
// 		if ( !fullatom_ ) {
// 			std::cout << "setup_full_coord only appropriate for fullatom poses" <<
// 				std::endl;
// 			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
// 		}
// 		initialize_fullcoord_array( Eposition, full_coord_,
// 																total_residue_, res, res_variant );
// 		// fix nh positions at chainbreaks
// 		FArray1D_bool const & is_cutpoint ( fold_tree_.get_is_cutpoint() );
// 		for ( int i=2; i<= total_residue_; ++i ) {
// 			if ( is_cutpoint(i-1) ) {
// 				build_nh_simple( res(i), res_variant(i), phi(i), full_coord_(1,1,i) );
// 			}
// 		}
// 	}

	/////////////////////////////////////////////////////////////////////////////
	// called after repacking
	void
	Pose::update_chi()
	{
		//std::cout << "pose::update_chi()" << std::endl;
		for ( int i=1; i<= total_residue_; ++i ) {
			update_chi_residue( i );
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	// sets phi(1),psi(total_residue),omega(total_residue) == 0
	// just as in input_pdb's torsion_from_position
	//
	// this may cause problems if coords are uninitialized, so
	// Pose::set_coords() tries to catch this

	void
	Pose::backbone_torsions_from_position()
	{
		phi_(1) = 0.0;
		for ( int i = 1; i <= total_residue_; ++i ) {
			if ( !is_protein( i ) ) continue;

			if ( i > 1 ) {
				phi_(i)   = dihedral( Eposition_(1,4,i-1), Eposition_(1,1,i),
															Eposition_(1,2,i  ), Eposition_(1,4,i));
			}

			if ( i < total_residue_ ) {
				psi_(i)   = dihedral( Eposition_(1,1,i  ), Eposition_(1,2,i  ),
															Eposition_(1,4,i  ), Eposition_(1,1,i+1));
				omega_(i) = dihedral( Eposition_(1,2,i  ), Eposition_(1,4,i  ),
															Eposition_(1,1,i+1), Eposition_(1,2,i+1));
			}
		}
		psi_(total_residue_) = 0.0;
		omega_(total_residue_) = 0.0;
	}

	/////////////////////////////////////////////////////////////////////////////
	//
	void
	Pose::update_chi_residue(
		int const seqpos
	)
	{
		using namespace aaproperties_pack;
		if ( !param_aa::is_protein( res_( seqpos ) ) ) return;
		{ for ( int chino = 1; chino <= param::MAX_CHI; ++chino ) {
			chi_( chino, seqpos ) = 0.;
		} } //Objexx:SGM Extra {} scope is a VC++ work-around
		int const aa ( res_        (seqpos) );
		int const aav( res_variant_(seqpos) );
		for ( int chino = 1; chino <= nchi(aa,aav); ++chino ) {
			chi_(chino,seqpos) =
				periodic_range(
					dihedral(
						full_coord_(1,chi_atoms(1,chino,aa,aav),seqpos),
						full_coord_(1,chi_atoms(2,chino,aa,aav),seqpos),
						full_coord_(1,chi_atoms(3,chino,aa,aav),seqpos),
						full_coord_(1,chi_atoms(4,chino,aa,aav),seqpos)), 360.0 );
		}
		//revert symmetric consideration for chi angle calculations --chu
		//set_all_chi_to_periodic_range( chi_( 1, seqpos ), aa );
		new_chi_refold( seqpos ) = false;
	}

	/////////////////////////////////////////////////////////////////////////////
	//
	bool
	Pose::check_chi() const
	{
		float const WARN_DEV ( 0.1 );
		float const MAX_DEV ( 1.0 );
		FArray2D_int rotarray( param::MAX_CHI, total_residue_ );
		FArray2D_float chiarray( param::MAX_CHI, total_residue_ );
		get_chi_and_rot_from_coords( total_residue_, res_, res_variant_,
																 full_coord_, chiarray, rotarray );
		float max_dev(0.0);
		for ( int i=1,aa,aav; i<= total_residue_; ++i ) {
			aa = res(i);
			aav = res_variant(i);
			for ( int j = 1, je = aaproperties_pack::nchi(aa,aav); j <= je; ++j ) {
				float dev ( std::abs( subtract_degree_angles( chiarray(j,i), chi(j,i) ) ));
				if ( dev > WARN_DEV ) {
					std::cout << "check_chi:: bad-chi " << i << ' ' << aa << ' ' << j << ' '
								 << chiarray(j,i) << ' ' << chi(j,i) << ' ' << dev << std::endl;
				}
				// check for symmetry:
				if ( dev >= MAX_DEV ) {
					if ( ( ( j == 2 &&
					 ( aa == param_aa::aa_phe || aa == param_aa::aa_tyr || aa == param_aa::aa_asp ) ) ||
					 ( j == 3 && aa == param_aa::aa_glu ) ) &&
					 std::abs( dev - 180.0 ) < 0.1 ) {
						dev = 0.0;
					}
				}
				max_dev = std::max( max_dev, dev );
			}
		}
		//std::cout << "check_chi:: max_dev= " << max_dev << std::endl;
		//if ( max_dev > WARN_DEV ) dump_phil_pdb();
		return ( max_dev < MAX_DEV );
	}

	/////////////////////////////////////////////////////////////////////////////
	// no call to refold
	void
	Pose::rebuild_centroids() const
	{
		for ( int i=1; i<= total_residue_; ++i ) {
			rebuild_centroid( i );
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	// no call to refold
	void
	Pose::rebuild_centroid(
		int const i
	) const
	{
		int const aa( res_(i) );
		if ( param_aa::is_protein( aa ) ) {
			if ( fullatom_ && use_actual_centroids_ ){
				build_actual_centroid(aa, full_coord_(1,1,i), centroid_(1,i));
			} else {
				build_centroid_n2c_ncac( aa, Eposition_(1,1,i), Eposition_(1,2,i),
																 Eposition_(1,4,i), centroid_(1,i) );
			}
		} else if ( param_aa::is_DNA( aa ) ) {
			assert( check_xyz( full_coord_ ) );
			int cen_index(0);
			if ( aa == param_aa::na_ade ) {
				cen_index = 18;
			} else if ( aa == param_aa::na_cyt ) {
				cen_index = 17;
			} else if ( aa == param_aa::na_thy ) {
				cen_index = 17;
			} else if ( aa == param_aa::na_gua ) {
				cen_index = 19;
			} else {
				std::cout << "Unrecognized dna aa type: " << aa << std::endl;
				std::exit( EXIT_FAILURE );
			}
			for ( int k=1; k<= 3; ++k ) {
				centroid_(k,i) = full_coord_(k,cen_index,i);
			}
		} else if ( param_aa::is_RNA( aa ) ) {
			/*			assert( check_xyz( full_coord_ ) );*/
  			numeric::xyzVector_float const temp_centroid = get_base_centroid( aa, full_coord_(1, 1, i) );
  			for ( int k=1; k<= 3; ++k ) {
  				centroid_(k,i) = temp_centroid( k );
  			}
		} else {
			for ( int k=1; k<= 3; ++k ) {
				centroid_(k,i) = Eposition_(k,1,i);
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	bool
	Pose::check_new_torsions() const
	{
		assert( !atom_tree_ );
		bool new_tor( false );
		for ( int i=1; i<= total_residue_; ++i ) {
			if ( new_bb_refold(i) ) {
				new_tor = true;
				break;
			} else if ( fullatom_ && new_chi_refold(i) ) {
				new_tor = true;
				break;
			}
		}
		if ( !new_tor ) {
			for ( int i=1; i<= num_jump_; ++i ) {
				if ( new_jump_refold(i) ) {
					new_tor = true;
					break;
				}
			}
		}
		return new_tor;
	}

} // Pose_ns


