// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8635 $
//  $Date: 2006-06-01 15:21:58 -0700 (Thu, 01 Jun 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_pose_relax
#define INCLUDED_pose_relax

// Rosetta Headers
#include "pose_fwd.h"
#include "kin_id.h"

// C++ Headers
#include <string>

//forward declaration

void
fast_relax_pose(
	pose_ns::Pose & pose,
	pose_ns::Score_weight_map & weight_map,
	int const lj_ramp_cycles,
	int const cycles,
	std::string const & score_filter_tag,
	float const score_filter_acceptance_rate,
	bool const vary_bond_angles,
	float const filter1 = 1.0e9,
	float const filter1a = 1.0e9,
	float const filter1b = 1.0e9,
	float const filter2 = 1.0e9
								);

void
pose_save_relax_score_filters(
	pose_ns::Pose & pose,
	float & current_score,
	pose_ns::Monte_carlo & mc,
	std::string const extrascorename,
	float const filter,
	bool & pass_score_filter );

void
initialize_vary_bond_geometry_flags( bool & vary_bond_angles, bool & vary_bond_angles_before_stage2,
																		 bool & vary_all_bond_distances, bool & vary_all_bond_distances_before_stage2,
																		 bool & vary_all_bond_angles, bool & vary_all_bond_angles_before_stage2,
																		 pose_ns::Score_weight_map & weight_map,
																		 pose_ns::Monte_carlo & mc);

void
initialize_vary_bond_geometry_constraints(
   bool const vary_bond_angles,
	 bool const vary_all_bond_distances,
	 bool const vary_all_bond_angles,
	 pose_ns::Pose & pose,
	 pose_ns::Score_weight_map weight_map,
	 pose_ns::Monte_carlo & mc
																					);

void
pose_relax_test();

void
pose_relax_wrapper(
	int const lj_ramp_cycles,
	int const cycles,
	bool const vary_bond_angles
									 );
void
pose1_relax_main();

void
pose_rhiju();

void
setup_omega_tether( pose_ns::Pose & pose );

void
setup_backbone_pairwise_tethers( pose_ns::Pose & pose, pose_ns::Score_weight_map & weight_map );

void
turn_off_backbone_pairwise_tethers( pose_ns::Score_weight_map & weight_map );

void
pose_relax_fullatom(
	pose_ns::Pose & pose
);


void
get_symm_jump_moves_during_relax(
	bool & symm_jump_moves_during_relax,
	float & transmag,
	float & rotmag
);

void
initialize_segment_map_from_pose( pose_ns::Pose & pose );


#endif
