// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_rna
#define INCLUDED_pose_rna


// Rosetta Headers
#include "pose_fwd.h"
#include "pose_rna_base_doublet_classes.h"
#include "kin_stub.h"
#include "silent_input.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
//#include <utility/io/all.fwd.hh>

// C++ Headers
#include <list>

float
rna_rna_vdw(pose_ns::Pose & pose, int const j, int const i, float const cendist_ij);

void
evaluate_long_range_contact_distances( pose_ns::Pose & pose );

void
eval_rna_score(
	pose_ns::Pose & pose,
	float & rna_bs_score,
	float & rna_bp_w_score,
	float & rna_bp_h_score,
	float & rna_bp_s_score,
	float & rna_axis_score,
	float & rna_stagger_score,
	float & rna_bulge_score,
	float & rna_contact_score,
	float & rna_long_range_contact_score,
	FArray2D_bool & scored_base_pair,
	FArray2D_bool & face_is_base_pairing,
	Energy_base_pair_list  & scored_base_pair_list,
	Energy_base_stack_list & scored_base_stack_list
);

void
eval_rna_nonbasebase_score(
  pose_ns::Pose & pose,
	float & rna_nonbasebase_score
);

void
eval_rna_o2star_score(
	pose_ns::Pose & pose,
	float & rna_o2star_score
);

void
eval_rna_phosphate_score(
	pose_ns::Pose & pose,
	float & rna_phosphate_score
);

void
eval_rna_score(
	pose_ns::Pose & pose,
	float & rna_bs_score,
	float & rna_bp_w_score,
	float & rna_bp_h_score,
	float & rna_bp_s_score,
	float & rna_axis_score,
	float & rna_stagger_score,
	float & rna_bulge_score,
	float & rna_contact_score,
	float & rna_long_range_contact_score
	);

void
eval_rna_score(
	pose_ns::Pose & pose,
	float & rna_bs_score,
	float & rna_bp_w_score,
	float & rna_bp_h_score,
	float & rna_bp_s_score,
	float & rna_axis_score,
	float & rna_stagger_score,
	float & rna_bulge_score,
	float & rna_contact_score,
	float & rna_long_range_contact_score,
	FArray2D_bool & scored_base_pair,
	FArray2D_bool & face_is_base_pairing
	);


float
get_rna_basepair_xy(
	float const x,
	float const y,
	float const theta,
	int const res_i,
	int const res_j
	);

float
get_rna_basepair_rho_omega1_omega2( float const rho, float const omega1, float const omega2,
																		float const theta, int const res_i, int const res_j);

float
get_rna_axis_score( float const theta );

float
get_rna_stagger_score( float const dist_z );

float
eval_rna_other_score(
	pose_ns::Pose & pose
	);

void
eval_rna_sasa_score(
	pose_ns::Pose & pose,
	float & rna_sasa_score,
	bool verbose = false,
	bool fast_sasa = true
	);

numeric::xyzVector_float
get_base_centroid( int const res_type, FArray3Da_float full_coord );


pose_ns::Score_weight_map
setup_rna_weight_map();

void
RNA_move_trial(
   pose_ns::Pose & pose,
	 pose_ns::Monte_carlo & mc,
	 bool const smooth,
	 std::string const trial_type,
	 int const frag_size = 3 );

void
add_rna_lores_terms_weight_map( pose_ns::Score_weight_map & w);

kin::Stub
get_base_coordinate_system(
   int const res_type,
   FArray3Da_float full_coord,
   numeric::xyzVector_float const centroid
   );

bool check_chainbreak(int i, pose_ns::Pose & pose);

int
num_unshared_basepairs(
		pose_ns::Pose & pose1 /* reference pose*/,
		pose_ns::Pose & pose2 /*scored pose*/
);

void
fill_native_base_pair_info(	pose_ns::Pose & pose );

void
read_user_defined_contact_files();

void
initialize_query_pose_rna(
	 pose_ns::Pose & pose,
	 bool const use_fasta = true
	);

void
update_frag_size( int const r, int const rounds, int & frag_size );

void
put_the_final_touch_on_rna(
      pose_ns::Pose & pose,
			silent_io::Silent_out & out,
			std::string const tag,
			bool const minimize );

void
rna_stuff();

void
make_ideal_rna_fullcoord(
  pose_ns::Pose & pose
	);

void
make_ideal_rna_fullcoord();

void
rna_test();

float
get_frag_rms( pose_ns::Pose const & pose1, pose_ns::Pose const & pose2,
							int const res1, int const res2, int const frag_size);


#endif
